{ Project: OELoad                                                    }
{ Description: Load Tables and Data                                  }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QButtons, OCIH, OCI, OCL, QExtCtrls, OVCL;

const
  BulkRows = 1000;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BitBtn1: TBitBtn;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ListCount: Integer;

implementation

{$R *.dfm}

uses
  OETree, Unit2;

{ Utilities }

procedure AddList(s: String);
begin
  { Add an Item to the ListBox }
  Form1.ListBox1.Items.Add('  '+s);
  Form1.ListBox1.ItemIndex:= ListCount;
  Inc(ListCount);
  Form1.ListBox1.ScrollBy(0,24);
  Application.ProcessMessages;
end;

procedure UpdateList;
var
  S: String;
begin
  { Update an Item in the ListBox }
  S:= Form1.ListBox1.Items.Strings[Form1.ListBox1.ItemIndex];
  S[1]:= '+';
  Form1.ListBox1.Items.Strings[Form1.ListBox1.ItemIndex]:= S;
  Application.ProcessMessages;
end;

{ Test Functions }

procedure InsertRows;
var
  { Students Table }
  SNo: NullString;
  SName: NullString;
  SGender: Byte;

  { Courses Table }
  CCode: NullString;
  CDescr: NullString;
  CNumStuds: Smallint;

  { Takes Table }
  TMark: Single;
begin
  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Students (SNo, SName, SGender) VALUES (?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, SName);
  Tree.Hstmt1.BindByte(3, SGender);
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700001';
  SName:= 'Van der Merwe, J';
  SGender:= 1;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700002';
  SName:= 'Schwarzenegger, A';
  SGender:= 1;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700003';
  SName:= 'Hamilton, L';
  SGender:= 0;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Courses (CCode, CDescr, CNumStuds) VALUES (?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, CCode);
  Tree.Hstmt1.BindNullString(2, CDescr);
  Tree.Hstmt1.BindSmallint(3, CNumStuds);
  UpdateList;

  AddList('Assigning Parameters...');
  CCode:= 'WR1';
  CDescr:= 'Computer Science 1';
  CNumStuds:= 80;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  CCode:= 'WR2';
  CDescr:= 'Computer Science 2';
  CNumStuds:= 40;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  CCode:= 'WR3';
  CDescr:= 'Computer Science 3';
  CNumStuds:= 20;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Takes (SNo, CCode, TMark) VALUES (?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, CCode);
  Tree.Hstmt1.BindSingle(3, TMark);
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700001';
  CCode:= 'WR1';
  TMark:= 80.6;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700002';
  CCode:= 'WR2';
  TMark:= 70.7;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700003';
  CCode:= 'WR3';
  TMark:= 60.8;
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;
end;

procedure InsertRows2;
var
  SNo: NullString;
  SName: NullString;
  SGender: Byte;
  SBirth: TTimeStamp;
  SPic: TMemoryStream;
  SComment: TMemoryStream;
  DriverPtr: TDriverPtr;
  Coach: Boolean;
begin
  SPic:= TMemoryStream.Create;
  SComment:= TMemoryStream.Create;

  AddList(Tree.Hdbc1.CurrentDriver);
  DriverPtr:= nil;
  //This driver needs a bit of couching
  Coach:= Tree.Hdbc1.CurrentDriver = 'Microsoft SQL Server;esoobclient';
  if Coach then
    DriverPtr:= Tree.Hdbc1.AddDriver(Tree.Hdbc1.CurrentDriver);

  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Students (SNo, SName, SGender, SBirth, SPic) '+
              'VALUES (?, ?, ?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, SName);
  Tree.Hstmt1.BindByte(3, SGender);
  Tree.Hstmt1.BindTimeStamp(4, SBirth);
  SPic.LoadFromFile('STUDENT.BMP');
  if Coach then
  begin
    Tree.Hdbc1.Core:= True;//coach on
    DriverPtr.PS_SQL_LONGVARBINARY:= SPic.Size;
  end;
  Tree.Hstmt1.BindBinary(5, SPic);
  if Coach then
    Tree.Hdbc1.Core:= False;//coach off
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700004';
  SName:= 'Weaver, S';
  SGender:= 0;
  SBirth:= TimeStamp(1961,2,3,0,0,0,0);
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, SName);
  Tree.Hstmt1.BindByte(3, SGender);
  Tree.Hstmt1.BindTimeStamp(4, SBirth);
  SPic.LoadFromFile('STUDENT.BMP');
  if Coach then
  begin
    Tree.Hdbc1.Core:= True;//coach on
    DriverPtr.PS_SQL_LONGVARBINARY:= SPic.Size;
  end;
  Tree.Hstmt1.BindBinary(5, SPic);
  if Coach then
    Tree.Hdbc1.Core:= False;//coach off
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700005';
  SName:= 'Gibson, M';
  SGender:= 1;
  SBirth:= TimeStamp(1962,3,4,0,0,0,0);
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Students (SNo, SName, SGender, SBirth, SPic, SComment) '+
              'VALUES (?, ?, ?, ?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, SName);
  Tree.Hstmt1.BindByte(3, SGender);
  Tree.Hstmt1.BindTimeStamp(4, SBirth);
  SPic.LoadFromFile('STUDENT.BMP');
  if Coach then
  begin
    Tree.Hdbc1.Core:= True;//coach on
    DriverPtr.PS_SQL_LONGVARBINARY:= SPic.Size;
  end;
  Tree.Hstmt1.BindBinary(5, SPic);
  SComment.LoadFromFile('LICENSE.TXT');
  if Coach then
    DriverPtr.PS_SQL_LONGVARCHAR:= SComment.Size;
  Tree.Hstmt1.BindText(6, SComment);
  if Coach then
    Tree.Hdbc1.Core:= False;//coach off
  UpdateList;

  AddList('Assigning Parameters...');
  SNo:= '9700006';
  SName:= 'Travolta, J';
  SGender:= 1;
  SBirth:= TimeStamp(1963,4,5,0,0,0,0);
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  SPic.Free;
  SComment.Free;
end;

procedure InsertBulk;
var
  i: Longint;

  SNo: NullString;
  SName: NullString;
  SGender: Byte;
begin
  Tree.Hdbc1.StartTransact;

  AddList('Preparing Statement...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Students (SNo, SName, SGender) VALUES (?, ?, ?)';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  Tree.Hstmt1.BindNullString(1, SNo);
  Tree.Hstmt1.BindNullString(2, SName);
  Tree.Hstmt1.BindByte(3, SGender);
  UpdateList;

  for i:= 1 to BulkRows do
  begin
    StrPCopy(SNo, '98'+LeadingZeros(i, 4));
    StrPCopy(SName, 'Surname, '+LeadingZeros(i, 4));
    SGender:= i mod 2;

    Tree.Hstmt1.Execute;
    if (i mod 10) = 0 then
    begin
      AddList('Rows Inserted: '+IntToStr(i));
      UpdateList;
    end;
  end;

  Tree.Hdbc1.EndTransact;
end;

procedure SelectRows;
var
  SNo: NullString;
begin
  AddList('Preparing Statement...');
  Tree.Hstmt1.BlobSize:= 100000;  //only needed for some databases
  Tree.Hstmt1.SQL:= 'SELECT * FROM Students WHERE SNo = ?';
  Tree.Hstmt1.Prepare;
  UpdateList;

  AddList('Binding Parameter...');
  Tree.Hstmt1.BindNullString(1, SNo);
  UpdateList;

  AddList('Assigning Parameter...');
  SNo:= '9700004';
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  if Tree.Hstmt1.FetchNext then
  begin
    Tree.Hstmt1.ColMemory[5].SaveToFile('WEAVER.BMP');
    AddList('Student''s Picture Saved: '+Tree.Hstmt1.ColString[2]);
  end;

  AddList('Assigning Parameter...');
  SNo:= '9700005';
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  if Tree.Hstmt1.FetchNext then
  begin
    Tree.Hstmt1.ColMemory[5].SaveToFile('GIBSON.BMP');
    AddList('Student''s Picture Saved: '+Tree.Hstmt1.ColString[2]);
  end;

  AddList('Assigning Parameter...');
  SNo:= '9700006';
  UpdateList;

  AddList('Executing Statement...');
  Tree.Hstmt1.Execute;
  UpdateList;

  if Tree.Hstmt1.FetchNext then
  begin
    Tree.Hstmt1.ColMemory[6].SaveToFile('TRAVOLTA.TXT');
    AddList('Student''s Comment Saved: '+Tree.Hstmt1.ColString[2]);
  end;
end;

procedure Transactions;
var
  SNo1, SNo2: NullString;
  SName1, SName2: NullString;
  SGender1, SGender2: Byte;

procedure DisplayOptions(var Hdbc: THdbc;
                         var Hstmt: THstmt);
begin
  { Isolation Level }
  AddList('  Isolation Level:');
  case Hdbc.IsolationLevel of
    SQL_TXN_READ_UNCOMMITTED:
      AddList('    Read Uncommitted');
    SQL_TXN_READ_COMMITTED:
      AddList('    Read Committed');
    SQL_TXN_REPEATABLE_READ:
      AddList('    Repeatable Read');
    SQL_TXN_SERIALIZABLE:
      AddList('    Serializable');
  end;

  { Concurrency Type }
  AddList('  Concurrency Type:');
  case Hstmt.ConcurrencyType of
    SQL_CONCUR_READ_ONLY:
      AddList('    Read Only');
    SQL_CONCUR_LOCK:
      AddList('    Lock');
    SQL_CONCUR_ROWVER:
      AddList('    RowVer');
    SQL_CONCUR_VALUES:
      AddList('    Values');
  end;

  { Cursor Type }
  AddList('  Cursor Type:');
  case Hstmt.CursorType of
    SQL_CURSOR_FORWARD_ONLY:
      AddList('    Forward Only');
    SQL_CURSOR_STATIC:
      AddList('    Static');
    SQL_CURSOR_KEYSET_DRIVEN:
      AddList('    Keyset Driven');
    SQL_CURSOR_DYNAMIC:
      AddList('    Dynamic');
  end;
end;

begin
  Tree.Hdbc1.Terminate;
  Tree.Hdbc2.Terminate;
  try
    Tree.Hstmt2.QueryTimeOut:= 10;  //some databases don't support query timeouts 
  except
  end;

  AddList('Options Hdbc1, Hstmt1:');
  DisplayOptions(Tree.Hdbc1, Tree.Hstmt1);

  AddList('Options Hdbc2, Hstmt2:');
  DisplayOptions(Tree.Hdbc2, Tree.Hstmt2);

  { *** Start Transactions *** }

  AddList('Starting Transactions...');
  Tree.Hdbc1.StartTransact;
  Tree.Hdbc2.StartTransact;
  UpdateList;

  AddList('Preparing Statements...');
  Tree.Hstmt1.SQL:= 'INSERT INTO Students (SNo, SName, SGender) VALUES (?, ?, ?)';
  Tree.Hstmt1.Prepare;

  Tree.Hstmt2.SQL:= 'INSERT INTO Students (SNo, SName, SGender) VALUES (?, ?, ?)';
  Tree.Hstmt2.Prepare;
  UpdateList;

  AddList('Binding Parameters...');
  SNo1:= '9700011';
  Tree.Hstmt1.BindNullString(1, SNo1);
  SName1:= 'Name11';
  Tree.Hstmt1.BindNullString(2, SName1);
  SGender1:= 0;
  Tree.Hstmt1.BindByte(3, SGender1);

  SNo2:= '9700012';
  Tree.Hstmt2.BindNullString(1, SNo2);
  SName2:= 'Name12';
  Tree.Hstmt2.BindNullString(2, SName2);
  SGender2:= 0;
  Tree.Hstmt2.BindByte(3, SGender2);
  UpdateList;

  try
    AddList('Executing Statement 1...');
    Tree.Hstmt1.Execute;
    Tree.Hdbc1.Commit;  //if this line is commented out, the app will timeout
                        //on the next execute after 10 seconds, as set above
    UpdateList;

    AddList('Executing Statement 2...');
    Tree.Hstmt2.Execute;
    Tree.Hdbc2.Commit;
    UpdateList;
  finally
    AddList('Ending Transactions...');
    Tree.Hdbc1.EndTransact;
    Tree.Hdbc2.EndTransact;
    UpdateList;
  end;
end;

{ Generated }

procedure TForm1.Button1Click(Sender: TObject);

procedure EnableButtons(AEnabled: Boolean);
begin
  Button2.Enabled:= AEnabled;
  Button3.Enabled:= AEnabled;
  Button4.Enabled:= AEnabled;
end;

begin
  if Form2.ShowModal = mrOK then
  begin
    ListBox1.Items.Clear;
    ListCount:= 0;
    EnableButtons(Tree.Hdbc1.Connected);
    if Tree.Hdbc1.Connected then
      AddList('Connected to DataSource '+Tree.Hdbc1.DataSource)
    else
      AddList('Not Connected to DataSource '+Tree.Hdbc1.DataSource)
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  AddList('Loading Data...');
  with Tree.OESchema1 do
  begin
    DropTables(True);
    LoadTables;
  end;

  InsertRows;
  InsertRows2;
  InsertBulk;
  AddList('Data Loaded');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Addlist('Selecting Rows...');
  SelectRows;
  AddList('Rows Selected');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  AddList('Performing Transactions...');
  Transactions;
  AddList('Transactions Performed');
end;

end.

