{ Project: OEiSQL                                                    }
{ Description: Interactive SQL                                       }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, OCIH, OCI, OCL, QComCtrls, QButtons, QExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Hdbc1: THdbc;
    Hstmt1: THstmt;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    BitBtn1: TBitBtn;
    RadioGroup1: TRadioGroup;
    Label2: TLabel;
    Label3: TLabel;
    Edit2: TEdit;
    Edit1: TEdit;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    NumRows: Longint;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  Unit2;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.ShowModal;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  i, RowsAffected: Integer;
  RetCode: SQLRETURN;
  icol: SQLUSMALLINT;
  CharAttr: NullString;
  NumAttr: SQLINTEGER;
  StringLength: SQLSMALLINT;
  Columns: String;

  OldCursor: TCursor;
  StartTime, TotalTime: TDateTime;
  Hour, Min, Sec, MSec: Word;
begin
  if not Hdbc1.Connected then
    Exit;

  OldCursor:= Screen.Cursor;
  Screen.Cursor:= crHourGlass;
  Memo1.Lines.BeginUpdate;

  try

    try

      case RadioGroup1.ItemIndex of
        0: Hstmt1.RowSetSize:= 1;
        1: Hstmt1.RowSetSize:= 64;
      end;

      if ComboBox1.Items.IndexOf(ComboBox1.Text) = -1 then
        ComboBox1.Items.Add(ComboBox1.Text);

      Hdbc1.StartTransact;

      try

        Hstmt1.SQL:= ComboBox1.Text;
        Hstmt1.Prepare;
        Hstmt1.Execute;
        RowsAffected:= Hstmt1.RowsAffected;

        Memo1.Clear;
        Columns:= '';
        for icol:= 1 to Hstmt1.ColCount do
        begin
          { Retrieve Column Display Size }
          RetCode:= SQLColAttribute(Hstmt1.Handle, icol, SQL_DESC_DISPLAY_SIZE,
            @CharAttr, SizeOf(NumAttr), @StringLength, @NumAttr);

          { Raise ODBCError }
          if not GlobalHenv.Error.Success(RetCode) then
            GlobalHenv.Error.RaiseError(Hstmt1, RetCode);

          Columns:= Columns+Hstmt1.ColNames[icol-1]+'['+IntToStr(NumAttr)+']  ';
        end;

        Edit1.Text:= '';
        Edit2.Text:= '';

        Memo1.Lines.Add(Columns);
        Memo1.Lines.Add('');

        StartTime:= Now;
        NumRows:= 0;
        while Hstmt1.FetchNext do
          for i:= 1 to Hstmt1.RowsFetched do
          begin
            Inc(NumRows);
            Columns:= '';
            for icol:= 1 to Hstmt1.ColCount do
              if Hstmt1.BlobCol[icol] then
              begin
                if Hstmt1.SqlType[icol] = SQL_LONGVARBINARY then
                begin
                  if Hstmt1.CellNull[icol,i] then
                    Columns:= Columns+'[Binary]  '
                  else
                    Columns:= Columns+'[BINARY]  ';
                end
                else
                begin
                  if Hstmt1.CellNull[icol,i] then
                    Columns:= Columns+'[Text]  '
                  else
                    Columns:= Columns+'[TEXT]  ';
                end;
              end
              else
                Columns:= Columns+Hstmt1.CellString[icol,i]+'  ';
            Memo1.Lines.Add(Columns);
          end;
        TotalTime:= Now-StartTime;

      finally
        Hdbc1.EndTransact;
      end;

      Edit1.Text:= IntToStr(NumRows);
      DecodeTime(TotalTime, Hour, Min, Sec, MSec);
      Sec:= Min*60 + Sec;
      Edit2.Text:= IntToStr(Sec);

    except
      On E: EODBC do
        if E.State = '24000' then  //Invalid Cursor State
          Memo1.Lines.Add('Rows Affected: '+IntToStr(RowsAffected))
        else
          E.Detail('ODBC Error');
    end;

  finally
    Memo1.Lines.EndUpdate;
    Screen.Cursor:= OldCursor;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ComboBox1.Items.Delete(ComboBox1.ItemIndex);
end;

end.

