{ Project: OEInfo                                                    }
{ Description: ODBC Information                                      }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QButtons, OCIH, OCL, OVCL;


type              
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    DSComboBox1: TDSComboBox;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Memo1: TMemo;
    Button1: TButton;
    SaveDialog1: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure RetrieveInfo;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    RetrieveInfo;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.RetrieveInfo;
var
  s: String;
begin
  Memo1.Clear;

  Memo1.Lines.Add('[ODBCExpress Information]');
  Memo1.Lines.Add('ODBCExpress Version:  '+OEVER);
  Memo1.Lines.Add('');
  Memo1.Lines.Add('[ODBC Information]');
  Memo1.Lines.Add('ODBC Version:  '+Hdbc1.GetInfoString(SQL_ODBC_VER));
  Memo1.Lines.Add('ODBC Driver Manager Version:  '+Hdbc1.GetInfoString(SQL_DM_VER));
  Memo1.Lines.Add('');
  Memo1.Lines.Add('[ODBC Driver Information]');
  Memo1.Lines.Add('ODBC Driver:  '+Hdbc1.GetInfoString(SQL_DRIVER_NAME));
  Memo1.Lines.Add('ODBC Driver Version:  '+Hdbc1.GetInfoString(SQL_DRIVER_VER));
  Memo1.Lines.Add('ODBC Version Supported by Driver:  '+Hdbc1.GetInfoString(SQL_DRIVER_ODBC_VER));

  case Hdbc1.GetInfoInteger(SQL_STANDARD_CLI_CONFORMANCE) of
    SQL_SCC_XOPEN_CLI_VERSION1:
      s:= 'X/Open CLI Version 1';
    SQL_SCC_ISO92_CLI:
      s:= 'ISO 92 CLI';
    else
      s:= '';
  end;
  Memo1.Lines.Add('CLI Standard Conformance:  '+s);

  case Hdbc1.GetInfoInteger(SQL_ODBC_INTERFACE_CONFORMANCE) of
    SQL_OIC_CORE:
      s:= 'Core';
    SQL_OIC_LEVEL1:
      s:= 'Level 1';
    SQL_OIC_LEVEL2:
      s:= 'Level 2';
    else
      s:= '';
  end;
  Memo1.Lines.Add('ODBC 3.x Interface Conformance:  '+s);

  case Hdbc1.GetInfoInteger(SQL_SQL_CONFORMANCE) of
    SQL_SC_SQL92_ENTRY:
      s:= 'Entry Level SQL-92';
    SQL_SC_FIPS127_2_TRANSITIONAL:
      s:= 'FIPS 127-2 Transitional Level';
    SQL_SC_SQL92_FULL:
      s:= 'Full Level SQL-92';
    SQL_SC_SQL92_INTERMEDIATE:
      s:= 'Intermediate Level SQL-92';
    else
      s:= '';
  end;
  Memo1.Lines.Add('SQL 3.x Conformance:  '+s);

  case Hdbc1.GetInfoSmallint(SQL_ODBC_API_CONFORMANCE) of
    SQL_OAC_NONE:
      s:= 'None';
    SQL_OAC_LEVEL1:
      s:= 'Level 1';
    SQL_OAC_LEVEL2:
      s:= 'Level 2';
    else
      s:= '';
  end;
  Memo1.Lines.Add('ODBC 2.x Interface Conformance:  '+s);

  case Hdbc1.GetInfoSmallint(SQL_ODBC_SQL_CONFORMANCE) of
    SQL_OSC_MINIMUM:
      s:= 'Minimum Grammar';
    SQL_OSC_CORE:
      s:= 'Core Grammar';
    SQL_OSC_EXTENDED:
      s:= 'Extended Grammar';
    else
      s:= '';
  end;
  Memo1.Lines.Add('SQL 2.x Conformance:  '+s);

  Memo1.Lines.Add('');
  Memo1.Lines.Add('[Database Management System Information]');
  Memo1.Lines.Add('Database Management System:  '+Hdbc1.GetInfoString(SQL_DBMS_NAME));
  Memo1.Lines.Add('Database Management System Version:  '+Hdbc1.GetInfoString(SQL_DBMS_VER));
  Memo1.Lines.Add('');
  Memo1.Lines.Add('[DataSouce Information]');
  Memo1.Lines.Add('DataSource:  '+Hdbc1.GetInfoString(SQL_DATA_SOURCE_NAME));
  Memo1.Lines.Add('Server:  '+Hdbc1.GetInfoString(SQL_SERVER_NAME));
  Memo1.Lines.Add('Database:  '+Hdbc1.GetInfoString(SQL_DATABASE_NAME));
  Memo1.Lines.Add('User Name:  '+Hdbc1.GetInfoString(SQL_USER_NAME));
  Memo1.Lines.Add('');
  Memo1.Lines.Add('[Other Information]');
  Memo1.Lines.Add('Can Describe Parameters:  '+Hdbc1.GetInfoString(SQL_DESCRIBE_PARAMETER));
  if Hdbc1.GetFunction(SQL_API_SQLDESCRIBEPARAM) then
    s:= 'Y'
  else
    s:= 'N';
  Memo1.Lines.Add('Supports SQLDescribeParam:  '+s);
  Memo1.Lines.Add('Needs Long Data Length:  '+Hdbc1.GetInfoString(SQL_NEED_LONG_DATA_LEN));
end;

end.

