{ Project: OEiGrid                                                   }
{ Description: Interactive Grid                                      }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QGrids, OCIH, OCI, OCL, OVCL, QExtCtrls, QStdCtrls, QButtons,
  QDBGrids, Db, ODSI;

type
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    Panel1: TPanel;
    Button1: TButton;
    BitBtn1: TBitBtn;
    OECatalog1: TOECatalog;
    ComboBox1: TComboBox;
    Label1: TLabel;
    DBGrid1: TDBGrid;
    OEDataSet1: TOEDataSet;
    DataSource1: TDataSource;
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  Unit2;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.ShowModal;
  if Hdbc1.Connected then
  begin
    OECatalog1.Refresh;
    ComboBox1.Items.Assign(OECatalog1.TableNames);
    ComboBox1.ItemIndex:= -1;
    ComboBox1.Enabled:= True;
    OECatalog1.Terminate;
  end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor:= Screen.Cursor;
  Screen.Cursor:= crHourGlass;

  try

    OEDataSet1.Close;
    if ComboBox1.ItemIndex > -1 then
    begin
      OEDataSet1.Table:= ComboBox1.Items[ComboBox1.ItemIndex];
      OEDataSet1.Open;
    end;

  finally
    Screen.Cursor:= OldCursor;
  end;
end;

end.

