{ Project: OECopy                                                    }
{ Description: Bulk Copy Data                                        }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, OVCL, OCL;

type
  TForm1 = class(TForm)
    HdbcSource: THdbc;
    HdbcTarget: THdbc;
    OESchemaTarget: TOESchema;
    DSComboBoxSource: TDSComboBox;
    DSComboBoxTarget: TDSComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    OEBulkCopy1: TOEBulkCopy;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure OEBulkCopy1Progress(Sender: TObject; Info: String);
    procedure OEBulkCopy1BindParams(Sender: TObject; Table: String;
      Hstmt: THstmt);
    procedure DSComboBoxSourceChange(Sender: TObject);
    procedure DSComboBoxTargetChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    SNo: String;

    procedure EnableButtons(Enable: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  EnableButtons(False);

  try

    OEBulkCopy1.Terminate;
    OESchemaTarget.DropTables(True);
    OESchemaTarget.LoadTables;

    OEBulkCopy1.SQLSource:= 'SELECT SNo, SName, SGender, SBirth, SPic, SComment FROM Students';
    OEBulkCopy1.SQLTarget:= 'INSERT INTO Students (SNo, SName, SGender, SBirth, SPic, SComment) VALUES (:SNo, :SName, :SGender, :SBirth, :SPic, :SComment)';
    OEBulkCopy1.RowSetSize:= 100;  //nulls will be inserted for blob fields
    OEBulkCopy1.Execute;

  finally
    EnableButtons(True);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  DriverPtr: TDriverPtr;
begin
  EnableButtons(False);

  try

    OEBulkCopy1.Terminate;
    OESchemaTarget.DropTables(True);
    OESchemaTarget.LoadTables;

    //This driver needs a bit of couching
    DriverPtr:= nil;
    if HdbcTarget.CurrentDriver = 'Microsoft SQL Server;esoobclient' then
    begin
      DriverPtr:= HdbcTarget.AddDriver(HdbcTarget.CurrentDriver);
      DriverPtr.PS_SQL_LONGVARBINARY:= 100000;
      DriverPtr.PS_SQL_LONGVARCHAR:= 100000;
      HdbcTarget.Core:= True;//coach on
    end;

    OEBulkCopy1.SQLSource:= 'SELECT SNo, SName, SGender, SBirth, SPic, SComment FROM Students';
    OEBulkCopy1.SQLTarget:= 'INSERT INTO Students (SNo, SName, SGender, SBirth, SPic, SComment) VALUES (:SNo, :SName, :SGender, :SBirth, :SPic, :SComment)';
    OEBulkCopy1.RowSetSize:= 1;  //blob fields will also be copied
    OEBulkCopy1.Execute;

    if DriverPtr <> nil then
      HdbcTarget.Core:= False;//coach off

  finally
    EnableButtons(True);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  EnableButtons(False);

  try

    OEBulkCopy1.Terminate;
    OESchemaTarget.DropTables(True);
    OESchemaTarget.LoadTables;

    OEBulkCopy1.OnBindParams:= OEBulkCopy1BindParams;

    try

      OEBulkCopy1.SQLSource:= 'SELECT SNo, SName, SGender, SBirth, SPic, SComment FROM Students WHERE SNo LIKE :SNo';
      OEBulkCopy1.SQLTarget:= 'INSERT INTO Students (SNo, SName, SGender, SBirth, SPic, SComment) VALUES (:SNo, :SName, :SGender, :SBirth, :SPic, :SComment)';
      OEBulkCopy1.RowSetSize:= 100;  //nulls will be inserted for blob fields
      OEBulkCopy1.Execute;

    finally
      OEBulkCopy1.OnBindParams:= nil;
    end;

  finally
    EnableButtons(True);
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  EnableButtons(False);

  try

    OEBulkCopy1.Terminate;
    OESchemaTarget.DropTables(True);
    OESchemaTarget.LoadTables;

    OEBulkCopy1.RowSetSize:= 100;  //nulls will be inserted for blob fields
    OEBulkCopy1.RunScript('COPYDATA.SQL');

  finally
    EnableButtons(True);
  end;
end;

procedure TForm1.OEBulkCopy1Progress(Sender: TObject; Info: String);
begin
  Label3.Caption:= 'Copied '+IntToStr(OEBulkCopy1.RowsAffected)+' rows to '+Info;
  Label3.Refresh;
end;

procedure TForm1.OEBulkCopy1BindParams(Sender: TObject; Table: String;
  Hstmt: THstmt);
begin
  if Table = 'Students' then
  begin
    SNo:= '98_____';
    Hstmt.BindStringByName('SNo', SNo);
  end;
end;

procedure TForm1.DSComboBoxSourceChange(Sender: TObject);
begin
  try

    if DSComboBoxSource.ItemIndex > -1 then
    begin
      HdbcSource.Disconnect;
      HdbcSource.DataSource:= DSComboBoxSource.DataSource;
      HdbcSource.Connect;

      EnableButtons(HdbcSource.Connected and HdbcTarget.Connected);
    end;

  except
    DSComboBoxSource.ItemIndex:= -1;
    raise;
  end;
end;

procedure TForm1.DSComboBoxTargetChange(Sender: TObject);
begin
  try

    if DSComboBoxTarget.ItemIndex > -1 then
    begin
      HdbcTarget.Disconnect;
      HdbcTarget.DataSource:= DSComboBoxTarget.DataSource;
      HdbcTarget.Connect;

      EnableButtons(HdbcSource.Connected and HdbcTarget.Connected);
    end;

  except
    DSComboBoxTarget.ItemIndex:= -1;
    raise;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBoxSource.Populate;
  DSComboBoxTarget.Populate;

  DSComboBoxSource.ItemIndex:= -1;
  DSComboBoxTarget.ItemIndex:= -1;

  Label3.Caption:= '';
  OEBulkCopy1.OnBindParams:= nil;
  EnableButtons(False);
end;

procedure TForm1.EnableButtons(Enable: Boolean);
begin
  Button1.Enabled:= Enable;
  Button2.Enabled:= Enable;
  Button3.Enabled:= Enable;
  Button4.Enabled:= Enable;
end;

end.

