{ Project: OECache                                                   }
{ Description: DataSet Caching                                       }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }
{ Kylix Note: There seems to be a problem with the TDBImage control  }
{             which prevents you from inserting or updating a bitmap }
{             using the control.  To fix this problem, change the    }
{             line "FDataLink.Field.Assign(Picture.Graphic) else"    }
{             in the procedure "TDBImage.UpdateData" in the unit     }
{             "QDBCtrls" to "FDataLink.Field.Assign(Picture) else".  }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  OVCL, QStdCtrls, QDBCtrls, QGrids, QDBGrids, DB, ODSI, OCL, QExtCtrls,
  QButtons;

type              
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    OEDataSet1: TOEDataSet;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBMemo1: TDBMemo;
    DBImage1: TDBImage;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    BitBtn1: TBitBtn;
    CheckBox2: TCheckBox;
    DSComboBox1: TDSComboBox;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure OEDataSet1UpdateError(DataSet: TDataSet; E: EODBC;
      UpdateKind: TUpdateKind; var RaiseError: Boolean);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
    procedure OEDataSet1BeforePost(DataSet: TDataSet);
    procedure OEDataSet1AfterPost(DataSet: TDataSet);
  private
    { Private declarations }
    DriverPtr: TDriverPtr;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
{$R GENDER.RES}

procedure TForm1.Button1Click(Sender: TObject);
begin
  OEDataSet1.Edit;
  DBImage1.Picture.Bitmap.LoadFromResourceName(HInstance, 'MALE');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  OEDataSet1.Edit;
  DBImage1.Picture.Bitmap.LoadFromResourceName(HInstance, 'FEMALE');
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  OEDataSet1.CachedUpdates:= CheckBox1.Checked;
  Button3.Enabled:= CheckBox1.Checked;
  Button4.Enabled:= CheckBox1.Checked;
  Button5.Enabled:= CheckBox1.Checked;

  CheckBox2.Checked:= OEDataSet1.Active;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OEDataSet1.ApplyUpdates;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  OEDataSet1.CancelUpdates;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  OEDataSet1.RevertRecord;
end;

procedure TForm1.OEDataSet1UpdateError(DataSet: TDataSet; E: EODBC;
  UpdateKind: TUpdateKind; var RaiseError: Boolean);
var
  Message: String;
begin
  case UpdateKind of
    ukModify:
      Message:= 'Record not Updated: ';
    ukInsert:
      Message:= 'Record not Inserted: ';
    ukDelete:
      Message:= 'Record not Deleted: ';
  end;
  E.Detail(Message+DataSet.FieldByName('SNo').AsString);

  RaiseError:= False;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  OEDataSet1.Active:= CheckBox2.Checked;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    //This driver needs a bit of couching
    DriverPtr:= nil;
    if Hdbc1.CurrentDriver = 'Microsoft SQL Server;esoobclient' then
      DriverPtr:= Hdbc1.AddDriver(Hdbc1.CurrentDriver);

    CheckBox2.Enabled:= True;
  end;
end;


procedure TForm1.OEDataSet1BeforePost(DataSet: TDataSet);
begin
  if DriverPtr <> nil then
  begin
    Hdbc1.Core:= True;//coach on
    DriverPtr.PS_SQL_LONGVARBINARY:= 100000;
    DriverPtr.PS_SQL_LONGVARCHAR:= 100000;
  end;
end;

procedure TForm1.OEDataSet1AfterPost(DataSet: TDataSet);
begin
  if DriverPtr <> nil then
    Hdbc1.Core:= False;//coach off
end;


end.

