{ Project: OEBulk                                                    }
{ Description: Bulk Operations                                       }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QButtons, QStdCtrls, QExtCtrls, QGrids, OVCL, OCL, OCIH;

type
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    Hstmt1: THstmt;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn5: TBitBtn;
    Button1: TButton;
    Button2: TButton;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    Edit2: TEdit;
    Hstmt2: THstmt;
    Label4: TLabel;
    DSComboBox1: TDSComboBox;
    Label5: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DataChange(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
  private
    { Private declarations }
    FNumRows, FCurRow: Integer;
    FChanging: Boolean;

    procedure DisplayInfo;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.DisplayInfo;
begin
  FChanging:= True;

  Edit1.Text:= Hstmt1.CellStringByName['SNo', FCurRow];
  Checkbox1.Checked:= Hstmt1.CellByteByName['SGender', FCurRow] = 1;
  Edit2.Text:= Hstmt1.CellStringByName['SName', FCurRow];

  FChanging:= False;
end;

procedure TForm1.DataChange(Sender: TObject);
begin
  if FChanging then
    Exit;

  with Hstmt1 do
  begin
    CellIgnore[ColByName('SNo'), FCurRow]:= True;
    if CheckBox1.Checked then
      CellByteByName['SGender', FCurRow]:= 1
    else
      CellByteByName['SGender', FCurRow]:= 0;
    CellStringByName['SName', FCurRow]:= Edit2.Text;

    RowFlag[FCurRow]:= rfUpdate;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  FChanging:= False;

  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.Button2Click(Sender: TObject);
const
  BulkRows = 1000;
var
  i: Integer;
  SNo, SName: array[1..BulkRows] of NullString;
  SGender: array[1..BulkRows] of Byte;
begin
  with Hstmt2 do
  begin
    { Delete Existing Bulk Records }
    SQL:= 'DELETE FROM Students WHERE SNo LIKE ''bulk%''';
    Prepare;
    Execute;

    { Insert Bulk Records }
    SQL:= 'INSERT INTO Students (SNo, SName, SGender) VALUES (?, ?, ?)';
    Prepare;
    BindNullStrings(1, SNo);
    BindNullStrings(2, SName);
    BindBytes(3, SGender);
    BulkSize:= BulkRows;  //not necessary if High(ParamValue)+1 = BulkRows

    for i:= 1 to BulkRows do
    begin
      Label4.Caption:= 'Adding Row #'+IntToStr(i)+' ...';
      Label4.Refresh;
      StrPCopy(SNo[i], 'bulkno'+IntToStr(i));
      StrPCopy(SName[i], 'bulkname'+IntToStr(i));
      SGender[i]:= i mod 2;
    end;

    Label4.Caption:= 'Inserting Bulk Rows ...';
    Label4.Refresh;
    Execute;

    Label4.Caption:= '1000 Rows Inserted';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Hstmt1.DoUpdate;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  if not Hstmt1.FetchPrev then
    Hstmt1.FetchNext;
  FNumRows:= Hstmt1.RowsFetched;
  FCurRow:= 1;

  DisplayInfo;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if not Hstmt1.FetchNext then
    Hstmt1.FetchPrev;
  FNumRows:= Hstmt1.RowsFetched;
  FCurRow:= 1;

  DisplayInfo;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  if FCurRow > 1 then
    Dec(FCurRow);

  DisplayInfo;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  if FCurRow < FNumRows then
    Inc(FCurRow);

  DisplayInfo;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    Hstmt1.SQL:= 'SELECT SNo, SName, SGender FROM Students';
    Hstmt1.Prepare;
    Hstmt1.Execute;

    Form1.BitBtn2Click(Sender);
  end;
end;

end.

