{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uUpdateGenerateDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QExtCtrls;

type
  TUpdateGenerateDlg = class(TForm)
    imgGenerateTarget: TImage;
    Label1: TLabel;
    rbselected: TRadioButton;
    rbAll: TRadioButton;
    Label2: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    imgUpdate: TImage;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent; bUpdate : boolean ); reintroduce;
  end;

var
  UpdateGenerateDlg: TUpdateGenerateDlg;

implementation

{$R *.xfm}

constructor TUpdateGenerateDlg.Create(AOwner : TComponent; bUpdate : boolean );
resourcestring
  rsUpdatingStrings = 'Updating Strings';
begin
  inherited Create(AOwner);
  imgUpdate.visible         := bUpdate;
  imgGenerateTarget.visible := not bUpdate;
  if bUpdate then
    caption := rsUpdatingStrings;
end;

end.
