{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uTransListPropsDlg;

interface

uses
  uProject,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QExtCtrls;

type
  TTransListPropsDlg = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    grpSource: TGroupBox;
    Label1: TLabel;
    lblSourceFileName: TLabel;
    Label3: TLabel;
    lblSourceLang: TLabel;
    grpTarget: TGroupBox;
    Label5: TLabel;
    efTargetFilename: TEdit;
    Label6: TLabel;
    lblTargetLang: TLabel;
    rgTargetFileFormat: TRadioGroup;
    btnBrowseTargetFile: TButton;
    SetTargetFileDlg: TSaveDialog;
    Label2: TLabel;
    Label4: TLabel;
    lblFiletime: TLabel;
    lblLastGeneration: TLabel;
    grpTransList: TGroupBox;
    Label7: TLabel;
    lblLastUpdate: TLabel;
    grpStatus: TGroupBox;
    imgStringsNotCreated: TImage;
    lblStringsNotCreated: TLabel;
    imgSourceChanged: TImage;
    lblSourceChanged: TLabel;
    imgTargetNotExist: TImage;
    lblTargetNotExist: TLabel;
    procedure FormShow(Sender: TObject);
    procedure btnBrowseTargetFileClick(Sender: TObject);
    procedure rgTargetFileFormatClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure efTargetFilenameChange(Sender: TObject);
  private
    { Private-Deklarationen }
    m_Translation : TTranslation;
    procedure UpdateOperations;
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; Translation : TTranslation ); reintroduce;
  end;

var
  TransListPropsDlg: TTransListPropsDlg;

implementation

{$R *.xfm}

uses
  uLanguage;

constructor TTransListPropsDlg.Create( AOwner : TComponent; Translation : TTranslation );
begin
  inherited create(AOwner);
  m_Translation := Translation;
end;

procedure TTransListPropsDlg.FormShow(Sender: TObject);
begin
  caption := caption + format(' - %s, %s -> %s', [m_Translation.parentsource.Title,
                                                  GetLangId(m_Translation.ParentSource.LangNo),
                                                  GetLangId(m_Translation.LangNo) ]);
  lblSourceFilename.caption := m_Translation.ParentSource.ExeFileName;
  lblSourceLang.caption     := GetLang(m_Translation.ParentSource.LangNo);
  efTargetFilename.text     := m_Translation.TargetFileName;
  lblTargetLang.caption     := GetLang(m_Translation.LangNo);
  rgTargetFileFormat.itemindex := ord(m_Translation.FileFormat);

  imgSourceChanged.Visible := FileDateToDateTime(fileage(m_Translation.ParentSource.ExeFileName)) > m_Translation.LastUpdate;
  lblSourceChanged.Visible := imgSourceChanged.Visible;
  UpdateOperations;
end;

procedure TTransListPropsDlg.btnBrowseTargetFileClick(Sender: TObject);
begin
   SetTargetFileDlg.initialDir := extractFilePath(efTargetFilename.Text);
   SetTargetFileDlg.filename   := extractFileName(efTargetFilename.Text);
   if SetTargetFileDlg.execute then
     efTargetFilename.Text := SetTargetFileDlg.filename;
   UpdateOperations;
end;

procedure TTransListPropsDlg.rgTargetFileFormatClick(Sender: TObject);
begin
  case rgTargetFileFormat.ItemIndex of
    0: efTargetFilename.Text := changeFileExt(efTargetFilename.Text, '.'+getLangId(m_Translation.LangNo));
    1: efTargetFilename.Text := changeFileExt(efTargetFilename.Text, '');
  end;
end;

procedure TTransListPropsDlg.btnOKClick(Sender: TObject);
begin
    m_Translation.TargetFileName := efTargetFilename.text;
    m_Translation.FileFormat := TTargetFileFormat(rgTargetFileFormat.itemindex);
end;

procedure TTransListPropsDlg.efTargetFilenameChange(Sender: TObject);
begin
   UpdateOperations;
end;

procedure TTransListPropsDlg.UpdateOperations;
begin
    if fileexists(efTargetFileName.text) then begin
      lblFileTime.Caption       := DateTimeToStr( FileDateToDateTime(fileage(efTargetFileName.text)) );
      lblLastGeneration.Caption := DateTimeToStr(m_Translation.LastTargetGeneration);
    end else begin
      lblFileTime.Caption := '';
      lblLastGeneration.Caption := '';
    end;
    if m_Translation.LastUpdate <> 0 then
       lblLastUpdate.caption := DateTimeToStr(m_Translation.LastUpdate)
    else
       lblLastUpdate.caption := '';

  lblStringsNotCreated.Visible := not fileexists(m_Translation.ListFileName);
  imgStringsNotCreated.Visible := lblStringsNotCreated.Visible;
  imgTargetNotExist.Visible    := not fileexists(efTargetFileName.text);
  lblTargetNotExist.Visible    := imgTargetNotExist.Visible;
end;

end.
