{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uTransFilterDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls;

type
  TFilter = set of (tfTranslated, tfUnTranslated, tfReview, tfReadOnly);
  TTransFilterDlg = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    cbTranslated: TCheckBox;
    cbUntranslated: TCheckBox;
    cbReview: TCheckBox;
    cbReadOnly: TCheckBox;
    ntnRemoveFilter: TButton;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
    m_Filter : TFilter;
  public
    { Public-Deklarationen }
    property Filter : TFilter read m_Filter write m_Filter;
  end;

var
  TransFilterDlg: TTransFilterDlg;

implementation

{$R *.xfm}

procedure TTransFilterDlg.FormShow(Sender: TObject);
begin
   cbTranslated.Checked   := tfTranslated in m_Filter;
   cbUnTranslated.Checked := tfUntranslated in m_Filter;
   cbReview.Checked       := tfReview in m_Filter;
   cbReadOnly.Checked     := tfReadOnly in m_Filter;
end;

procedure TTransFilterDlg.btnOKClick(Sender: TObject);
begin
   m_Filter := [];
   if cbTranslated.Checked then
     m_Filter := m_Filter + [tfTranslated];
   if cbUnTranslated.Checked then
     m_Filter := m_Filter + [tfUnTranslated];
   if cbReview.Checked then
     m_Filter := m_Filter + [tfReview];
   if cbReadOnly.Checked then
     m_Filter := m_Filter + [tfReadOnly];
end;

end.
