{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uStatisticsDlg;

interface

uses
  uTextLists,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls;

type
  TStatisticsDlg = class(TForm)
    Label1: TLabel;
    lblName: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    lblStringCount: TLabel;
    lblWordCount: TLabel;
    lblTransRate: TLabel;
    lblLengthChange: TLabel;
    btnOK: TButton;
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    m_TransTextList : TTransTextList;
  public
    { Public-Deklarationen }
    constructor create( AOwner : TComponent; list : TTransTextList ); reintroduce;
  end;

var
  StatisticsDlg: TStatisticsDlg;

implementation

{$R *.xfm}

uses
  uLanguage;

constructor TStatisticsDlg.Create( AOwner : TComponent; list : TTransTextList );
begin
  inherited Create(AOwner);
  m_TransTextList := list;
end;


procedure TStatisticsDlg.FormShow(Sender: TObject);
var
 iStringCount, iWordCount, iTransRate, iLengthChange : integer;
begin
   if assigned(m_TransTextList.ParentTranslation) then
      lblName.Caption := m_TransTextList.ParentTranslation.ParentSource.Title+', '
   else
      lblName.Caption := '';
   lblName.Caption := lblName.Caption + getLangID(m_TransTextList.SourceLangNo)+' -> '+
                                        getLangID(m_TransTextList.TransLangNo);
   m_TransTextList.GetStatistics(iStringCount, iWordCount, iTransRate, iLengthChange);
   lblStringCount.Caption  := inttostr(iStringCount);
   lblWordCount.Caption    := inttostr(iWordCount);
   lblTransrate.Caption    := inttostr(iTransRate) + ' % ';
   lblLengthChange.Caption := inttostr(iLengthChange) + ' % ';
end;

end.
