{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uSourceListPropsDlg;

interface

uses
  uProject,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QExtCtrls;

type
  TSourceListPropsDlg = class(TForm)
    btnCancel: TButton;
    btnOK: TButton;
    grpSourceFile: TGroupBox;
    Label1: TLabel;
    efFileName: TEdit;
    btnBrowseFileName: TButton;
    Label2: TLabel;
    comboLanguage: TComboBox;
    OpenFileNameDlg: TOpenDialog;
    Label3: TLabel;
    lblFileTime: TLabel;
    grpSourceList: TGroupBox;
    Label4: TLabel;
    lblLastUpdate: TLabel;
    grpStatus: TGroupBox;
    imgStringsNotCreated: TImage;
    lblStringsNotCreated: TLabel;
    imgSourceChanged: TImage;
    lblSourceChanged: TLabel;
    procedure efFileNameChange(Sender: TObject);
    procedure comboLanguageChange(Sender: TObject);
    procedure btnBrowseFileNameClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
    m_Source : TSource;
    procedure UpdateOperations;
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; Source : TSource ); reintroduce;
  end;

var
  SourceListPropsDlg: TSourceListPropsDlg;

implementation

{$R *.xfm}

uses
  uLanguage;

constructor TSourceListPropsDlg.Create( AOwner : TComponent; Source : TSource );
var
  srcdate : TDateTime;
begin
  inherited Create(AOwner);
  m_Source := Source;
  AssignLanguages(comboLanguage.Items);
  lblLastUpdate.caption := '';
  if assigned(m_Source) then begin
     caption := caption + ' - ' + m_Source.Title;
     efFileName.Text         := m_Source.ExeFileName;
     comboLanguage.ItemIndex := m_Source.LangNo;
     if m_Source.lastUpdate <> 0 then
       lblLastUpdate.caption := dateTimeToStr(m_Source.lastUpdate);
  end;
  srcdate := FileDateToDateTime(fileage(efFileName.Text));
  imgSourceChanged.visible := assigned(m_source) and (srcdate > m_source.LastUpdate);
  lblSourceChanged.Visible := assigned(m_source) and (srcdate > m_source.LastUpdate);
  imgStringsNotCreated.visible := assigned(m_source) and not fileexists(m_source.ListFileName);
  lblStringsNotCreated.Visible := assigned(m_source) and not fileexists(m_source.ListFileName);
  UpdateOperations;
end;

procedure TSourceListPropsDlg.UpdateOperations;
var
  srcdate : TDateTime;
begin
  btnOK.Enabled := fileexists(efFileName.Text) and (comboLanguage.Text<>'');
  if fileexists(efFileName.Text) then begin
    srcdate := FileDateToDateTime(fileage(efFileName.Text));
    lblFileTime.Caption := DateTimeToStr( srcdate );
  end else begin
    lblFileTime.Caption := '';
  end;
end;

procedure TSourceListPropsDlg.efFileNameChange(Sender: TObject);
begin
   UpdateOperations;
end;

procedure TSourceListPropsDlg.comboLanguageChange(Sender: TObject);
begin
   UpdateOperations;
end;

procedure TSourceListPropsDlg.btnBrowseFileNameClick(Sender: TObject);
begin
    if OpenFileNameDlg.Execute then begin
       efFileName.Text := OpenFileNameDlg.FileName;
       UpdateOperations;
    end;
end;

procedure TSourceListPropsDlg.btnOKClick(Sender: TObject);
begin
   if assigned(m_Source) then begin
      m_Source.ExeFileName := efFileName.Text;
      m_Source.LangNo := comboLanguage.ItemIndex;
   end;
end;

end.
