{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uSourceFilterDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls;

type
  TFilter = set of (sfUnmodified, sfModified, sfNew);
  TSourceFilterDlg = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    cbUnmodified: TCheckBox;
    cbModified: TCheckBox;
    cbNew: TCheckBox;
    ntnRemoveFilter: TButton;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
    m_Filter : TFilter;
  public
    { Public-Deklarationen }
    property Filter : TFilter read m_Filter write m_Filter;
  end;

var
  SourceFilterDlg: TSourceFilterDlg;

implementation

{$R *.xfm}

procedure TSourceFilterDlg.FormShow(Sender: TObject);
begin
   cbUnmodified.Checked := sfUnModified in m_Filter;
   cbModified.Checked   := sfModified in m_Filter;
   cbNew.Checked        := sfNew in m_Filter;
end;

procedure TSourceFilterDlg.btnOKClick(Sender: TObject);
begin
   m_Filter := [];
   if cbUnmodified.Checked then
     m_Filter := m_Filter + [sfUnmodified];
   if cbModified.Checked then
     m_Filter := m_Filter + [sfModified];
   if cbNew.Checked then
     m_Filter := m_Filter + [sfNew];
end;

end.
