{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uScanTargetDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls;

type
  TScanTargetDlg = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    efTargetFileName: TEdit;
    Label2: TLabel;
    lblLanguage: TLabel;
    cbTranslated: TCheckBox;
    cbReview: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    btnBrowseTargetFile: TButton;
    AddTargetDlg: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure btnBrowseTargetFileClick(Sender: TObject);
    procedure efTargetFileNameChange(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  ScanTargetDlg: TScanTargetDlg;

implementation

{$R *.xfm}

procedure TScanTargetDlg.FormShow(Sender: TObject);
begin
   efTargetFilename.Text := '';
   btnOk.enabled := fileexists(efTargetFileName.text);
end;

procedure TScanTargetDlg.btnBrowseTargetFileClick(Sender: TObject);
begin
   if AddTargetDlg.execute then begin
     efTargetFileName.text := AddTargetDlg.FileName;
     btnOk.enabled := fileexists(efTargetFileName.text);
   end;
end;

procedure TScanTargetDlg.efTargetFileNameChange(Sender: TObject);
begin
   btnOk.enabled := fileexists(efTargetFileName.text);
end;

end.
