{ *************************************************************************** }

{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }


unit uResIO;

interface

uses
  uResFile, classes;

procedure GetRes( entry : TresourceEntry; strings : TStrings );
procedure SetRes( entry : TresourceEntry; strings : TStrings );

implementation

uses
  sysUtils, rtlConsts;

type
  TMyWriter = class(TWriter)
     public
       procedure WritePrefix(Flags: TFilerFlags; AChildPos: Integer);
  end;

procedure TMyWriter.WritePrefix(Flags: TFilerFlags; AChildPos: Integer);
begin
   inherited WritePrefix(Flags, AChildPos);
end;

procedure GetFormRes( entry : TresourceEntry; strings : TStrings ); forward;
procedure SetFormRes( entry : TresourceEntry; strings : TStrings ); forward;
procedure GetResourceStringRes( entry : TResourceEntry; strings : TStrings ); forward;
procedure SetResourceStringRes( entry : TResourceEntry; strings : TStrings ); forward;

procedure GetRes( entry : TresourceEntry; strings : TStrings );
begin
   if entry.IsResourceString then
     GetResourceStringRes(entry, strings);
   if entry.IsForm then
     GetFormRes(entry, strings);
end;

procedure SetRes( entry : TresourceEntry; strings : TStrings );
begin
   if entry.IsResourceString then
     SetResourceStringRes(entry, strings);
   if entry.IsForm then
     SetFormRes(entry, strings);
end;
//***************************************************************************
procedure GetResourceStringRes( entry : TResourceEntry; strings : TStrings );
var
  b: byte;
  line : string;
  iNo : integer;
function readString(length:integer):string;
var
  c: char;
  k: integer;
begin
   result:='';
   for k:=0 to length-1 do begin
        entry.data.Read(c,1); //#0
        entry.data.Read(c,1);
        result:=result+c;
   end;
   entry.data.Read(c,1); //#0
end;
begin
   strings.Clear;
   entry.data.Position := 0;
   line := '';
   iNo := 0;
   while entry.data.position<entry.data.size do begin
         entry.data.Read(b,1);
         if b=0 then break;
         //b= size of the string to read *2 (unicode)
         line:=readstring(b);
         strings.add( inttostr(entry.wResourcename*16+iNo) + '=' + line );
         inc(iNo);
    end;
    entry.data.Position:=0;
end;

procedure SetResourceStringRes( entry : TResourceEntry; strings : TStrings );
var
  i:integer;
  line:string;
  c: byte;
  d: char;
  k: integer;
begin
  entry.data.Clear;
  for i:=0 to strings.count-1 do begin
        line := strings.ValueFromIndex[i];
        c:=length(line);
        entry.data.Write(c,1);
        for k:=1 to length(line) do begin
            d:=#0;
            entry.data.Write(d,1);
            d:=line[k];
            entry.data.Write(d,1);
        end;
        d:=#0;
        entry.data.Write(d,1);
  end
end;
//************************************************************************
procedure GetFormRes( entry : TresourceEntry; strings : TStrings );
var
  SaveSeparator: Char;
  Reader: TReader;
  strObjectName, strPropName: string;

  procedure ConvertBinary;
  var
    Count: Longint;
  begin
    Reader.ReadValue;
    Reader.Read(Count, SizeOf(Count));
    Reader.Position := Reader.Position + count;
  end;

  procedure ConvertProperty; forward;

  procedure ConvertValue;
  var
    strId, strVal : string;
  begin
    case Reader.NextValue of
      vaList:
        begin
          strVal := '';
          Reader.ReadValue;
          while not Reader.EndOfList do begin
              if Reader.NextValue in [vaWString, vaUTF8String, vaString, vaLString] then begin
                if strVal <> '' then strVal := strVal + #10;
                if Reader.NextValue in [vaString, vaLString] then
                  strVal := strVal + Reader.ReadString;
                if Reader.NextValue in [vaWString, vaUTF8String] then
                  strVal := strVal + Reader.ReadWideString;
              end else
                   ConvertValue;
          end;
          Reader.ReadListEnd;
          if strVal <> '' then begin
             strId := strObjectname+'.'+strPropname;
             strings.Add(strId+'='+strVal);
          end;
        end;
      vaInt8, vaInt16, vaInt32:
        Reader.ReadInteger;
      vaExtended:
        Reader.ReadFloat;
      vaSingle:
        Reader.ReadSingle;
      vaCurrency:
        Reader.ReadCurrency;
      vaDate:
        Reader.ReadDate;
      //strings
      vaWString, vaUTF8String,
      vaString, vaLString:
        begin
          if Reader.NextValue in [vaWString, vaUTF8String] then
             strVal := Reader.ReadWideString;
          if Reader.NextValue in [vaString, vaLString] then
             strVal := Reader.ReadString;
          strId := strObjectname+'.'+strPropname;
          strings.Add(strId+'='+strVal);
        end;
      /////
      vaIdent, vaFalse, vaTrue, vaNil, vaNull:
          Reader.ReadIdent;
      vaBinary:
        ConvertBinary;
      vaSet:
        begin
          Reader.ReadValue;
          repeat
          until Reader.ReadStr = '';
        end;
      vaCollection:
        begin
          Reader.ReadValue;
          while not Reader.EndOfList do begin
            if Reader.NextValue in [vaInt8, vaInt16, vaInt32] then begin
              ConvertValue;
            end;
            Reader.CheckValue(vaList);
            while not Reader.EndOfList do ConvertProperty;
            Reader.ReadListEnd;
          end;
          Reader.ReadListEnd;
        end;
      vaInt64:
        Reader.ReadInt64;
    else
      raise EReadError.CreateResFmt(@sPropertyException,
        [strObjectName, '.', strPropName, IntToStr(Ord(Reader.NextValue))]);
    end;
  end;

  procedure ConvertProperty;
  begin
    strPropName := Reader.ReadStr;  // save for error reporting
    ConvertValue;
  end;

  procedure ConvertHeader;
  var
    ClassName: string;
    Flags: TFilerFlags;
    Position: Integer;
  begin
    Reader.ReadPrefix(Flags, Position);
    ClassName := Reader.ReadStr;
    strObjectName := Reader.ReadStr;

    if strObjectName = '' then
      strObjectName := ClassName;  // save for error reporting
  end;

  procedure ConvertObject;
  begin
    ConvertHeader;
    while not Reader.EndOfList do ConvertProperty;
    Reader.ReadListEnd;
    while not Reader.EndOfList do ConvertObject;
    Reader.ReadListEnd;
  end;

begin
  strings.clear;
   //only resourcetype RCData
   //all forms begin with TFilerSignature signature TPF0 (Turbo-Pascal-Filer)
  if not (entry.resourceType = rtRCData) then exit;
  if not comparemem( entry.data.memory, pchar('TPF0'), 4 ) then exit;

  entry.data.position := 0;
  Reader              := TReader.Create(entry.data, 4096);
  SaveSeparator       := DecimalSeparator;
  DecimalSeparator    := '.';
  try
      Reader.ReadSignature;
      ConvertObject;
  finally
    DecimalSeparator := SaveSeparator;
    Reader.Free;
  end;
end;

//**********************************************************************
procedure SetFormRes( entry : TresourceEntry; strings : TStrings );
var
  input : TMemoryStream;
  SaveSeparator: Char;
  Reader: TReader;
  Writer : TMyWriter;
  strObjectName, strPropName: string;

  procedure ConvertBinary;
  var
    Count: Longint;
    i : LongInt;
    bt : byte;
  begin
    writer.Writevalue( Reader.ReadValue );
    Reader.Read(Count, SizeOf(Count));
    writer.Write(Count, sizeof(Count) );
    //not the fastest but it works
    for i := 1 to Count do begin
      Reader.Read(bt,1);
      Writer.Write(bt, 1);
    end;
  end;

  procedure ConvertProperty; forward;

  procedure ConvertValue;
  var
    strId : string;
    strTmp : string;
    sl : TStringList;
    i : integer;
  begin
    case Reader.NextValue of
      vaList:
        begin
          writer.writeValue( reader.ReadValue );
          while not Reader.EndOfList do begin
            //ConvertValue;
             if Reader.NextValue in [vaWString, vaUTF8String] then
                Reader.ReadWideString;
             if Reader.NextValue in [vaString, vaLString] then
               Reader.ReadString;
          end;
          Reader.ReadListEnd;
          strId := strObjectname+'.'+strPropname;

          sl := TStringList.Create;
          try
           sl.Text := strings.Values[strId];
           for i := 0 to sl.count-1 do
              writer.WriteString(sl[i]);
           writer.writeListEnd;
          finally
           sl.Free;
          end;
        end;
      vaInt8, vaInt16, vaInt32:
        writer.writeInteger( Reader.ReadInteger );
      vaExtended:
        writer.WriteFloat( Reader.ReadFloat );
      vaSingle:
        writer.WriteSingle( Reader.ReadSingle );
      vaCurrency:
        writer.writeCurrency( Reader.ReadCurrency );
      vaDate:
        writer.WriteDate( reader.ReadDate );
      //strings
      vaWString, vaUTF8String,
      vaString, vaLString:
        begin
          strId := strObjectname+'.'+strPropname;
          if Reader.NextValue in [vaWString, vaUTF8String] then begin
             Reader.ReadWideString;
             writer.writeWideString( strings.Values[strId] );
          end;
          if Reader.NextValue in [vaString, vaLString] then begin
             Reader.ReadString;
             writer.Writestring( strings.Values[strId] );
          end;
        end;
      /////
      vaIdent, vaFalse, vaTrue, vaNil, vaNull:
          writer.WriteIdent( reader.ReadIdent );
      vaBinary:
        ConvertBinary;
      vaSet:
        begin
          writer.writeValue( Reader.ReadValue );
          repeat
            strTmp := Reader.ReadStr;
            writer.WriteStr(strTmp);
          until strTmp = '';
        end;
      vaCollection:
        begin
          writer.WriteValue( Reader.ReadValue );
          while not Reader.EndOfList do begin
            if Reader.NextValue in [vaInt8, vaInt16, vaInt32] then begin
              ConvertValue;
            end;
            Reader.CheckValue(vaList);
            while not Reader.EndOfList do ConvertProperty;
            Reader.ReadListEnd;
            Writer.WriteListEnd;
          end;
          Reader.ReadListEnd;
          Writer.WriteListEnd;
        end;
      vaInt64:
        writer.writeInteger( Reader.ReadInt64 );
    else
      raise EReadError.CreateResFmt(@sPropertyException,
        [strObjectName, '.', strPropName, IntToStr(Ord(Reader.NextValue))]);
    end;
  end;

  procedure ConvertProperty;
  begin
    strPropName := Reader.ReadStr;  // save for error reporting
    Writer.WriteStr(strPropName);
    ConvertValue;
  end;

  procedure ConvertHeader;
  var
    strClassName: string;
    Flags: TFilerFlags;
    Position: Integer;
  begin
    Reader.ReadPrefix(Flags, Position);
    Writer.WritePrefix(Flags, Position);
    strClassName  := Reader.ReadStr;
    strObjectName := Reader.ReadStr;
    Writer.WriteStr(strClassName);
    Writer.WriteStr(strObjectName);

    if strObjectName = '' then
      strObjectName := strClassName;  // save for error reporting
  end;

  procedure ConvertObject;
  begin
    ConvertHeader;
    while not Reader.EndOfList do ConvertProperty;
    Reader.ReadListEnd;
    Writer.WriteListEnd;
    while not Reader.EndOfList do ConvertObject;
    Reader.ReadListEnd;
    Writer.WriteListEnd;
  end;

begin
   //only resourcetype RCData
   //all forms begin with TFilerSignature signature TPF0 (Turbo-Pascal-Filer)
  if not (entry.resourceType = rtRCData) then exit;
  if not comparemem( entry.data.memory, pchar('TPF0'), 4 ) then exit;

  //input
  //copy entry.data to read from orginal-resource
  entry.data.position := 0;
  Input := TMemoryStream.Create;
  Input.LoadFromStream(entry.data);
  Input.Position := 0;
  Reader              := TReader.Create(Input, 4096);

  //output
  entry.data.clear;
  Writer              := TMyWriter.Create(entry.data, 4096);

  SaveSeparator       := DecimalSeparator;
  DecimalSeparator    := '.';
  try
      Reader.ReadSignature;
      Writer.WriteSignature;
      ConvertObject;
  finally
    DecimalSeparator := SaveSeparator;
    Reader.Free;
    Writer.Free;
    Input.Free;
  end;
end;

end.

