{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uProjectViewFm;

interface

uses
  uProject,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QComCtrls, QActnList, QMenus, QImgList;

type
  TProjectViewFm = class(TForm)
    tvProject: TTreeView;
    MainMenu1: TMainMenu;
    ActionList1: TActionList;
    actOpenStringList: TAction;
    StringList1: TMenuItem;
    OpenStringList1: TMenuItem;
    actCreateUpdateStringList: TAction;
    actGenerateTarget: TAction;
    CreateUpdateStringList1: TMenuItem;
    N1: TMenuItem;
    Generatetarget: TMenuItem;
    actProjectSetup: TAction;
    Project1: TMenuItem;
    actProjectSetup1: TMenuItem;
    actStringListProps: TAction;
    Properties1: TMenuItem;
    PopupMenu1: TPopupMenu;
    CreateUpdateStringList2: TMenuItem;
    GenerateTargetFile1: TMenuItem;
    OpenStringList2: TMenuItem;
    N2: TMenuItem;
    Setup1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ImageList1: TImageList;
    actProjectGlossaries: TAction;
    N3: TMenuItem;
    ProjectGlossaries1: TMenuItem;
    imgListTree: TImageList;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    procedure FormShow(Sender: TObject);
    procedure tvProjectEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actOpenStringListExecute(Sender: TObject);
    procedure IsStringListUpdate(Sender: TObject);
    procedure actCreateUpdateStringListExecute(Sender: TObject);
    procedure tvProjectItemDoubleClick(Sender: TObject; Node: TTreeNode);
    procedure actProjectSetupExecute(Sender: TObject);
    procedure actGenerateTargetExecute(Sender: TObject);
    procedure actStringListPropsExecute(Sender: TObject);
    procedure actProjectGlossariesExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
    m_Project : TProject;
    procedure CreateUpdateStringList( obj : TObject );
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; Project : TProject ); reintroduce;
    procedure FillList;
    property Project : TProject read m_Project;
  end;

{var
  ProjectViewFm: TProjectViewFm;}

implementation

{$R *.xfm}

uses
 uGlossaryDlg, uGlobal,
 uTransListPropsDlg, uSourceListPropsDlg, uUpdateGenerateDlg,
 uLanguage, uSourceListFm, uTransListFm, uMainFm, uApp, uProjectSetupDlg, uTextLists;

constructor TProjectViewFm.Create( AOwner : TComponent; Project : TProject );
begin
   m_Project := project;
   g_app.Projects.add(m_Project);
   inherited Create( AOwner );
end;

procedure TProjectViewFm.FormShow(Sender: TObject);
begin
  FillList;
  AddShortCutsToActionHints( actionList1 );
end;

procedure TProjectViewFm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    action := caFree;
end;

procedure TProjectViewFm.FormDestroy(Sender: TObject);
begin
   try
     m_Project.writetofile;
   finally
     g_app.Projects.Remove(m_Project); //free projects
   end;
end;

procedure TProjectViewFm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  i : integer;
  form : TForm;
begin
   canClose := true;
   for i := mainfm.MDIChildCount-1 downto 0 do begin
      form := mainFm.MDIChildren[i];
      if (form is TSourceListFm) and ((form as TSourceListFm).SourceTextList.ParentSource.parentproject = m_Project) then
         form.close;
      if (form is TTransListFm) and assigned((form as TTransListFm).TransTextList.ParentTranslation) and ((form as TTransListFm).TransTextList.ParentTranslation.ParentSource.parentproject = m_Project) then
         form.close;
   end;
end;

procedure TProjectViewFm.FillList;
var
  i, iLang : integer;
  tnExe : TTreeNode;
begin
   caption := extractFilename(m_project.FileName);
   tvProject.Items.beginUpdate;
   try
   tvProject.Items.Clear;
   for i := 0 to m_Project.sources.count-1 do begin
      //exe
      tnExe := tvProject.Items.AddChildObject(nil,
                                    (m_Project.sources[i] as TSource).Title,
                                    nil);
      //source
      tvProject.Items.AddChildObject(tnExe,
                                    GetLang( (m_Project.sources[i] as TSource).LangNo ),
                                    pointer(m_Project.sources[i] as TSource) ).ImageIndex := 0;
      //translations
      for iLang := 0 to m_Project.Languages.count-1 do begin
         tvProject.Items.AddChildObject(tnExe,
                                       GetLang( integer(m_Project.languages[iLang])),
                                       (m_Project.sources[i] as TSource).Translations[iLang]).ImageIndex := 1;
      end;
      tnExe.Expand(false);
   end;
   finally
      tvProject.Items.EndUpdate;
   end;
end;

procedure TProjectViewFm.tvProjectEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
   AllowEdit := false;
end;

procedure TProjectViewFm.actOpenStringListExecute(Sender: TObject);
var
  obj : TObject;
  SourceTextList : TSourceTextList;
  TransTextList : TTransTextList;
resourcestring
  rsNoSourceList = 'Source-list does not exist! Create it now?';
  rsNoTransList  = 'Translation-list does not exist! Create it now?';
function FormAlreadyOpen : boolean;
var
  i : integer;
  form : TCustomForm;
begin
   result := false;
   if obj is TSource then begin
      for i := 0 to mainfm.MDIChildCount-1 do begin
         form := mainFm.MDIChildren[i];
         if (form is TSourceListFm) and ((form as TSourceListFm).SourceTextList.ParentSource = obj) then begin
            result := true;
            break;
         end;
      end;
   end;
   if obj is TTranslation then begin
      for i := 0 to mainfm.MDIChildCount-1 do begin
         form := mainFm.MDIChildren[i];
         if (form is TTransListFm) and ((form as TTransListFm).TransTextList.ParentTranslation = obj) then begin
            result := true;
            break;
         end;
      end;
   end;
end;
begin
  obj := TObject(tvProject.Selected.Data);
  if assigned(obj) and not FormAlreadyOpen then begin
     if obj is TSource then begin
        if not fileexists((obj as TSource).ListFileName) then begin
           if MessageDlg( application.Title, rsNoSourceList, mtConfirmation, mbOKCancel, 0) = mrOK then
              CreateUpdateStringList(obj);
        end;
        if fileexists((obj as TSource).ListFileName) then begin
          SourceTextList := TSourceTextList.Create(obj as TSource);
          screen.cursor := crHourglass;
          try
           SourceTextList.ReadFromFile;
          finally
           screen.cursor := crDefault;
          end;
          TSourceListFm.Create(self, SourceTextList);
        end;
     end;
     if obj is TTranslation then begin
        if not fileexists((obj as TTranslation).ListFileName) then begin
           if MessageDlg( application.Title, rsNoTransList, mtConfirmation, mbOKCancel, 0) = mrOK then
              CreateUpdateStringList(obj);
        end;
        if fileexists((obj as TTranslation).ListFileName) then begin
          TransTextList := TTransTextList.Create(obj as TTranslation );
          screen.cursor := crHourglass;
          try
          TransTextList.ReadFromFile;
          finally
           screen.cursor := crDefault;
          end;
          TTransListFm.Create(self, TransTextList);
        end;
     end;
  end;
end;

procedure TProjectViewFm.IsStringListUpdate(Sender: TObject);
var
  obj : TObject;
begin
  if assigned(tvProject.Selected) then
    obj := TObject(tvProject.Selected.Data)
  else
    obj := nil;
  (sender as TAction).Enabled := assigned(obj) and ((obj is TSource) or (obj is TTranslation));
end;

procedure TProjectViewFm.actStringListPropsExecute(Sender: TObject);
var
  obj : TObject;
begin
  obj := TObject(tvProject.Selected.Data);
  if not assigned(obj) then exit;

  if obj is TSource then begin
     with TSourceListPropsDlg.create(self, obj as TSource) do begin
       try
        if showmodal = mrOK then
           FillList;
       finally
        free;
       end;
     end;
  end;
  if obj is TTranslation then begin
     with TTransListPropsDlg.create(self, obj as TTranslation) do begin
       try
        if showmodal = mrOK then
           FillList;
       finally
        free;
       end;
     end;
  end;
end;

procedure TProjectViewFm.CreateUpdateStringList( obj : TObject );
begin
  assert( assigned(obj) );
  if obj is TSource then begin
     with TSourceTextList.create(obj as TSource) do begin
       try
        CreateUpdate( g_app.ResbindLocation, MainFm.memOutput.lines);
       finally
        free;
       end;
     end;
  end;
  if obj is TTranslation then begin
     with TTransTextList.create(obj as TTranslation) do begin
       try
        CreateUpdate( MainFm.memOutput.lines );
       finally
        free;
       end;
     end;
  end;
end;

procedure TProjectViewFm.actCreateUpdateStringListExecute(Sender: TObject);
var
  obj : TObject;
  iSource, iTrans : integer;
  Source : TSource;
resourcestring
  rsTransList  = 'Translation-List';
  rsSourceList = 'Source-List';
begin
  with TUpdateGenerateDlg.Create(self, true) do begin
    try
     obj := TObject(tvProject.Selected.Data);
     if assigned(obj) then begin
       rbSelected.Checked := true;
       if obj is TTranslation then begin
         rbselected.Caption := format(rsTransList+' - %s, %s -> %s',[(obj as TTranslation).ParentSource.title,
                                      getLangId((obj as TTranslation).ParentSource.langNo),
                                      getlangId((obj as TTranslation).langno)]);
       end;
       if obj is TSource then begin
         rbselected.Caption := format(rsSourceList+' - %s',[(obj as TSource).title]);
       end;
     end else begin
       rbSelected.Enabled := false;
       rbAll.Checked      := true;
     end;
     if showmodal = mrOK then begin
       screen.Cursor := crHourGlass;
       MainFm.memOutput.lines.clear;
       if rbSelected.Checked then begin
          //selected
          CreateUpdateStringList( obj );
       end else begin
          //all
          for iSource := 0 to m_Project.Sources.Count-1 do begin
            source := m_Project.Sources[iSource] as TSource;
            with TSourceTextList.create(source) do begin
               screen.cursor := crHourglass;
               try
                CreateUpdate( g_app.ResbindLocation, MainFm.memOutput.lines);
               finally
                screen.Cursor := crDefault;
                free;
               end;
            end;
            for iTrans := 0 to Source.Translations.count-1 do begin
               with TTransTextList.create( Source.Translations[iTrans] as TTranslation ) do begin
                 screen.cursor := crHourglass;
                 try
                  CreateUpdate( MainFm.memOutput.lines);
                 finally
                  screen.Cursor := crDefault;
                  free;
                 end;
               end;
            end;
          end;//if
       end;
       screen.Cursor := crDefault;
     end;//if showmodal
    finally
     free;
    end;
  end;
end;

procedure TProjectViewFm.actGenerateTargetExecute(Sender: TObject);
var
  obj : TObject;
  iSource, iTrans : integer;
  Source : TSource;
resourcestring
  rsTransList = 'Translation-List';
begin
  with TUpdateGenerateDlg.Create(self, false) do begin
    try
     obj := TObject(tvProject.Selected.Data);
     if assigned(obj) and (obj is TTranslation) then begin
       rbSelected.Checked := true;
       rbselected.Caption := format(rsTransList+' - %s, %s -> %s',[(obj as TTranslation).ParentSource.title,
                                    getLangId((obj as TTranslation).ParentSource.langNo),
                                    getlangId((obj as TTranslation).langno)]);
     end else begin
       rbSelected.Enabled := false;
       rbAll.Checked      := true;
     end;
     if showmodal = mrOK then begin
       screen.Cursor := crHourGlass;
       MainFm.memOutput.lines.clear;
       if rbSelected.Checked then begin
          //selected
          with TTransTextList.create( obj as TTranslation ) do begin
            screen.cursor := crHourglass;
            try
             ReadFromFile;
             GenerateTarget(g_app.ResbindLocation, MainFm.memOutput.lines);
            finally
             screen.Cursor := crDefault;
             free;
            end;
          end;
       end else begin
          //all
          for iSource := 0 to m_Project.Sources.Count-1 do begin
            source := m_Project.Sources[iSource] as TSource;
            for iTrans := 0 to Source.Translations.count-1 do begin
               with TTransTextList.create( Source.Translations[iTrans] as TTranslation ) do begin
                 screen.cursor := crHourglass;
                 try
                  ReadFromFile;
                  GenerateTarget(g_app.ResbindLocation, MainFm.memOutput.lines);
                 finally
                  screen.Cursor := crDefault;
                  free;
                 end;
               end;
            end;
          end;//if
       end;//if
       screen.Cursor := crDefault;
     end;
    finally
     free;
    end;
  end;//with
end;

procedure TProjectViewFm.tvProjectItemDoubleClick(Sender: TObject;
  Node: TTreeNode);
begin
   actOpenStringListExecute(nil);
end;

procedure TProjectViewFm.actProjectSetupExecute(Sender: TObject);
begin
  with TProjectSetupDlg.create(self, m_project, false) do begin
    try
     if showmodal = mrOK then begin
       fillList;
     end;
    finally
     free;
    end;
  end;
end;

procedure TProjectViewFm.actProjectGlossariesExecute(Sender: TObject);
begin
   with TGlossaryDlg.Create(self, m_Project.Glossaries, m_Project) do begin
     showmodal;
   end;
end;

end.
