{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uMainFm;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QExtCtrls, QMenus, QActnList, QImgList, QComCtrls,
  QStdActns;

type
  TMainFm = class(TForm)
    ActionList1: TActionList;
    MainMenu1: TMainMenu;
    FileItem: TMenuItem;
    actNew: TAction;
    New1: TMenuItem;
    actExit: TAction;
    N1: TMenuItem;
    Exit1: TMenuItem;
    ViewItem: TMenuItem;
    actViewOutput: TAction;
    Output1: TMenuItem;
    ToolsItem: TMenuItem;
    HelpItem: TMenuItem;
    actAppOptions: TAction;
    Options1: TMenuItem;
    actAbout: TAction;
    Info1: TMenuItem;
    actClose: TAction;
    Close1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    actOpenProject: TAction;
    Open1: TMenuItem;
    OpenDlg: TOpenDialog;
    WindowItem: TMenuItem;
    actWindowCascade: TWindowCascade;
    actWindowTile: TWindowTile;
    actWindowMinimizeAll: TWindowMinimizeAll;
    berlappend1: TMenuItem;
    actWindowTile1: TMenuItem;
    Alleverkleinern1: TMenuItem;
    StatusBar1: TStatusBar;
    actSave: TAction;
    Save1: TMenuItem;
    ImageList1: TImageList;
    actNewTestPrj: TAction;
    tNewTestProject1: TMenuItem;
    N2: TMenuItem;
    actGlossaries: TAction;
    Glossaries1: TMenuItem;
    actExportTransList: TAction;
    N3: TMenuItem;
    ExportToGlossary1: TMenuItem;
    actCreateGlossaryOfSourceListsASCII: TAction;
    CreateGlossaryOfSourceListASCII1: TMenuItem;
    actExportSourceList: TAction;
    ExporttoTextFile1: TMenuItem;
    openKylixGlossDlg: TOpenDialog;
    saveKylixGlossDlg: TSaveDialog;
    actImportTransList: TAction;
    ImportTranslationList1: TMenuItem;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    procedure actExitExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actNewExecute(Sender: TObject);
    procedure actViewOutputExecute(Sender: TObject);
    procedure actViewOutputUpdate(Sender: TObject);
    procedure actAppOptionsExecute(Sender: TObject);
    procedure actAboutExecute(Sender: TObject);
    procedure actCloseExecute(Sender: TObject);
    procedure actCloseUpdate(Sender: TObject);
    procedure actOpenProjectExecute(Sender: TObject);
    procedure OpenDlgFilterChange(Sender: TObject; NewIndex: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure actSaveUpdate(Sender: TObject);
    procedure actNewTestPrjExecute(Sender: TObject);
    procedure actGlossariesExecute(Sender: TObject);
    procedure actExportTransListExecute(Sender: TObject);
    procedure actExportTransListUpdate(Sender: TObject);
    procedure actCreateGlossaryOfSourceListsASCIIExecute(Sender: TObject);
    procedure actExportSourceListExecute(Sender: TObject);
    procedure actExportSourceListUpdate(Sender: TObject);
    procedure actImportTransListExecute(Sender: TObject);
    procedure actImportTransListUpdate(Sender: TObject);
    procedure FileItemClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen }
    procedure CreatetestPrj;
    function IstextListActive : boolean;
    procedure ShowMRU;
    procedure OpenProject( const strFileName : string );
    procedure FileMRUClick(Sender: TObject);
  public
    { Public-Deklarationen }
    memOutput : TMemo;
    splitOutput : TSplitter;
  end;

var
  MainFm: TMainFm;

implementation

{$R *.xfm}

uses
  uGlossary, uGlobal,
  uLanguage, uTextLists, uTransListFm, uSourceListFm, uApp, Libc,
  uProject, uAppOptionsDlg, uProjectViewFm, uAboutDlg, uProjectSetupDlg, uGlossaryDlg;

procedure TMainFm.FormShow(Sender: TObject);
begin
   g_app.readfromIni;

//create it dynamically so that it is top of statusbar
   memOutput := TMemo.Create(self);
   memoutput.Parent     := self;
   memOutput.Visible    := g_app.OutputVisible;
   memoutput.height     := g_app.OutputHeight;
   memOutput.Align      := alBottom;
   memOutput.ReadOnly   := true;
   memOutput.ScrollBars := ssAutoBoth;
   memOutput.Lines.clear;

   splitOutput := TSplitter.Create(self);
   splitOutput.Parent    := self;
   splitOutput.Visible   := g_app.OutputVisible;
   splitOutput.Align     := alBottom;

   AddShortCutsToActionHints( actionList1 );
end;

procedure TMainFm.FormDestroy(Sender: TObject);
begin
   g_app.OutputHeight := memOutput.Height;
   g_app.WriteToIni;
end;

procedure TMainFm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  i : integer;
begin
  for i := mainfm.MDIChildCount-1 downto 0 do begin
    if not (mdiChildren[i] is TProjectViewFm) then
       mdiChildren[i].Close;
  end;
  for i := mainfm.MDIChildCount-1 downto 0 do begin
     mdiChildren[i].Close;
  end;
  CanClose := true;
end;

procedure TMainFm.CreatetestPrj;
var
  project : TProject;
  source : TSource;
begin
  Project := TProject.Create;
  Project.FileName := includeTrailingPathdelimiter(getHomeDir)+'test.llp';
  Project.AddLanguage(GetLangNoFromID('de'));
  Project.AddLanguage(GetLangNoFromID('es'));
  source := TSource.Create(project, GetLangNoFromID('en'), application.ExeName);
  project.AddSource(source);
  TProjectViewFm.create(self, project);
end;

function TMainFm.IstextListActive : boolean;
begin
  result := assigned(ActiveMDIChild) and
                   ((ActiveMDIChild is TSourceListFm) or (ActiveMDIChild is TTransListFm))
end;

procedure TMainFm.actExitExecute(Sender: TObject);
begin
   close;
end;

procedure TMainFm.actNewExecute(Sender: TObject);
var
  project : TProject;
begin
  Project := TProject.Create;
  with TProjectSetupDlg.create(self, project, true) do begin
    try
      if showmodal = mrOK then begin
         TProjectViewFm.create(self, project);
         g_app.addMRU(project.FileName);
         ShowMRU;
      end else begin
         Project.Free;
      end;
    finally
     free;
    end;
  end;
end;

procedure TMainFm.actViewOutputExecute(Sender: TObject);
begin
   memOutput.visible   := not memOutput.visible;
   splitOutput.Visible := memOutput.Visible;
   g_app.OutputVisible := memOutput.Visible;
end;

procedure TMainFm.actViewOutputUpdate(Sender: TObject);
begin
   actViewOutput.checked := g_app.Outputvisible;
end;

procedure TMainFm.actAppOptionsExecute(Sender: TObject);
begin
   with TAppOptionsDlg.create(self) do begin
     try
      showmodal;
     finally
      free;
     end;
   end;
end;

procedure TMainFm.actAboutExecute(Sender: TObject);
begin
   with TAboutDlg.create(self) do begin
     try
      showmodal;
     finally
      free;
     end;
   end;
end;

procedure TMainFm.actCloseExecute(Sender: TObject);
begin
   ActiveMDIChild.close;
end;

procedure TMainFm.actCloseUpdate(Sender: TObject);
begin
   actClose.visible := assigned(activeMDIChild);
end;

procedure TMainFm.actOpenProjectExecute(Sender: TObject);
var
   TransTextList : TTransTextList;
begin
   OpenDlgFilterChange(self, OpenDlg.FilterIndex );
   if OpenDlg.Execute then begin
      case OpenDlg.FilterIndex of
        1: OpenProject( OpenDlg.FileName );
        2: begin
           TransTextList := TTransTextList.Create(OpenDlg.filename);
           TransTextList.ReadFromFile;
           TTransListFm.Create(self, TransTextList);
        end;
      end;
   end;
end;

procedure TMainFm.OpenDlgFilterChange(Sender: TObject; NewIndex: Integer);
begin
  case NewIndex of
     1: OpenDlg.DefaultExt := '.llp';
     2: OpenDlg.DefaultExt := '.trl';
  end;
end;

procedure TMainFm.actSaveExecute(Sender: TObject);
begin
  if ActiveMdiChild is TTransListFm then
     (ActiveMdiChild as TTransListFm).actSaveExecute(nil);
  if ActiveMdiChild is TSourceListFm then
     (ActiveMdiChild as TSourceListFm).actSaveExecute(nil);
  if ActiveMdiChild is TProjectViewFm then
     (ActiveMdiChild as TProjectViewFm).Project.WriteToFile;
end;

procedure TMainFm.actSaveUpdate(Sender: TObject);
begin
  actSave.Visible := IsTextListActive or (assigned(ActiveMdiChild) and (ActiveMdiChild is TProjectViewFm));
end;

procedure TMainFm.actNewTestPrjExecute(Sender: TObject);
begin
   CreateTestPrj;
end;

procedure TMainFm.actGlossariesExecute(Sender: TObject);
begin
   with TGlossaryDlg.Create(self, g_app.Glossaries, nil) do begin
     showmodal;
   end;
end;

procedure TMainFm.actExportTransListExecute(Sender: TObject);
begin
   (ActiveMDIChild as TTransListFm).Export;
end;

procedure TMainFm.actExportTransListUpdate(Sender: TObject);
begin
  actExportTransList.visible := assigned(ActiveMDIChild) and (ActiveMDIChild is TTransListFm);
end;

procedure TMainFm.actCreateGlossaryOfSourceListsASCIIExecute(Sender: TObject);
var
  i, t : integer;
  glossary : TGlossary;
  strLangId : string;
  aslTextes : array of TStringList;
  slLine : TStringList;
  strID : string;
resourcestring
  rsCreating = 'Creating Kylix-Glossary %s';
begin
 if openKylixGlossDlg.Execute then begin
    if openKylixGlossDlg.Files.count < 2 then exit;

    forceDirectories( g_app.GlossaryDir );
    saveKylixGlossDlg.InitialDir := g_app.GlossaryDir;
    saveKylixGlossDlg.filename   := copy( openKylixGlossDlg.Files[0], 1, pos('.', openKylixGlossDlg.Files[0])-1);
    if not saveKylixGlossDlg.Execute then
      exit;

    memOutput.Lines.Clear;
    memOutput.Lines.add(format(rsCreating, [saveKylixGlossDlg.filename]));
    application.ProcessMessages;
    glossary := TGlossary.Create;
    try
     screen.Cursor := crHourglass;
     setLength( aslTextes, openKylixGlossDlg.Files.count);
     for i := 0 to openKylixGlossDlg.Files.count-1 do begin
        strLangID := extractFileExt(changeFileExt(openKylixGlossDlg.files[i], ''));
        if strLangID <> '' then
          strLangID := copy(strLangId, 2, length(strLangID)-1);
        glossary.AddLanguage( GetLangNoFromID(strLangID) );
        aslTextes[i] := TStringList.Create;
        aslTextes[i].LoadFromFile(openKylixGlossDlg.files[i]);
     end;
     slLine := TStringList.Create;
     try
      for i := 0 to aslTextes[0].count-1 do begin
        strID := aslTextes[0].names[i];
        slLine.Clear;
        for t := 0 to high(aslTextes) do
           slLine.Add( addsysChars(aslTextes[t].values[strID]) );
        glossary.add(slLine);
      end;
     finally
      slLine.free;
     end;

     glossary.WriteToFile(saveKylixGlossDlg.filename);
    finally
     glossary.Free;
     for i := 0 to high(aslTextes) do
       aslTextes[i].Free;
     screen.cursor := crDefault;
    end;

    memOutput.Lines.add('OK');
 end;
end;

procedure TMainFm.actExportSourceListExecute(Sender: TObject);
begin
  (ActiveMDIChild as TSourceListFm).Export;
end;

procedure TMainFm.actExportSourceListUpdate(Sender: TObject);
begin
  actExportSourceList.visible := assigned(ActiveMDIChild) and
                                 (ActiveMDIChild is TSourceListFm);
end;

procedure TMainFm.actImportTransListExecute(Sender: TObject);
begin
  (ActiveMDIChild as TTransListFm).Import;
end;

procedure TMainFm.actImportTransListUpdate(Sender: TObject);
begin
  actImportTransList.visible := assigned(ActiveMDIChild) and
                               (ActiveMDIChild is TTransListFm);
end;

procedure TMainFm.ShowMRU;
var
  i : integer;
  item : TMenuItem;
begin
  //remove old
  for i := fileitem.count-1 downto 0 do begin
     if fileitem[i].Tag > 0 then
       FileItem.Delete(i);
  end;

  if g_app.MRU.count > 0 then begin
    FileItem.InsertNewLineAfter(FileItem[FileItem.count-1]);
    fileitem[FileItem.count-1].Tag := 1;
  end;
  for i := 0 to g_app.MRU.count-1 do begin
     item := TMenuItem.Create(self);
     item.Caption := format('&%d %s', [i+1, g_app.MRU[i]]);
     item.Tag     := i+1;
     item.OnClick := FileMRUClick;
     FileItem.Add(item);
  end;
end;

procedure TMainFm.FileItemClick(Sender: TObject);
begin
   ShowMRU;
end;

procedure TMainFm.OpenProject( const strFileName : string );
var
  Project : Tproject;
begin
  Project := TProject.Create;
  Project.ReadFromFile(strFileName);
  TProjectViewFm.create(self, project);
  g_app.addMRU(strFileName);
  ShowMRU;
end;

procedure TMainFm.FileMRUClick(Sender: TObject);
begin
  OpenProject( g_app.MRU[ (sender as TComponent).tag-1 ] );
end;

end.
