{ *************************************************************************** }

{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }


unit uLanguage;

interface

uses
 classes;

procedure AssignLanguages( lst : TStrings );
function GetLangID( i : integer ) : string; overload;
function GetLangID( const strLang : string ) : string; overload;
function GetLangNoFromID( const strID : string ) : integer;
function GetLang( const strID : string ) : string; overload;
function GetLang( i : integer ) : string; overload;
function stripSubLangFromID( const strID : string ) : string;

implementation

uses
  sysUtils;

function TrimLang( const strLang : string ) : string; forward;

const
  astrLanguages : array[0..123+58] of string =(
'Afrikaans     [af]',
'Arabic        [ar]',
'Byelorussian  [be]',
'Bulgarian     [bg]',
'Bengali       [bn]',
'Catalan       [ca]',
'Czech         [cs]',
'Danish        [da]',
'German        [de]',
'Greek         [el]',
'English       [en]',
'Spanish       [es]',
'Estonian      [et]',
'Basque        [eu]',
'Persian       [fa]',
'Persian       [fa]',
'Finnish       [fi]',
'Faroese       [fo]',
'French        [fr]',
'Irish         [ga]',
'Galician      [gl]',
'Manx Gaelic   [gv]',
'Hebrew        [he]',
'Hindi         [hi]',
'Croatian      [hr]',
'Hungarian     [hu]',
'Indonesian    [id]',
'Icelandic     [is]',
'Italian       [it]',
'Japanese      [ja]',
'Greenlandic   [kl]',
'Konkani       [kok]',
'Korean        [ko]',
'Cornish       [kw]',
'Lithuanian    [lt]',
'Lativian      [lv]',
'Macedonian    [mk]',
'Marathi       [mr]',
'Malay         [ms]',
'Maltese       [mt]',
'Dutch         [nl]',
'Norwegian     [no]',
'Polish        [pl]',
'Portuguese    [pt]',
'Romanian      [ro]',
'Russian       [ru]',
'SerboCroatian [sh]',
'Slovakian     [sk]',
'Albanian      [sq]',
'Serbian       [sr]',
'Swedish       [sv]',
'Tamil         [ta]',
'Telugu        [te]',
'Thai          [th]',
'Turkish       [tr]',
'Ukrainian     [uk]',
'Vietnamese    [vi]',
'Chinese       [zh]',

'Afrikaans     [af_ZA]  SOUTH AFRICA',
'Arabic        [ar_AE]  UNITED ARAB EMIRATES',
'Arabic        [ar_BH]  BAHRAIN',
'Arabic        [ar_DZ]  ALGERIA',
'Arabic        [ar_EG]  EGYPT',
'Arabic        [ar_IN]  INDIA',
'Arabic        [ar_IQ]  IRAQ',
'Arabic        [ar_JO]  JORDAN',
'Arabic        [ar_KW]  KUWAIT',
'Arabic        [ar_LB]  LEBANON',
'Arabic        [ar_LY]  LIBYAN ARAB JAMAHIRIYA',
'Arabic        [ar_MA]  MOROCCO',
'Arabic        [ar_OM]  OMAN',
'Arabic        [ar_QA]  QATAR',
'Arabic        [ar_SA]  SAUDI ARABIA',
'Arabic        [ar_SD]  SUDAN',
'Arabic        [ar_SY]  SYRIAN ARAB REPUBLIC',
'Arabic        [ar_TN]  TUNISIA',
'Arabic        [ar_YE]  YEMEN',
'Byelorussian  [be_BY]  BELARUS',
'Bulgarian     [bg_BG]  BULGARIA',
'Bengali       [bn_IN]  INDIA',
'Catalan       [ca_ES]  SPAIN',
'Czech         [cs_CZ]  CZECH REPUBLIC',
'Danish        [da_DK]  DENMARK',
'German        [de_AT]  AUSTRIA',
'German        [de_BE]  BELGIUM',
'German        [de_CH]  SWITZERLAND',
'German        [de_DE]  GERMANY',
'German        [de_LU]  LUXEMBOURG',
'Greek         [el_GR]  GREECE',
'English       [en_AU]  AUSTRALIA',
'English       [en_BE]  BELGIUM',
'English       [en_BW]  BOTSWANA',
'English       [en_CA]  CANADA',
'English       [en_GB]  UNITED KINGDOM',
'English       [en_HK]  HONG KONG',
'English       [en_IE]  IRELAND',
'English       [en_IN]  INDIA',
'English       [en_NZ]  NEW ZEALAND',
'English       [en_PH]  PHILIPPINES',
'English       [en_SG]  SINGAPORE',
'English       [en_US]  UNITED STATES',
'English       [en_ZA]  SOUTH AFRICA',
'English       [en_ZW]  ZIMBABWE',
'Spanish       [es_AR]  ARGENTINA',
'Spanish       [es_BO]  BOLIVIA',
'Spanish       [es_CL]  CHILE',
'Spanish       [es_CO]  COLOMBIA',
'Spanish       [es_CR]  COSTA RICA',
'Spanish       [es_DO]  DOMINICAN REPUBLIC',
'Spanish       [es_EC]  ECUADOR',
'Spanish       [es_ES]  SPAIN',
'Spanish       [es_GT]  GUATEMALA',
'Spanish       [es_HN]  HONDURAS',
'Spanish       [es_Mx]  MEXICO',
'Spanish       [es_NI]  NICARAGUA',
'Spanish       [es_PA]  PANAMA',
'Spanish       [es_PE]  PERU',
'Spanish       [es_PR]  PUERTO RICO',
'Spanish       [es_PY]  PARAGUAY',
'Spanish       [es_SV]  REPUBLIC OF EL SALVADOR',
'Spanish       [es_US]  UNITED STATES',
'Spanish       [es_UY]  URUGUAY',
'Spanish       [es_VE]  VENEZUELA',
'Estonian      [et_EE]  ESTONIA',
'Basque        [eu_ES]  SPAIN',
'Persian       [fa_IN]  INDIA',
'Persian       [fa_IR]  IRAN (ISLAMIC REPUBLIC OF)',
'Finnish       [fi_FI]  FINLAND',
'Faroese       [fo_FO]  FAROE ISLAND',
'French        [fr_BE]  BELGIUM',
'French        [fr_CA]  CANADA',
'French        [fr_CH]  SWITZERLAND',
'French        [fr_FR]  FRANCE',
'French        [fr_LU]  LUXEMBOURG',
'Irish         [ga_IE]  IRELAND',
'Galician      [gl_ES]  SPAIN',
'Manx Gaelic   [gv_GB]  UNITED KINGDOM',
'Hebrew        [he_IL]  ISRAEL',
'Hindi         [hi_IN]  INDIA',
'Croatian      [hr_HR]  CROATIA',
'Hungarian     [hu_HU]  HUNGARY',
'Indonesian    [id_ID]  INDONESIA',
'Icelandic     [is_IS]  ICELAND',
'Italian       [it_CH]  SWITZERLAND',
'Italian       [it_IT]  ITALY',
'Japanese      [ja_JP]  JAPAN',
'Greenlandic   [kl_GL]  GREENLAND',
'Konkani       [kok_IN] INDIA',
'Korean        [ko_KR]  KOREA, REPUBLIC OF',
'Cornish       [kw_GB]  UNITED KINGDOM',
'Lithuanian    [lt_LT]  LITHUANIA',
'Lativian      [lv_LV]  LATVIA',
'Macedonian    [mk_MK]  MACEDONIA, THE FORMER YUGSOLAV REPUBLIC OF',
'Marathi       [mr_IN]  INDIA',
'Malay         [ms_MY]  MALAYSIA',
'Maltese       [mt_MT]  MALTA',
'Dutch         [nl_BE]  BELGIUM',
'Dutch         [nl_NL]  NETHERLANDS',
'Norwegian     [no_NO]  NORWAY',
'Polish        [pl_PL]  POLAND',
'Portuguese    [pt_BR]  BRAZIL',
'Portuguese    [pt_PT]  PORTUGAL',
'Romanian      [ro_RO]  ROMANIA',
'Russian       [ru_RU]  RUSSIAN FEDERATION',
'Russian       [ru_UA]  UKRAINE',
'SerboCroatian [sh_YU]  YUGOSLAVIA',
'Slovakian     [sk_SK]  SLOVAKIA',
'Slovenian     [sl_SI]  SLOVENIA',
'Albanian      [sq_AL]  ALBANIA',
'Serbian       [sr_YU]  YUGOSLAVIA',
'Swedish       [sv_FI]  FINLAND',
'Swedish       [sv_SE]  SWEDEN',
'Tamil         [ta_IN]  INDIA',
'Telugu        [te_IN]  INDIA',
'Thai          [th_TH]  THAILAND',
'Turkish       [tr_TR]  TURKEY',
'Ukrainian     [uk_UA]  UKRAINE',
'Vietnamese    [vi_VN]  VIETNAM',
'Chinese       [zh_CN]  CHINA',
'Chinese       [zh_HK]  HONG KONG',
'Chinese       [zh_SG]  SINGAPORE',
'Chinese       [zh_TW]  TAIWAN, PROVINCE OF CHINA'
);

function GetLangID( i : integer ) : string;
begin
   if i >= 0 then
     result := GetLangID( astrLanguages[i] )
   else
     result := '';
end;

function GetLangID( const strLang : string ) : string;
var
  k:integer;
begin
  result:='';
  k:=pos('[',strLang);
  if k<>0 then begin
     result:=copy(strLang,k+1,length(strLang));
     k:=pos(']',result);
     if k<>0 then begin
           result:=copy(result,1,k-1);
     end;
  end;
end;

procedure AssignLanguages( lst : TStrings );
var
 i : integer;
begin
  for i := 0 to high(astrLanguages) do
    lst.Add(astrLanguages[i])
end;

function GetLangNoFromID( const strID : string ) : integer;
var
 i : integer;
begin
  result := -1;
  for i := 0 to high(astrLanguages) do begin
     if pos('['+strID+']', astrLanguages[i]) > 0 then begin
       result := i;
       break;
     end;
  end;
end;

function GetLang( const strID : string ) : string;
begin
  result := GetLang( GetLangNoFromID(strID) );
end;

function GetLang( i : integer ) : string;
begin
   if i >= 0 then
     result := TrimLang(astrLanguages[i])
   else
     result := '';
end;

function TrimLang( const strLang : string ) : string;
var
  i : integer;
begin
   result := strLang;
   i := pos('[', strLang);
   if i > 0 then begin
     result := trim(copy(strLang, 1, i-1)) + '  ' + trim(copy(strLang, i, length(strLang)-i+1));
   end;
end;

function stripSubLangFromID( const strID : string ) : string;
begin
  if pos('_', strID)>1 then
    result := copy(strID, 1, pos('_', strID)-1)
  else
    result := strID;
end;

end.
