{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uFindDlg;

interface

uses
  uTextLists, QGrids,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QExtCtrls, QActnList;

type
  TFindDlg = class(TForm)
    Label1: TLabel;
    comboFindWhat: TComboBox;
    grpOptions: TGroupBox;
    cbMatchCase: TCheckBox;
    cbMatchWholeWord: TCheckBox;
    cbPassEOF: TCheckBox;
    cbIgnoreAmpersand: TCheckBox;
    grpLookIn: TGroupBox;
    cbLookInAllFields: TCheckBox;
    cbLookInText: TCheckBox;
    btnFindNext: TButton;
    btnCancel: TButton;
    cbLookInOldTextSourceText: TCheckBox;
    cbLookInComment: TCheckBox;
    panFindIn: TPanel;
    Label3: TLabel;
    rbAllResources: TRadioButton;
    rbCurrentResource: TRadioButton;
    panDirection: TPanel;
    Label2: TLabel;
    rbDirUp: TRadioButton;
    rbDirDown: TRadioButton;
    ActionList1: TActionList;
    actLookInAllFields: TAction;
    actLookInText: TAction;
    actLookInOldTextSourceText: TAction;
    actLookInComment: TAction;
    actFindNext: TAction;
    procedure actLookInAllFieldsExecute(Sender: TObject);
    procedure actLookInTextExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actFindNextExecute(Sender: TObject);
    procedure actFindNextUpdate(Sender: TObject);
  private
    { Private-Deklarationen }
    m_FindDef : TFindDef;
    m_GridTextes : TStringGrid;
    m_ResultItem : TCustomSourceTransItem;
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; finddef : TFindDef; gridTextes : TStringGrid ); reintroduce;
    property ResultItem : TCustomSourceTransItem read m_ResultItem write m_ResultItem;
  end;

var
  FindDlg: TFindDlg;

implementation

{$R *.xfm}

uses
 uCustomListFm;

constructor TFindDlg.Create( AOwner : TComponent; finddef : TFindDef; gridTextes : TStringGrid );
begin
  inherited Create(AOwner);
  m_FindDef    := finddef;
  m_GridTextes := gridTextes;
end;

procedure TFindDlg.FormShow(Sender: TObject);
begin
  comboFindWhat.items.assign(m_Finddef.m_lstHistory);
  comboFindWhat.Text  := m_Finddef.m_strFindWhat;
  cbMatchCase.Checked := m_Finddef.m_bMatchCase;
  cbMatchWholeWord.checked := m_Finddef.m_bMatchWholeWord;
  cbPassEOF.checked := m_Finddef.m_bPassEOF;
  cbIgnoreAmpersand.Checked := m_Finddef.m_bIgnoreAmpersand;
  if m_Finddef.m_bDirDown then
    rbDirDown.checked := true
  else
    rbDirUp.checked := true;
  if m_Finddef.m_bAllResources then
     rbAllResources.checked := true
  else
     rbCurrentResource.checked := true;
  actLookInAllFields.checked := m_Finddef.m_bLookInAllFields;
  actLookInText.checked := m_Finddef.m_bLookInText;
  actLookInOldTextSourceText.checked := m_Finddef.m_bLookInOldTextSourceText;
  actLookInComment.checked := m_Finddef.m_bLookInComment;
  activeControl := comboFindWhat;
end;

procedure TFindDlg.actLookInAllFieldsExecute(Sender: TObject);
begin
   actLookInAllFields.Checked         := not actLookInAllFields.Checked;
   actLookInText.Checked              := not actLookInAllFields.Checked;
   actLookInOldTextSourceText.checked := not actLookInAllFields.Checked;
   actLookInComment.Checked           := not actLookInAllFields.Checked;
end;

procedure TFindDlg.actLookInTextExecute(Sender: TObject);
begin
   (sender as TAction).Checked := not (sender as TAction).Checked;
   if (sender as TAction).Checked then
     actLookInAllFields.Checked := false;
   if not actLookInText.checked and not actLookInOldTextSourceText.checked and not actLookInComment.Checked then
     actLookInAllFields.Checked := true;
end;

procedure TFindDlg.actFindNextExecute(Sender: TObject);
var
  iIndex : integer;
begin
  iIndex := m_Finddef.m_lstHistory.indexof(comboFindWhat.text);
  if iIndex <> -1 then
    m_Finddef.m_lstHistory.move(iIndex,0)
  else
    m_Finddef.m_lstHistory.insert(0,comboFindWhat.text);

  m_Finddef.m_strFindWhat := comboFindWhat.Text;
  m_Finddef.m_bMatchCase := cbMatchCase.Checked;
  m_Finddef.m_bMatchWholeWord := cbMatchWholeWord.checked;
  m_Finddef.m_bPassEOF := cbPassEOF.checked;
  m_Finddef.m_bIgnoreAmpersand := cbIgnoreAmpersand.Checked;
  m_Finddef.m_bDirDown := rbDirDown.checked;
  m_Finddef.m_bAllResources := rbAllResources.checked;
  m_Finddef.m_bLookInAllFields := actLookInAllFields.checked;
  m_Finddef.m_bLookInText := actLookInText.checked;
  m_Finddef.m_bLookInOldTextSourceText := actLookInOldTextSourceText.checked;
  m_Finddef.m_bLookInComment := actLookInComment.checked;

  if (owner as TCustomListFm).find(m_Finddef.m_bDirDown) <> nil then
    modalresult := mrOK;
end;

procedure TFindDlg.actFindNextUpdate(Sender: TObject);
begin
   actFindNext.Enabled := comboFindwhat.Text <> '';
end;

end.
