{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uExportTransListDlg;

interface

uses
  uTextLists,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls;

type
  TExportTransListDlg = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    lbFormat: TListBox;
    cbBookmark: TCheckBox;
    saveGlossDlg: TSaveDialog;
    saveTransListDlg: TSaveDialog;
    saveTextFileDlg: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
    m_TransTextList : TTransTextList;
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; TransTextList : TTransTextList ); reintroduce;
  end;

var
  ExportTransListDlg: TExportTransListDlg;

implementation

{$R *.xfm}

uses
 uApp, uLanguage, uGlossary, uMainFm;

constructor TExportTransListDlg.Create( AOwner : TComponent; TransTextList : TTransTextList );
begin
  inherited create(AOwner);
  m_TransTextList := TransTextList;
end;

procedure TExportTransListDlg.FormShow(Sender: TObject);
begin
   lbFormat.itemindex := 2;
end;

procedure TExportTransListDlg.btnOKClick(Sender: TObject);
var
  strFileName, strPath : string;
resourcestring
  rsExporting = 'Exporting %s to %s';
begin
   strFileName := extractFileName(m_TransTextList.ListFileName);
   strFileName := changeFileExt(strFileName, '');
   strFileName := changeFileExt(strFileName, '');
   strFilename := strFilename + '.'+GetLangId(m_TransTextList.sourceLangNo)+
                                '.'+GetLangId(m_TransTextList.TransLangNo);

   case lbFormat.ItemIndex of
     0: begin
       saveTransListDlg.Filename := strFilename;
       if saveTransListDlg.execute then begin
           mainFm.memOutput.Lines.Clear;
           mainFm.memOutput.Lines.add(format(rsExporting, [(owner as TForm).caption, saveTransListDlg.filename]));
           m_TransTextList.WriteToFile( saveTransListDlg.filename );
       end;
     end;
     1: begin
       saveTextFileDlg.Filename := strFilename;
       if saveTextFileDlg.execute then begin
           mainFm.memOutput.Lines.Clear;
           mainFm.memOutput.Lines.add(format(rsExporting, [(owner as TForm).caption, saveTextFileDlg.filename]));
           m_TransTextList.WriteToTextFile( saveTextFileDlg.filename, cbBookmark.checked );
       end;
     end;
     2: begin
        if assigned(m_TransTextList.ParentTranslation) then
           strPath := extractFilePath(m_TransTextList.ParentTranslation.Parentsource.ParentProject.Filename)
        else
           strPath := g_app.glossaryDir;
        saveGlossDlg.initialdir := strPath;
        saveGlossDlg.filename   := strFilename;
        if saveGlossDlg.execute then begin
          with TGlossary.create( m_TransTextList, cbBookmark.checked ) do begin
            try
             mainFm.memOutput.Lines.Clear;
             mainFm.memOutput.Lines.add(format(rsExporting, [(owner as TForm).caption, saveGlossDlg.FileName]));
             writeToFile( saveGlossDlg.FileName );
             g_app.reloadGlossary(saveGlossDlg.FileName);
            finally
             free;
            end;
          end;
        end;
     end;
   end;
end;

end.
