{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uEditTransItemFm;

interface

uses
  QGrids, uTextLists,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QActnList, QImgList, QComCtrls, QExtCtrls;

type
  TEditTransItemFm = class(TForm)
    panTop: TPanel;
    cbBookmark: TCheckBox;
    cbTranslated: TCheckBox;
    cbReview: TCheckBox;
    memComment: TMemo;
    memSourceText: TMemo;
    memTranslation: TMemo;
    tbBottom: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ImageList1: TImageList;
    ActionList1: TActionList;
    actFirst: TAction;
    actUp: TAction;
    actDown: TAction;
    actLast: TAction;
    actBookmark: TAction;
    actTranslated: TAction;
    actReview: TAction;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    actValidateTranslation: TAction;
    actUntranslate: TAction;
    actTransComment: TAction;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    actCharTable: TAction;
    lblStat: TLabel;
    ToolButton11: TToolButton;
    actAutoTranslateString: TAction;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure actFirstExecute(Sender: TObject);
    procedure actFirstUpdate(Sender: TObject);
    procedure actLastExecute(Sender: TObject);
    procedure actLastUpdate(Sender: TObject);
    procedure actUpExecute(Sender: TObject);
    procedure actUpUpdate(Sender: TObject);
    procedure actDownExecute(Sender: TObject);
    procedure actDownUpdate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actBookmarkExecute(Sender: TObject);
    procedure actTranslatedExecute(Sender: TObject);
    procedure actReviewExecute(Sender: TObject);
    procedure actReviewUpdate(Sender: TObject);
    procedure actValidateTranslationExecute(Sender: TObject);
    procedure actUntranslateExecute(Sender: TObject);
    procedure actValidateTranslationUpdate(Sender: TObject);
    procedure actUntranslateUpdate(Sender: TObject);
    procedure actTransCommentExecute(Sender: TObject);
    procedure actCharTableExecute(Sender: TObject);
    procedure memTranslationChange(Sender: TObject);
    procedure actAutoTranslateStringExecute(Sender: TObject);
    procedure memTranslationKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
    m_Grid : TStringGrid;
    m_TransTextList : TTransTextList;
    function HasGriddata : boolean;
    procedure ShowContent;
    procedure SaveContent;
  public
    { Public-Deklarationen }
    constructor Create( AOwner : TComponent; TransTextList : TTransTextList; grid : TStringGrid ); reintroduce;
  end;

var
  EditTransItemFm: TEditTransItemFm;

implementation

{$R *.xfm}

uses
  uApp, uLanguage, uTransListFm, uTransCommentDlg, uCharTableDlg, uGlobal,
  Qt, QMenus;

var
  iLeft : integer = -1;
  iTop : integer = -1;
  iWidth : integer = -1;
  iHeight : integer = -1;

constructor TEditTransItemFm.Create( AOwner : TComponent;  TransTextList : TTransTextList; grid : TStringGrid );
begin
   inherited Create(AOwner);
   m_grid := grid;
   m_TransTextList := TransTextList;
end;

procedure TEditTransItemFm.FormShow(Sender: TObject);
begin
   if (iLeft<>-1) and (iTop<>-1) and (iWidth<>-1) and (iHeight<>-1) then begin
      setbounds(iLeft, iTop, iWidth, iHeight);
   end else begin
      Left := screen.Width div 2 - width div 2;
      Top  := screen.Height div 2 - Height div 2;
   end;

   ShowContent;
   memSourceText.Hint  := memSourceText.Hint + ' - ' + GetLangID(m_TransTextList.SourceLangno);
   memTranslation.Hint := memTranslation.Hint + ' - ' + GetLangID(m_TransTextList.TransLangno);
   actUp.ShortCut := shortcut(key_up, [ssCtrl]);
   actDown.ShortCut := shortcut(key_down, [ssCtrl]);
   actFirst.ShortCut := shortcut(key_Home, [ssCtrl]);
   actLast.ShortCut := shortcut(key_end, [ssCtrl]);
   AddShortCutsToActionHints( actionList1 );
end;

procedure TEditTransItemFm.FormDestroy(Sender: TObject);
begin
   SaveContent;
   iLeft   := Left;
   iTop    := top;
   iWidth  := Width;
   iHeight := Height;
end;

procedure TEditTransItemFm.FormResize(Sender: TObject);
var
  h : integer;
begin
  h := (clientheight - panTop.Height - tbBottom.Height) div 3;
  memComment.Height     := h;
  memSourceText.Top     := memComment.top + h;
  memSourceText.Height  := h;
  memTranslation.Top    := memSourceText.top + h;
  memTranslation.Height := h;
end;

function TEditTransItemFm.HasGriddata : boolean;
begin
   result := (m_Grid.RowCount >= 2) and ( assigned(m_Grid.objects[0,1]) );
end;

procedure TEditTransItemFm.ShowContent;
var
  TransItem : TTransItem;
  strComment : string;
resourcestring
  rsCaption = 'Translation-String %d - String %s';
  rsIn = 'in';
begin
   TransItem := m_grid.objects[0,m_grid.row] as TTransItem;
   caption := format(rsCaption, [TransItem.No, stripID(TransItem.ID)]);
   if TransItem.ParentTransResItem.ResName <> '' then
     caption := caption + ' '+rsIn+' ' + uppercase(TransItem.ParentTransResItem.ResName);
   actBookmark.checked      := TransItem.Bookmark;
   actTranslated.checked    := TransItem.Translated;
   actReview.checked        := TransItem.Review;
   strComment := TransItem.SourceComment;
   if (strComment <> '') and (TransItem.TransComment<>'') then
     strComment := strComment + #10;
   strComment := strComment + TransItem.TransComment;
   memComment.Text          := strComment;
   memSourceText.Text       := TransItem.SourceText;
   memTranslation.Text      := TransItem.TransText;
   memTranslation.Modified  := false;
   if TransItem.ReadOnly then
     memTranslation.Color := clBackground
   else
     memTranslation.Color := clBase;
   memTranslation.ReadOnly  := TransItem.ReadOnly;
   actBookmark.enabled      := not TransItem.ReadOnly;
   actTranslated.enabled    := not TransItem.ReadOnly;
   actReview.enabled        := not TransItem.ReadOnly;
   actCharTable.Enabled     := not TransItem.ReadOnly;
   actAutoTranslateString.Enabled := not TransItem.ReadOnly;
end;

procedure TEditTransItemFm.SaveContent;
var
  TransItem : TTransItem;
  bModified : boolean;
begin
   TransItem := m_grid.objects[0,m_grid.row] as TTransItem;
   bModified := (TransItem.Bookmark <> cbBookmark.Checked) or
                (TransItem.Translated <> cbTranslated.Checked) or
                (TransItem.Review <> cbReview.Checked) or
                (TransItem.TransText <> memTranslation.Text) or
                 memTranslation.Modified;
   TransItem.Bookmark     := cbBookmark.Checked;
   TransItem.Translated   := cbTranslated.Checked;
   TransItem.Review       := cbReview.Checked;
   TransItem.TransText    := memTranslation.Text;
   if memTranslation.Modified then
      Transitem.Translated := true;
   (Owner as TTransListFm).UpdateCurrentTextListLine;
   if bModified then
     (Owner as TTransListFm).SetModified(true);
end;

procedure TEditTransItemFm.actFirstExecute(Sender: TObject);
begin
   SaveContent;
   m_Grid.Row := 1;
   ShowContent;
end;

procedure TEditTransItemFm.actFirstUpdate(Sender: TObject);
begin
   actFirst.Enabled := HasGridData and (m_Grid.Row > 1);
end;

procedure TEditTransItemFm.actLastExecute(Sender: TObject);
begin
   SaveContent;
   m_Grid.Row := m_Grid.RowCount-1;
   ShowContent;
end;

procedure TEditTransItemFm.actLastUpdate(Sender: TObject);
begin
   actLast.Enabled := HasGridData and (m_Grid.Row < m_Grid.RowCount-1);
end;

procedure TEditTransItemFm.actUpExecute(Sender: TObject);
begin
   SaveContent;
   m_Grid.Row := m_Grid.Row-1;
   ShowContent;
end;

procedure TEditTransItemFm.actUpUpdate(Sender: TObject);
begin
   actUp.Enabled := HasGridData and (m_Grid.Row > 1);
end;

procedure TEditTransItemFm.actDownExecute(Sender: TObject);
begin
   SaveContent;
   m_Grid.Row := m_Grid.Row+1;
   ShowContent;
end;

procedure TEditTransItemFm.actDownUpdate(Sender: TObject);
begin
   actDown.Enabled := HasGridData and (m_Grid.Row < m_Grid.RowCount-1);
end;

procedure TEditTransItemFm.actBookmarkExecute(Sender: TObject);
begin
   actBookmark.Checked := not actBookmark.Checked;
end;

procedure TEditTransItemFm.actTranslatedExecute(Sender: TObject);
begin
   actTranslated.Checked := not actTranslated.Checked;
end;

procedure TEditTransItemFm.actReviewExecute(Sender: TObject);
begin
   actReview.Checked := not actReview.Checked;
end;

procedure TEditTransItemFm.actReviewUpdate(Sender: TObject);
begin
   actReview.Enabled := actTranslated.Checked;
   if not actReview.Enabled then
       actReview.checked := false;
end;

procedure TEditTransItemFm.actValidateTranslationExecute(Sender: TObject);
begin
   actTranslated.Checked := true;
   actReview.Checked := false;
end;

procedure TEditTransItemFm.actValidateTranslationUpdate(Sender: TObject);
begin
   actValidateTranslation.Enabled := (not actTranslated.Checked or actReview.Checked) and
                                      not memTranslation.ReadOnly;
end;

procedure TEditTransItemFm.actUntranslateExecute(Sender: TObject);
begin
   actTranslated.Checked := false;
   memTranslation.text := memSourceText.text;
   memTranslation.modified := false;
end;

procedure TEditTransItemFm.actUntranslateUpdate(Sender: TObject);
begin
   actUnTranslate.Enabled := (actTranslated.Checked or (memSourceText.Text <> memTranslation.Text)) and
                             not memTranslation.ReadOnly;
end;

procedure TEditTransItemFm.actTransCommentExecute(Sender: TObject);
var
  TransItem : TTransItem;
  strComment : string;
begin
   TransItem := m_grid.objects[0,m_grid.row] as TTransItem;
   with TTransCommentDlg.create(self) do begin
      lblCaption.Caption := self.Caption;
      memComment.Text    := TransItem.TransComment;
      if showmodal = mrOk then begin
          if TransItem.TransComment <> memComment.Text then begin
             TransItem.TransComment := memComment.Text;
             strComment := TransItem.SourceComment;
             if (strComment <> '') and (TransItem.TransComment<>'') then
                strComment := strComment + #10;
             strComment := strComment + TransItem.TransComment;
             self.memComment.Text := strComment;
             (self.Owner as TTransListFm).SetModified(true);
          end;
      end;
   end;
end;

procedure TEditTransItemFm.actCharTableExecute(Sender: TObject);
begin
   with TCharTableDlg.create(self) do begin
     try
      if showmodal = mrOK then
         memTranslation.Insert(m_char, memTranslation.caretpos.col, memTranslation.caretpos.line);
     finally
      free;
     end;
   end;
end;

procedure TEditTransItemFm.memTranslationChange(Sender: TObject);
begin
    lblStat.caption := format('C: %d'#10'L: %d',[getcharcount(memTranslation.lines.text), memTranslation.lines.count]);
end;

procedure TEditTransItemFm.actAutoTranslateStringExecute(Sender: TObject);
var
  TransItem : TTransitem;
  strTrans : string;
begin
   TransItem := m_grid.objects[0,m_grid.row] as TTransItem;
   if g_app.Translate(TransItem, memTranslation.text, strTrans)>0 then
     memTranslation.Text := strTrans
   else begin
      if m_TransTextList.TranslateHint(TransItem, memTranslation.text, strTrans) then
        memTranslation.Text := strTrans
   end;
end;

procedure TEditTransItemFm.memTranslationKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
var
  i : integer;
  action : TCustomAction;
begin
  for i := 0 to actionList1.ActionCount-1 do begin
     if not (actionList1.actions[i] is TCustomAction) then continue;
     action := actionList1.actions[i] as TCustomAction;
     if (shortcut(key, shift) = action.shortcut) then begin
        key := 0;
        if action.enabled and action.visible then
          action.execute;
        break;
     end;
  end;
  if key = key_return then begin
      key := 0;
      if (ssCtrl in shift) <> g_app.EnterSelNext then begin
        if actDown.Enabled then
          actDownExecute(nil);
        //only with enter select all in memo
        memTranslation.SelectAll;
      end else
        memTranslation.Insert(#10, memTranslation.caretpos.col, memTranslation.caretpos.line);
  end;
end;


end.
