{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uCustomListFm;

interface

uses
  Contnrs, uTextLists,
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QGrids, QExtCtrls, QComCtrls, QActnList, QMenus,
  QImgList, uLLStringGrid;

type
  TCustomListFm = class(TForm)
    tvResources: TTreeView;
    Splitter1: TSplitter;
    gridTextes: TLLStringGrid;
    popResources: TPopupMenu;
    ShowallResources1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ImageList1: TImageList;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    popTextList: TPopupMenu;
    Properties1: TMenuItem;
    OpenResource1: TMenuItem;
    N5: TMenuItem;
    ActionList1: TActionList;
    actDisplayAll: TAction;
    actSave: TAction;
    actPrint: TAction;
    actFind: TAction;
    actDefineFilter: TAction;
    actFilterOff: TAction;
    actProps: TAction;
    actUpdateStringList: TAction;
    actViewOutput: TAction;
    actOpenResource: TAction;
    ilstTree: TImageList;
    actFindNext: TAction;
    actFindPrevious: TAction;
    StatusBar1: TStatusBar;
    actGotoStringNo: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tvResourcesEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure tvResourcesItemClick(Sender: TObject; Button: TMouseButton;
      Node: TTreeNode; const Pt: TPoint);
    procedure actDisplayAllExecute(Sender: TObject);
    procedure actDisplayAllUpdate(Sender: TObject);
    procedure actFindExecute(Sender: TObject);
    procedure actFilterOffExecute(Sender: TObject);
    procedure actPropsUpdate(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure actDefineFilterExecute(Sender: TObject);
    procedure actFilterOffUpdate(Sender: TObject);
    procedure actDefineFilterUpdate(Sender: TObject);
    procedure actViewOutputExecute(Sender: TObject);
    procedure actViewOutputUpdate(Sender: TObject);
    procedure actOpenResourceUpdate(Sender: TObject);
    procedure actOpenResourceExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actFindNextExecute(Sender: TObject);
    procedure actFindNextUpdate(Sender: TObject);
    procedure actFindPreviousExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
  protected
    m_bDisplayAll : boolean;
    m_bFilter : boolean;
    m_ResItems : TObjectList; //link to textlist.items
    m_FindDef : TFindDef;
    m_bModified : boolean;
    procedure FillResourceTree;
    procedure FillTextList;
    procedure UpdateTextListLines;
    procedure UpdateTextListLine( iRow : integer ); virtual; abstract;
    function CanAdd( item : TObject ) : boolean; virtual; abstract;
    procedure SaveTextList; virtual; abstract;
    procedure OpenResource( CustomResItem : TCustomResItem; textitem : TObject );
  public
    { Public-Deklarationen }
    function Find( bDirDown : boolean ) : TCustomSourceTransItem;
    procedure UpdateCurrentTextListLine;
    procedure SetModified( b : boolean );
 end;

var
  CustomListFm: TCustomListFm;

implementation

{$R *.xfm}

uses
  math, uMainFm, uFindDlg, uApp, uGlobal;

procedure TCustomListFm.FormShow(Sender: TObject);
begin
  m_FindDef := TFindDef.create;
  AddShortCutsToActionHints( actionList1 );
end;

procedure TCustomListFm.FormDestroy(Sender: TObject);
begin
  m_FindDef.Free;
end;

procedure TCustomListFm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
resourcestring
  rsSaveQuery = 'Save changes in %s?';
begin
  CanClose := true;
  if m_bModified then begin
    if g_app.AutoSaveStringLists then begin
       SaveTextList;
    end else begin
      if MessageDlg( application.Title, format(rsSaveQuery,[caption]), mtConfirmation, mbYesNo, 0) = mrYes then
          SaveTextList;
    end;
  end;//if modified
end;

procedure TCustomListFm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   action := caFree;
end;

procedure TCustomListFm.SetModified( b : boolean );
begin
  if b <> m_bModified then begin
    m_bModified := b;
    if m_bModified then
      caption := caption + '*'
    else
      caption := copy(caption, 1, length(caption)-1);
  end;
end;

procedure TCustomListFm.FillResourceTree;
var
 iRes : integer;
 tnForms, tnStrings : TTreeNode;
 CustomResItem : TCustomResItem;
 strResName : string;
const
  STRINGINDEX = 0;
  FORMINDEX       = 1;
begin
   tvResources.Items.beginUpdate;
   try
   tvResources.Items.Clear;
   //strings
   tnStrings := tvResources.Items.AddChildObject(nil, 'ResourceStrings', nil);
   tvResources.Items.AddChildObject(tnStrings, 'ResourceStrings', m_Resitems[0]).imageindex := STRINGINDEX;
   tnStrings.Expand(false);
   //forms
   tnForms   := tvResources.Items.AddChildObject(nil, 'Forms', nil);
   for iRes := 0 to m_ResItems.Count-1 do begin
       CustomResItem := m_ResItems[iRes] as TCustomResItem;
       strResName := uppercase(CustomResItem.ResName);
       if CustomResItem.UpdateState = usNew then
         strResName := strResName + ' n';
       if CustomResItem.ResType = rtForm then
         tvResources.Items.AddChildObject(tnForms, strResName, CustomResItem).ImageIndex := FORMINDEX;
   end;
   tnForms.Expand(false);
   finally
      tvResources.Items.EndUpdate;
   end;
end;

procedure TCustomListFm.tvResourcesEditing(Sender: TObject;
  Node: TTreeNode; var AllowEdit: Boolean);
begin
    AllowEdit := false;
end;

procedure TCustomListFm.tvResourcesItemClick(Sender: TObject;
  Button: TMouseButton; Node: TTreeNode; const Pt: TPoint);
begin
  m_bDisplayAll := false;
  FillTextList;
end;

procedure TCustomListFm.UpdateCurrentTextListLine;
begin
   UpdateTextListLine(gridTextes.row);
end;

procedure TCustomListFm.UpdateTextListLines;
var
  i : integer;
begin
  for i := 1 to gridTextes.rowcount-1 do begin
        UpdateTextListLine(i);
  end;
end;

procedure TCustomListFm.actDisplayAllExecute(Sender: TObject);
begin
  m_bDisplayAll := true;
  FillTextList;
end;

procedure TCustomListFm.FillTextList;
var
  iRes, i, iRow : integer;
  CustomResItem : TCustomResItem;
begin
  gridTextes.RowCount := 2;
  iRow := 1;
  gridTextes.Objects[0,iRow] := nil;

  if m_bDisplayAll then
    for iRes := 0 to m_ResItems.Count-1 do begin
      CustomResItem := m_ResItems[iRes] as TCustomResItem;
      for i := 0 to CustomResItem.Count-1 do begin
          if CanAdd(CustomResItem.customItems[i]) then begin
            gridTextes.Objects[0,iRow] := CustomResItem.customItems[i];
            gridTextes.RowCount := gridTextes.RowCount + 1;
            inc(iRow);
          end;
      end;
    end
  else begin
    if assigned(tvResources.Selected) then begin
      CustomResItem := TCustomResItem(tvResources.Selected.data);
      if assigned(CustomResItem) then begin
         gridTextes.RowCount := 2;
         iRow := 1;
         gridTextes.Objects[0,iRow] := nil;
         for i := 0 to CustomResItem.Count-1 do begin
            if CanAdd(CustomResItem.customItems[i]) then begin
              gridTextes.Objects[0,iRow] := CustomResItem.customItems[i];
              gridTextes.RowCount := gridTextes.RowCount+1;
              inc(iRow);
            end;
         end;
      end;//if
    end;//if assigned
  end;

  gridTextes.RowCount := max(2, gridTextes.RowCount-1);
  UpdateTextListLines;
end;

procedure TCustomListFm.OpenResource( CustomResItem : TCustomResItem; textitem : TObject );
var
  i, t : integer;
begin
      for i := 0 to tvResources.Items.count-1 do begin
          if tvResources.Items[i].data = CustomResItem then begin
              tvResources.selected := tvResources.Items[i];
              m_bDisplayAll := false;
              FillTextList;
              //select last
              if assigned(textitem) then begin
                for t := 0 to gridtextes.rowcount-1 do begin
                   if gridtextes.objects[0,t] = textitem then begin
                      gridtextes.row := t;
                      break;
                   end;
                end;
              end;
              break;
          end;
      end;
end;

procedure TCustomListFm.actDisplayAllUpdate(Sender: TObject);
begin
  actDisplayAll.Enabled := not m_bDisplayAll;
end;

procedure TCustomListFm.actSaveExecute(Sender: TObject);
begin
;
end;

procedure TCustomListFm.actFindExecute(Sender: TObject);
begin
   with TFindDlg.create(self, m_Finddef, gridTextes) do begin
     try
       showmodal;
     finally
       free;
     end;
   end;
end;

procedure TCustomListFm.actDefineFilterExecute(Sender: TObject);
begin
//implemented in child forms
end;

procedure TCustomListFm.actDefineFilterUpdate(Sender: TObject);
begin
    actDefineFilter.checked := m_bFilter;
end;

procedure TCustomListFm.actFilterOffExecute(Sender: TObject);
begin
  m_bFilter := false;
  FillTextList;
end;

procedure TCustomListFm.actFilterOffUpdate(Sender: TObject);
begin
   actFilterOff.Enabled := m_bFilter;
end;

procedure TCustomListFm.actPropsUpdate(Sender: TObject);
begin
  actProps.Enabled := gridtextes.Row > 0;
end;

procedure TCustomListFm.actViewOutputExecute(Sender: TObject);
begin
  with (application.mainform as TMainFm) do begin
     memOutput.visible   := not memOutput.visible;
     splitOutput.Visible := memOutput.Visible;
  end;
end;

procedure TCustomListFm.actViewOutputUpdate(Sender: TObject);
begin
   actViewOutput.checked := (application.mainform as TMainFm).memOutput.visible;
end;

procedure TCustomListFm.actOpenResourceExecute(Sender: TObject);
begin
  if activeControl = tvResources then begin
        m_bDisplayAll := false;
        FillTextList;
  end
end;

procedure TCustomListFm.actOpenResourceUpdate(Sender: TObject);
begin
   if activeControl = gridTextes then begin
      actOpenResource.Enabled := m_bDisplayAll and assigned(gridTextes.objects[0, gridTextes.row]);
   end else begin
      if activeControl = tvResources then begin
         actOpenResource.Enabled := assigned(tvResources.selected) and assigned(tvResources.selected.data);
      end else begin
         actOpenResource.Enabled := false;
      end;
   end;
end;

function TCustomListFm.Find( bDirDown : boolean ) : TCustomSourceTransItem;
var
  i : integer;
  CustomSourceTransItem : TCustomSourceTransItem;
const
  aDir : array[boolean] of integer = (-1,+1);
begin
  result := nil;

  if m_FindDef.m_strFindWhat = '' then exit;
  if (gridTextes.rowcount = 2) and not assigned(gridTextes.objects[0,1]) then exit;

  i := gridTextes.row;
  i := i + aDir[bDirDown];
  if m_Finddef.m_bPassEOF then begin
    if i < 1 then
        i := gridTextes.rowcount-1;
    if i > gridTextes.rowcount-1 then
        i := 1;
  end;
  while (i <> gridTextes.row) and (i>=1) and (i<=gridTextes.RowCount-1) do begin
    CustomSourceTransItem := TCustomSourceTransItem(gridTextes.objects[0,i]);
    if CustomSourceTransItem.Find(m_FindDef) then begin
       result          := CustomSourceTransItem;
       gridTextes.row  := i;
       break;
    end;
    i := i + aDir[bDirDown];
    if m_Finddef.m_bPassEOF then begin
      if i < 1 then
        i := gridTextes.rowcount-1;
      if i > gridTextes.rowcount-1 then
        i := 1;
    end;
  end;
end;

procedure TCustomListFm.actFindNextExecute(Sender: TObject);
begin
  Find( m_FindDef.m_bDirDown );
end;

procedure TCustomListFm.actFindNextUpdate(Sender: TObject);
begin
  (sender as TAction).Enabled := m_FindDef.m_strFindWhat <> '';
end;

procedure TCustomListFm.actFindPreviousExecute(Sender: TObject);
begin
  Find( not m_FindDef.m_bDirDown );
end;

end.
