{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uCharTableDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QGrids, QExtCtrls, QComCtrls;

type
  TCharTableDlg = class(TForm)
    gridChars: TStringGrid;
    Label1: TLabel;
    comboRange: TComboBox;
    panChar: TPanel;
    Label2: TLabel;
    efChar: TEdit;
    procedure FormShow(Sender: TObject);
    procedure gridCharsMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure gridCharsSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure gridCharsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure efCharKeyPress(Sender: TObject; var Key: Char);
    procedure efCharChange(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    m_char : char;
  end;

var
  CharTableDlg: TCharTableDlg;

implementation

{$R *.xfm}

uses
  math;

procedure TCharTableDlg.FormShow(Sender: TObject);
var
  iCol, iRow, i : integer;
begin
   i := $20;
   for iRow := 0 to 13 do begin
      for iCol := 0 to 15 do begin
        gridChars.Cells[iCol, iRow] := chr(i);
        inc(i);
      end;
   end;
end;

procedure TCharTableDlg.gridCharsMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  iCol, iRow : integer;
begin
  gridChars.MouseToCell(x,y, iCol, iRow);
  if InRange(iCol, 0, gridchars.colcount-1) and InRange(iRow, 0, gridchars.rowcount-1) then begin
    gridchars.col := iCol;
    gridchars.row := iRow;
  end;
end;

procedure TCharTableDlg.gridCharsSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
    canselect := true;
    m_char := char(gridChars.cells[ACol, ARow][1]);
    panChar.Caption := m_char;
    efChar.text  := format('%2.2X', [ord(m_char)] );
    efChar.CursorPos := 0;
end;

procedure TCharTableDlg.gridCharsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    modalresult := mrOK;
end;

procedure TCharTableDlg.efCharKeyPress(Sender: TObject; var Key: Char);
begin
   if not (key in ['0'..'9', 'A'..'F', #13, #8]) then
     key := #0;
end;

procedure TCharTableDlg.efCharChange(Sender: TObject);
var
 iVal : integer;
 pcText, pcBuf : pchar;
 aBuf : array[0..1] of char;
 str : string;
begin
  iVal    := -1;
  pcText := pchar(lowercase(efChar.text));
  pcBuf  := aBuf;
  hextobin(pctext, pcbuf, 2);
  str := pcBuf;
  if str <> '' then
     iVal := ord(str[1]);
  if iVal >= $20 then begin
     iVal := iVal - $20;
     gridChars.Col := iVal mod 16;
     gridChars.Row := iVal div 16;
  end;
end;

end.
