{ *************************************************************************** }
{                                                                             }
{ This file is part of the LinLocalize project                                }
{                                                                             }
{ Copyright (c) 2003                                                          }
{ Jens Khner <kuehner@users.sourceforge.net>                                 }
{                                                                             }
{ This program is free software; you can redistribute it and/or               }
{ modify it under the terms of the GNU General Public                         }
{ License as published by the Free Software Foundation; either                }
{ version 2 of the License, or (at your option) any later version.            }
{                                                                             }
{ This program is distributed in the hope that it will be useful,             }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           }
{ General Public License for more details.                                    }
{                                                                             }
{ You should have received a copy of the GNU General Public License           }
{ along with this program; see the file COPYING.  If not, write to            }
{ the Free Software Foundation, Inc., 59 Temple Place - Suite 330,            }
{ Boston, MA 02111-1307, USA.                                                 }
{                                                                             }
{ *************************************************************************** }

unit uAppOptionsDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls;

type
  TAppOptionsDlg = class(TForm)
    btnCancel: TButton;
    btnOK: TButton;
    grpPaths: TGroupBox;
    Label1: TLabel;
    efResbind: TEdit;
    btnBrowseLocation: TButton;
    OpenResbindDlg: TOpenDialog;
    grpStringLists: TGroupBox;
    cbAutoSaveStringLists: TCheckBox;
    grpStringProp: TGroupBox;
    Label2: TLabel;
    rbSelNextString: TRadioButton;
    rbLineFeed: TRadioButton;
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnBrowseLocationClick(Sender: TObject);
    procedure efResbindChange(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure UpdateOperations;
  public
    { Public-Deklarationen }
  end;

var
  AppOptionsDlg: TAppOptionsDlg;

implementation

{$R *.xfm}

uses
  uApp;

procedure TAppOptionsDlg.FormShow(Sender: TObject);
begin
  efResbind.Text := g_app.resbindLocation;
  cbAutosaveStringLists.checked := g_app.AutoSaveStringLists;
  if g_app.EnterSelNext then
    rbSelNextString.Checked := true
  else
    rbLineFeed.Checked := true;
  UpdateOperations;
end;

procedure TAppOptionsDlg.btnOKClick(Sender: TObject);
begin
  g_app.resbindLocation := efResbind.Text;
  g_app.AutoSaveStringLists := cbAutosaveStringLists.checked;
  g_app.EnterSelNext := rbSelNextString.Checked;
end;

procedure TAppOptionsDlg.btnBrowseLocationClick(Sender: TObject);
begin
   if OpenResbindDlg.Execute then begin
     efResbind.Text := OpenResbindDlg.FileName;
     UpdateOperations;
   end;
end;

procedure TAppOptionsDlg.efResbindChange(Sender: TObject);
begin
   UpdateOperations;
end;

procedure TAppOptionsDlg.UpdateOperations;
begin
  btnOK.enabled := fileexists(efResbind.text);
end;

end.
