program setupLL;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Libc,
  IniFiles;

var
  strKylixPath, strResbind, strLibBorQT, strStartLL, strDesk,
  strLinLocalize : string;
  f : textfile;
begin
   writeln;
   writeln;
   writeln('Installing LinLocalize - written 2003 by Jens Khner');
   write('Please enter your Kylix 3-location: ');
   readln(strKylixpath);
   strKylixPath := includeTrailingPathDelimiter(strKylixPath);

   if not directoryExists(strKylixPath) then begin
     writeln( format('Directory %s does not exist!', [strKylixPath]) );
     __exit(1);
   end;
   strResbind := strKylixPath+'bin/resbind';
   if not FileExists(strResbind) then begin
     writeln( format('Cannot find file %s!', [strResbind]) );
     __exit(1);
   end;
   strLibBorQT := strKylixPath+'bin/libborqt-6.9-qt2.3.so';
   if not FileExists(strLibBorQT) then begin
     writeln( format('Cannot find file %s!', [strLibBorQT]) );
     __exit(1);
   end;

   strLinLocalize := IncludeTrailingPathDelimiter(get_current_dir_name)+'LinLocalize';

   strStartLL := IncludeTrailingPathDelimiter(get_current_dir_name)+'startLL';
   assignfile(f, strStartLL);
   rewrite(f);
   writeln(f, '#!/bin/bash');
   writeln(f, 'export LD_LIBRARY_PATH='+strKylixPath+'bin');
   writeln(f, strLinLocalize);
   closefile(f);
   chmod(pchar(strStartLL), ACCESSPERMS);

   with TIniFile.Create(extractFilePath(paramstr(0))+'LinLocalize.ini') do begin
      writestring('Options', 'ResbindLocation', strResbind);
      updatefile;
   end;

   try
     strDesk := IncludeTrailingPathDelimiter(GetEnvironmentVariable('HOME'))+'Desktop/LinLocalize.desktop';
     assignfile(f, strDesk);
     rewrite(f);
     writeln(f, '[Desktop Entry]');
     writeln(f, 'Comment=Starts LinLocalize');
     writeln(f, 'Exec='+strStartLL);
     writeln(f, 'Icon=');
     writeln(f, 'MimeType=');
     writeln(f, 'Name=LinLocalize');
     writeln(f, 'Path=');
     writeln(f, 'ServiceTypes=');
     writeln(f, 'SwallowExec=');
     writeln(f, 'SwallowTitle=');
     writeln(f, 'Terminal=');
     writeln(f, 'TerminalOptions=');
     writeln(f, 'Type=Application');
     writeln(f, 'X-KDE-SubstituteUID=false');
     writeln(f, 'X-KDE-Username=');
     closefile(f);
     chmod(pchar(strDesk), ACCESSPERMS);
  except
   end;

   writeln('Setup of LinLocalize was successfully.');
   writeln('To start LinLocalize execute ./startLL in a shell!');
end.
