unit uLLStringGrid;

interface

uses
  Types, QGraphics,
  SysUtils, Classes, QControls, QGrids;

type
  TOnTextColor = function( ACol, ARow: Longint; ARect: TRect;
      AState: TGridDrawState ) : TColor of object;
  TLLStringGrid = class(TStringGrid)
  private
    { Private-Deklarationen }
    FOnTextColor : TOnTextColor;
  protected
    { Protected-Deklarationen }
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect;
      AState: TGridDrawState); override;
  public
    { Public-Deklarationen }
  published
    { Published-Deklarationen }
    property OnTextColor : TOnTextColor read FOnTextColor write FOnTextColor;
  end;

procedure Register;

implementation

procedure TLLStringGrid.DrawCell(ACol, ARow: Longint; ARect: TRect;
                                 AState: TGridDrawState);
begin
  if assigned(FOnTextColor) then
     canvas.font.Color := FOnTextColor(ACol, ARow, ARect, AState );
  inherited
end;


procedure Register;
begin
  RegisterComponents('LinLocalize', [TLLStringGrid]);
end;

end.
