unit Main;
{
KReversi version 0.1 a revesi program
Copyright (C) 2001 Preben Bjorn Madsen
E-mail: kuyabjorn@yahoo.com

Visit my web site for for new versions
http://www.geocities.com/kuyabjorn

Or join my Yahoo Club for Kylix
http://clubs.yahoo.com/clubs/kylixclub

KReversi is a very simple reversi program. I just made it
as a first test of Kylix under Linux. The engine isn't
very clever. And the rest of the program is very basic too.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QGrids, QStdCtrls;

const SBoard: array[0..7, 0..7] of Char =
                        (('F','F','F','F','F','F','F','F'),
                        ('F','F','F','F','F','F','F','F'),
                        ('F','F','F','F','F','F','F','F'),
                        ('F','F','F','W','B','F','F','F'),
                        ('F','F','F','B','W','F','F','F'),
                        ('F','F','F','F','F','F','F','F'),
                        ('F','F','F','F','F','F','F','F'),
                        ('F','F','F','F','F','F','F','F'));

type
  TCode = (F,B,W);
{F - Free
B - Black
W - White}

type
  TMainForm = class(TForm)
    Grid: TDrawGrid;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Label1: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Button2: TButton;
    Button1: TButton;
    Label13: TLabel;
    procedure GridDrawCell(Sender: TObject; Col, Row: Integer; Rect: TRect;
      State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure GridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DoCount;
    procedure ComputerPlay;
    procedure RadioButtonClick(Sender: TObject);
    procedure StartGame;
    function DoMove(CurCol: TCode; Col, Row: Integer): Boolean;
  private
    { Private declarations }
  public
    Map: array[0..7,0..7] of TCode;
    CurCol, ComCol, PlaCol: TCode;
    Bmp: TBitmap;
    Whites, Blacks: Integer;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.xfm}

Uses Reversi;

procedure TMainForm.StartGame;
var i,j: Integer;
c: Char;

function CharToCode(AChar: Char): TCode;
begin
  Result := F;
  case AChar of
    'F': Result := F;
    'B': Result := B;
    'W': Result := W;
  end;
end;

begin
  for i := 0 to 7 do
  begin
    for j := 0 to 7 do
    begin
      c := SBoard[j,i];
      Map[j,i] := CharToCode(c);
    end;
    j := 7;
    c := SBoard[j,i];
    Map[j,i] := CharToCode(c);
  end;
  Grid.Repaint;
  RadioButtonClick(Self);
  CurCol := B;
  if ComCol = B then ComputerPlay;
end;

procedure TMainForm.GridDrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
var Image: PChar;
begin
  Image := 'FREE';
  case Map[Col,Row] of
    F: Image := 'FREE';
    B: Image := 'BLACK';
    W: Image := 'WHITE';
  end;

  Bmp.LoadFromResourceName(HInstance,Image);
  Grid.Canvas.Draw(Rect.Left, Rect.Top, Bmp);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Bmp := TBitmap.Create;
  StartGame;
end;

procedure TMainForm.ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.NewClick(Sender: TObject);
begin
  StartGame;
end;

procedure TMainForm.GridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Col, Row: Integer;
begin
  if CurCol = ComCol then Exit;
  CurCol := ComCol;
  Grid.MouseToCell(X,Y,Col,Row);
  If DoMove(PlaCol, Col, Row) then ComputerPlay
  else CurCol := PlaCol;
  // Fix if no legal move
end;

procedure TMainForm.ComputerPlay;
var
  Tmp: Integer;
begin
  if ComCol = W then Tmp := DoStep(Reversi.W, @Map)
  else Tmp := DoStep(Reversi.B, @Map);
  if tmp <> 65535 then DoMove(ComCol, tmp shr 8, tmp and 255);
  CurCol := PlaCol;
end;

function TMainForm.DoMove(CurCol: TCode; Col, Row: Integer): Boolean;
var
  Otr, Own: TCode;
  Chk1, Chk2: Boolean;
  i, j, k: Integer;
begin
  if CurCol = B then
  begin
    Own := CurCol;
    Otr := W;
  end
  else
  begin
    Own := CurCol;
    Otr := B;
  end;

  Chk1 := False;
  Chk2 := False;

  if Map[Col, Row] <> F then Result := False
  else
  begin
    for i := Col -1 downto 0 do // Check left
    begin
      if Map[i, Row] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, Row] = Own) Then
        begin
          Chk2 := True;
          for j := Col downto i + 1 do Map[j, Row] := Own;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //for i

    Chk1 := False;

    for i := Col + 1 to 7 do // Check Right
    begin
      if Map[i, Row] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, Row] = Own) Then
        begin
          Chk2 := True;
          for j := Col to i - 1 do Map[j, Row] := Own;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //for i

    Chk1 := False;

    for i := Row - 1 downto 0 do // Check Up
    begin
      if Map[Col, i] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[Col, i] = Own) Then
        begin
          Chk2 := True;
          for j := Row downto i + 1 do Map[Col, j] := Own;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //for i

    Chk1 := False;

    for i := Row + 1 to 7 do // Check Down
    begin
      if Map[Col, i] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[Col, i] = Own) Then
        begin
          Chk2 := True;
          for j := Row to i - 1 do Map[Col, j] := Own;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //for i

    Chk1 := False;
    i := Col;
    j := Row;
    While (i > 0) and (j > 0) do  // Check Left - up
    begin
      Dec(i);
      Dec(j);
      if Map[i, j] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, j] = Own) Then
        begin
          Chk2 := True;
          j := Row;
          for k := Col downto i + 1 do
          begin
            Map[k, j] := Own;
            Dec(j);
          end;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //while

    Chk1 := False;
    i := Col;
    j := Row;
    While (i <7) and (j > 0) do  // Check Right up
    begin
      Inc(i);
      Dec(j);
      if Map[i, j] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, j] = Own) Then
        begin
          Chk2 := True;
          j := Row;
          for k := Col to i - 1 do
          begin
            Map[k, j] := Own;
            Dec(j);
          end;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //while

    Chk1 := False;
    i := Col;
    j := Row;
    While (i <7) and (j < 7) do  // Check Right Down
    begin
      Inc(i);
      Inc(j);
      if Map[i, j] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, j] = Own) Then
        begin
          Chk2 := True;
          j := Row;
          for k := Col to i - 1 do
          begin
            Map[k, j] := Own;
            Inc(j);
          end;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //while

    Chk1 := False;
    i := Col;
    j := Row;
    While (i > 0) and (j < 7) do  // Check Left Down
    begin
      Dec(i);
      Inc(j);
      if Map[i, j] = Otr then Chk1 := True
      else
      begin
        if (Chk1) and (Map[i, j] = Own) Then
        begin
          Chk2 := True;
          j := Row;
          for k := Col downto i + 1 do
          begin
            Map[k, j] := Own;
            Inc(j);
          end;
          Break;
        end
        else Break; // if Chk1
      end; // if Map
    end; //while
  end; //if Map

  if Chk2 then
  begin
    Result := True;
    DoCount;
    Label5.Caption := Chr(Col + 65) + IntToStr(Row + 1);
    Grid.Repaint;
  end
  else Result := False;
end;

procedure TMainForm.DoCount;
var
  i, j: Integer;
begin
  Blacks := 0;
  Whites := 0;
  for i := 0 to 7 do
    for j := 0 to 7 do
      if Map[i,j] = w then inc(Whites)
      else if Map[i,j] = B then inc(Blacks);
      label2.Caption := IntToStr(Blacks);
      label4.Caption := IntToStr(Whites);
end;
procedure TMainForm.RadioButtonClick(Sender: TObject);
begin
  if RadioButton1.Checked then
  begin
    ComCol := B;
    PlaCol := W;
  end
  else
  begin
    ComCol := W;
    PlaCol := B;
  end;
end;
 end.
