{
File Server version 0.1 a simple server
Copyright (C) 2001 Preben Bjorn Madsen
E-mail: kuyabjorn@yahoo.com

Requires: Indy Components for Kylix.

Based on Image Server by Allen O'Neill <email: allen_oneill@hotmail.com> 28/11/2000

Visit my web site for for new versions
http://www.geocities.com/kuyabjorn

Or join my Yahoo Club for Kylix
http://clubs.yahoo.com/clubs/kylixclub

KReversi is a very simple reversi program. I just made it
as a first test of Kylix under Linux. The engine isn't
very clever. And the rest of the program is very basic too.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}

unit fServer;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  IdBaseComponent, IdComponent, IdTCPServer, IdGlobal,
  QStdCtrls;

type
  TfrmServer = class(TForm)
    IdTCPServer: TIdTCPServer;
    lstRequests: TListBox;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure IdTCPServerDisconnect(AThread: TIdPeerThread);
    procedure IdTCPServerExecute(AThread: TIdPeerThread);
    procedure IdTCPServerConnect(AThread: TIdPeerThread);
  private
    { Private declarations }
    PubDir: String;
  public
    { Public declarations }
  Function GetList : String;
  end;

var
  frmServer: TfrmServer;
  sFilePattern : String;

implementation

{$R *.xfm}

// activates TCP server
procedure TfrmServer.FormCreate(Sender: TObject);
begin
IdTCPServer.Active := true;
if IdTCPServer.Active = true then
    lstRequests.items.append('Active');
PubDir := ExtractFileDir(ParamStr(0)) + '/download/'
end;

procedure TfrmServer.IdTCPServerDisconnect(AThread: TIdPeerThread);
begin
lstRequests.items.append('Dis-Connected');
end;

// interpets request and sends back data
procedure TfrmServer.IdTCPServerExecute(AThread: TIdPeerThread);
var
    s, sCommand, sAction : string;
    fStream : TFileStream;
begin

try

s := AThread.Connection.ReadLn;
sCommand := uppercase(copy(s,1,3));
sAction := copy(s,5,100);

if sCommand = 'LST' then
    begin
    AThread.Connection.WriteLn(GetList);
    AThread.Connection.Disconnect;
    end
else
if sCommand = 'GET' then
    begin
    if FileExists(PubDir + sAction) then
        Begin
        lstRequests.items.add('Serving up: ' + sAction);
        // open file stream to image requested
        fStream := TFileStream.Create(PubDir + sAction,fmOpenRead + fmShareDenyNone);
        // copy file stream to write stream
        AThread.Connection.OpenWriteBuffer;
        AThread.Connection.WriteStream(fStream);
        AThread.Connection.CloseWriteBuffer;
        // free the file stream
        FreeAndNil(fStream);
        lstRequests.items.add('File transfer completed');
        End
    else
    AThread.Connection.WriteLn('ERR - Requested file does not exist:' + sAction);
    AThread.Connection.Disconnect;
    End
else
if (sCommand <> 'LST') and (sCommand <> 'GET') then
    Begin
    AThread.Connection.WriteLn('ERR : Unknown command / action');
    AThread.Connection.Disconnect;
    end;
except
on E : Exception do
ShowMessage(E.Message);
End;
end;

procedure TfrmServer.IdTCPServerConnect(AThread: TIdPeerThread);
begin
lstRequests.items.add('Server connected');
end;

// Simple function to search given path and return file names in comma delimited format
// NOTE! .. assumes in demo version there is a sub-folder off executable called 'images" that contains
// sample valid BMP images
Function TfrmServer.GetList : String;
var
    SR : TSearchRec;
    S : String;
Begin
sFilePattern := PubDir + '*.*';
S := '';
if FindFirst(sFilePattern,faAnyFile,SR) = 0 then
    Begin
    s := SR.Name;
    while FindNext(sr) = 0 do
        s := s + ',' + SR.Name;
    End;
result := s;
End;

end.
