{
File Download Client version 0.1 a simple client
Copyright (C) 2001 Preben Bjorn Madsen
E-mail: kuyabjorn@yahoo.com

Requires: Indy Components for Kylix.

Based on Image Server by Allen O'Neill <email: allen_oneill@hotmail.com> 28/11/2000

Visit my web site for for new versions
http://www.geocities.com/kuyabjorn

Or join my Yahoo Club for Kylix
http://clubs.yahoo.com/clubs/kylixclub

KReversi is a very simple reversi program. I just made it
as a first test of Kylix under Linux. The engine isn't
very clever. And the rest of the program is very basic too.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}

unit fClient;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient,IdGlobal, QExtCtrls;

type
  TfrmClient = class(TForm)
    btnGetImageList: TButton;
    lstAvailableFiles: TListBox;
    Label1: TLabel;
    Shape1: TShape;
    btnGetSelectedImage: TButton;
    btnExit: TButton;
    Label2: TLabel;
    edtServerHost: TEdit;
    IdTCPClient: TIdTCPClient;
    Label4: TLabel;
    edtServerPort: TEdit;
    Label3: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnGetImageListClick(Sender: TObject);
    procedure btnGetSelectedImageClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    DownDir: String;
  public
    { Public declarations }
  Procedure LoadItems(S : String);
  end;

var
  frmClient: TfrmClient;

implementation

{$R *.xfm}

procedure TfrmClient.btnExitClick(Sender: TObject);
begin
if MessageDlg('Are you sure you wish to exit?', mtInformation, [mbYes, mbNo], 0)
= mrYes then application.terminate;
end;

// Get list of available images form server
procedure TfrmClient.btnGetImageListClick(Sender: TObject);
begin
try
with IdTCPClient do
    begin
    if connected then DisConnect;
    Host := edtServerHost.text;
    Port := StrToInt(edtServerPort.text);
    Connect;
    WriteLn('LST:');
    lstAvailableFiles.Clear;
    LoadItems(ReadLn);
    Disconnect;
    end;
except
on E : Exception do
    ShowMessage(E.Message);
end;
end;

//get selected image in listbox from server
procedure TfrmClient.btnGetSelectedImageClick(Sender: TObject);
var
    ftmpStream : TFileStream;
begin
Try
if lstAvailableFiles.itemindex = -1 then
MessageDlg('Cannot proceed until you select an image from the list !', mtInformation, [mbOK], 0)
else
with IdTCPClient do
    begin
    if connected then DisConnect;
    Host := edtServerHost.text;
    Port := StrToInt(edtServerPort.text);
    Connect;
    WriteLn('GET:' + lstAvailableFiles.Items[lstAvailableFiles.itemindex]);
    // delete if exists
    // in production situation you might store binary downloads like this in a cache folder
    if FileExists(DownDir + lstAvailableFiles.Items[lstAvailableFiles.itemindex]) then
        DeleteFile(DownDir + lstAvailableFiles.Items[lstAvailableFiles.itemindex]);
    try
      try
        ftmpStream := TFileStream.Create(DownDir + lstAvailableFiles.Items[lstAvailableFiles.itemindex],fmCreate);
        while connected do
          ReadStream(fTmpStream,-1,true);
        except
          //
        end;
    finally
      FreeAndNil(fTmpStream);
      Disconnect;
    end;
    if FileExists(DownDir + lstAvailableFiles.Items[lstAvailableFiles.itemindex]) then
        Label3.Caption := 'Download OK!'
        else Label3.Caption := 'Download failed';
end;
except
on E : Exception do
    ShowMessage(E.Message);
end;
end;

// Procedure to break up items in input string
Procedure TfrmClient.LoadItems(S : String);
var
    iPosComma : integer;
    sTmp : string;
begin
try
lstAvailableFiles.Clear;
s := trim(s);
while pos(',',s) > 0 do
    Begin
    iPosComma := pos(',',s); // locate commas
    sTmp := copy(s,1,iPosComma - 1); // copy item to tmp string
    lstAvailableFiles.items.Add(sTmp); // add to list
    s := copy(s,iPosComma + 1,Length(s)); // delete item from string
    End;
// trap for trailing filename
if length(s) <> 0 then lstAvailableFiles.items.Add(s);
except
on E : Exception do
    ShowMessage(E.Message);
end;
end;

 procedure TfrmClient.FormCreate(Sender: TObject);
begin
  DownDir := ExtractFileDir(ParamStr(0)) + '/download/';
end;


end.

