/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates.  All rights reserved.
 *
 * $Id$
 */

#ifndef _DB_PERFMON_H_
#define	_DB_PERFMON_H_

/*******************************************************
 * Oracle Berkeley DB Performance Event Monitoring
 *
 * Some events inside of Oracle Berkeley DB can be 'published'
 * to the operating environment's performance tracing system
 * as they occur. Current support includes:
 *	DTrace on Solaris, Darwin (Mac OS X), QNX(?)  	--enable-dtrace
 *	SystemTap on Linux 				--enable-systemtap
 *
 ******************************************************/

/*
 * The performance monitoring system can display many of the statistics which
 * are obtainable through the {DB,DB_ENV}->xxx_stat() functions. By default
 * they are included for now. We'll see how useful they are.
 */
#ifdef HAVE_STATISTICS_PERFMON
#define STAT_PERFMON1(env, cat, id, a1)	PERFMON1(env, cat, id, (a1))
#else
#define STAT_PERFMON1(env, cat, id, a1)
#endif


#ifdef HAVE_PERFMON
/*
 * The DTrace macros which are generated at configure time in db_provider.h can
 * have full function signatures. These declarations are needed for compilation
 * when DTrace support is enabled. It is "too early" in the include sequence
 * to include the header files which define these structs.
 */
struct __bh;
struct __db_dbt;

#if defined(HAVE_DTRACE)
/* Solaris 10, Darwin/Mac OS X starting in 10.5 (Leopard) */
#include "db_provider.h"

#define PERFMON0(env, cat, id)			\
    bdb##_##cat##_##id()
#define PERFMON1(env, cat, id, a1)		\
    bdb##_##cat##_##id(a1)
#define PERFMON2(env, cat, id, a1, a2)		\
    bdb##_##cat##_##id((a1), (a2))
#define PERFMON3(env, cat, id, a1, a2, a3)	\
    bdb##_##cat##_##id((a1), (a2), (a3))
#define PERFMON4(env, cat, id, a1, a2, a3, a4)	\
    bdb##_##cat##_##id((a1), (a2), (a3), (a4))
#endif

#if defined(HAVE_SYSTEMTAP)
/*
 * Linux SystemTap 0.9
 * It mostly compatible with Solaris, though we do not use the
 * function/macro definition possibly generated by dtrace -h.
 * The systemtap development package needs to be installed in order to build db.
 * It might be named systemtap-sdt-dev, systemtap-sdt-devel, or stap-dev.
 */
#include <sys/sdt.h>
#define PERFMON0(env, cat, id)			\
    DTRACE_PROBE(bdb, cat##__##id)
#define PERFMON1(env, cat, id, a1)		\
    DTRACE_PROBE1(bdb, cat##__##id, (a1))
#define PERFMON2(env, cat, id, a1, a2)		\
    DTRACE_PROBE2(bdb, cat##__##id, (a1), (a2))
#define PERFMON3(env, cat, id, a1, a2, a3)	\
    DTRACE_PROBE3(bdb, cat##__##id, (a1), (a2), (a3))
#define PERFMON4(env, cat, id, a1, a2, a3, a4)	\
    DTRACE_PROBE4(bdb, cat##__##id, (a1), (a2), (a3), (a4))
#endif


#else
/* Without HAVE_PERFMON these macros map to null bodies. */
#define PERFMON0(env, cat, id)
#define PERFMON1(env, cat, id, a1)
#define PERFMON2(env, cat, id, a1, a2)
#define PERFMON3(env, cat, id, a1, a2, a3)
#define PERFMON4(env, cat, id, a1, a2, a3, a4)
#endif


#endif
