# WELCOME.TCL - Setup procedures for implementing welcome wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01d,26apr99,bjl  removed icon for Unix to aid refresh problem.
# 01c,22mar99,wmd  Rename file from .CD_STATUS to CD_STATUS.
# 01b,19mar99,wmd  Add debug code to warn user that CD may have defects.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(welcome) - displays CD title, welcome and warning statements
#
# This procedure will display CD title, welcome and warning statements
#
# SYNOPSIS
# .tS
# pageCreate(welcome)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(welcome) {} {
    global ctrlVals
    global setupVals

    # chop off the string if it is too long

    if {[string length $setupVals(CDdescription)] > 45} {
        set cdTitle [cdromDescGet]
    } else {
        set cdTitle [strTableGet 1000_WELCOME_CD]
    }

    if {[isUnix]} {
        # move the first welcome messages to the left since
        # the icon is removed.

        set topmsgx 101
        set msg1w 204
    } else {
        set topmsgx 135
        set msg1w 169
    }

    if {[isUnix]} {
        # do not display message about exiting all programs.

        set ctrlVals(volatileFrm) [list \
                    [list bitmap -name bmp -stretch -title \
                                [cdFileNameGet \
                                [file join RESOURCE BITMAPS SETUPICO.BMP]] \
                                -x 101 -y 10 -w 24 -h 24] \
                    [list label -name msg0 \
                                -title $cdTitle\
                                -x $topmsgx -y 10 -w 173 -h 8] \
                    [list label -name msg1 \
                                -title [strTableGet 1000_WELCOME1]\
                                -x $topmsgx -y 20 -w $msg1w -h 18] \
                    [list label -name msg3 \
                                -title [strTableGet 1020_WELCOME3]\
                                -x 101 -y 49 -w 204 -h 40] \
                    [list label -name msg4 \
                                -title [strTableGet 1030_WELCOME4]\
                                -x 100 -y 95 -w 205 -h 16] \
                    [list label -name msg5 \
                                -title [strTableGet 1040_WELCOME5]\
                                -x 100 -y 125 -w 205 -h 32] \
        ]
    } else {
        set ctrlVals(volatileFrm) [list \
                    [list bitmap -name bmp -stretch -title \
                                [cdFileNameGet \
                                [file join RESOURCE BITMAPS SETUPICO.BMP]] \
                                -x 101 -y 10 -w 24 -h 24] \
                    [list label -name msg0 \
                                -title $cdTitle\
                                -x $topmsgx -y 10 -w 173 -h 8] \
                    [list label -name msg1 \
                                -title [strTableGet 1000_WELCOME1]\
                                -x $topmsgx -y 20 -w $msg1w -h 18] \
                    [list label -name msg2 \
                                -title [strTableGet 1010_WELCOME2]\
                                -x 101 -y 40 -w 204 -h 24] \
                    [list label -name msg3 \
                                -title [strTableGet 1020_WELCOME3]\
                                -x 101 -y 69 -w 204 -h 40] \
                    [list label -name msg4 \
                                -title [strTableGet 1030_WELCOME4]\
                                -x 100 -y 119 -w 205 -h 16] \
                    [list label -name msg5 \
                                -title [strTableGet 1040_WELCOME5]\
                                -x 100 -y 145 -w 205 -h 24] \
        ]
    }

    if {[isUnix]} {
        # remove the setup icon, it has a different color palette and may
        # appear incorrectly.  In the latest version of UITclSh it also
	# appears to contribute to an overlapping window refresh problem.  

        set ctrlVals(volatileFrm) [lrange $ctrlVals(volatileFrm) 1 \
                            [expr [llength $$ctrlVals(volatileFrm)] - 1]]
    }

    set w [dlgFrmCreate [strTableGet 1410_TITLE_WELCOME]]

    # Disable the Back button since this is the first page

    controlEnable $w.backButt 0
    controlEnable $w.nextButt 1
    controlFocusSet $w.nextButt
    controlPropertySet $w.msg0 -bold 1

    if {![isUnix]} {
        controlPropertySet $w.msg2 -bold 1
    }

    controlHide $ctrlVals(mainWindow).bitmap 0

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Welcome page: Skipped"
        pageRemove readme
        nextCallback
    }
}

#############################################################################
#
# pageProcess(welcome) - process inputs from welcome wizard page
#
# This procedure will process inputs from welcome wizard page
#
# SYNOPSIS
# .tS
# pageProcess(welcome)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 if successful
#
# ERRORS: N/A
#

proc pageProcess(welcome) {} {
    global ctrlVals
    global setupVals

    if {[debug]} {
        if {![catch {open [cdromRootDirGet]/CD_STATUS "r"} fd]} {
            gets $fd cdStatus
            close $fd
            if {[string compare $cdStatus "SUCCESS"] != 0} {
                messageBox -ok -exclamationicon "This CD may contain zero-length \
                    files, or may be missing files!"
            }
        }
    }

    controlEnable $ctrlVals(mainWindow).backButt 1
    return 1
}
