# SYSCONFG.TCL  - Setup procedures for implementing system-configuration
#                 wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01i,20apr99,wmd  Modify to add $WIND_BASE/host/$WIND_HOST_TYPE/lib/to
#                  LD_LIBRARY_PATH, etc.
# 01h,24mar99,tcy  moved code for opening program folder to FINISH page
# 01g,19mar99,wmd  Output to a file any debug messages.
# 01f,10feb99,bjl  added LD_LIBRARY_PATH for solaris hosts.
# 01e,10feb99,tcy  fixed USER condition
# 01d,02feb99,tcy  added USER line torVars.csh/sh (fix for SPR 24724)
# 01c,01feb99,tcy  moved torVarsCreate() from INSTALL.TCL;
#                  redo messages
# 01b,28jan99,tcy  made the meter blue.
# 01a,26jan99,tcy  extracted from FINISH.TCL.
#

#############################################################################
#
# pageCreate(systemConfig) - configure user system for Tornado
#
# This procedure will display a wizard page showing what Setup is doing
# to configure the system:
# - Updating the Windows registry for Tornado (Windows only)
# - Installing Tornado program group icons (Windows only)
# - Creating torVars.bat/csh
# - Configuring on-line HTML help
#
# SYNOPSIS
# .tS
# pageCreate(systemConfig)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(systemConfig) {} {
    global ctrlVals
    global tornadoInstalled
    global env

    set ctrlVals(numBbrd) 0

    set msg "SETUP is performing final steps to finish installation."
    if {[isUnix]} {
        set torVarsFiles "torVars.csh and torVars.sh"
    } else {
        set torVarsFiles torVars.bat
    }

    meterCreate $msg

    set w [dlgFrmCreate "System configuration"]

    controlPropertySet $ctrlVals(meterWindow).$ctrlVals(meterWg) \
                            -background Blue -foreground Black

    controlEnable $w.backButt 0
    controlEnable $w.nextButt 0
    controlEnable $w.cancelButt 1
    controlFocusSet $w.cancelButt

    if {![isUnix]} {
        meterUpdate 0 "Updating the Windows registry for Tornado"
    } else {
        meterUpdate 0 ""
    }

    # write Registry values from TORNADO.INF.  This is required to update
    # the user name, company, keydata, folder, etc. each time the user runs
    # the setup program.

    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]

    # process INF files for all selected products

    selectedProductsProcessInfFile FilesCopy

    if {![isUnix]} {
        selectedProductsProcessInfFile AddService
    }

    selectedProductsProcessInfFile AddRegistry

    if {![isUnix]} {
        # make sure we have a folder if tornado is not installed
        # before we add icons

        if ![info exists tornadoInstalled] {
            folderCreateLog [defGroupGet] $ctrlVals(admin)
        }
        selectedProductsProcessInfFile AddIcon
    }
    queueExecute

    meterUpdate 33 "Creating $torVarsFiles"

    if {[info exists tornadoInstalled]} {
        torVarsCreate
    }

    meterUpdate 66 "Configuring on-line HTML help"

    set htmlBookPath [file join \
                     [destDirGet] host resource doctools htmlBook.tcl]
    if [isUnix] {
        set wtxtcl [file join [destDirGet] host [windHostTypeGet] bin wtxtcl.ex]
    } else {
        set wtxtcl \
            [file join [destDirGet] host [windHostTypeGet] bin wtxtcl.exe]
    }

    # use wait cursor here to let users know this step may step a while ...

    beginWaitCursor

    # sets WIND_BASE so the spawned shell can pick up the env. variable
    set env(WIND_BASE) [destDirGet]
    if {[file exists $htmlBookPath] && [file exists $wtxtcl]} {
        if [catch {exec $wtxtcl $htmlBookPath \
                   [file join [destDirGet] docs]} error] {
            dbgputs "Cannot run html tool: $error"
        } else {
            dbgputs "Html tool runs successfully"
        }
    }

    endWaitCursor

    meterUpdate 100 ""

    meterDestroy $ctrlVals(meterWindow)

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "System configuration page"
        nextCallback
    }

    nextCallback
}

#############################################################################
#
# pageProcess(systemConfig) - process inputs from system configuration 
#                             page if any
#
# This procedure will process inputs from system configuration page if any
#
# SYNOPSIS
# .tS
# pageProcess(systemConfig)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(systemConfig) {} {
    return 1
}

##############################################################################
#
# torVarsCreate - creates a Tornado environment variables startup file.
#
# SYNOPSIS
# torVarsCreate
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc torVarsCreate {} {
    global setupVals

    set binDir [destDirGet]/host/[windHostTypeGet]/bin

    if {"[windHostTypeGet]" == "x86-win32" && [file isdirectory $binDir]} {

        if {![file exists $binDir/torVars.bat]} {
            uninstLog file "wind_base\thost/[windHostTypeGet]/bin/torVars.bat"
        }

        if {![catch {open $binDir/torVars.bat "w"} f]} {
            puts $f "rem Command line build environments"
            puts $f "set WIND_HOST_TYPE=[windHostTypeGet]"
            puts $f "set WIND_BASE=[destDirGet]"

            if [info exists setupVals(regHost)] {
                puts $f "set WIND_REGISTRY=$setupVals(regHost)"
            }
            puts $f "set PATH=%WIND_BASE%\\host\\%WIND_HOST_TYPE%\\bin;%PATH%"

            close $f
        }

    } elseif {[file isdirectory $binDir]} {

        if {![file exists $binDir/torVars.csh]} {
            uninstLog file "wind_base\thost/[windHostTypeGet]/bin/torVars.csh"
        }

        if {![catch {open $binDir/torVars.csh "w"} f]} {

            puts $f "# Command line build environments"
            puts $f "setenv WIND_HOST_TYPE [windHostTypeGet]"
            puts $f "setenv WIND_BASE [destDirGet]"

            if {[info exists setupVals(registry)]} {
                puts $f "setenv WIND_REGISTRY $setupVals(registry)"
            }

            puts $f {setenv PATH $WIND_BASE/host/$WIND_HOST_TYPE/bin:$PATH}
            puts $f "if \(! \$\?USER) then"
            puts $f "    setenv USER \$LOGNAME" 
            puts $f "endif"

	    if {[windHostTypeGet]=="sun4-solaris2"} {
                puts $f "if \(\$\?LD_LIBRARY_PATH) then"
		puts $f "    setenv LD_LIBRARY_PATH \${LD_LIBRARY_PATH}:\$WIND_BASE/host/\$WIND_HOST_TYPE/lib:/usr/dt/lib:/usr/openwin/lib"
		puts $f "else"
		puts $f "    setenv LD_LIBRARY_PATH \$WIND_BASE/host/\$WIND_HOST_TYPE/lib:/usr/dt/lib:/usr/openwin/lib"
		puts $f "endif"
	    } elseif {[windHostTypeGet]=="parisc-hpux10"} {
                puts $f "if \(\$\?SHLIB_PATH) then"
		puts $f "    setenv SHLIB_PATH \${SHLIB_PATH}:\$WIND_BASE/host/\$WIND_HOST_TYPE/lib"
		puts $f "else"
		puts $f "    setenv SHLIB_PATH \$WIND_BASE/host/\$WIND_HOST_TYPE/lib"
		puts $f "endif"

            }

            close $f
        }

        if {![file exists $binDir/torVars.sh]} {
            uninstLog file "wind_base\thost/[windHostTypeGet]/bin/torVars.sh"
        }

        if {![catch {open $binDir/torVars.sh "w"} f]} {

            puts $f "# Command line build environments"
            puts $f "WIND_HOST_TYPE=[windHostTypeGet]"
            puts $f "export WIND_HOST_TYPE"
            puts $f "WIND_BASE=[destDirGet]"
            puts $f "export WIND_BASE"

            if {[info exists setupVals(registry)]} {
                puts $f "WIND_REGISTRY=$setupVals(registry)"
                puts $f "export WIND_REGISTRY"
            }

            puts $f {PATH=$WIND_BASE/host/$WIND_HOST_TYPE/bin:$PATH}
            puts $f "export PATH"
            puts $f "if \[ \"\$USER\" = \"\" \] ; then"
            puts $f "    USER=\$LOGNAME" 
            puts $f "fi"
            puts $f "export USER"

	    if {[windHostTypeGet]=="sun4-solaris2"} {
                puts $f "if \[ \"\$LD_LIBRARY_PATH\" = \"\" \] ; then"
		puts $f "    LD_LIBRARY_PATH=\$WIND_BASE/host/\$WIND_HOST_TYPE/lib:/usr/dt/lib:/usr/openwin/lib"
		puts $f "else"
		puts $f "    LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:\$WIND_BASE/host/\$WIND_HOST_TYPE/lib:/usr/dt/lib:/usr/openwin/lib"
		puts $f "fi"
		puts $f "export LD_LIBRARY_PATH"
	    } elseif {[windHostTypeGet]=="parisc-hpux10"} {
                puts $f "if \[ \"\$SHLIB_PATH\" = \"\" \] ; then"
		puts $f "    SHLIB_PATH=\$WIND_BASE/host/\$WIND_HOST_TYPE/lib"
		puts $f "else"
		puts $f "    SHLIB_PATH=\$SHLIB_PATH:\$WIND_BASE/host/\$WIND_HOST_TYPE/lib"
		puts $f "fi"
		puts $f "export SHLIB_PATH"

            }

            close $f
        }
    }
}


