# REGISTER.TCL - Setup procedures for implementing user registration wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01h,15apr99,wmd  If ALT-F is used, remove the corresponding key if it exists
#                  in the registry.
# 01g,15apr99,wmd  Need to destroy the "nokey" control created when no
#                  installation key is required.
# 01f,12apr99,wmd  Need to add full simulator product to the tornadoIndex in 
#                  the setupVals array.
# 01e,31mar99,wmd  Fix spr# 26130, blank components page.
# 01d,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01c,19mar99,wmd  Output to a file any debug messages.
# 01b,01feb99,tcy  moved procs from INSTALL.TCL.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# onClickFaeBox - prompt FAEs to save the installation key
#
# This procedure will prompt FAEs to save the installation key
#
# SYNOPSIS
# .tS
# onClickFaeBox
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onClickFaeBox {} {
    global setupVals

    if {![dialog yes_no "Setup" [strTableGet 5020_DO_NOT_SAVE_KEY_FOR_FAE]]} {
         set setupVals(instKeyNotSaved) 1
    } elseif [info exists setupVals(instKeyNotSaved)] {
         unset setupVals(instKeyNotSaved)
    }
}

#############################################################################
#
# pageCreate(registration) - displays CD information and prompt users for
#                            registration information
#
# This procedure will display CD information and prompt users for
# registration information such as user name, company name and installation key
#
# SYNOPSIS
# .tS
# pageCreate(registration)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(registration) {} {
    global ctrlVals
    global setupVals

    # read user's information

    registrationValuesReadFromRegistry

    if { "$setupVals(keyList)" == "" } {
        set numKeys 0
    } else {
        set numKeys [llength $setupVals(keyList)]
    }

    set ctrlVals(volatileFrm) [list \
                [list label -name message1 \
                            -title [strTableGet 1060_REGISTRATION] \
                            -x 99 -y 10 -w 206 -h 27] \
                [list label -name message2 \
                            -title "Name" \
                            -x 99 -y 56 -w 32 -h 10] \
                [list label -name message3 \
                            -title "Company" \
                            -x 99 -y 80 -w 35 -h 10] \
                [list label -name message4 \
                            -title "Key" \
                            -x 99 -y 104 -w 29 -h 8] \
                [list text -name nameText -border -x 139 -y 56 -w 166 -h 13 \
                           -callback {onTextChange nameText name}] \
                [list text -name companyText -border -x 139 -y 79 -w 166 -h 13 \
                           -callback {onTextChange companyText company}] \
                [list combo -name keyText -x 139 -y 102 -w 166 \
                           -h [expr 13 * ($numKeys + 1)] \
                           -editable \
                           -callback {onTextChange keyText instKey}]\
                [list label -name Information \
                            -title "Information" \
                            -x 105 -y 125 -w 40 -h 8] \
                [list frame -name frm1 \
                           -xpos 100 -ypos 135 -width 207 -height 30] \
                [list label -name cdInfo \
                            -x 107 -y 140 -w 180 -h 20] \
                [list button  -name fae -title "&f" -x 280 -y 35 -w 1 -h 1 \
                            -callback {onClickFaeBox} ] \
    ]

    set w [dlgFrmCreate [strTableGet 1430_TITLE_REGISTRATION]]

    controlHide $w.fae 1
    controlValuesSet $w.companyText [companyNameGet]
    controlValuesSet $w.nameText [userNameGet]
    controlValuesSet $w.keyText [instKeyDataGet]

    if {[string length $setupVals(CDdescription)] > 45} {
        set cdDesc [cdromDescGet]
    } else {
        set cdDesc [strTableGet 1000_WELCOME_CD]
    }

    controlValuesSet $w.cdInfo "CD number:\t$setupVals(CDnumber)\
                                \nCD description:\t$cdDesc"


    # overwrite keyText
    # test automation

    if { $ctrlVals(useInputScript) } {
        controlValuesSet $w.keyText $setupVals(instKey2)
    }

    # use the user key as default; otherwise use the first key as default

    set index 0
    if { [instKeyGet] != "" } {
        set keyList [split [instKeyDataGet]]
        set index [lsearch -exact $keyList [instKeyGet]]
        if {$index == -1} {
            set index 0
        }
    }

    if {[string compare "none" [instKeyGet]] == 0} {

        # if the key "none" works, set the value and hide the key edit text box

        instKeySet "none"
        controlHide $w.keyText 1
        controlHide $w.message4 1

        # shows message informing user that no key is required for installation

        controlCreate $w [list label -name noKeyText \
                           -title [strTableGet 1085_WARN_4] \
                           -x 99 -y 102 -w 206 \
                           -h [expr 24 * ($numKeys + 1)]]

    } else {
        controlSelectionSet $w.keyText $index
    }

    if {"[userNameGet]" == ""} {
        controlFocusSet $w.nameText
    } elseif {"[companyNameGet]" == ""} {
        controlFocusSet $w.companyText
    } else {
        controlFocusSet $w.keyText
    }

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Registration page:"
        autoSetupLog "\tUser name:    [userNameGet]"
        autoSetupLog "\tCompany Name: [companyNameGet]"
        autoSetupLog "\tInstall Key:  $setupVals(instKey2)"
        if {[isUnix]} { pageRemove projectInfo }
        nextCallback
    }
}

#############################################################################
#
# onFindZipFileDlgCancel - close the findZipFileDlg dialog box
#
# This procedure will close the findZipFileDlg dialog box when the cancel
# button is pushed
#
# SYNOPSIS
# .tS
# onFindZipFileDlgCancel
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFindZipFileDlgCancel {} {

     if [catch {windowClose findZipFileDlgHnd} error] {
         puts "Error: $error"
     }
}

#############################################################################
#
# onFindZipFileDlgOK - close the findZipFileDlg dialog box
#
# This procedure will save the zip directory and close the findZipFileDlg
# dialog box when the cancel button is pushed
#
# SYNOPSIS
# .tS
# onFindZipFileDlgOK
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFindZipFileDlgOK {} {

    cdromZipDirSet \
        [string trim [controlValuesGet findZipFileDlgHnd.zipDirText] " "]
    windowClose findZipFileDlgHnd
}

#############################################################################
#
# findZipFileDlgInit - place default zip directory in zipDirText edit box
#
# This procedure will place default zip directory in zipDirText edit box
#
# SYNOPSIS
# .tS
# findZipFileDlgInit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc findZipFileDlgInit {} {

    controlValuesSet findZipFileDlgHnd.zipDirText [cdromZipDirGet]
    controlFocusSet findZipFileDlgHnd.zipDirText
}

#############################################################################
#
# findZipFileDlg - create dialog box for findind WIND zip files
#
# This procedure will create dialog box for findind WIND zip files
#
# SYNOPSIS
# .tS
# findZipFileDlg
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc findZipFileDlg {} {
    global ctrlVals
    global setupVals

    set controls [list \
                 [list label -title [strTableGet 4030_NO_ZIP_FILE] \
                             -name zipDirLabel \
                             -xpos 7 -ypos 10 -width 186 -height 80] \
                 [list label -name windLabel \
                             -title "archive directory" \
                             -xpos 12 -ypos 134 -w 100 -h 8] \
                 [list frame -name zipDirFrame \
                             -xpos 7 -ypos 144 -width 198 -height 24] \
                 [list text -name zipDirText -border \
                            -xpos 11 -ypos 149 -width 133 -height 14 ] \
                 [list button -title "&Browse" -name browse \
                              -xpos 150 -ypos 149 -width 50 -height 14 \
                              -callback {onFindZipFileBrowse zipDirText} ] \
                 [list button -title "&Cancel" -name cancelButt \
                              -xpos 150 -ypos 173 -width 50 -height 14  \
                              -callback onFindZipFileDlgCancel ] \
                 [list button -title "&OK" -name okButt -default \
                              -xpos 94 -ypos 173 -width 50 -height 14 \
                              -callback onFindZipFileDlgOK] \
    ]
    dialogCreate \
        -name findZipFileDlgHnd \
        -title "Locating archive files" \
        -width 212 -height 195 \
        -parent $ctrlVals(mainWindow) \
        -init findZipFileDlgInit \
        -controls $controls \
        -helpfile $setupVals(setupHelp)
}

#############################################################################
#
# pageProcess(registration) - process inputs from registration page
#
# This procedure will process inputs from registration page
#
# SYNOPSIS
# .tS
# pageProcess(registration)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageProcess(registration) {} {
    global setupVals
    global ctrlVals
    global infVals

    beginWaitCursor

    if {[string compare "none" [instKeyGet]] != 0} {
        instKeySet [controlValuesGet $ctrlVals(mainWindow).keyText -edit]
    }
    set retVal 0

    if {![catch {setupKeyValidate [instKeyGet]} error]} {

        companyNameSet [controlValuesGet $ctrlVals(mainWindow).companyText]
        userNameSet [controlValuesGet $ctrlVals(mainWindow).nameText]

        if {![regexp {^[ ]*$} [companyNameGet] junk] && \
            ![regexp {^[ ]*$} [userNameGet] junk]} {

            # change dir to avoid pwd being a UNC directory which
            # fails under Win95

            catch {cd c:/}

            if ![catch {setupInit [cdromZipDirGet]} error] {

                # user has a new location for ZIP files, and
                # installation key may not match the CD id in DISK_ID
                # so we don't write the key to registry

                if ![info exists setupVals(noZipDir)] {
                    # do not write to the registry if hidden box is checked

                    if ![info exists setupVals(instKeyNotSaved)] {
                        # Set keyData to be written to the registry.
                        setKeyDataRegistryValue
                    } else {
                        # remove the key if found in registry
                        modKeyDataRegistryValue
                    }
                }
                set retVal 1
            } else {

                # test automation

                if { $ctrlVals(useInputScript) } {
                    autoSetupLog "\tError in CD: $error\n"
                    autoSetupLog "Application Exit\n"
                    set setupVals(cancel) 1
                    applicationExit
                    set retVal 0
                    return $retVal
                }

                switch -exact -- $error {
                    BAD_CD_KEY {
                        messageBox [strTableGet 1080_WARN_2]
                        set retVal 0
                    }
                    BAD_CD_REVISION {
                        messageBox [strTableGet 1080_WARN_4]

                        # do not write to the registry if hidden box is checked

                        if ![info exists setupVals(instKeyNotSaved)] {
                            setKeyDataRegistryValue
                        } else {
                            # remove the key if found in registry
                            modKeyDataRegistryValue
                        }
                        set retVal 1
                    }
                    BAD_CD_VENDOR_ID {
                        messageBox [strTableGet 1080_WARN_3]
                        set retVal 0
                    }
                    NO_ZIP_FILE {
                        set setupVals(noZipDir) 1
                        findZipFileDlg

                        # avoid calling objectConstruct by returning 0 here
                        # user will return to the registration page

                        return 0
                    }
                    default {
                        exitWithMessage [strTableGet 1090_WARN_3 $error]
                    }
                }
            }
        } else {
            messageBox [strTableGet 1071_WARN_1]
            return $retVal
        }
    } else {
        # test automation

        if { $ctrlVals(useInputScript) } {
            autoSetupLog "[strTableGet 1070_WARN_1]"
            autoSetupLog "Application Exit\n"
            set setupVals(cancel) 1
            applicationExit
            set retVal 0
            return $retVal
        } else {
            messageBox [strTableGet 1070_WARN_1]
            return $retVal
        }
    }

    objectConstruct
    set infVals(addRegistration) 1
    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    queueExecute
    set infVals(addRegistration) 0
    endWaitCursor

    # if nokey is required, destroy the control that was created earlier

    if {[string compare "none" [instKeyGet]] == 0} {
        controlDestroy $ctrlVals(mainWindow).noKeyText
    }
    return $retVal
}

#############################################################################
#
# modKeyDataRegistryValue - modifies installation key information in the 
#                           Windows registry
#
# This procedure will set installation key information in the Windows
# registry
#
#
# SYNOPSIS
# .tS
# modKeyDataRegistryValue
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc modKeyDataRegistryValue {} {
    global setupVals
    global infVals

    if {[instKeyGet] != "none"} {
        set HKCU HKEY_CURRENT_USER
        set infVals(addRegKeyData) 1
        set key [instKeyGet]

        if {![catch {sysRegistryValueRead $HKCU \
            "Software\\Wind River Systems" "keyData"} setupVals(keyString)]} {

            set foundCD 0
            for {set idx 0} \
                {$idx < [llength $setupVals(keyString)]} \
                {incr idx} {
                set combo [lindex $setupVals(keyString) $idx]

                if {[lsearch $combo $setupVals(CDnumber)] != -1} {
                    set foundCD 1
		    set tgtKeyIdx [lsearch $combo $key]
                    if {$tgtKeyIdx != -1} {
                        # installation key has been found

                        set setupVals(keyString) \
                        [lreplace $setupVals(keyString) $idx $idx \
                                  [lreplace $combo $tgtKeyIdx $tgtKeyIdx]]
                        dbgputs "CD found, new key: \
                            setupVals(keyString) = $setupVals(keyString)"
                    }
                }
            }
        }
    }
}



#############################################################################
#
# setKeyDataRegistryValue - set installation key information in the Windows
#                           registry
#
# This procedure will set installation key information in the Windows
# registry
#
#
# SYNOPSIS
# .tS
# setKeyDataRegistryValue
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc setKeyDataRegistryValue {} {
    global ctrlVals
    global setupVals
    global infVals

    if {[instKeyGet] != "none"} {
        set infVals(addRegKeyData) 1
        set key [instKeyGet]

        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
            "Software\\$setupVals(WRS)" "keyData"} setupVals(keyString)]} {

            set foundCD 0
            for {set idx 0} \
                {$idx < [llength $setupVals(keyString)]} \
                {incr idx} {
                set combo [lindex $setupVals(keyString) $idx]

                if {[lsearch $combo $setupVals(CDnumber)] != -1} {
                    set foundCD 1
                    if {[lsearch $combo $key] == -1} {
                        # installation key is not found
                        set setupVals(keyString) \
                        [lreplace $setupVals(keyString) $idx $idx \
                                  [linsert $combo 1 $key]]

                        dbgputs "CD found, new key: \
                            setupVals(keyString) = $setupVals(keyString)"
                    }
                }
            }

            if !{$foundCD} {
                set setupVals(keyString) \
                    "\{$setupVals(CDnumber) $key\} $setupVals(keyString)"

                dbgputs "new CD, new key: \
                        setupVals(keyString) = $setupVals(keyString)"
            }

        } else {
            set setupVals(keyString) "\{$setupVals(CDnumber) $key\}"

            dbgputs "new keyData registry: \
                    setupVals(keyString) = $setupVals(keyString)"
        }
    }
}

#############################################################################
#
# onFindZipFileBrowse - set the value in edit box when a directory is selected
#                       from the browse window
#
# This procedure will set the value in edit box when a directory is selected
# from the browse window
#
# This procedure
#
# SYNOPSIS
# .tS
# onFindZipFileBrowse <ctrlName>
# .tE
#
# PARAMETERS:
# .IP ctrlName
# control name which will have the new value
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFindZipFileBrowse {ctrlName} {
    global ctrlVals

    set retDir [dirBrowseDialogCreate \
                    -title "WIND Directory" \
                    -initialDir [cdromZipDirGet] ]

    if {"$retDir" != ""} {
        controlValuesSet findZipFileDlgHnd.$ctrlName $retDir
    }
}

#############################################################################
#
# registrationValuesReadFromRegistry - fetch user registration values from
#                                      the Windows registry
#
# This procedure will fetch user registration values from the Windows
# registry
#
# SYNOPSIS
# .tS
# registrationValuesReadFromRegistry
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc registrationValuesReadFromRegistry {} {
    global setupVals

    # Load user name from the previous installation if any

    if {"[userNameGet]" == ""} {
        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                 "Software\\$setupVals(WRS)" "name"} name]} {

            userNameSet $name

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                 "SOFTWARE\\$setupVals(WRS)" "name"} name]} {

            userNameSet $name
        } else {
            userNameSet ""
        }
    }

    # Load company name from the previous installation if any

    if {"[companyNameGet]" == ""} {
        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                 "Software\\$setupVals(WRS)" "company"} company]} {

            companyNameSet $company

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                 "SOFTWARE\\$setupVals(WRS)" "company"} company]} {

            companyNameSet $company
        } else {
            companyNameSet ""
        }
    }

    # Load installation key from the previous installation if any

        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                 "Software\\$setupVals(WRS)" "keyData"} keyString]} {
            instKeyDataSet [getKeyData $keyString $setupVals(CDnumber) list]

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                 "SOFTWARE\\$setupVals(WRS)" "keyData"} keyString]} {
            instKeyDataSet [getKeyData $keyString $setupVals(CDnumber) list]

        } else {
            instKeyDataSet ""
        }
}

#############################################################################
#
# getKeyData - search for the requested CD number in string of keys and
#              CD numbers and return either the installation key or the
#              combination of key and the CD number
#
# This procedure will search for the requested CD number in string of keys and
# CD numbers and return either the installation key or the combination of
# key and the CD number
#
# SYNOPSIS
# .tS
# getKeyData <keyString> <CDnumber> <data>
# .tE
#
# PARAMETERS:
# .IP keyString
# the entire list of keys and CD number read from the registry
# .IP CDnumber
# the CD number (TDK-XXXXX-XX-XX) to look for in keyString
# .IP data
# data to be fetched - key  -- installation key
#                    - list -- combination of key and CD number
#
# RETURNS: either the installation key or the combination of
#          key and the CD number
#
# ERRORS: N/A
#

proc getKeyData {keyString CDnumber {data {key list}}} {

    for {set idx 0} {$idx < [llength $keyString]} {incr idx} {
        set combo [lindex $keyString $idx]
        set found [lsearch $combo $CDnumber]
        if {$found != -1} {
            switch -exact $data {
                key     { return [lindex $combo 1]}
                list    { return [lrange $combo 1 end]}
                default { dbgputs "getKeyData: bad argument: $data"
                          return ""
                }
            }
        }
    }

    return ""
}

##############################################################################
#
# objectConstruct - creates objects to store all information about the unlocked
#                   products.
#
# This function must be called prior to the following functions: cdInfoGet/Set
# SYNOPSIS
# objectConstruct
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc objectConstruct {} {
    global productObj partObj featureObj cdObj
    global constructed
    global setupVals

    if {![info exists constructed([instKeyGet])]} {

        catch {
            unset constructed
            unset productObj
            unset partObj
            unset featureObj
            unset setupVals(tornadoIndex)
            unset setupVals(drvIndex)
        }

        set constructed([instKeyGet]) 1
        set productDescList {}
        set setupVals(drvIndex) -1

        foreach prodIndex [setupProductIndexListGet] {

            set productObj($prodIndex,instFlag) 0
            set productObj($prodIndex,prevInstFlag) 0
            set productObj($prodIndex,partIndexList) {}

            set partIndexList [setupPartIndexListGet $prodIndex]

            foreach partIndex $partIndexList {

                set infoList [setupPartInfoGet $partIndex]

                set productNum    [lindex $infoList 0]
                set productName   [lindex $infoList 1]
                set productDesc   [lindex $infoList 2]
                set partName      [lindex $infoList 3]
                set partDesc      [lindex $infoList 4]
                set productIndex  [lindex $infoList 5]
                set defInstFlag   [lindex $infoList 6]
                set totalFile     [lindex $infoList 7]
                set featureDesc   [lindex $infoList 8]
                set featureId     [lindex $infoList 9]
                set size          [lindex $infoList 10]
                set coreProd      [lindex $infoList 12]

                # record the prodIndex of the drivers product

                if {[string compare $productName "tornado-comp-drv"] == 0} {
                    if {[lindex $setupVals(drvIndex) 0] == -1} {
                        set setupVals(drvIndex) \
                            [lreplace $setupVals(drvIndex) 0 0]
                    }
                    set lineIx [string last ":" $productDesc]
                    set lineLen [string length $productDesc]
                    set arch [string range $productDesc \
                             [expr $lineIx+2] $lineLen]
                    lappend setupVals(drvIndex) [list $prodIndex $arch]
                }

                if {[string compare $productName "tornado"] == 0} {
                    set lineIx [string last "x" $productDesc]
                    set lineLen [string length $productDesc]
                    set arch [string range $productDesc \
                             [expr $lineIx+2] $lineLen]
                    lappend setupVals(tornadoIndex) [list $prodIndex $arch]
                }


                if {[string compare $productName "tornado-vxsim"] == 0 } {
                    set lineIx [string last ":" $productDesc]
                    set lineLen [string length $productDesc]
                    set arch [string range $productDesc \
                             [expr $lineIx+2] $lineLen]
                    switch -exact -- $arch {
                        hp9700          { set arch simhppa }
                        x86-winNT       { set arch simnt }
                        solaris         { set arch simsolaris }
                    }
                    lappend setupVals(tornadoIndex) [list $prodIndex $arch]
                }

                # construct CD object

                if {![info exists cdObj(number)]} {
                    set cdObj(number) [lindex $infoList 11]
                }

                # construct product objects

                set productObj($prodIndex,number) $productNum
                set productObj($prodIndex,name) $productName
                set productObj($prodIndex,desc) $productDesc
                set productObj($prodIndex,featureId) $featureId
                set productObj($prodIndex,coreProd) $coreProd
                lappend productObj($prodIndex,partIndexList) $partIndex
 
                # construct part objects

                set partObj($partIndex,instFlag) $defInstFlag
                set partObj($partIndex,prevInstFlag) $defInstFlag
                set partObj($partIndex,desc) $partDesc
                set partObj($partIndex,size) $size
                set partObj($partIndex,totalFile) $totalFile
                set partObj($partIndex,parent) $prodIndex
                set partObj($partIndex,coreProd) $coreProd

                set featureObj($featureId) $featureDesc

                if {"$defInstFlag" == "1"} {
                    set productObj($prodIndex,instFlag) 1
                    set productObj($prodIndex,prevInstFlag) 1
                }
            }

            if {[llength $partIndexList] == 1} {
                set partObj([lindex $partIndexList 0],instFlag) 1
                set partObj([lindex $partIndexList 0],prevInstFlag) 1
            }

            lappend productDescList \
                    [list $productObj($prodIndex,desc) $prodIndex]
        }

        set cdObj(productIndexList) {}
        foreach pair [lsort $productDescList] {
            lappend cdObj(productIndexList) [lindex $pair 1]
        }
    }

    # make the list of tornado indices unique

    if {[info exists setupVals(tornadoIndex)]} {
        set setupVals(tornadoIndex) [lunique $setupVals(tornadoIndex)]
    }

    dbgputs "finish constructing the products array"
}
