# REGHOST.TCL - Setup procedures for implementing remote-registry host 
#               wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01c,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01b,22mar99,bjl  set setupVals(torRegOption) for Unix for compatibility 
#                  page. 
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(remoteRegistryHost) - prompt for host name to install tornado
#                                  registry
#
# This procedure will prompt for host name to install tornado registry
#
# SYNOPSIS
# .tS
# pageCreate(remoteRegistryHost)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(remoteRegistryHost) {} {
    global ctrlVals
    global setupVals

    if {[isUnix]} {
        set regmsg [strTableGet 1190_REGISTRY_HOST]
    } else {
        set regmsg [strTableGet 1192_REGISTRY_NAME]
    }

    set ctrlVals(volatileFrm) [list \
             [list label -name msg0 \
                         -title $regmsg \
                         -x 100 -y 10 -w 205 -h 64] \
             [list label -name msg1 -title "Host Name:" \
                         -x 100 -y 94 -w 40 -h 10] \
             [list text -name remoteReg -border \
                        -x 150 -y 92 -w 148 -h 13] \
    ]

    set w [dlgFrmCreate [strTableGet 1490_TITLE_REGISTRY_HOST]]

    controlValuesSet $w.remoteReg [windRegValueRead]
    controlFocusSet $w.remoteReg
    controlEnable $w.backButt 1

    # test automation

    if { $ctrlVals(useInputScript) } {
        controlValuesSet $w.remoteReg $setupVals(registry)
        autoSetupLog "Tornado Registry page:"
        autoSetupLog "\tRegistry Host: $setupVals(registry)"
        nextCallback
    }
}

#############################################################################
#
# pageProcess(remoteRegistryHost) - process inputs from remoteRegistryHost page
#
# This procedure will process inputs from remoteRegistryHost page
#
# SYNOPSIS
# .tS
# pageProcess(remoteRegistryHost)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageProcess(remoteRegistryHost) {} {
    global ctrlVals
    global setupVals
    global infVals

    set setupVals(registry) [controlValuesGet $ctrlVals(mainWindow).remoteReg]
    if {[isUnix]} {

        # need to set this here since torRegistry page is removed for Unix

        set setupVals(torRegOption) torRegRemote
        set infVals(torRegRemote) 1
    }

    if {![regexp {^[ ]*$} "$setupVals(registry)" junk]} {
        searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                             INF TORNADO.INF]]
        queueExecute
        set infVals(torRegRemote) 0
        return 1
    } else {
        messageBox "Please enter a valid registry name"
        return 0
    }
}
