# README.TCL - Setup procedures for implementing readme wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01b,26apr99,bjl  removed icon for Unix to aid refresh problem.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(readme) - display the readme.txt file
#
# This procedure will display the readme.txt file
#
# SYNOPSIS
# .tS
# pageCreate(readme)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(readme) {} {
    global ctrlVals
    global setupVals

    if {[isUnix]} {
        set labelx 10
        set labelw 286
    } else {
        set labelx 90
        set labelw 206
    }

    controlHide $ctrlVals(mainWindow).bitmap 1
    set ctrlVals(volatileFrm) [list \
                [list bitmap -name bmp -stretch -title \
                                "[cdFileNameGet \
                                [file join RESOURCE BITMAPS SETUPICO.BMP]]"\
                                -x 20 -y 9 -w 36 -h 36] \
                [list label -name readmeLabel \
                            -title [strTableGet 4090_README_TEXT] \
                            -x $labelx -y 10 -w $labelw -h 40] \
                [list text -name readmeFile -border -vscroll \
                            -multiline -readonly \
                            -x 10 -y 52 -width 295 -height 119] \
     ]

    if {[isUnix]} {
        # remove the setup icon, it has a different color palette and may
        # appear incorrectly
        set ctrlVals(volatileFrm) [lrange $ctrlVals(volatileFrm) 1 \
                                    [expr [llength $$ctrlVals(volatileFrm)] - 1]
]
    }

    set w [dlgFrmCreate "README.TXT"]

    # initialize the text box

    controlTextSet $w.readmeFile [fileContentGet [cdFileNameGet README.TXT]]

    controlEnable $ctrlVals(mainWindow).nextButt 1
    controlFocusSet $ctrlVals(mainWindow).nextButt
}

#############################################################################
#
# pageProcess(readme) - process inputs from the readme page
#
# This procedure will process inputs from the readme page
#
# SYNOPSIS
# .tS
# pageProcess(readme)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS:  1 if successful
#
# ERRORS: N/A
#

proc pageProcess(readme) {} {
    global ctrlVals

    controlHide $ctrlVals(mainWindow).bitmap 0
    return 1
}
