# PRVLEGE.TCL - Setup procedures for implementing privilege wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(privilege) - warn users of non-administrator privileges
#
# This procedure will warn users of non-administrator privileges
#
# SYNOPSIS
# .tS
# pageCreate(privilege)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(privilege) {} {
    global ctrlVals

    set ctrlVals(volatileFrm) [list \
            [list label -name message \
                        -title [strTableGet 1051_ROOT_WARN]\
                        -x 100 -y 10 -w 193 -h 100] \
    ]

    set w [dlgFrmCreate [strTableGet 1420_TITLE_WARNING]]

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Privilege page:"
        autoSetupLog "\tWarning: Installation continues\
        without System Administrator privileges."
        nextCallback
    }

}

#############################################################################
#
# pageProcess(privilege) - process inputs from privilege page if any
#
# This procedure will process inputs from privilege page if any
#
# SYNOPSIS
# .tS
# pageProcess(privilege)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(privilege) {} {
    return 1
}


