# PROJINFO.TCL - Setup procedures for implementing project-information 
#                wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01c,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01b,08feb99,wmd  Need to validate that the number of licenses field is
#                  numeric.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(projectInfo) - prompts users for project information
#
# This procedure will prompt user for project information such as project name
# and number of Tornado seats
#
# SYNOPSIS
# .tS
# pageCreate(projectInfo)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(projectInfo) {} {
    global ctrlVals
    global setupVals
    global projLic
    global projName
    global projLicUsers

    set ctrlVals(volatileFrm) [list \
                [list label -name message1 \
                            -title [strTableGet 4050_PROJECT_TEXT] \
                            -x 99 -y 10 -w 206 -h 35] \
                [list label -name message2 \
                            -title "WRS License Number" \
                            -x 99 -y 56 -w 75 -h 10] \
                [list label -name message3 \
                            -title "Project Name" \
                            -x 99 -y 80 -w 75 -h 10] \
                [list label -name message4 \
                            -title "Number of Tornado Seats" \
                            -x 99 -y 104 -w 99 -h 8] \
                [list text -name WRSLicText -border -x 187 -y 56 -w 120 -h 13 \
                           -readonly ] \
                [list text -name projNameText -border -x 187 -y 79 -w 120 \
                           -h 13 -callback \
                           {onTextChange projNameText projName}] \
                [list text -name numUsersText -border -x 187 -y 102 -w 120 \
                           -h 13 -callback \
                           {onTextChange numUsersText numUsers}] \
    ]

    set w [dlgFrmCreate "Project Information"]

    # initialize values in controls if they exist in the registry

    controlValuesSet $w.WRSLicText [projInfoGet WRSLic]
    controlValuesSet $w.projNameText [projInfoGet projName]
    controlValuesSet $w.numUsersText [projInfoGet numUsers]
    controlFocusSet $w.nextButt

    if {$projLic != "" && $projName != "" && $projLicUsers != "" } {
        controlValuesSet $w.WRSLicText $projLic
        controlValuesSet $w.projNameText $projName
        controlValuesSet $w.numUsersText $projLicUsers
    }
}

#############################################################################
#
# pageProcess(projectInfo) - process inputs from projectInfo page
#
# This procedure will process inputs from projectInfo page
#
# SYNOPSIS
# .tS
# pageProcess(projectInfo)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if procedure onProjLicRecordOK returns 0
#          1 if procedure onProjLicRecordOK returns 1
#
# ERRORS: N/A
#

proc pageProcess(projectInfo) {} {
    global infVals

    set infVals(addProjectInfo) 1
    set retVal [onProjLicRecordOK]
    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    queueExecute
    set infVals(addProjectInfo) 0
    return $retVal
}

#############################################################################
#
# projInfoGet - initialize licenseAgreement page
#
# This procedure will initialize licenseAgreement page
#
# SYNOPSIS
# .tS
# projInfoGet <info>
# .tE
#
# PARAMETERS:
# .IP <info> information needed for project. It can be one of the following:
#  WRSLic   - WRS license number assigned to vendor
#  projName - project name
#  numUsers - numbers of registered users
#
# RETURNS: registry value of requested info
#
# ERRORS: N/A
#

proc projInfoGet {info} {

    set usrRoot HKEY_CURRENT_USER
    set root HKEY_LOCAL_MACHINE
    set sp "SOFTWARE\\Wind River Systems"


    if {$info == "WRSLic"} {
        if {![catch {setupLicenseNumGet} lic]} {
            return $lic
        }
    }

    if {![catch {sysRegistryValueRead $usrRoot $sp WRSLicense} value]} {
        set vals $value
    } else {
        set vals ""
    }

    if {![catch {sysRegistryValueRead $root $sp WRSLicense} value]} {
        set vals2 $value
    } else {
        set vals2 ""
    }

    if {$vals != ""} {
        switch -exact -- $info {
            WRSLic {
                if {![catch {sysRegistryValueRead \
                             $usrRoot $sp WRSLicense} value]} {
                    return $value
                } else { return ""}
            }
            projName {
                if {![catch {sysRegistryValueRead \
                             $usrRoot $sp projectName} value]} {
                    return $value
                } else { return ""}
            }
            numUsers {
                if {![catch {sysRegistryValueRead \
                           $usrRoot $sp nLicensedUsers} value]} {
                    return $value
                } else { return ""}
            }
        }

    } elseif {$vals2 != ""} {
        switch -exact -- $info {
            WRSLic {
                if {![catch {sysRegistryValueRead \
                           $root $sp WRSLicense} value]} {
                    return $value
                } else { return ""}
            }
            projName {
                if {![catch {sysRegistryValueRead \
                           $root $sp projectName} value]} {
                    return $value
                } else { return ""}
            }
            numUsers {
                if {![catch {sysRegistryValueRead \
                           $root $sp nLicensedUsers} value]} {
                    return $value
                } else { return ""}
            }
        }
    }
}

#############################################################################
#
# onProjLicRecordOK - process inputs from projectInfo page
#
# This procedure is a helper which processes inputs ffrom projectInfo page
#
# SYNOPSIS
# .tS
# onProjLicRecordOK
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if project information is not completely filled
#          1 if project information is completely filled
#
# ERRORS: N/A
#

proc onProjLicRecordOK {} {
    global setupVals
    global projLic
    global projName
    global projLicUsers

    # query the user with the info he has entered

    if [catch {setupLicenseNumGet} error] {
        puts "Error: $error"
    } else {
        set projLic $error
    }

    set projName $setupVals(projName)
    set projLicUsers [string trim $setupVals(numUsers)]

    if {$projLic == "" || $projName == "" || $projLicUsers == "" } {
        messageBox -ok -exclamationicon \
            "You have not completely entered your\
            project information."
        return 0
    }

    if {[regexp {[^0-9]+} $projLicUsers var]} {
	messageBox -ok -exclamationicon \
	    "The value you entered for the \"Number of Tornado Seats\"\
             field in non-numeric, please re-enter it."
	return 0
    }

    # record the license record in the registry under "WIND RIVER SYSTEMS",
    # done in TORNADO.INF

    return 1
}
