# INSTW32.TCL - UITcl script for Windows/UNIX Installation schemes
#
# Copyright 1996-1999 Wind River Systems, Inc.
#
# modification history
# --------------------
# 11b,26apr99,bjl  Check for KDE in dlgFrmCreate, restoreOriginalDialog,
#                  and meterCreate.
# 11a,21apr99,wmd  Fix spr #25970 - by utilizing controlHide first, then 
#                  destroying the control, we avoid the refresh problem.
# 10z,08apr99,wmd  Move the unused background window to 10000 10000.
# 10y,08apr99,wmd  Do not use windowSetSize 0 0, use windowShow xxx 0 instead.
# 10x,02apr99,wmd  More fixes for resize problem.
# 10w,31mar99,wmd  Fix resizing problem.
# 10v,31mar99,wmd  Fix spr #226197 by introducing a pause between updates of
#                  ole and com.
# 10u,24mar99,bjl  workaround UITclSh problem with resizing Unix window.
# 10t,22mar99,bjl  move back button to the left on Unix to prevent overlap.
# 10s,19mar99,wmd  Output to a file any debug messages.
# 10r,16mar99,tcy  Added compatiblity and howto pages to UNIX Setup
# 10q,16mar99,tcy  Added safeguard to prevent setup from wiping out 
#                  program folders
# 10p,15mar99,tcy  minor fix: need to escape quote in message
# 10o,12mar99,bjl  restored gradient background and banner for windows.  
# 10n,01mar99,wmd  Fix progStart to work for all window managers.
# 10m,23feb99,tcy  minimize system rebooting to only once (fix for SPR 22838)
# 10l,18feb99,tcy  placed remoteRegistryHost page after registry page
# 10k,17feb99,tcy  added REGDLL page to program group installation 
#                  (partial fix for SPR 24897)
# 10j,11feb99,tcy  added COMPTBLE and HOWTO pages for backward compatibility
# 10i,09feb99,bjl  do not resize next button in restoreOriginalDialog to
#                  fix final oversized OK button on some Unix hosts.
# 10h,03feb99,tcy  hardcode file versions for OLE32.DLL and COMCTL32.DLL 
#                  (fix for SPR 24191)
# 10g,03feb99,tcy  fixed "Overwrite one file" bug (SPR 24715, 24135)
# 10f,28jan99,tcy  create new page configSys for configuration user system
# 10e,27jan99,tcy  moved some procedures to INCLUDE.TCL
# 10d,26jan99,tcy  moved regOptionRegValueRead() to REGISTRY.TCL
# 10c,26jan99,tcy  use for loop to source wizard pages
# 10b,26jan99,tcy  added sourcing of permission page
# 10a,25jan99,tcy  reorganize INSTW32.TCL -- move procs to wizard page files
# 09f,25jan99,tcy  added fileContentGet();
#                  convert calls from cdRomRootDirGet() to cdFileNameGet();
#                  move some messages to MESSAGES.TCL
# 09e,25jan99,wmd  Fixed spr 24181, allow partial selection of Tornado product
#                  to be installed without dragging in the driver object.
# 09d,22jan99,wmd  Fix bug in proc onProjLicRecordOK, $error should be error.
# 09c,20jan99,tcy  added more comment headers
# 09b,19jan99,tcy  added comment headers to all procedures;
#                  updated file according to WRS coding convention; 
#                  removed license management
# 09a,18jan99,wmd  Fix test automation stuff.
# 08z,14jan99,wmd  Need to eliminate use of FSPACE.TCL, its functions are now
#                  in GLOBAL.TCL.
# 08y,14jan99,wmd  Changename of proc fileAppreviate to fileAbbreviate.
# 08x,10dec98,tcy  corrected logic to show program group for non-administrators
# 08w,09dec98,bjl  added superceding patch messages to patchinfo.  
# 08v,04dev98,bjl  allow choice to continue Setup for required patches.
# 08u,04dec98,tcy  remove extra space in first user folder (fixes SPR 23700)
# 08t,03dec98,tcy  reset uninstall link location to SETUP directory
# 08s,02dec98,bjl  convert Unix style slashes to backslashes for Windows
#                  in pageProcess(destDir).
# 08r,25nov98,tcy  use kbyteToMbyte to get available disk space for Windows
# 08q,24nov98,bjl  do not allow any directory starting with a number
#                  for destDir.
# 08p,24nov98,tcy  run htmlBook utility at end of SETUP for UNIX
# 08o,23nov98,tcy  adjusted welcome screen to incoporate new warning message
# 08n,20nov98,bjl  skip filesCopy if user chooses to exit during setupCopy.   
# 08m,20nov98,tcy  made last mod applicable for Windows only
# 08l,19nov98,tcy  prevent user from choosing directory with leading numbers
#                  or directory without absolute paths
# 08n,19nov98,bjl  append web site location to patchinfo.  
# 08m,18nov98,bjl  create patchinfo file during Unix patch checking to be 
#                  displayed at the shell when setup exits.  
# 08l,17nov98,bjl  lowered space required/available labels for Unix (fixes
#                  spr 23328).  
# 08k,13nov98,wmd  fix spacing for choice button text.
# 08j,13nov98,wmd  create page for installation or program group icon 
#                  installation choices for the user.
# 08i,13nov98,bjl  move torRegistry radio buttons up for Win95, changed
#                  order of radio button creation.  
# 08h,12nov98,tcy  provide option for FAE to not save installation key 
# 08g,12nov98,wmd  change order of choice boxes in Tornado Registry page,
#                  change shortcut key for browse to be 'r' in destDir page.
# 08f,11nov98,bjl  replaced all group boxes with labels and frames (fixes
#                  spr 23061).
# 08e,11nov98,bjl  restore window in restoreOriginalDialog before resizing
#                  (fixes spr 22841).
# 08d,10nov98,tcy  removed batch file creation for regTornado.bat;
#                  added call to backupFileQueueFlush to command queue;
#                  disallow white space in destination directory (fix for SPR
#                  22793); run htmlbook tool
# 08c,09nov98,wmd  need to make setupVals(drvIndex) and array of indices.
# 08b,30oct98,bjl  added noColorMgr check, remove setup icon from welcome page 
#                  if color manager not running.     
# 08a,28oct98,wmd  if the installation key is "none" remove the projInfo page.
# 07z,28oct98,bjl  allow overwrite of existing products for test automation,
#                  fixed problem with Next button after minimize on Unix.
# 07y,27oct98,bjl  do not check for tornadoInstalled in folderSelect for icon 
#                  install, open explorer in iconFinish, reduce tor registry 
#                  label height for win95, do not display message about
#                  exiting all programs for Unix, fixed various labels for
#                  mw build 96.
# 07x,27oct98,bjl  added patchCheck procedure and recommended patch handling.  
# 07w,27oct98,tcy  added nextCallback for finish page in automated test
# 07v,26oct98,tcy  changed "Select Components" to "Select Products"
#                  added check for disk space on Windows
# 07u,25oct98,tcy  added backupFileQueueFlush call after filesCopy and
#                  fixed return values of tempDirectory
# 07t,22oct98,wmd  change title of "I accept" button, check key shortcuts.
# 07s,21oct98,tcy  set focus on OK button in finish page; create folder
#                  before creating icons if tornado is not installed
# 07r,21oct98,wmd  fix bug when compsel page is wrapped around using space key
#                  when selected/deselecting the drv/objects.
# 07q,20oct98,tcy  fixed typo in prgGrp variable ; removed newDestDir variable
# 07p,20oct98,tcy  added sourcing of REGSAVE.TCL for updating registry to T2;
#                  update comctl32.dll on Win95 if necessary
# 07o,20oct98,bjl  reduced height for tor reg description label for win95,
#                  do not display reg desc. on remote page for Windows,
#                  lower meter for billboard display.
# 07n,20oct98,wmd  fix some button coordinates.
# 07m,20oct98,wmd  same fix for tornadoSelected.
# 07l,20oct98,wmd  make sure setupVals(devIndex) is valid before using it.
# 07k,19oct98,bjl  lower license agreement button for Unix, added
#                  tornado registry description to torRegistry page, make
#                  torRegistry and remoteRegistryHost titles consistent.
# 07j,16oct98,wmd  if Tornado selected, don't allow de-selection of driver 
#                  product.
# 07i,16oct98,wmd  bold the message to exit all programs.
# 07h,19oct98,bjl  added code to place billboards in dialog window. Set   
#                  the env variable SETUP_REMOVEBACKGROUND=1 to activate. 
# 07g,16oct98,tcy  do not write installation key to registry if user is FAE
# 07f,15oct98,tcy  do not copy atl.dll to system directory
# 07e,15oct98,tcy  enable detail button for all product with subparts
# 07d,13oct98,wmd  Reverse the order for the Registry and Project Info pages,
#                  and automatically extract the WRS license field.
# 06c,09oct98,bjl  added code to remove background and limit colors. Set
#                  the env variable SETUP_LIMITCOLORS=1 to activate.  
# 06b,09oct98,wmd  fix for test automation.
# 06a,09oct98,bjl  use solid background and product label bitmap for Windows.
# 05z,09oct98,tcy  fixed patch scenario
# 05y,07oct98,bjl  do not call uninstStop unless uninstHomeDir is set.  
# 05x,06oct98,bjl  added permissions page for Unix.
# 05w,06oct98,tcy  save tornado registry option in registry
# 05v,06oct98,wmd  fixed bug in installedProdGet.
# 05u,06oct98,tcy  used defGroupGet instead of Tornado for 
#                  opening program folder; added CD description to 
#                  welcome and registry frames
# 05t,05oct98,bjl  removed unsupported -topmost flag from proc dlgFrmCreate.
# 05s,01oct98,wmd  open explorer on the Tornado group for windows hosts.
# 05r,29sep98,wmd  fix envPathSet to respect UNIX names.
# 05q,29sep98,wmd  move display of README.TXT to right after welcome screen
# 05p,30sep98,tcy  move setupCopy ahead of filesCopy
# 05o,29sep98,wmd  added readmeDlg to ask if user wishes to read README.TXT.
# 05n,29sep98,tcy  added "yes_exit" dialog box 
# 05m,29sep98,tcy  update Uninstall string from Tornado 1.0.1 to Tornado 2.0
# 05l,29sep98,wmd  fix hardcoding of SUN4/SOLARIS2 for CD_BIN
# 05k,29sep98,tcy  check for dcom95 installation at start and removed dcom page
# 05j,28sep98,bjl  display README.TXT and NEW.TXT at finish.
# 05i,26sep98,tcy  added progressmeter to DLL registration page
# 05h,25sep98,bjl  added required patch checking before setup starts, remove 
#                  setup.log.abort at finish.
# 05g,25sep98,tcy  make sure ATL.DLL is run first
# 05f,25sep98,wmd  display blank lines in license.txt for clarity.
# 05e,25sep98,wmd  left out some procs while merging, fixed it.
# 05d,25sep98,wmd  add warning if any installed product is about to be 
#                  overwritten, fix how to use choice buttons in proc dialog.
# 05c,24Sep98,vhe  Corrected boggus desc in partGuiChkLstUpdate
#                  Added automatic selection of WTX component for 
#                  automatic setup
# 05b,24sep98,tcy  For dll registration, call batch file if exec does not work
# 05a,23sep98,tcy  use batch file to workaround exec bug ;
#                  set overwritePolicy if user installs to new directory
# 04z,22sep98,bjl  added tornado-vxsim for tornadoInstalled setting, changed
#                  setupVals(prodRegEntry) to Tornado 2.0, do not write
#                  reg values immediately for remote registry, fixed remote
#                  registry writing for unix, close mainWindow in 
#                  applicationExit to fix exit problems.  
# 04y,22sep98,tcy  added regTornado page and rearranged dCom page and 
#                  regTornado proc; retain duplicate products; enabled
#                  workaround for exit program on Windows; copied Tornado
#                  DLLs before calling regTornado
# 04x,22sep98,wmd  fixed the product info screen dimensions for controls.
# 04w,21sep98,bjl  removed setupBannerAttach, added product label for Windows
#                  and product bitmap for unix.  
# 04v,21sep98,tcy  remove duplicate products from product list
# 04u,19sep98,tcy  fixed missing folder names on Win95 and 
#                  reregister debugger if failed once
# 04t,17sep98,tcy  adjust finish page and added dcom warning page
#                  disable detail button initially
# 04s,17sep98,bjl  write registry values immediately, do not run uninstStop
#                  if disk is full.
# 04r,17sep98,wmd  fix syntax problems from merging previous checkin.
# 04q,17sep98,wmd  use proc cdFileNameGet, fix onProjRecordOK proc.
# 04p,16sep98,vhe  Add automatic selection of product from configuration file
# 04o,16sep98,tcy  adjusted compSelect page 
# 04n,15sep98,wmd  remove confirmation of project info page, changed some
#                  wording, changed how proc dialogCreate worked.
# 04m,14sep98,tcy  print list of products after finish page
# 04l,14sep98,bjl  focus on backgroundWindow first for unix to set correct
#                  colors for welcome page.  
# 04k,14sep98,j_w  fix auto setup in registration page
# 04j,11sep98,tcy  added regTornado to register Tornado binaries
# 04i,11sep98,j_w  display products installed in log file in auto install
# 04h,10sep98,j_w  add test modification 
# 04g,09sep98,bjl  fixed remove unix tempDir on exit, modified isUnix 
#                  procedure, workaround setup.ico with setupico.bmp, moved 
#                  projInfo registry values to inf file, workaround for 
#                  application exit for unix, include fspace.tcl for unix 
#                  available space, use different minimized icon for unix.
# 04f,04sep98,bjl  changed tornado.inf to uppercase, modified tempDirectory
#                  procedure to work with setup wrapper.
# 04e,03sep98,bjl  removed torRegistry page for unix, added tornadoInstalled 
#                  check to compSelect, lowered button and frame on license 
#                  text page for unix display.  
# 04d,03sep98,wmd  removed horizontal scroll bar from license text page.
# 04c,03sep98,bjl  modified to handle unix directories, added borders to 
#                  text boxes, removed folderSelect page for unix, 
#                  fixed exit dialogs to return values for unix.
# 04b,02sep98,tcy  torRegistry/remoteRegistryHost pages moved before filesCopy
# 04a,01sep98,wmd  incorporate license/project info into the setup widzard.
# 03z,26aug98,tcy  added context-sensitive help for all dialogs/controls
# 03Y,25aug98,wmd  fix the license text to fit into dialog frame nicely.
# 03X,24aug98,wmd  allign input text boxes for project info.
# 03W,20aug98,wmd  modify to identify and prevent installation over T101 tree.
# 03v,19aug98,wmd  modified for Mainwin.
# 03u,19aug98,tcy  added dialog box prompting for WIND directory if ZIP files
#                  are not found
# 03t,17aug98,j_w  fix various pages for auto installation
# 03s,12aug98,wmd  add license agreement page, license record dialog to Setup.
# 03r,14aug98,j_w  add modification for test automation
# 03q,10aug98,tcy  added extra argument "args" for linkCreateLog
# 03p,10aug98,tcy  use COM interface functions to create folders and links
# 03o,06aug98,tcy  fixed bug of missing curly brace in keyData registry
# 03n,05aug98,bjl  write user data to registry from tornado.inf when setup 
#		   finishes.
# 03m,04aug98,tcy  fixed meter for libUpdate()
# 03l,04aug98,bjl  added processing of warning message file from inf file.  
# 03k,04aug98,wmd  modified to add check for coreProd, and edited some warnings.
# 03j,03aug98,bjl  modified setup /ICON to update registry and use inf file. 
# 03i,30jul98,bjl  added inf file processing; removed service install of 
#		   Tornado Registry, Tornado icon functions, functions that 
#		   store Tornado specific data into the Windows Registry, 
#		   and fileDup of .TXT files (now handled by inf files); 
#		   allow installation of Registry as a service without 
#		   the portmapper.
# 03h,29jul98.wmd  added error handling to check responses for overwrite/core
#                  installation.
# 03g,28jul98,tcy  modified for new UITclSh
# 03f,27jul98,tcy  changed to controlPropertySet in libUpdate frame
# 03e,24jul98,wmd  fixed bitmap fading for bbrdUpdate.
# 03d,23jul98,wmd  add dialog for corefile installation, new dialog for setting
#                  overwrite policy, uitclsh t2 changes.
# 03c,23jul98,tcy  added multi-key selection capability
# 03b,22jul98,tcy  added system check for TCP-IP and long filename
# 03a,22jul98,tcy  removed portMapper and moved License procs to LICW32.TCL
# 02j,01apr98,pdn  fixed localHost to localhost
# 02i,09feb98,pdn  continued even after getting BAD_CD_REVISION message.
# 02h,16sep97,pdn  allowed the 'none' key to be changed.
# 02g,01jul97,pdn  fixed the available diskspace problem.
# 02f,13jun97,pdn  added error handling in case key vendor mismatch.
# 02e,08apr97,pdn  fixed remote icon install problem, fixed mail sending
#                  problem, copied *.TXT from root of CDROM to root of
#                  tornado tree.
# 02d,28mar97,pdn  fixed the problem that torVarCreate get call too early
# 02c,25mar97,pdn  asigned 'localHost' to WIND_REGISTRY if user chooses to 
#                  run wtxregd.exe locally.
# 02b,17mar97,pdn  used "WindLM" instead of "Wind License Manager" for 
#                  service name on NT. 
# 02a,12mar97,pdn  fixed setup problem when portMapper is running.
# 01z,07mar97,pdn  fixed the resource logging problem.
# 01y,05mar97,pdn  sorted the product list.
# 01w,03mar97,pdn  added the minimize flag when creating icons in the startup
#                  group.  created uninstall icon for all Window hosts.
#                  added -p option for patch installation.
# 01v,13feb97,pdn  improved license installation steps.
# 01u,09feb97,pdn  added option to configure a floating license server
# 01t,04feb97,pdn  filted out unused messages from checklist box.
# 01s,24jan97,pdn  cleanup
# 01r,24jan97,pdn  adjusted welcome, and component select dialog.
# 01q,22jan97,pdn  fixed folder install bug.
# 01p,21jan97,pdn  saved the last Tornado group, fixed license install
# 01o,20jan97,pdn  used backslashes where possible, saved installation key
# 01n,16jan97,pdn  surrounded the if conditions w/ braces
# 01m,13jan97,pdn  fixed WIND_REGISTRY location, fixed checklist logic, 
#                  moved uninstBinCopy() to INSTALL.TCL, and clean up.
# 01l,06jan97,pdn  updated billboard cyling by product.  cleanup text.
# 01k,18dec96,sks  cleaned up; better error handling on startup; rearranged code
#                  a bit; create & destroy TMP dir.; change location of "TCL" &
#                  "BITMAPS" directories; renamed "TEXT.TCL" to "MESSAGES.TCL"
# 01j,12dec96,pdn  added BAD_CD_REVISION check
# 01i,11dec96,pdn  displayed the feature id/description
# 01h,24nov96,sj   eliminated premature returns.
# 01g,18nov96,sj   replaced global variables with functions
#                  from GLOBAL.TCL
# 01f,14nov96,sj   moved all text messages to TEXT.TCL
# 01e,08nov96,sj   queued up all registry key and value
#                  writes until the end of uninstBinCopy.
# 01d,06nov96,sj   setup now works on 95 and NTs. 
# 01c,30oct96,sj   completed the license setup
# 01b,10may96,pdn  adding setup wizard.
# 01a,19apr96,sks  written.

# DESCRIPTION
# This module is the Tcl code for the Setup program. It creates the wizard
# pages.
#
# RESOURCE FILES
# etc/tools/resource/mfg/setup/RESOURCE/TCL/INSTALL.TCL
# etc/tools/resource/mfg/setup/RESOURCE/TCL/GLOBAL.TCL
# etc/tools/resource/mfg/setup/RESOURCE/TCL/MESSAGES.TCL
# etc/tools/resource/mfg/setup/RESOURCE/TCL/CONFIG.TCL
# etc/tools/resource/mfg/setup/RESOURCE/TCL/INF.TCL
# etc/tools/resource/mfg/setup/RESOURCE/TCL/HELPW32.TCL

# globals

#############################################################################
#
# fileContentGet - return the content of a file as a string
#
# This procedure opens a file and return the content of the file as a 
# string separated by new lines
#
# SYNOPSIS
# .tS
# fileContentGet <file>
# .tE
#
# PARAMETERS: 
# .IP file
# file name relative to the root of the CD
#
# RETURNS: N/A 
#
# ERRORS: N/A
#

proc fileContentGet {file} {

    set file [cdFileNameGet $file]
    if [catch {open $file r} infile] {
        puts "Error: can't open $file"
        close $infile
        return
    }

    set contents ""
    foreach line  [split [read $infile] \n] {
        string trimright $line
        append contents [format "%s\r\n" $line]
    }
    close $infile

    return $contents
}

#############################################################################
#
# isUnix - determine whether host platform is Unix or not
#
# This procedure will determine whether host platform is Unix or not
#
# SYNOPSIS
# .tS
# isUnix
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if host platform is not Unix
#          1 if host platform is Unix
#
# ERRORS: N/A
#
#
proc isUnix {} {
    global env

    if {[info exists env(WIND_HOST_TYPE)]} {
        if {[string match sun4* $env(WIND_HOST_TYPE)]} {
            return 1;
	} elseif {[string match parisc* $env(WIND_HOST_TYPE)]} {
            return 1;
	} else {
            return 0;
	}
    } else {
        return [info exists env(MWHOME)]
    }
}

#############################################################################
#
# limitColors - determine whether environment variable SETUP_LIMITCOLORS is set
#
# This procedure will determine whether environment variable 
# SETUP_LIMITCOLORS is set
#
# SYNOPSIS
# .tS
# limitColors
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if enviroment variable SETUP_LIMITCOLORS is not set
#          1 if enviroment variable SETUP_LIMITCOLORS is set
#
# ERRORS: N/A
#

proc limitColors {} {
    global env

    if {[info exists env(SETUP_LIMITCOLORS)]} {
        if {$env(SETUP_LIMITCOLORS)==1} {
            return 1
	}
    }

    return 0
}

#############################################################################
#
# removeBackground - determine whether environment variable 
#                    SETUP_REMOVEBACKGROUND is set
#
# This procedure will determine whether environment variable
# SETUP_REMOVEBACKGROUND is set
#
# SYNOPSIS
# .tS
# removeBackground
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if enviroment variable SETUP_REMOVEBACKGROUND is not set
#          1 if enviroment variable SETUP_REMOVEBACKGROUND is set
#
# ERRORS: N/A
#

proc removeBackground {} {
    global env

    if {[info exists env(SETUP_REMOVEBACKGROUND)]} {
        if {$env(SETUP_REMOVEBACKGROUND)==1} {
            return 1
        }
    }

    return 0
}

#############################################################################
#
# noColorMgr - determine whether environment variable SETUP_NOCOLORMGR is set
#
# This procedure will determine whether environment variable
# SETUP_NOCOLORMGR is set
#
# SYNOPSIS
# .tS
# noColorMgr
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if enviroment variable SETUP_NOCOLORMGR is not set
#          1 if enviroment variable SETUP_NOCOLORMGR is set
#
# ERRORS: N/A
#

proc noColorMgr {} {
    global env

    if {[info exists env(SETUP_NOCOLORMGR)]} {
        if {$env(SETUP_NOCOLORMGR)==1} {
            return 1
        }
    }

    return 0
}

#############################################################################
#
# parseCmdLine - parse command line arguments
#
# This procedure will parse command line argument
#
# SYNOPSIS
# .tS
# parseCmdLine <switches>
# .tE
#
# PARAMETERS: 
# .IP switches 
# /ICON - install icons only
# /HELP - print help messages
#
# RETURNS: 1 if there are more than 1 switches
#          0 if there are one or no switches
#
# ERRORS: N/A
#

proc parseCmdLine {switches} {
    global tornadoInstalled

    set usageError [expr [llength $switches] > 1]

    if {!$usageError && ([llength $switches] == 1)} {
        set switches [string toupper $switches]
        switch -regexp ($switches) {
            \-I -
            /I -
            /ICON {
                instTypeSet icon
		set tornadoInstalled 1
            }
            /? -
            /H -
            /HELP -
            default {
                set usageError 1
            }
        }
    }

    if {$usageError} {
        messageBox -ok -informationicon [strTableGet 1550_USAGE]
    }

    return $usageError
}

#############################################################################
#
# setupFolderCreate - create Tornado folder
#
# This procedure will create Tornado folder
#
# SYNOPSIS
# .tS
# setupFolderCreate <folder> <mode>
# .tE
#
# PARAMETERS:
# .IP folder
# folder name to be created
# .IP mode 
# 0 -- install Tornado in the user program group 
# 1 -- install Tornado in the common program group
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc setupFolderCreate {folder mode} {

    set path [programPathGet $mode]
     
    if [catch {file mkdir "$path\\$folder"} err] {
        dbgputs "cannot create folder, $folder, $mode: $err"
    }
}


#############################################################################
#
# setupLinkDelete - create Tornado program links
#
# This procedure will create Tornado program links
#
# SYNOPSIS
# .tS
# setupLinkDelete <folder> <linkName> <mode>
# .tE
#
# PARAMETERS:
# .IP folder 
# folder name containing the program links
# .IP linkName
# string name of program links
# .IP mode 
# 0 -- install Tornado in the user program group 
# 1 -- install Tornado in the common program group
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc setupLinkDelete {folder linkName mode} {

    set programPath [programPathGet $mode]

    if { "$folder" == "" } {
        puts "Error: folder name is null"
        return
    }

    if {"$linkName" == "" } {
        puts "Error: link name is null"
        return
    }

    if [catch {file delete "$programPath\\$folder\\$linkName"} err] {
        dbgputs "cannot delete icon, $linkName: $err"
    } else {
        dbgputs "deleted icon: $linkName"
    }
}

#############################################################################
#
# folderCreateLog - create Tornado folders and log the actions
#
# This procedure will create Tornado folders and log the actions for uninstall
# use later 
#
# SYNOPSIS
# .tS
# folderCreateLog <folder> <mode> [log]
# .tE
#
# PARAMETERS:
# .IP folder
#  folder name to be created
# .IP mode
# 0 -- install Tornado in the user program group
# 1 -- install Tornado in the common program group
# .IP log
# true -- log the actions (default) 
# false -- do not log the actions
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc folderCreateLog {folder mode {log true}} {
    global ctrlVals

    setupFolderCreate $folder $mode

    if {[lsearch $ctrlVals(folders) $folder] == "-1" && $log == "true"} {
        lappend ctrlVals(folders) $folder
        uninstLog resource "folder\t$folder\t$mode"
    }
}

#############################################################################
#
# linkCreateLog - create Tornado program links and log the actions
#
# This procedure will create Tornado program links and log the actions for
# uninstall use later
#
# SYNOPSIS
# .tS
# linkCreateLog <folder> <item> <exe> [args] [dir] [mode] [fMin] [iconIndex]
#               [iconPath]
# .tE
#
# PARAMETERS:
# .IP folder    
# folder name containing the program links
# .IP item
# icon name; eg "Tornado Registry", "VxWorks COM1"
# .IP exe
# path to the executable file; eg "host\x86-win32\bin\wtxregd.exe"
# .IP args
# arguments passed to the executable; eg "-V" 
# .IP dir
# directory that the executable resides
# .IP mode
# 0 -- install Tornado in the user program group
# 1 -- install Tornado in the common program group
# .IP fMin 
# run in minimized state
# .IP iconIndex
# icon index
# .IP iconPath
# path to the icon file; eg host\resource\bitmaps\WindView\evtRecv.ico
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc linkCreateLog {folder item exe args dir mode {fMin 0} {iconIndex 0}\
                    {iconPath ""}} {

    set added 0
    set new 0

    if [catch {setupLinkDelete $folder $item $mode} error] {
        set new 1
    }

    if {$iconPath == "" && ![catch {setupLinkCreate $folder \
                                    $item \
                                    $exe \
                                    $args \
                                    $dir \
                                    $mode \
                                    $fMin} error]} {
        set added 1
        
    } elseif {![catch {setupLinkCreate $folder \
                                    $item \
                                    $exe \
                                    $args \
                                    $dir \
                                    $mode \
                                    $fMin \
                                    $iconIndex \
                                    $iconPath} error]} {
        set added 1
    } else {
        dbgputs "error when creating item $item in $folder: $error"
        set hasError 1
    }

    if {$new && $added} {
        uninstLog resource "icon\t$folder\t$item\t$mode"
    }

    if [info exists hasError] {
        messageBox "Cannot create icons(s): $error\nPlease run \"SETUP \/I\"\
        to install icons at a later time."
    }
}

#############################################################################
#
# regKeyCreateLog - create registry key and log the actions
#
# This procedure will create registry key and log the actions
#
# SYNOPSIS
# .tS
# regKeyCreateLog <rootKey> <subKey> <key> [log]
# .tE
#
# PARAMETERS:
# .IP rootKey 
# root of registry key hierarchy; eg HKEY_LOCAL_MACHINE
# .IP subKey
# path to the registry key; eg SOFTWARE\\Microsoft\\Windows\\CurrentVersion 
# .IP key  
# key name; eg "Uninstall", "TornadoV2.0"
# .IP log 
# true -- log the actions (default)
# false -- do not log the actions
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc regKeyCreateLog {rootKey subKey key {log true}} {
    global setupVals

    lappend setupVals(commandQueue) \
        [list regKeyCreateLogHelper $rootKey $subKey $key $log]  
}

#############################################################################
#
# regKeyCreateLogHelper - helper procedure to create registry key and
#                         save the actions
#
# This procedure is a helper procedure to create registry key and save the
# actions
#
# SYNOPSIS
# .tS
# regKeyCreateLogHelper <rootKey> <subKey> <key> [log]
# .tE
#
# PARAMETERS:
# .IP rootKey 
# root of registry key hierarchy; eg HKEY_LOCAL_MACHINE
# .IP subKey  
# path to the registry key; eg SOFTWARE\\Microsoft\\Windows\\CurrentVersion
# .IP key
# key name; eg "Uninstall", "TornadoV2.0"
# .IP log 
# true -- log the actions (default)
# false -- do not log the actions
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc regKeyCreateLogHelper {rootKey subKey key log} {

    if {[catch {setupRegKeyExists $rootKey "$subKey\\$key"} error] &&
       ![catch {sysRegistryKeyCreate $rootKey $subKey $key} error] && 
       "$log" == "true"} {
         uninstLog resource "regkey\t$rootKey\t$subKey\\$key"
    }
}

#############################################################################
#
# regValueExists - test if registry key exists
#
# This procedure will test if registry key exists
#
# SYNOPSIS
# .tS
# regValueExists <rootKey> <subKey> <value>
# .tE
#
# PARAMETERS:
# .IP rootKey 
# root of registry key hierarchy; eg HKEY_LOCAL_MACHINE
# .IP subKey 
# path to the registry key; eg SOFTWARE\\Microsoft\\Windows\\CurrentVersion
# .IP key     
# key name; eg "Uninstall", "TornadoV2.0"
#
# RETURNS: retVal - 0 -- registry key does not exist
#                 - 1 -- registry key exists
#
# ERRORS: N/A
#

proc regValueExists {rootKey subKey value} {
    set retVal 0
    if {[lsearch [setupRegValueEnum $rootKey $subKey] $value] != -1} {
        set retVal 1
    }
    return $retVal
}

#############################################################################
#
# regValueWriteLog - write registry key to the Windows registry and save
#                    the actions for uninstall use later
#
# This procedure will write registry key to the Windows registry and save
# the actions for uninstall use later
#
# SYNOPSIS
# .tS
# regValueWriteLog <rootKey> <key> <valueName> <value> [log]
# .tE
#
# PARAMETERS:
# .IP rootKey   
# root of registry key hierarchy; eg HKEY_LOCAL_MACHINE
# .IP key       
# path to the registry key; eg SOFTWARE\\Microsoft\\Windows\\CurrentVersion
# .IP valueName 
# key name; eg "Uninstall", "TornadoV2.0"
# .IP value
# value associated with the key
# .IP log 
# true -- log the actions (default)
# false -- do not log the actions
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc regValueWriteLog {rootKey key valueName value {log true}} {
    global setupVals

    lappend setupVals(commandQueue) \
        [list regValueWriteLogHelper $rootKey $key $valueName $value $log]  
}

#############################################################################
#
# regValueWriteLogHelper - helper procedure to regValueWriteLog
#
# This procedure is a helper procedure to regValueWriteLog
#
# SYNOPSIS
# .tS
# regValueWriteLogHelper <rootKey> <key> <valueName> <value> [log]
# .tE
#
# PARAMETERS: 
# .IP rootKey   
# root of registry key hierarchy; eg HKEY_LOCAL_MACHINE
# .IP key       
# path to the registry key; eg SOFTWARE\\Microsoft\\Windows\\CurrentVersion
# .IP valueName 
# key name; eg "Uninstall", "TornadoV2.0"
# .IP value     
# value associated with the key
# .IP log       
# true -- log the actions (default)
# false -- do not log the actions
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc regValueWriteLogHelper {rootKey key valueName value log} {

    if {[catch {sysRegistryValueWrite $rootKey $key $valueName $value} error]} {
        puts "error when writing value $valueName: $error"

    } elseif {"$log" == "true" && ![regValueExists $rootKey $key $valueName]} {
        uninstLog resource "regValue\t$rootKey\t$key\t$valueName"
    } 
}

#############################################################################
#
# queueExecute - execute commands in the queue
#
# This procedure will execute commands in the queue. The purpose is to store
# a list of commands in case if users decide to exit the setup program, these
# commands can all be executed at once.
#
# SYNOPSIS
# .tS
# queueExecute
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc queueExecute {} {
    global setupVals

    foreach command $setupVals(commandQueue) {
        eval $command
    }    
}

#############################################################################
#
# windRegValueRead - load WIND_REGISTRY registry value from the previous 
#                    installation if any
#
# This procedure will load WIND_REGISTRY registry value from the previous 
# installation if any
#
# SYNOPSIS
# .tS
# windRegValueRead
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: WIND_REGISTRY value
#
# ERRORS: N/A
#

proc windRegValueRead {} {
    global setupVals
    global ctrlVals

    # Load WIND_REGISTRY from the previous installation if any

    if ![info exists setupVals(registry)] { 
        set setupVals(registry) ""

        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                "Software\\$setupVals(WRS)\\$setupVals(prodRegEntry)" \
                WIND_REGISTRY} retVal]} { 

            set setupVals(registry) $retVal

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                "SOFTWARE\\$setupVals(WRS)\\$setupVals(prodRegEntry)" \
                WIND_REGISTRY} retVal]} {

            set setupVals(registry) $retVal
        }
    }

    return $setupVals(registry)
}

#############################################################################
#
# constructPages - contruct list of pages based on types of installation
#
# This procedure will construct list of pages based on types of installation
#
# SYNOPSIS
# .tS
# constructPages
# .tE
#
# PARAMETERS:
# .IP mode 
# icon -- icon installation only
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc constructPages {mode} {
    global ctrlVals
    global dll

    set retVal 1
    set ctrlVals(pageList) {}

    switch $mode {
    
        icon {
	    if {[isUnix]} {
	    	# do not select folder, display only remote registry host page
                set ctrlVals(pageList) {welcome destDir \
	      			        remoteRegistryHost iconFinish}
	    } else {
                set ctrlVals(pageList) {welcome destDir folderSelect \
		                        torRegistry remoteRegistryHost \
					iconFinish}
	    }
            cdromDescSet "Remote Icons"
        }
    
        default {
            initPageList
        }
    }

    set ctrlVals(currPage) [lindex $ctrlVals(pageList) 0]
    set ctrlVals(pageListBack) $ctrlVals(pageList)
    return $retVal
}

#############################################################################
#
# initPageList - init procedure to construct the default page list
#
# This procedure is a init procedure to construct the default page list
#
# SYNOPSIS
# .tS
# initPageList
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc initPageList {} {
    global ctrlVals

    if {[isUnix]} {
        # do not select folder, display only remote registry host page
        set ctrlVals(pageList) {welcome readme licAgreement \
                                        privilege registration projectInfo \
                                        destDir compSelect permission \
                                        remoteRegistryHost compatibility howTo \
                                        filesCopy libUpdate systemConfig finish}
    } else {
        set ctrlVals(pageList) {welcome readme licAgreement \
                                privilege registration installChoice}
    }

    if {($ctrlVals(admin) == "1") || ($ctrlVals(NT) != "1")} {
        pageRemove privilege
    }     
}

#############################################################################
#
# dlgFrmCreate - create wizard page
#
# This procedure will create wizard page
#
# SYNOPSIS
# .tS
# dlgFrmCreate <title>
# .tE
#
# PARAMETERS:
# .IP title 
# name of the wizard page
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc dlgFrmCreate {title} {
    global ctrlVals
    global setupVals
    global env

    if {[removeBackground]} {
        set title "Setup -- $title"
    }

    if {[windHostTypeGet]=="x86-win32"} {
        set backButtXPos 147
    } else {
        set backButtXPos 143
    }

    if {[windowExists $ctrlVals(mainWindow)] != 1 } {
        set controls [list \
                [list bitmap -name bitmap \
                             -title $ctrlVals(dlgImage) -stretch \
                             -x 10 -y 10 -w 80 -h 160] \
                [list frame -gray -name frm2 -x 10 -y 178 -w 295 -h 2] \
                [list button -name backButt -title "< &Back" \
                             -callback backCallback \
                             -disable -x $backButtXPos -y 185 -w 50 -h 14] \
                [list button -name nextButt -title "&Next >" \
                             -default -callback nextCallback \
                              -x 197 -y 185 -w 50 -h 14] \
                [list button -name cancelButt -title "&Cancel" \
                             -callback quitCallback \
                              -x 255 -y 185 -w 50 -h 14] \
        ]
        if {[removeBackground] && ![info exists env(SETUP_USEKDE)]} {
	    # add a minimize box to the dialog form since
	    # there is no background to minimize.  

	    # create the dialog with initial size of 1 1, then
	    # resize and reposition the dialog after.  This is
	    # to workaround a UITclSh bug which does not allow
	    # the window to shrink below its original size for
	    # the billboard dialogs.

            dialogCreate -name $ctrlVals(mainWindow) \
                         -title $title \
                         -parent $ctrlVals(parentDialog) \
                         -helpfile $setupVals(setupHelp) \
                         -modeless \
                         -controls $controls 

            windowSizeSet $ctrlVals(mainWindow) 315 204

            windowPositionSet $ctrlVals(mainWindow) \
                          [expr $ctrlVals(screenW) / 2] \
                          [expr $ctrlVals(screenH) / 2]

            set dlg_orig_xpos [lindex [windowPositionGet \
                                         $ctrlVals(mainWindow)] 0]
            set dlg_orig_ypos [lindex [windowPositionGet \
                                         $ctrlVals(mainWindow)] 1]
            windowPositionSet $ctrlVals(mainWindow) \
                          [expr $dlg_orig_xpos - 158] \
                          [expr $dlg_orig_ypos - 102]
        } elseif {[removeBackground] && [info exists env(SETUP_USEKDE)]} {

	    # Sizing and positioning a window causes
	    # KDE to crash.  Initialize window for KDE at
	    # full size, and later keep the same size
	    # in the file copying billboard page.  

            dialogCreate -name $ctrlVals(mainWindow) \
                         -title $title \
                         -parent $ctrlVals(mainWindow) \
                         -helpfile $setupVals(setupHelp) \
                         -modeless \
                         -controls $controls -w 315 -h 204
	} else {
            dialogCreate -name $ctrlVals(mainWindow) \
                         -title $title -w 315 -h 204 \
                         -parent $ctrlVals(parentDialog) \
                         -helpfile $setupVals(setupHelp) \
                         -modeless \
                         -controls $controls
	}

        set ctrlVals(parentDialog) $ctrlVals(mainWindow)
        windowQueryCloseCallbackSet $ctrlVals(mainWindow) quitCallback
    }

    customizeMainWindow $title
    return $ctrlVals(mainWindow)    
}

#############################################################################
#
# customizeMainWindow - set the title of the wizard page 
#
# This procedure will set the title of the wizard page
#
# SYNOPSIS
# .tS
# customizeMainWindow
# .tE
#
# PARAMETERS:
# .IP title 
# title of the wizard page
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc customizeMainWindow {title} {
    global ctrlVals

    windowTitleSet $ctrlVals(mainWindow) $title

    foreach ctrl $ctrlVals(volatileFrm) {
        controlCreate $ctrlVals(mainWindow) $ctrl
    }

    set ctrlVals(jumpBack) 1
}

#############################################################################
#
# destroyVolatileFrm - close the wizard page
#
# This procedure will close the wizard page
#
# SYNOPSIS
# .tS
# destroyVolatileFrm
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc destroyVolatileFrm {} {
    global ctrlVals

    # First hide the controls to make it 'invisible', mainwin may be slow in
    # how it implements refresh logic on unix.

    foreach ctrl $ctrlVals(volatileFrm) {
        set pos [lsearch $ctrl "-name"]

        if {$pos != "-1"} {
            controlHide \
                $ctrlVals(mainWindow).[lindex $ctrl [expr $pos + 1]] 1 
        }
    }

    # Then we destroy the controls

    foreach ctrl $ctrlVals(volatileFrm) {
        set pos [lsearch $ctrl "-name"]

        if {$pos != "-1"} {
            controlDestroy \
                $ctrlVals(mainWindow).[lindex $ctrl [expr $pos + 1]] 
        }
    }
    set ctrlVals(volatileFrm) ""
}

#############################################################################
#
# backCallback - close the current wizard page and return to the previous
#                wizard page
#
# This procedure will close the current wizard page and return to the previous
# wizard page
#
# SYNOPSIS
# .tS
# backCallback
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc backCallback {} {
    global ctrlVals

    # decrement the dialog index and re-create previous page

    set currPageIndex [lsearch $ctrlVals(pageList) $ctrlVals(currPage)]
    set prevPageIndex [expr $currPageIndex - 1]

    if {"$prevPageIndex" >= "0"} {
        set ctrlVals(currPage) [lindex $ctrlVals(pageList) $prevPageIndex]

        destroyVolatileFrm
        pageCreate($ctrlVals(currPage))

    } else {
        messageBox "Can't go back further!"
    }
}

#############################################################################
#
# calcPage - return the difference in the desired page index and the current 
#            page index 
#
# This procedure will return the difference in the desired page index and
# the current page index
#
# SYNOPSIS
# .tS
# calcPage <desiredPage>
# .tE
#
# PARAMETERS:
# .IP desiredPage 
# page name of wizard to go next
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc calcPage {desiredPage} {
    global ctrlVals
    
    # jump to the desired page

    set desiredIndex [lsearch $ctrlVals(pageList) $desiredPage]
    set currentPageIndex [lsearch $ctrlVals(pageList) $ctrlVals(currPage)]
    set retval [expr $desiredIndex - $currentPageIndex]
    return $retval
}

#############################################################################
#
# restoreOriginalDialog - restore the original dialog size
#
# This procedure will restore the original dialog size
#
# SYNOPSIS
# .tS
# restoreOriginalDialog
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc restoreOriginalDialog {} {
    global ctrlVals
    global env

    set ctrlVals(restoredDialog) 1
    windowShow $ctrlVals(mainWindow) -restore 1
    if {![info exists env(SETUP_USEKDE)]} {
       windowPositionSet $ctrlVals(mainWindow) [expr $ctrlVals(dlg_orig_xpos)] \
                                               [expr $ctrlVals(dlg_orig_ypos)]
    }
    controlHide $ctrlVals(mainWindow).bitmap 0

    # hide the "phony" Next button and restore the original button.
    # See the procedure "resizeBbrdDialog".
    controlHide $ctrlVals(mainWindow).phonynextButt 1
    controlHide $ctrlVals(mainWindow).nextButt 0

    controlPropertySet $ctrlVals(mainWindow).nextButt -defaultbutton 1
    controlSizeSet $ctrlVals(mainWindow).frm2 \
                   [lindex $ctrlVals(dlg_orig_frm2_size) 0] \
                   [lindex $ctrlVals(dlg_orig_frm2_size) 1]
    controlPositionSet $ctrlVals(mainWindow).frm2 \
                   [lindex $ctrlVals(dlg_orig_frm2_pos) 0] \
                   [lindex $ctrlVals(dlg_orig_frm2_pos) 1]
    controlPositionSet $ctrlVals(mainWindow).backButt \
                   [lindex $ctrlVals(dlg_orig_back_pos) 0] \
                   [lindex $ctrlVals(dlg_orig_back_pos) 1]
    controlPositionSet $ctrlVals(mainWindow).nextButt \
                   [lindex $ctrlVals(dlg_orig_next_pos) 0] \
                   [lindex $ctrlVals(dlg_orig_next_pos) 1]
    controlPositionSet $ctrlVals(mainWindow).cancelButt \
                   [lindex $ctrlVals(dlg_orig_cancel_pos) 0] \
                   [lindex $ctrlVals(dlg_orig_cancel_pos) 1]
    if {![info exists env(SETUP_USEKDE)]} {
      windowSizeSet $ctrlVals(mainWindow) [lindex $ctrlVals(dlg_orig_size) 0] \
                                          [lindex $ctrlVals(dlg_orig_size) 1]
    }
}

#############################################################################
#
# nextCallback - go to the next wizard page
#
# This procedure will take Setup to the next wizard page as if next button
# is pushed
#
# SYNOPSIS
# .tS
# nextCallback
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc nextCallback {} {
    global ctrlVals
    global setupVals

    set retVal 0
   
    if {"$ctrlVals(currPage)" == ""} { return $retVal }

    set processRetVal [pageProcess($ctrlVals(currPage))]
    if {$processRetVal == "1"} {

        set currPageIndex [lsearch $ctrlVals(pageList) $ctrlVals(currPage)]

        if {"$currPageIndex" != "-1"} {
            set nextPageIndex [expr $currPageIndex + 1]
            set nextPage [lindex $ctrlVals(pageList) $nextPageIndex]

            if {"$nextPage" != ""} {
                set ctrlVals(currPage) $nextPage
                destroyVolatileFrm

                if {[info exists ctrlVals(restoredDialog)]} {
                    if {$ctrlVals(restoredDialog) == 0} { 
                        restoreOriginalDialog
                    }
                }
                pageCreate($nextPage)            
                set retVal 1
                            
            } else {
                # temporary workaround for windowClose exit problem
	    	set setupVals(cancel) 1
                applicationExit
            } 
        } else {            
            puts "error: page $ctrlVals(currPage) not found!"
        }

    } elseif {$processRetVal != "0"} {
        
        # calculate the current page based on the return value

        set currPageIndex [lsearch $ctrlVals(pageList) $ctrlVals(currPage)]
        set currPageIndex [expr $currPageIndex + $processRetVal]
        set maxVal [llength $ctrlVals(pageList)]

        if {"$currPageIndex" != "-1" && $currPageIndex <= $maxVal} {
            set nextPageIndex $currPageIndex
            set nextPage [lindex $ctrlVals(pageList) $nextPageIndex]

            if {"$nextPage" != ""} {
                set ctrlVals(currPage) $nextPage
                destroyVolatileFrm

                pageCreate($nextPage)            
                set retVal 1
                            
            } else {
                applicationExit
            } 
        } else {            
            puts "error: page $ctrlVals(currPage) not found!"
        }
    }

    return $retVal
}

#############################################################################
#
# fileExistsNewerWarnExit - exit procedure for fileExistsNewerExit dialog box
#
# This procedure is a exit procedure for fileExistsNewerExit dialog box
#
# SYNOPSIS
# .tS
# fileExistsNewerWarnExit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc fileExistsNewerWarnExit {} {
    global retvalNew

    if {[controlChecked file_exists_newer_warn.overwriteFile]} {
	set retvalNew 0
    }
    if {[controlChecked file_exists_newer_warn.no_overwriteFile]} {
	set retvalNew 1
    }
    if {[controlChecked file_exists_newer_warn.overwriteAll]} {
        set retvalNew 2
    }
}

#############################################################################
#
# fileExistsNewerWarnInit - Init procedure for fileExistsNewerWarn dialog box
#
# This procedure is a init procedure for fileExistsNewerWarn dialog box
#
# SYNOPSIS
# .tS
# fileExistsNewerWarnInit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc fileExistsNewerWarnInit {} {
    global retvalNew

    set retvalNew 2
    windowExitCallbackSet file_exists_newer_warn fileExistsNewerWarnExit
    controlCheckSet file_exists_newer_warn.overwriteAll 1
}

#############################################################################
#
# fileExistsOlderWarnExit - exit procedure for fileExistsOlderExit dialog box
#
# This procedure is a exit procedure for fileExistsOlderExit dialog box
#
# SYNOPSIS
# .tS
# fileExistsOlderWarnExit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc fileExistsOlderWarnExit {} {
    global retvalOld

    if {[controlChecked file_exists_older_warn.overwriteAll]} {
        set retvalOld 2
    }
    if {[controlChecked file_exists_older_warn.no_overwriteFile]} {
	set retvalOld 0
    }
    if {[controlChecked file_exists_older_warn.overwriteFile]} {
	set retvalOld 1
    }
}

#############################################################################
#
# fileExistsOlderWarnInit - init procedure for fileExistsOlderInit dialog box
#
# This procedure is a init procedure for fileExistsOlderInit dialog box
#
# SYNOPSIS
# .tS
# fileExistsOlderWarnInit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc fileExistsOlderWarnInit {} {
    global retvalNew

    set retvalNew 2
    windowExitCallbackSet file_exists_older_warn fileExistsOlderWarnExit
    controlCheckSet file_exists_older_warn.overwriteAll 1
}

#############################################################################
#
# onBaseInstallWarnContinue - callback procedure when continue button is 
#                             pushed
#
# This procedure is a callback procedure when continue button is 
# pushed and it closes the base_install_warn dialog box
#
# SYNOPSIS
# .tS
# onBaseInstallWarnContinue
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onBaseInstallWarnContinue {} {
    global returnval

    set returnval 0
    windowClose base_install_warn
}

#############################################################################
#
# onBaseInstallWarnReturn - callback procedure when return button is 
#                           pushed
#
# This procedure is a  callback procedure when return button is 
# pushed and it closes the base_install_warn dialog box
#
# SYNOPSIS
# .tS
# onBaseInstallWarnReturn
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onBaseInstallWarnReturn {} {
    global returnval

    set returnval 1
    windowClose base_install_warn
}

#############################################################################
#
# dialog - create a dialog box with buttons and messages based on 
#          passed in arguments
#
# This procedure will create a dialog box with buttons and messages based on  
# passed in arguments
#
# SYNOPSIS
# .tS
# dialog <dialogType> <title> <message> <args>
# .tE
#
# PARAMETERS:
# dialogType - stop                   -- dialog box with stop button
#              retry_cancel           -- dialog box with retry and cancel 
#                                        buttons
#              yes_no                 -- dialog box with yes and no buttons
#              ok_proceed_exit        -- dialog box with ok, proceed and 
#                                        exit buttons
#              yes_exit               -- dialog box with yes and exit buttons
#              resume_exit            -- dialog box with resume and 
#                                        exit buttons
#              re_ig_cancel           -- dialog box with retry, ignore and 
#                                        cancel buttons
#              re_ig_cancel_old       -- dialog box with retry, ignore and 
#                                        cancel buttons (old version)
#              base_install_warn      -- dialog box with install and 
#                                        "select path" buttons
#              file_exists_older_warn -- dialog box with yes and exit buttons
#              file_exists_newer_warn -- dialog box with ok button
#              ok                     -- dialog box with ok button
#              ok_cancel              -- dialog box with ok and cancel buttons
#
# title      - title for the dialog box
# message    - message displayed for the dialog box
# args       - XXX not used XXX
#
# RETURNS: 1 if successful
#          0 if failed
#
# ERRORS: N/A
#

proc dialog {dialogType title message args} {
    global ctrlVals
    global setupVals

    switch $dialogType {
        stop {
            switch [messageBox -ok -stopicon $message] {

                ok { return 1 }
            }
        }
        retry_cancel {
            switch [messageBox -retrycancel -questionicon $message] {
                retry  { return 0 }
                cancel { return 1 }
            }
        }
        yes_no {
            switch [messageBox -yesno -questionicon $message] {
                yes { return 0 }
                no  { return 1 }
            }
        }           
        ok_proceed_exit {
		global returnval
		set returnval 0

                set controls [list \
                    [list label -name message -title $message \
                                -x 10 -y 10 -w 205 -h 90] \
                    [list button -name Resume -title "&Go back" -default \
                                 -tooltip "Go specify another directory" \
                                 -callback {global returnval;
				 	    windowClose ok_proceed_exit;
                                            set returnval 0} \
                                 -x 10 -y 78 -w 50 -h 14] \
                    [list button -name Exit -title "&Proceed" \
                                 -tooltip "Continue with installation" \
                                 -callback {global returnval;
				 	    windowClose ok_proceed_exit;
                                            set returnval 1} \
                                 -x 70 -y 78 -w 50 -h 14] \
                    [list button -name Exit -title "E&xit Setup" \
                                 -tooltip "Stop installation and exit" \
                                 -callback {global returnval;
				 	    windowClose ok_proceed_exit;
                                            set returnval 2} \
                                 -x 169 -y 78 -w 50 -h 14] \
                ]

                set width 230
                set xpos [expr ($ctrlVals(screenW) / 2) - ($width / 2)]

                set height 100
                set ypos [expr ($ctrlVals(screenH) / 2) - ($height / 2)]
        
                dialogCreate -name ok_proceed_exit \
                            -title "$title" \
                            -helpfile $setupVals(setupHelp) \
                            -parent $ctrlVals(parentDialog) \
                            -x $xpos -y $ypos \
                            -w $width -h $height \
                            -controls $controls
		return $returnval
        }
        yes_exit {
	 	 global returnval
		 set returnval 0

                 set controls [list \
                    [list label -name message -title $message \
                                -x 10 -y 10 -w 205 -h 120] \
                    [list button -name Yes -title "&Yes" \
                                 -tooltip "Proceed with installation" \
                                 -callback {global returnVal;
				 	    windowClose yes_exit;
                                            set returnval 0} \
                                 -x 116 -y 142 -w 50 -h 14] \
                    [list button -name Exit -title "E&xit Setup" \
                                 -tooltip "Stop installation and exit" \
                                 -callback {global returnval;
				 	    windowClose yes_exit;
                                            set returnval 1} \
                                 -x 169 -y 142 -w 50 -h 14] \
                ]
    
                set width 230
                set height 160

                dialogCreate -name yes_exit \
                            -title "$title" \
                            -helpfile $setupVals(setupHelp) \
                            -parent $ctrlVals(parentDialog) \
                            -w $width -h $height \
                            -controls $controls
	        return $returnval
        }
        resume_exit {
	 	 global returnval
		 set returnval 0

                 set controls [list \
                    [list label -name message -title $message \
                                -x 10 -y 10 -w 205 -h 90] \
                    [list button -name Resume -title "&Resume" \
                                 -tooltip "Resume installation" \
                                 -callback {global returnVal;
				 	    windowClose resume_exit;
                                            set returnval 0} \
                                 -x 116 -y 92 -w 50 -h 14] \
                    [list button -name Exit -title "E&xit Setup" \
                                 -tooltip "Stop installation and exit" \
                                 -callback {global returnval;
				 	    windowClose resume_exit;
                                            set returnval 1} \
                                 -x 169 -y 92 -w 50 -h 14] \
                ]
                set width 230
                set xpos [expr ($ctrlVals(screenW) / 2) - ($width / 2)]

                set height 114
                set ypos [expr ($ctrlVals(screenH) / 2) - ($height / 2)]

                dialogCreate -name resume_exit \
                            -title "$title" \
                            -helpfile $setupVals(setupHelp) \
                            -parent $ctrlVals(parentDialog) \
                            -x $xpos -y $ypos \
                            -w $width -h $height \
                            -controls $controls
	        return $returnval
        }
        re_ig_cancel {
            switch [messageBox -abortretryignore -questionicon $message] {
                abort  { return 2 }
                retry  { return 0 }
                ignore { return 1 }
            }
        }
        re_ig_cancel_old {
            global returnval
            set returnval 0
            set controls [list \
                [list label -name message -title $message \
                            -x 10 -y 7 -w 194 -h 90] \
                [list button -name retry -title "&Retry" \
                             -callback {global returnval; \
                                        windowClose dlg; \
                                        set returnval 0} \
                             -x 10 -y 56 -w 50 -h 14] \
                [list button -name ignore -title "&Ignore" \
                             -callback {global returnval; \
                                        windowClose dlg; \
                                        set returnval 1} \
                             -x 80 -y 56 -w 50 -h 14] \
                [list button -name cancel -title "&Cancel" \
                             -callback {global returnval; \
                                        windowClose dlg; \
                                        set returnval 2} \
                             -x 150 -y 56 -w 50 -h 14] \
            ]

            dialogCreate -name "re_ig_cancel" \
                         -title "$title" \
                         -parent $ctrlVals(parentDialog) \
                         -helpfile $setupVals(setupHelp) \
                         -w 205 -h 76 \
                         -controls $controls
            return $returnval
        }
	base_install_warn {
            global returnval
            set returnval 1

            set controls [list \
                [list frame -white -name baseFrame -x 7 -y 7 -w 1 -h 1 \
                        -w 188 -h 36] \
                [list label -name warn_label \
                        -title " Installing Tornado Over an Existing Tree " \
                        -x 20 -y 4 -w 160 -h 8] \
                [list label -name message -title $message \
                        -x 14 -y 14 -w 175 -h 28] \
                [list label -name message2 \
                        -title [strTableGet 4000_BASE_INSTALL_WARN_1] \
                        -x 10 -y 47 -w 184 -h 25] \
                [list button -name continue -title "&Install" \
                        -tooltip "Continue with installation" \
                        -callback onBaseInstallWarnContinue \
                        -x 10 -y 77 -w 50 -h 14] \
                [list button -name return -title "&Select Path" -default \
                        -tooltip "Return to Select Directory page" \
                        -callback onBaseInstallWarnReturn \
                        -x 146 -y 77 -w 50 -h 14] \
	    ]

	    dialogCreate -name base_install_warn \
		      -title "$title" \
                      -helpfile $setupVals(setupHelp) \
		      -parent $ctrlVals(parentDialog) \
                      -w 205 -h 96 \
                      -init {
                          controlPropertySet base_install_warn.warn_label \
                                             -bold 1
                      } \
		      -controls $controls
           return $returnval
	}
	file_exists_older_warn {
            global retvalOld
	    set retvalOld 2
	    set controls [list \
		[list label -name message -title $message \
			-x 10 -y 7 -w 188 -h 51] \
		[list choice -name overwriteFile -title \
			[strTableGet 4010_FILE_EXISTS_WARN_1] \
			-newgroup -auto \
                        -tooltip "Overwrite one file" \
			-x 10 -y 55 -w 150 -h 10 ] \
		[list choice -name no_overwriteFile -title \
			[strTableGet 4010_FILE_EXISTS_WARN_2] -auto \
                        -tooltip "Do not overwrite file" \
		        -x 10 -y 67 -w 150 -h 10 ] \
		[list choice -name overwriteAll -title \
			[strTableGet 4010_FILE_EXISTS_WARN_3] -auto \
                        -tooltip "Overwrite all duplicate files" \
		        -x 10 -y 79 -w 190 -h 10 ] \
		[list button -name file_exists_OK -title "&OK" \
			-callback { \
			    windowClose file_exists_older_warn} \
			-x 77 -y 95 -w 50 -h 14 ] \
	    ]

	    dialogCreate -name file_exists_older_warn \
		      -title "$title" \
		      -parent $ctrlVals(parentDialog) \
                      -helpfile $setupVals(setupHelp) \
                      -init fileExistsOlderWarnInit \
		      -w 205 -h 115 \
		      -controls $controls
            return $retvalOld
	}
	file_exists_newer_warn {
            global retvalNew
	    set retvalNew 2
	    set controls [list \
		[list label -name message -title $message \
			-x 10 -y 7 -w 188 -h 51] \
		[list choice -name overwriteFile -title \
			[strTableGet 4010_FILE_EXISTS_WARN_1] \
			-newgroup -auto \
                        -tooltip "Overwrite one file" \
			-x 10 -y 55 -w 150 -h 10 ] \
		[list choice -name no_overwriteFile -title \
			[strTableGet 4010_FILE_EXISTS_WARN_2] -auto \
                        -tooltip "Do not overwrite file" \
		        -x 10 -y 67 -w 150 -h 10 ] \
		[list choice -name overwriteAll -title \
			[strTableGet 4010_FILE_EXISTS_WARN_3] -auto \
                        -tooltip "Overwrite all duplicate files" \
		        -x 10 -y 79 -w 190 -h 10 ] \
		[list button -name file_exists_OK -title "&OK" \
			-callback { \
			    windowClose file_exists_newer_warn} \
			-x 77 -y 95 -w 50 -h 14 ] \
	    ]

	    dialogCreate -name file_exists_newer_warn \
		      -title "$title" \
		      -parent $ctrlVals(parentDialog) \
                      -helpfile $setupVals(setupHelp) \
                      -init fileExistsNewerWarnInit \
		      -exit fileExistsNewerWarnExit \
                      -w 205 -h 115 \
		      -controls $controls
            return $retvalNew
	}
        ok {
            switch [messageBox -ok -information $message] {
                ok { return 0 }
            }
        }
        ok_cancel {
            switch [messageBox -okcancel -questionicon $message] {
                ok     { return 0 }
                cancel { return 1 }
            }
        }
    }
}

#############################################################################
#
# quitCallback - callback procedure invoked when cancel button is pushed
#
# This procedure is a callback procedure invoked when cancel button is pushed
#
# SYNOPSIS
# .tS
# quitCallback
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: 0 if user decides to resume installation
#         1 if user decides to quit
#

proc quitCallback {} {
    global setupVals
    global ctrlVals

    
    if {"$setupVals(cancel)" != "1"} {
        switch [dialog resume_exit "Setup" [strTableGet 1360_QUIT_CALLBACK]] {
            0 {
                return 0
            }
            1 {
                set setupVals(cancel) 1

                catch {uninstLog setupLog "\tUser aborted!"}

                if {"filesCopy" != "$ctrlVals(currPage)"} {
                    applicationExit
                }

                return 1
            }
        }
    }
}

#############################################################################
#
# applicationExit - close the main and background windows for Setup
#
# This procedure will close the main and background windows for Setup
#
# SYNOPSIS
# .tS
# applicationExit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc applicationExit {} {
    global ctrlVals
   
    closeSetupDebugLog
    windowClose $ctrlVals(mainWindow) 
    windowClose $ctrlVals(backgroundWindow)
}

#############################################################################
#
# onTextChange - set the variable in setupVals when text in edit box is changed
#
# This procedure will  set the variable in setupVals when text in edit box 
# is changed
#
# SYNOPSIS
# .tS
# onTextChange <control> <var>
# .tE
#
# PARAMETERS:
# .IP control 
# name of the control
# .IP var 
# variable to be set
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onTextChange {control var} {
    global ctrlVals
    global setupVals
 
    set setupVals($var) [controlValuesGet $ctrlVals(mainWindow).$control]
}

#############################################################################
#
# uninstallInitWin32 - set up the uninstall process
#
# This procedure will copy files to the user directory necessary to run
# uninstall.
#
# SYNOPSIS
# .tS
# uninstallInitWin32
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc uninstallInitWin32 {} {
    global ctrlVals

    beginWaitCursor

    set binDir "[destDirGet]\\SETUP\\X86\\WIN32"
    set windBase [dosToUnix "[destDirGet]"]
    set uninstTcl [dosToUnix "[uninstHomeDirGet]\\UNINST.TCL"]

    # On 95 and NT4 create the registry entries for uninstall if they don't 
    # already exist, else just increment the value of share count

    if {$ctrlVals(version) != "NT3x"} {
        set subKey "SOFTWARE\\Microsoft\\Windows\\CurrentVersion"
        regKeyCreateLog HKEY_LOCAL_MACHINE $subKey Uninstall noLog
        set subKey "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"

        # Uninstall entries need to be added

        regKeyCreateLog HKEY_LOCAL_MACHINE $subKey "TornadoV2.0"
        regValueWriteLog HKEY_LOCAL_MACHINE "$subKey\\TornadoV2.0" \
                                DisplayName "Tornado Version 2.0"

        regValueWriteLog HKEY_LOCAL_MACHINE "$subKey\\TornadoV2.0" \
                                UninstallString \
                                "$binDir\\UITCLSH.EXE $uninstTcl \
                                $windBase -seed"
     }

     # create an uninstall icon

     folderCreateLog [defGroupGet] $ctrlVals(admin) 

     fileDup "[cdromRootDirGet]\\RESOURCE\\BITMAPS\\REMOVE.ICO" \
             "[destDirGet]\\.wind\\uninst\\REMOVE.ICO"
 
     linkCreateLog \
                [defGroupGet] \
                "Tornado Uninstall" \
                "$binDir\\UITCLSH.EXE" \
                "$uninstTcl $windBase -seed" \
                $binDir \
                $ctrlVals(admin) 0 0 \
                "[destDirGet]\\.wind\\uninst\\REMOVE.ICO"
    
     endWaitCursor
}

#############################################################################
#
# previousPage - return to the previous wizard page
#
# This procedure will bring Setup to the previous wizard page
#
# SYNOPSIS
# .tS
# previousPage
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc previousPage {} {
    global ctrlVals

    set currPageIndex [lsearch $ctrlVals(pageList) $ctrlVals(currPage)]
    set prevPageIndex [expr $currPageIndex - 1]

    return [lindex $ctrlVals(pageList) $prevPageIndex] 
}

#############################################################################
#
# meterCreate - create the meter control
#
# This procedure will create the meter control
#
# SYNOPSIS
# .tS
# meterCreate
# .tE
#
# PARAMETERS: 
# .IP msg 
# message to be printed when meter is running
#
# RETURNS: 1 if successful
#
# ERRORS: N/A
#

proc meterCreate {msg} {
   global ctrlVals
   global setupVals
   global env
        
   set ctrlVals(meterWg) "meterCtrl"
   set ctrlVals(meterTagWg) "fileName"

   if {$ctrlVals(numBbrd) == "0"} {

       set ctrlVals(volatileFrm) [list \
               [list label -name message -title $msg \
                           -x 100 -y 10 -w 205 -h 100] \
               [list label -name $ctrlVals(meterTagWg) \
                           -x 100 -y 120 -w 195 -h 10] \
               [list progressmeter -center -name $ctrlVals(meterWg) \
                           -x 100 -y 138 -w 205 -h 10] \
       ]

       set ctrlVals(meterWindow) $ctrlVals(mainWindow)
       set ctrlVals(bbrdElapse)  101
   } elseif {[removeBackground]} {

       set bbrdW $ctrlVals(bbrdW)
       set bbrdH $ctrlVals(bbrdH)

       set dlg_orig_w [lindex $ctrlVals(dlg_orig_size) 0]
       set right_border [expr $dlg_orig_w - 10]

       set dimension [pixelsToDialogUnits $ctrlVals(mainWindow) \
                        [list $bbrdW $bbrdH]]
       set bbrdW [lindex $dimension 0]
       set bbrdH [lindex $dimension 1]


       if {[info exists env(SETUP_USEKDE)]} {
           set bitmap_ypos 10
       } else {
           set bitmap_ypos 40
       }
  
       # relative to the bitmap position
       set labely [expr $bbrdH + $bitmap_ypos + 10]
       set metery [expr $labely + 12]

       if {[info exists env(SETUP_USEKDE)]} {
           set meterw [expr $right_border - 10]
       } else {
           set meterw $bbrdW
       }

       if {[info exists env(SETUP_USEKDE)]} {
           # center the bitmap

           set bitmap_xpos [expr [expr $dlg_orig_w - $bbrdW] / 2]
           set label_ypos 15
       } else {
           set bitmap_xpos 10
           set label_ypos 10
       }

       # no top directory message for KDE
       
       if {[info exists env(SETUP_USEKDE)]} {
           set ctrlVals(volatileFrm) [list \
                   [list bitmap -name bbrd -title [lindex $ctrlVals(bbrdList) 0] \
                         -x $bitmap_xpos -y $bitmap_ypos -stretch -w $bbrdW -h $bbrdH \
                         -fade "[cdFileNameGet \
                                [file join RESOURCE BITMAPS FADEBG.BMP]]"] \
                   [list label -name $ctrlVals(meterTagWg) \
                               -x 10 -y $labely -w [expr $meterw-10] -h 10] \
                   [list progressmeter -center -name $ctrlVals(meterWg) \
                               -x 10 -y $metery -w $meterw -h 10] \
           ]
       } else {
           set ctrlVals(volatileFrm) [list \
                   [list label -name message -title $msg \
                               -x 10 -y $label_ypos -w 205 -h 60] \
                   [list bitmap -name bbrd -title [lindex $ctrlVals(bbrdList) 0] \
                         -x $bitmap_xpos -y $bitmap_ypos -stretch -w $bbrdW -h $bbrdH \
                         -fade "[cdFileNameGet \
                                [file join RESOURCE BITMAPS FADEBG.BMP]]"] \
                   [list label -name $ctrlVals(meterTagWg) \
                               -x 10 -y $labely -w [expr $meterw-10] -h 10] \
                   [list progressmeter -center -name $ctrlVals(meterWg) \
                               -x 10 -y $metery -w $meterw -h 10] \
           ]

       }
 
       set ctrlVals(meterWindow) $ctrlVals(mainWindow)
       set ctrlVals(bbrdWindow)  $ctrlVals(mainWindow)
       set ctrlVals(nextBbrd) 0

   } else {
       windowShow $ctrlVals(mainWindow) 0
       
       for {set i 0} {$i < 1000} {incr i} { 
           uiEventProcess
       }

       set ctrlVals(volatileFrm) {}
       set ctrlVals(nextBbrd) 0
       set ctrlVals(meterWindow) "meterWindow"
       set ctrlVals(bbrdWindow)  "bbrdWindow"

       set bbrdW $ctrlVals(bbrdW)
       set bbrdH $ctrlVals(bbrdH)
 
       set dimension [pixelsToDialogUnits $ctrlVals(backgroundWindow) \
                        [list $bbrdW $bbrdH]]
       set bbrdW [lindex $dimension 0]
       set bxpos [expr ($ctrlVals(screenW) - $bbrdW) / 2]

       set bbrdH [lindex $dimension 1]
       set bypos [expr (($ctrlVals(screenH) - $bbrdH) / 2)]

       set controls(bbrd) [list \
            [list bitmap -name bbrd -title [lindex $ctrlVals(bbrdList) 0] \
                     -x 0 -y 0 -stretch -w $bbrdW -h $bbrdH \
                     -fade "[cdFileNameGet \
                            [file join RESOURCE BITMAPS FADEBG.BMP]]"] \
            ]
     
       set meterWidth 222
       set xpos [expr $ctrlVals(screenW) - $meterWidth - 10]

       set meterHeight 54
       set ypos [expr $ctrlVals(screenH) - $meterHeight - 25]

       set controls(meter) [list \
            [list label -name $ctrlVals(meterTagWg) \
                        -x 7 -y 5 \
                        -w 195 -h 10] \
            [list progressmeter -center -name $ctrlVals(meterWg) \
                        -x 7 -y 19 \
                        -w 211 -h 13 ] \
            [list button -name cancel -title "&Cancel" \
                        -callback quitCallback \
                        -x 87 -y 36 \
                        -w 50 -h 14] \
       ]

       dialogCreate -name $ctrlVals(meterWindow) \
                    -helpfile $setupVals(setupHelp) \
                    -modeless \
                    -notitle \
                    -parent $ctrlVals(parentDialog) \
                    -x $xpos -y $ypos \
                    -w $meterWidth -h $meterHeight \
                    -controls $controls(meter)

       windowPositionSet $ctrlVals(meterWindow) $xpos $ypos

       set ctrlVals(parentDialog) $ctrlVals(meterWindow)
       windowQueryCloseCallbackSet $ctrlVals(meterWindow) quitCallback
     
       dialogCreate -name $ctrlVals(bbrdWindow) \
                    -helpfile $setupVals(setupHelp) \
                    -noframe -notitle -modeless \
                    -parent $ctrlVals(parentDialog) \
                    -x $bxpos -y $bypos \
                    -w $bbrdW -h $bbrdH \
                    -controls $controls(bbrd)

       windowPositionSet $ctrlVals(bbrdWindow) $bxpos $bypos
       set ctrlVals(parentDialog) $ctrlVals(bbrdWindow)

       return 1  
   }
}

#############################################################################
#
# bbrdUpdate - update the billboard
#
# This procedure will update the billboard
#
# SYNOPSIS
# .tS
# bbrdUpdate <percent>
# .tE
#
# PARAMETERS: 
# .IP percent 
# percentage of billboards that have been shown
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc bbrdUpdate {percent} {
    global ctrlVals

    if { $percent > $ctrlVals(bbrdElapse) } {

        incr ctrlVals(bbrdElapse) $ctrlVals(displayInt)

        set prevBbrdIndex $ctrlVals(nextBbrd)
        incr ctrlVals(nextBbrd)
    
        if { [lindex $ctrlVals(bbrdList) $ctrlVals(nextBbrd)] != "" } {
            controlValuesSet $ctrlVals(bbrdWindow).bbrd -fadebmp \
                    [lindex $ctrlVals(bbrdList) $prevBbrdIndex] \
                    [lindex $ctrlVals(bbrdList) $ctrlVals(nextBbrd)]
        }
    }
}

#############################################################################
#
# meterUpdate - update the meter
#
# This procedure will update the meter based on percent and the tag name
#
# SYNOPSIS
# .tS
# meterUpdate <percent> <tag>
# .tE
#
# PARAMETERS:
# .IP percent 
# percentage of files that have been installed
# .IP tag
# name of the file being installed
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc meterUpdate {percent tag} {
    global ctrlVals

    controlValuesSet $ctrlVals(meterWindow).$ctrlVals(meterWg) $percent
    controlValuesSet $ctrlVals(meterWindow).$ctrlVals(meterTagWg) \
                        [fileNameAbbreviate $tag 40]
    uiEventProcess
}

#############################################################################
#
# meterDestroy - remove the meter
#
# This procedure will remove the meter
#
# SYNOPSIS
# .tS
# meterDestroy <meterW>
# .tE
#
# PARAMETERS:
# .IP meterW 
# the handle for the meter control
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc meterDestroy {meterW} {
    global ctrlVals

    if {$meterW != $ctrlVals(mainWindow)} {

        if [catch {windowClose $meterW} error] {
            puts "error on closing $meterW: $error"
        }

        if [catch {windowClose $ctrlVals(bbrdWindow)} error] {
            puts "error when closing bbrdWindow: $error"
        }
        
        set ctrlVals(volatileFrm) {}
        windowShow $ctrlVals(mainWindow) 1
        set ctrlVals(parentDialog) $ctrlVals(mainWindow)
    } 
}

#############################################################################
#
# exitWithMessage - display exiting messages
#
# This procedure will display exiting messages
#
# SYNOPSIS
# .tS
# exitWithMessage <message>
# .tE
#
# PARAMETERS:
# .IP message 
# message to be displayed
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc exitWithMessage {message} {
    if {$message == ""} {
        messageBox -ok -stopicon [strTableGet 1213_FINISH]
    } {
        messageBox -ok -stopicon "$message"
        uninstLog setupLog "\tSetup terminated: $message"
    }
    applicationExit
    return 0
}

#############################################################################
#
# bkgndInit - init procedure called when background window is created
#
# This procedure is an initialization procedure called when background 
# window is created
#
# SYNOPSIS
# .tS
# bkgndInit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc bkgndInit {} {
    global ctrlVals
    global setupVals
    
    if ![catch {setupScreenDimensionsGet} dimension] {
        set dimension \
            [pixelsToDialogUnits $ctrlVals(backgroundWindow) $dimension]
        set ctrlVals(screenW) [lindex $dimension 0] 
        set ctrlVals(screenH) [lindex $dimension 1]
    }

    set bkgnd [cdFileNameGet [file join RESOURCE BITMAPS BKGNDSOL.BMP]]

    set control [list bitmap -name bitmap \
                             -title $bkgnd \
                             -x 0 -y 0 -stretch \
                             -w $ctrlVals(screenW) \
                             -h $ctrlVals(screenH) \
    ]
    
    if {[removeBackground]} {
        # this will effectively cause the background to disappear.

        windowShow $ctrlVals(backgroundWindow) 0
    } else {
        windowSizeSet $ctrlVals(backgroundWindow) $ctrlVals(screenW) \
	     		      $ctrlVals(screenH)
    }

    controlCreate $ctrlVals(backgroundWindow) $control

    if {![removeBackground]} {
        setupBannerAttach [windowHandleGet $ctrlVals(backgroundWindow)] \
	                  [controlHandleGet $ctrlVals(backgroundWindow).bitmap] \
			  [list "$setupVals(WRS), Inc." "[cdromDescGet] Setup"]
    }
    
    windowQueryCloseCallbackSet $ctrlVals(backgroundWindow) quitCallback

#   Next line commented out because it's not guaranteed to work,
#   Left in as a lesson to be learned: window managers affect program behavior.
#   windowActivateCallbackSet $ctrlVals(backgroundWindow) startProg

    startProg
}

#############################################################################
#
# bkgndExit - exit procedure invoked when background is closed
#
# This procedure is a exit procedure invoked when background is closed
#
# SYNOPSIS
# .tS
# bkgndExit
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc bkgndExit {} {
    global ctrlVals
    global setupVals
    global env

    beginWaitCursor
    if {[uninstHomeDirGet] != "" && ![info exists setupVals(diskfull)]} {
        uninstStop    
    } else {
        # call queueExecute here since we don't call it in uninstStop
        queueExecute
    }

    if {[isUnix]} {
        #  do not destroy temp directory yet if TMP/patchinfo exists.  
	#  The SETUP script will remove the temp directory after the 
	#  patchinfo message is displayed.  
        if {![file exists $env(TMP)/patchinfo]} {
            catch {tempDirectory destroy}
        }
    } else {
        catch {tempDirectory destroy}
    }
    
    endWaitCursor
}

#############################################################################
#
# applicationStart - create the background and main windows
#
# This procedure will create the background and main windows
#
# SYNOPSIS
# .tS
# applicationStart
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc applicationStart {} {
    global setupVals
    global ctrlVals

    set ctrlVals(parentDialog) $ctrlVals(backgroundWindow)

    if {![isUnix]} {
        dialogCreate -title "Setup" \
                     -name $ctrlVals(backgroundWindow) \
                     -helpfile $setupVals(setupHelp) \
                     -init bkgndInit \
                     -exit bkgndExit \
                     -icon [cdFileNameGet \
                           [file join RESOURCE BITMAPS SETUP.ICO]] \
                     -thinframe -minibox -maxibox \
                     -x 0 -y 0 
    } elseif {![removeBackground]} { 
        # use an icon for Unix with less colors than Windows

        dialogCreate -title "Setup" \
                     -name $ctrlVals(backgroundWindow) \
                     -helpfile $setupVals(setupHelp) \
                     -init bkgndInit \
                     -exit bkgndExit \
                     -thinframe -minibox -maxibox \
                     -x 0 -y 0 
#                     -icon [cdFileNameGet
#                           [file join RESOURCE BITMAPS SETUPUNX.ICO]]
    } else {
        # This is the case for when we want to remove the background. 

        # remove the title, otherwise a small residual window appears, even
	# when the window size is set to 0 0 in bkgndInit.  A thinframe is
	# also necessary.  

       dialogCreate -notitle \
                     -name $ctrlVals(backgroundWindow) \
                     -helpfile $setupVals(setupHelp) \
                     -init bkgndInit \
                     -exit bkgndExit \
                     -thinframe \
                     -x 10000 -y 10000
#                     -icon [cdFileNameGet 
#			 [file join RESOURCE BITMAPS SETUPUNX.ICO]]
    }
    return $setupVals(cancel)
}

#############################################################################
#
# needUpdate - test if patches need to be applied to the user system 
#
# This procedure will test if patches need to be applied to the user system
#
# SYNOPSIS
# .tS
# needUpdate <fileName>
# .tE
#
# PARAMETERS:
# .IP fileName 
# file to be used for determining whether patches need be applied
#
# RETURNS: 1 if update is needed
#          0 if update is not needed
#
# ERRORS: N/A
#

proc needUpdate {fileName} {

    if { "$fileName" == "COMCTL32.DLL" } {
        set wrsVersion 4.72.3110.9
    } elseif { "$fileName" == "OLE32.DLL" } {
        set wrsVersion 4.71.2618
    }

    set userFile [file join [sysDirGet] $fileName]

    if {[file exists $userFile] &&  \
        [catch {setupFileVersionInfoGet $userFile} userVersion]} {
        set error $userVersion
        dbgputs "Error: Cannot get file version of $userFile"
    } elseif ![file exists $userFile] {
        set error "$fileName is not currently installed on the system"
        dbgputs "Error: $error"
    }

    if {[info exists error] || $userVersion < $wrsVersion} {
        return 1
    } else {
        return 0
    }
}

#############################################################################
#
# windowsSystemCheck - check for Tornado requirements on Windows
#
# This procedure will check if the user's system has the following installed:
# TCP-IP, DCOM95, and 401comupd; otherwise, Setup will ask these patches
# to be installed.
#
# SYNOPSIS
# .tS
# windowsSystemCheck
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 if patches are successfully installed
#          0 if patches are not successfully installed
#
# ERRORS: N/A
#
     
proc windowsSystemCheck {} {

    global ctrlVals

    # detects if the system has TCP-IP installed

    if {"[info hostname]" == "" } {
        messageBox -ok -stopicon [strTableGet 1095_WARN_NO_TCPIP]
        return 0
    }

    if { "$ctrlVals(version)" == "WIN95" } {
        set oleUpdate [needUpdate OLE32.DLL]
        set comctlUpdate [needUpdate COMCTL32.DLL]
        set wDir [cdFileNameGet [file join X86 WIN95]]
        set comctrl [cdFileNameGet [file join X86 WIN95 401comupd.exe]]
        set dcom [cdFileNameGet [file join X86 WIN95 dcom95.exe]]

        if {$oleUpdate == 1 && $comctlUpdate == 1} {
            if {![dialog yes_exit "Setup" \
                [strTableGet 4082_DCOM95_AND_COMCTL_TEXT]]} {
                # run 401comupd.exe in quiet mode and dcom95
    
                if [catch {processCreate "$comctrl /r:n /q:a" $wDir} error] {
                    messageBox "Error in running 401comupd.exe: $error\n\
                    Please run $comctrl after SETUP has completed."
                }

                # introduce a pause between the updates

                after 2000

                set dcom [cdFileNameGet [file join X86 WIN95 dcom95.exe]]
                if [catch {processCreate "$dcom /q" $wDir} error] {
                     messageBox "Error in running DCOM95.exe: $error\n\
                                 Please run $dcom after SETUP has completed."
                }
            }
            # exit SETUP

            return 0
        } elseif { $oleUpdate == 1 && $comctlUpdate == 0 } {
            if {![dialog yes_exit "Setup" [strTableGet 4080_DCOM_TEXT]]} {
                # run dcom95

                if [catch {processCreate "$dcom /q" $wDir} error] {
                     messageBox "Error in running DCOM95.exe: $error\n\
                                 Please run $dcom after SETUP has completed."
                }
            }
            # exit SETUP

            return 0
        } elseif { $oleUpdate == 0 && $comctlUpdate == 1 } {
            if {![dialog yes_exit "Setup" \
                   [strTableGet 4085_COMCTL_UPDATE_TEXT]]} {
                # run 401comupd.exe

                if [catch {processCreate "$comctrl /q" $wDir} error] {
                    messageBox "Error in running 401comupd.exe: $error\n\
                    Please run $comctrl after SETUP has completed."
                }
            }
            # exit SETUP

            return 0
        }
    }
    return 1
}

#############################################################################
#
# startProg - callback procedure invoked when Setup window is active 
#
# This procedure is a callback procedure invoked when Setup window is active
#
# SYNOPSIS
# .tS
# startProg
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc startProg {} {
    global ctrlVals

    windowActivateCallbackSet $ctrlVals(backgroundWindow) ""
    pageCreate(welcome) 
    if {[isUnix]} {
        # focus on backgroundWindow first to set correct colors
        # for welcome screen

        setupWindowFocusSet $ctrlVals(backgroundWindow)
    }
    setupWindowFocusSet "Welcome"
}

#############################################################################
#
# tempDirectory - create, destroy or return the temp directory based on option
#
# This procedure will create, destroy or return the temp directory based 
# on option
#
# SYNOPSIS
# .tS
# tempDirectory <option>
# .tE
#
# PARAMETERS:
# .IP options 
# create  -- create the temp directory
# destroy -- destroy the temp directory
# get     -- return the temp directory path
#
# RETURNS: return the temp directory path if option is create or get;
#          nothing otherwise
#
# ERRORS: N/A
#

proc tempDirectory {option} {
    global env

    if {$option == "create"} {
        # Determine the "temp" directory

        set uninstTemp "WIND_TMP[pid]"

        foreach elem [array names env] {
            if {[string compare [string tolower $elem] "tmp"] == 0} {
                set env(TMP) $env($elem)
            }
            if {[string compare [string tolower $elem] "temp"] == 0} {
               set env(TEMP) $env($elem)
            }
            if {[string compare [string tolower $elem] "tmpdir"] == 0} {
               set env(TMPDIR) $env($elem)
            }
        }
         
	if {![isUnix]} {
            if {[info exists env(TEMP)] && [file isdir $env(TEMP)]} {
                set env(TMP) $env(TEMP)\\$uninstTemp
            } elseif {[info exists env(TMP)] && [file isdir $env(TMP)]} {
                set env(TMP) $env(TMP)\\$uninstTemp
            } elseif {[info exists env(TMPDIR)] && [file isdir $env(TMPDIR)]} {
                set env(TMP) $env(TMPDIR)\\$uninstTemp
            } else {
	        if {[windHostTypeGet] == "x86-win32"} {
                    set env(TMP) "C:\\$uninstTemp"
                } 
            }
        }

	if {[isUnix]} {
	    set env(TMP) [dosToUnix $env(TMP)]
	}

        if {![isUnix]} {
            # tmp directory already exists for unix from setup wrapper

            file mkdir $env(TMP)
        }

        return $env(TMP)

    } elseif {$option == "destroy"} {
        if {![isUnix]} {
            cd c:/
	}
        file delete -force $env(TMP)

    } elseif {$option == "get"} {
        return $env(TMP)

    } else {
        error "unknown option: $option"
    }
}

#############################################################################
#
# envPathSet - add bin directory to the PATH environment variable
#
# This procedure will add bin directory to the PATH environment variable
#
# SYNOPSIS
# .tS
# envPathSet
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc envPathSet {} {
    global env

    if {[isUnix]} {
        set exePath [dosToUnix [file dirname [info nameofexecutable]]]
    } else {
        set exePath [unixToDos [file dirname [info nameofexecutable]]]
    }

    foreach elem [array names env] {
        if {[string compare [string tolower $elem] "path"] == 0} {
            if {[isUnix]} {
                set env($elem) "[cdromBinDirGet]:$exePath:$env($elem)"
            } else {
                set env($elem) "[cdromBinDirGet];$exePath;$env($elem)"
            }
            return
        }
    }
    if {[isUnix]} {
        set env(PATH) "[cdromBinDirGet]:$exePath"
    } else {
        set env(PATH) "[cdromBinDirGet];$exePath"
    }
}

#############################################################################
#
# globalInit - initialize all global variables
#
# This procedure will initialize all global variables
#
# SYNOPSIS
# .tS
# globalInit 
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc globalInit {} {
    global setupVals ctrlVals env dll argv 
    global autoSetupLogFile
    global projLic
    global projName
    global projLicUsers

    # Get the CD root directory
   
    if {![isUnix]} {
        # change slashes for win32

        regsub -all {/} [lindex $argv 0] {\\} env(CD_ROOT)
        if {![info exists env(HOME)]} {
            set env(HOME) "~"
        }
    } else {
        set env(CD_ROOT) [lindex $argv 0]
        if {![info exists env(HOME)]} {
            set env(HOME) "C:"
        }
    }

    # make sure we can read the filename on the CD
    # INCLUDE.TCL - procedures sourced by INSTW32.TCL and INCLUDE.TCL
    # GLOBAL.TCL  - procedures sourced by INSTW32.TCL only

    set sourceList "GLOBAL INCLUDE"
    foreach includeFile $sourceList {
        set fileName [file join RESOURCE TCL $includeFile.TCL]
        set fn [string toupper $fileName]
        if {[file exists [file join $env(CD_ROOT) $fn]]} {
            set globFile [file join $env(CD_ROOT) $fn]
        } 
        set fn [string tolower $fileName]
        if {[file exists  [file join $env(CD_ROOT) $fn]]} {
            set globFile [file join $env(CD_ROOT) $fn]
        }
        source $globFile
    }
    envPathSet

    if {[isUnix]} {
        if {$env(WIND_HOST_TYPE) == "sun4-solaris2"} {
            set env(CD_BIN) "$env(CD_ROOT)/SUN4/SOLARIS2"
        } elseif {$env(WIND_HOST_TYPE) == "parisc-hpux10"} {
            set env(CD_BIN) "$env(CD_ROOT)/PARISC/HPUX10"
        }        
    } else {
        set env(CD_BIN) "$env(CD_ROOT)\\X86\\WIN32"
    }

    # Work around for the case sensitivity clash of the environment vars
    # between Windows and TCL.  
    
    foreach elem [array names env] {
       if {[string compare [string tolower $elem] "tmp"] == 0} {
           regsub -all {/} $env($elem) {\\} env(TMP)
           break
       }
    }

    # Create the "temp" directory (destroyed in "bkgndExit")

    if [catch {tempDirectory create} errStr] {
        messageBox "Unable to create temporary directory: $errStr"
        return -1
    }

    set ctrlVals(useInputScript) 0

    set setupVals(errorCount) 0
    set setupVals(cancel) 0
    set setupVals(torRegServName) "Tornado Registry"
    set setupVals(uninstFile) ""

    set projLic ""
    set projName ""
    set projLicUsers ""

    set setupVals(hostName) "unknown"
    set setupVals(hostId) ""
    set setupVals(components) ""
    set setupVals(commandQueue) ""
    set setupVals(fileName) ""
    set setupVals(WRS) "Wind River Systems"
    set setupVals(prodRegEntry) "Tornado 2.0"
    set setupVals(keyList) ""
    set setupVals(drvIndex) -1

    set ctrlVals(torRegAction) ""   

    # Cannot use cdFileNameGet here because cdFileNameGet() uses 
    # ctrlVals(version) which is not set now until later in this proc;
    # so we stick with cdromRootDirGet ()

    cdromZipDirSet [file join [cdromRootDirGet] WIND]

    if [isUnix] {
        windHostTypeSet $env(WIND_HOST_TYPE)
    } else {
        windHostTypeSet "x86-win32"
    }	

    if { [info exists env(SETUP_ANS_FILE)] } {
	puts "Use Setup Answer file"
	
	set ctrlVals(useInputScript) 1
	if { [info exists env(SETUP_LOG_FILE)] } {
	    set autoSetupLogFile $env(SETUP_LOG_FILE)
	} else {
	    set autoSetupLogFile "c:\\autoSetup.log"
	}
	puts "log file is $autoSetupLogFile"

	if { ![file exists $env(SETUP_ANS_FILE)] } {
	    autoSetupLog "Input script $env(SETUP_ANS_FILE) not exists!\n"
	    return -1
	}
	if [catch {source $env(SETUP_ANS_FILE)} e] {
	    append logMsg "Error in sourcing $env(SETUP_ANS_FILE)\n"
	    return -1
	}
    } 

    openSetupDebugLog

    set ctrlVals(bbrdList) ""
    set ctrlVals(bbrdW) 400
    set ctrlVals(bbrdH) 300
    set ctrlVals(numBbrd) 1
    set ctrlVals(volatileFrm) ""
    set ctrlVals(meterWg) ""
    set ctrlVals(meterTagWg) ""
    set ctrlVals(mainWindow) "wizardDialog"
    set ctrlVals(backgroundWindow) "backgroundWindow"
    set ctrlVals(parentDialog) ""

    load [cdromBinDirGet]/SETUPTCL[string toupper [info sharedlibextension]]

    if {![isUnix]} {
        if ![catch {setupSysDirGet} dir] {
            sysDirSet $dir
        } else {
            puts "\tCannot determine system directory: $dir"
        }
    }

    # Detect if the user has admin privileges
    set ctrlVals(admin) [setupRunningAsAdmin]

    # Detect the version of windows we are running

    if [catch {setupWinVerGet} ctrlVals(version)] {
        exitWithMessage "Detected an unsupported platform,\naborting setup"
    } else {
        if {($ctrlVals(version) == "NT3x") || ($ctrlVals(version) == "NT4x")} {
            set ctrlVals(NT) 1
        } else {
            set ctrlVals(NT) 0   
        } 
    }    

    # set this value here, need ctrlVals(version) to be set first
    
    set ctrlVals(dlgImage) [cdFileNameGet \
                [file join RESOURCE BITMAPS DIALOG.BMP]]

    # Get a list of existing groups in the program manager

    set ctrlVals(folders) ""
    if [catch {setupExistingFoldersGet 1} userFolder] {
         dbgputs "Cannot get user folder: $userFolder"
         set userFolder ""
    }
    if [catch {setupExistingFoldersGet 0} commonFolder] {
         dbgputs "Cannot get common folder: $commonFolder"
         set commonFolder ""
    }

    set folderList [lsort [split "$commonFolder$userFolder" "\n\r"]]
    foreach folder $folderList {
        if {"$folder" != ""} {
            lappend ctrlVals(folders) $folder
        }
    }

    # check for Setup display options

    if {[info exists env(SETUP_LIMITCOLORS)]} {
        if {$env(SETUP_LIMITCOLORS) == 1} {
            set env(SETUP_REMOVEBACKGROUND) 1
        }
    }

    return 1
}

#############################################################################
#
# autoSetupLog - put message in setup log file for test automation
#
# This procedure will put message in setup log file for test automation
#
# SYNOPSIS
# .tS
# autoSetupLog <msg>
# .tE
#
# PARAMETERS:
# .IP msg 
# message to be inserted in setup log file for test automation
#
# RETURNS: N/A
#
# ERRORS: -1 if unsuccessful
#

proc autoSetupLog {msg} {
    global autoSetupLogFile

    if [catch {open $autoSetupLogFile a+} file] {
	puts "Error in writing $autoSetupLogFile"
	return -1
    }
    puts $file "[getDate]: $msg"
    close $file
}

#############################################################################
#
# patchCheck - check if patches need to be applied to UNIX user systems
#
# This procedure will check if patches need to be applied to UNIX user systems
#
# SYNOPSIS
# .tS
# patchCheck
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc patchCheck {} {
    global setupVals
    global ctrlVals
    global env


    if {[isUnix]} {
        # bypass patch checking for test automation
        # test automation

        if {$ctrlVals(useInputScript)} {
	    autoSetupLog "Unix patch checking: Skipped"
            return 1
        }

        searchAndProcessSection CheckPatch [cdFileNameGet \
            [file join RESOURCE INF TORNADO.INF]]
        if {$setupVals(uninstalledPatches_required) != ""} {

            set patchText [strTableGet 5000_PATCHES_REQUIRED_TEXT]
	    set patchinfoText \
		[strTableGet 5003_PATCHES_REQUIRED_FORMATTED_TEXT]
            append patchText $setupVals(uninstalledPatches_required)
            append patchinfoText $setupVals(uninstalledPatches_required)

            if {$setupVals(uninstalledPatches_recommended) != ""} {
                append patchText [strTableGet 5001_PATCHES_RECOMMENDED_TEXT] 
                append patchText $setupVals(uninstalledPatches_recommended)
                append patchinfoText \
		    [strTableGet 5004_PATCHES_RECOMMENDED_FORMATTED_TEXT] 
                append patchinfoText $setupVals(uninstalledPatches_recommended)
	    }

	    if {$env(WIND_HOST_TYPE)=="sun4-solaris2"} {
                append patchText [strTableGet 5006_PATCHES_SUN_LOCATION]
                append patchinfoText [strTableGet 5006_PATCHES_SUN_LOCATION]
	    } elseif {$env(WIND_HOST_TYPE)=="parisc-hpux10"} {
                append patchText [strTableGet 5007_PATCHES_HP_LOCATION]
                append patchinfoText [strTableGet 5007_PATCHES_HP_LOCATION]
	    }

	    append patchText [strTableGet 5008_PATCHES_UPDATE]
	    append patchinfoText [strTableGet 5009_PATCHES_UPDATE_FORMATTED]
	   
	    # write patch info to TMP/patchinfo to be printed to the
	    # console later.  This will allow the user to cut and
	    # paste information since cut and paste is not allowed from
	    # a messagebox.
	    set patchfile "$env(TMP)/patchinfo"
            set patchfileId [open $patchfile w]
	    puts $patchfileId $patchinfoText
	    close $patchfileId
	    
	    append patchText "\nNote: This message will also be reprinted to\
	                      your shell when you exit."
            append patchText "\n\nWould you prefer to continue with SETUP?\n\n\
	                      If you click the Yes button, SETUP will proceed\
			      with installation.  However, this may cause\
			      SETUP and/or your system to become unstable, and\
			      we strongly recommend that you install the\
			      patches before proceeding.  (If you know that\
			      you have installed patches that supercede or\
			      are equal to those listed above, it should be\
			      safe to continue.)  SETUP will exit if\
			      you click the No button."
            set result [messageBox -yesno -stopicon $patchText]
	    if {$result == "no"} {
                return 0
	    }
        } elseif {$setupVals(uninstalledPatches_recommended) != ""} {
            set patchText [strTableGet 5002_PATCHES_RECOMMENDED_TEXT]
            append patchText $setupVals(uninstalledPatches_recommended)
            set patchinfoText \
		[strTableGet 5005_PATCHES_RECOMMENDED_FORMATTED_TEXT]
            append patchinfoText $setupVals(uninstalledPatches_recommended)
	    
	    if {$env(WIND_HOST_TYPE)=="sun4-solaris2"} {
                append patchText [strTableGet 5006_PATCHES_SUN_LOCATION]
                append patchinfoText [strTableGet 5006_PATCHES_SUN_LOCATION]
	    } elseif {$env(WIND_HOST_TYPE)=="parisc-hpux10"} {
                append patchText [strTableGet 5007_PATCHES_HP_LOCATION]
                append patchinfoText [strTableGet 5007_PATCHES_HP_LOCATION]
	    }

	    append patchText [strTableGet 5008_PATCHES_UPDATE]
	    append patchinfoText [strTableGet 5009_PATCHES_UPDATE_FORMATTED]
	    
	    # write patch info to TMP/patchinfo to be printed to the
	    # console later.  This will allow the user to cut and
	    # paste information since cut and paste is not allowed from
	    # a messagebox.

	    set patchfile "$env(TMP)/patchinfo"
            set patchfileId [open $patchfile w]
	    puts $patchfileId $patchinfoText
	    close $patchfileId

	    append patchText "\nNote: This message will also be reprinted to\
	                      your shell when you exit SETUP."
            messageBox $patchText
        }
    } elseif {![windowsSystemCheck]} {
        return 0
    } 
    return 1
}

###########################################################################
#
# INSTW32.TCL - Initialization code
#
# This code is executed when the file is sourced. It does all the 
# necessary initialization to start the Setup program.
#

applicationTitleSet "Setup"
 
if {[globalInit] != "1"} {
    return 0
}

# parse command line to see whether we are running in 
# INSTALL, LICENSE, or ICONINSTALL mode

if {[parseCmdLine [lrange $argv 1 [expr [llength $argv] - 1]]]} {
    return 0
}

set WIND_HOST_TYPE [windHostTypeGet]

if {$WIND_HOST_TYPE == "x86-win32"} {
    dllLoad  [cdFileNameGet [file join X86 WIN32 UITCLCONTROLS.DLL]] \
              _UITclControls_Init
} elseif {$WIND_HOST_TYPE == "sun4-solaris2"} {
    dllLoad  [tmpDirGet]/libuitclcontrols.so _UITclControls_Init
} elseif {$WIND_HOST_TYPE == "parisc-hpux10"} {
    dllLoad  [tmpDirGet]/libuitclcontrols.sl _UITclControls_Init
}

set file [cdFileNameGet [file join RESOURCE TCL INSTALL.TCL]]
source $file
set file [cdFileNameGet [file join RESOURCE TCL MESSAGES.TCL]]
source $file
set file [cdFileNameGet [file join RESOURCE TCL CONFIG.TCL]]
source $file
set file [cdFileNameGet [file join RESOURCE TCL INF.TCL]]
source $file
set helpTclFile [cdFileNameGet [file join RESOURCE TCL HELPW32.TCL]]
if [file exists $helpTclFile] {
    source $helpTclFile
}

# source all wizard page files

set allWizardPages "\
WELCOME README LICAGREE PROJINFO PRVLEGE REGISTER CHOICE DESTDIR COMPSLCT \
FOLDER PERMISSN FILECOPY LIBUPDTE REGISTRY COMPTBLE REGHOST REGDLL \
SYSCONFG FINISH ICONFIN"

foreach wizardPage $allWizardPages {
    source [cdFileNameGet [file join RESOURCE TCL $wizardPage.TCL]]
}

set setupVals(CDnumber) [cdNameGet number]
set setupVals(CDdescription) [cdNameGet description]
set setupVals(setupHelp) [cdFileNameGet  [file join RESOURCE HELP SETUP.HLP]]
set winFullInstPages {projectInfo destDir compSelect folderSelect torRegistry \
                      remoteRegistryHost compatibility howTo filesCopy \
                      libUpdate regTornado systemConfig finish}
set winPrgGrpPages {destDir folderSelect torRegistry remoteRegistryHost \
                    regTornado iconFinish}

if ![constructPages [instTypeGet]] {
    return 0    
}

# check for required patches

if {![patchCheck]} {
    return 0
}

applicationStart
