# INCLUDE.TCL - Setup procedures common to both INSTW32.TCL and UNINST.TCL
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01a,27jan99,tcy  extracted from INSTW32.TCL, INSTALL.TCL and UNINST.TCL.
#

#############################################################################
#
# isUnix - determine whether host platform is Unix or not
#
# This procedure will determine whether host platform is Unix or not
#
# SYNOPSIS
# .tS
# isUnix
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if host platform is not Unix
#          1 if host platform is Unix
#
# ERRORS: N/A
#

proc isUnix {} {
    global env

    if {[info exists env(WIND_HOST_TYPE)]} {
        if {[string match sun4* $env(WIND_HOST_TYPE)]} {
            return 1;
        } elseif {[string match parisc* $env(WIND_HOST_TYPE)]} {
            return 1;
        } else {
            return 0;
        }
    } else {
        return [info exists env(MWHOME)]
    }
}

#############################################################################
#
# dosToUnix - convert backward slashes to forward slashes
#
# This procedure will convert backward slashes to forward slashes
#
# SYNOPSIS
# .tS
# dosToUnix <path>
# .tE
#
# PARAMETERS:
# .IP path
# path with slashes
#
# RETURNS: new path with forward slashes
#
# ERRORS: N/A
#

proc dosToUnix {path} {
    regsub -all {\\} $path {/} newpath
    return $newpath
}

#############################################################################
#
# unixToDos - convert forward slashes to backward slashes
#
# This procedure will convert forward slashes to backward slashes
#
# SYNOPSIS
# .tS
# unixToDos <path>
# .tE
#
# PARAMETERS:
# .IP path
# path with slashes
#
# RETURNS: new path with backward slashes
#
# ERRORS: N/A
#

proc unixToDos {path} {
    regsub -all {/} $path {\\} newpath
    return $newpath
}

#############################################################################
#
# getDate - return the current date time stamp
#
# This procedure will return the current date time stamp
#
# SYNOPSIS
# .tS
# getDate
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: return the current date time stamp
#
# ERRORS: N/A
#

proc getDate {} {
    return [clock format [clock second] -format "%d-%b-%y.%H:%M"]
}

##############################################################################
#
# fileNameAbbreviate - shorten the filename for GUI displaying purpose
#
# This procedure shorten filename if it's longer than <length> chars.  The 
# shorten filename will be in the form firstDir/.../lastDir/fileName.  
# There is no warranty that the resulted filename will be any shorter than 
# the original one.
#
# SYNOPSIS
# fileNameAbbreviate <fileName> <length>
#
# PARAMETERS:
#    fileName : a path filename
#    length : length of the filename
#
# RETURNS: shorten filename
#
# ERRORS: N/A
#

proc fileNameAbbreviate {fileName length} {
    set shortName $fileName

    if {[string length $fileName] > $length} {
        if [regexp {(^[^/]+)/.*/([^/]+/[^/]+$)} $fileName junk\
                 firstPart lastPart] {
            set shortName "$firstPart/.../$lastPart"
        }
    }
    return $shortName
}
