# FOLDER.TCL  - Setup procedures for implementing folder wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01f,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01e,22mar99,bjl  remove backward compatibility pages if tornado not 
#                  installed.
# 01d,19mar99,wmd  Output to a file any debug messages.
# 01c,01feb99,tcy  prevent user from installing T2 into T101 folder
# 01b,27jan99,tcy  changed default folder name to "Tornado2" 
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(folderSelect) - display existing folders for Tornado installation
#                            and prompt for Tornado folder name
#
# This procedure will display existing folders for Tornado installation
# and prompt for Tornado folder name
#
# SYNOPSIS
# .tS
# pageCreate(folderSelect)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(folderSelect) {} {
    global ctrlVals
    global setupVals

    set ctrlVals(volatileFrm) [list \
                [list label -name msg1 \
                            -title [strTableGet 1161_FOLDER_SELECT]\
                            -x 100 -y 10 -w 205 -h 27] \
                [list label -name msg2 -title "&Program Folder:" \
                            -x 100 -y 43 -w 85 -h 10] \
                [list text -name folderName -border \
                           -callback onFolderName \
                           -x 100 -y 53 -w 205 -h 12] \
                [list label -name msg3 -title "E&xisting Folders:" \
                            -x 100 -y 73 -w 85 -h 10] \
                [list list -name folderList \
                           -callback onFolderSelect \
                           -x 100 -y 83 -w 205 -h 87] \
    ]

    set w [dlgFrmCreate [strTableGet 1560_TITLE_FOLDER]]

    controlValuesSet $w.folderName [folderValueReadFromRegistry]
    controlValuesSet $w.folderList $ctrlVals(folders)
    controlFocusSet $w.folderName

    # test automation

    if { $ctrlVals(useInputScript) } {
        controlValuesSet $w.folderName $setupVals(folder)
        autoSetupLog "Folder Selection page:"
        autoSetupLog "\tSelected folder: $setupVals(folder)"
        nextCallback
    }
}

#############################################################################
#
# pageProcess(folderSelect) - process inputs from folderSelect page
#
# This procedure will process inputs from folderSelect page
#
# SYNOPSIS
# .tS
# pageProcess(folderSelect)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if folder name contains spaces
#          1 if folder name does not contain spaces
#
# ERRORS: N/A
#

proc pageProcess(folderSelect) {} {
    global ctrlVals
    global setupVals
    global tornadoInstalled
    global infVals

    set retVal 0
    if {[instTypeGet] != "icon"} {
        foreach prodIndex [cdInfoGet selectedProdIndexList] {
            set productName [productInfoGet name $prodIndex]
            if {$productName == "tornado"||$productName == "tornado-vxsim"} {
                set tornadoInstalled 1
            }
        }
    }

    if ![info exists tornadoInstalled] {
        pageRemove torRegistry
        pageRemove remoteRegistryHost
        pageRemove regTornado
        pageRemove compatibility
        pageRemove howTo
    }

    defGroupSet [controlValuesGet $ctrlVals(mainWindow).folderName]

    if {[regexp {^[ ]*$} [defGroupGet] junk]} {
        messageBox [strTableGet 1162_FOLDER_SELECT]
    } else {
        set retVal 1
    }

    if {[portMapperIconExist \
        [controlValuesGet $ctrlVals(mainWindow).folderName]] == 1} {
        messageBox "Setup has detected that the folder name you selected\
                    contains icons belonging to previous version of Tornado.\
                    Please select another folder name."
        set retVal 0
    } else {
        set retVal 1
    }

    set infVals(addFolder) 1
    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    queueExecute
    set infVals(addFolder) 0
    return $retVal
}

#############################################################################
#
# onFolderName - set the default folder name when text is changed
#
# This procedure will set the default folder name when text is changed
#
# SYNOPSIS
# .tS
# onFolderName
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFolderName {} {
    global ctrlVals
    global setupVals

    defGroupSet [controlValuesGet $ctrlVals(mainWindow).folderName]
}

#############################################################################
#
# onFolderSelect - set the value in edit box when a folder name is selected
#                  from the folder list
#
# This procedure will set the value in edit box when a folder name is selected
# from the folder list
#
# SYNOPSIS
# .tS
# onFolderSelect
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFolderSelect {} {
    global ctrlVals

    controlValuesSet $ctrlVals(mainWindow).folderName \
        [controlSelectionGet $ctrlVals(mainWindow).folderList -string]
}

#############################################################################
#
# folderValueReadFromRegistry - read folder value from the Windows registry
#
# This procedure will read folder value from the Windows registry
#
# SYNOPSIS
# .tS
# folderValueReadFromRegistry
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc folderValueReadFromRegistry {} {
    global setupVals

    # Load folder from the previous installation if any

    if {"[defGroupGet]" == ""} {
        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                 "Software\\$setupVals(WRS)" "folder"} folder]} {
            defGroupSet $folder
        } else {
            defGroupSet "Tornado2"
        }
    }

    return [defGroupGet]
}

#############################################################################
#
# portMapperIconExist - determine if the given folder contains portMapper icon
#
# This procedure will determine if the given folder contains portMapper icon
#
# SYNOPSIS
# .tS
# portMapperIconExist
# .tE
#
# PARAMETERS:
# <folder>
# program folder name
#
# RETURNS: 1 if portmapper exists
#          0 if portmapper does not exist
#
# ERRORS: N/A
#

proc portMapperIconExist {folder} {
    
    # look for portmapper icon to determine if the last
    # installation is of T101

    if ![catch {programPathGet 0} error] {
        set commonProgramPath [programPathGet 0]
    } else {
        dbgputs "$error"
    }
    if ![catch {programPathGet 0} error] {
        set userProgramPath [programPathGet 1]
    } else {
        dbgputs "$error"
    }

    if {[file exists "$commonProgramPath\\$folder\\Portmapper.lnk"] ||\
        [file exists "$userProgramPath\\$folder\\Portmapper.lnk"]} { 
        return 1
    } else {
        return 0
    }
}
