# FINISH.TCL  - Setup procedures for implementing finish wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01d,27apr99,bjl  workaround to allow user to press Return to exit 
#                  on Unix (spr 27072).
# 01c,24mar99,tcy  moved code to open program folder here
# 01b,28jan99,tcy  moved system configuration code to SYSCONFG.TCL.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(finish) - display list of installed products
#
# This procedure will display list of installed products and serve as
# the last wizard page
#
# SYNOPSIS
# .tS
# pageCreate(finish)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(finish) {} {
    global ctrlVals
    global setupVals
    global tornadoInstalled
    global env

    exitMsgSet "[strTableGet 1210_FINISH]"

    # Warn the user in case of error during the setup

    if {[errorCountGet] > 0} {
        exitMsgSet "[exitMsgGet]  [strTableGet 1200_FINISH_WARN]"
    }

    set title ""
    if [info exists setupVals(confirmation)] {
        foreach product $setupVals(confirmation) {
            append title [format "%s\r\n" $product]
        }
    }
    set ctrlVals(volatileFrm) [list \
                       [list label -name finishText \
                                -title [exitMsgGet]\
                                -x 100 -y 10 -w 206 -h 24] \
                [list text -name productList -border -vscroll \
                                -multiline -readonly \
                            -x 100 -y 60 -width 206 -height 111] ]

    set w [dlgFrmCreate "Finish"]

    controlTextSet $w.productList $title
    controlValuesSet $w.nextButt "OK"
    controlEnable $w.backButt 0
    controlEnable $w.nextButt 1
    controlEnable $w.cancelButt 0

    # the following is to workaround a bug in UITclSh: 
    # if the user presses Return for the OK button, 
    # UITclSh does not exit.

    if {[isUnix]} {
        controlPropertySet $w.nextButt -defaultbutton 0
        controlFocusSet $w.cancelButt
    } else {
        controlFocusSet $w.nextButt
    }

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Finish page:"
        autoSetupLog "\t[exitMsgGet]"
        nextCallback
    }

}

#############################################################################
#
# pageProcess(finish) - process inputs from finish page if any
#
# This procedure will process inputs from finish page if any
#
# SYNOPSIS
# .tS
# pageProcess(finish)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(finish) {} {

    global ctrlVals

    # add call to open up program group for windows only

    if {![isUnix]} {
        # display common program group

        set prgGrp [programPathGet 1]
        if {$prgGrp == "" || $ctrlVals(admin) != "1"} {
            # display common user group

            set prgGrp [programPathGet 0]
        }
        if {$prgGrp != ""} {
            set path [file join $prgGrp [defGroupGet]]
            set path [unixToDos $path]
            catch {exec explorer $path} err
        }
    }

    # remove setup.log.abort

    catch {file delete [destDirGet]/setup.log.abort}

    return 1
}
