/*
 *  ----------------------------------------------------------------------------
 *  This file was automatically generated by SWIG (http://www.swig.org).
 *  Version: 1.3.19
 *
 *  Do not make changes to this file unless you know what you are doing--modify
 *  the SWIG interface file instead.
 *  -----------------------------------------------------------------------------
 */
package com.sleepycat.db;

/**
 *  The DbEnv object is the handle for a Berkeley DB environment -- a collection
 *  including support for some or all of caching, locking, logging and
 *  transaction subsystems, as well as databases and log files. Methods off the
 *  DbEnv handle are used to configure the environment as well as to operate on
 *  subsystems and databases in the environment.</p> <p>
 *
 *  DbEnv handles are free-threaded if the {@link com.sleepycat.db.Db#DB_THREAD
 *  Db.DB_THREAD} flag is specified to the {@link com.sleepycat.db.DbEnv#open
 *  DbEnv.open} method when the environment is opened. The DbEnv handle should
 *  not be closed while any other handle remains open that is using it as a
 *  reference (for example, {@link com.sleepycat.db.Db Db} or {@link
 *  com.sleepycat.db.DbTxn DbTxn}). Once either the {@link
 *  com.sleepycat.db.DbEnv#close DbEnv.close} or {@link
 *  com.sleepycat.db.DbEnv#remove DbEnv.remove} methods are called, the handle
 *  may not be accessed again, regardless of the method's return.</p>
 *
 */
public class DbEnv {
    private long swigCPtr;
    /**
     */
    protected boolean swigCMemOwn;


    /**
     *  Constructor for the DbEnv object
     *
     */
    protected DbEnv(long cPtr, boolean cMemoryOwn) {
        swigCMemOwn = cMemoryOwn;
        swigCPtr = cPtr;
    }


    /**
     *  Constructor for the DbEnv object
     */
    protected DbEnv() {
        this(0, false);
    }


    /**
     */
    protected void delete() {
        if (swigCPtr != 0 && swigCMemOwn) {
            swigCMemOwn = false;
        }
        swigCPtr = 0;
    }


    /**
     *  Gets the cPtr attribute of the DbEnv class
     *
     *@return      The cPtr value
     */
    protected static long getCPtr(DbEnv obj) {
        return (obj == null) ? 0 : obj.swigCPtr;
    }


    // Internally, the JNI layer creates a global reference to each DbEnv,
    // which can potentially be different to this.  We keep a copy here so
    // we can clean up after destructors.
    private Object dbenv_ref;
    private DbAppDispatch app_dispatch_handler;
    private DbEnvFeedbackHandler env_feedback_handler;
    private DbErrorHandler error_handler;
    private DbPanicHandler panic_handler;
    private DbRepTransport rep_transport_handler;
    private String errpfx;


    /**
     *
     */
    public static class RepProcessMessage {
        /**
         *  The <b>envid</b> field contains the local identifier of the
         *  environment returned by the DbEnv.replicationProcessMessage method.
         *
         *</ul>
         *
         */
        public int envid;
    }


    // Called by the public DbEnv constructor and for private environments
    // by the Db constructor.
    /**
     */
    void initialize() {
        dbenv_ref = db_java.initDbEnvRef0(this, this);
        // Start with System.err as the default error stream.
        set_error_stream(System.err);
    }


    /**
     */
    void cleanup() {
        swigCPtr = 0;
        db_java.deleteRef0(dbenv_ref);
        dbenv_ref = null;
    }


    /**
     *  The DbEnv.close method closes the Berkeley DB environment, freeing any
     *  allocated resources and closing any underlying subsystems.</p> <p>
     *
     *  The {@link com.sleepycat.db.DbEnv DbEnv} handle should not be closed
     *  while any other handle that refers to it is not yet closed; for example,
     *  database environment handles must not be closed while database handles
     *  remain open, or transactions in the environment have not yet been
     *  committed or aborted. Specifically, this includes {@link
     *  com.sleepycat.db.Db Db}, {@link com.sleepycat.db.Dbc Dbc}, {@link
     *  com.sleepycat.db.DbTxn DbTxn}, {@link com.sleepycat.db.DbLogc DbLogc}
     *  and {@link com.sleepycat.db.DbMpoolFile DbMpoolFile} handles.</p> <p>
     *
     *  Where the environment was initialized with the {@link
     *  com.sleepycat.db.Db#DB_INIT_LOCK Db.DB_INIT_LOCK} flag, calling
     *  DbEnv.close does not release any locks still held by the closing
     *  process, providing functionality for long-lived locks. </p> <p>
     *
     *  Where the environment was initialized with the {@link
     *  com.sleepycat.db.Db#DB_INIT_TXN Db.DB_INIT_TXN} flag, calling
     *  DbEnv.close aborts any unresolved transactions. Applications should not
     *  depend on this behavior for transactions involving Berkeley DB
     *  databases; all such transactions should be explicitly resolved. The
     *  problem with depending on this semantic is that aborting an unresolved
     *  transaction involving database operations requires a database handle.
     *  Because the database handles should have been closed before calling
     *  DbEnv.close, it will not be possible to abort the transaction, and
     *  recovery will have to be run on the Berkeley DB environment before
     *  further operations are done.</p> <p>
     *
     *  Where log cursors were created using the {@link
     *  com.sleepycat.db.DbEnv#logCursor DbEnv.logCursor} method, calling
     *  DbEnv.close does not imply closing those cursors.</p> <p>
     *
     *  In multithreaded applications, only a single thread may call
     *  DbEnv.close.</p> <p>
     *
     *  After DbEnv.close has been called, regardless of its return, the
     *  Berkeley DB environment handle may not be accessed again.</p>
     *
     *@param  flags         currently unused, and must be set to 0.
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public synchronized void close(int flags) throws DbException {
        try {
            close0(flags);
        } finally {
            cleanup();
        }
    }


    /**
     *
     *@return         Description of the Return Value
     */
    private final int handle_app_dispatch(Dbt dbt, DbLsn lsn, int recops) {
        return app_dispatch_handler.appDispatch(this, dbt, lsn, recops);
    }


    /**
     *
     */
    private final void handle_env_feedback(int opcode, int percent) {
        env_feedback_handler.feedback(this, opcode, percent);
    }


    /**
     *
     */
    private final void handle_error(String msg) {
        error_handler.error(this.errpfx, msg);
    }


    /**
     *
     */
    private final void handle_panic(DbException e) {
        panic_handler.panic(this, e);
    }


    /**
     *
     *@return                  Description of the Return Value
     */
    private final int handle_rep_transport(Dbt control, Dbt rec,
            DbLsn lsn, int flags, int envid)
             throws DbException {
        return rep_transport_handler.send(this, control, rec, lsn,
                flags, envid);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockVector(int,int,DbLockRequest[],int,int)}
     */
    public void lock_vec(int locker, int flags, DbLockRequest[] list, int offset, int count) throws DbException {
        lockVector(locker, flags, list, offset, count);
    }


    /**
     *  The DbEnv.lockVector method atomically obtains and releases one or more
     *  locks from the lock table. The DbEnv.lockVector method is intended to
     *  support acquisition or trading of multiple locks under one lock table
     *  semaphore, as is needed for lock coupling or in multigranularity locking
     *  for lock escalation.</p> <p>
     *
     *  If any of the requested locks cannot be acquired, or any of the locks to
     *  be released cannot be released, the operations before the failing
     *  operation are guaranteed to have completed successfully, and
     *  DbEnv.lockVector throws an exception</p>
     *
     *@param  flags                       must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_NOWAIT Db.DB_LOCK_NOWAIT}
     *        <p>
     *
     *        If a lock cannot be granted because the requested lock conflicts
     *        with an existing lock, throw a {@link
     *        com.sleepycat.db.DbLockNotGrantedException
     *        DbLockNotGrantedException} immediately instead of waiting for the
     *        lock to become available. In this case, the index of the request
     *        that was not granted can be found by calling
     *        DbLockNotGrantedException.get_index. </li>
     *      </ul>
     *
     *@param  locker                      an unsigned 32-bit integer quantity.
     *      It represents the entity requesting or releasing the lock.
     *@param  list                        The <b>list</b> array provided to
     *      DbEnv.lockVector is a set of DbLockRequest objects. Only <b>count
     *      </b> elements of <b>list</b> starting at <b>offset</b> are
     *      considered by DbEnv.lockVector. A DbLockRequest object has at least
     *      the following fields: <p>
     *
     *      A DB_LOCKREQ structure has at least the following fields:</p> <p>
     *
     *      The operation to be performed, which must be set to one of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_GET Db.DB_LOCK_GET}<p>
     *
     *        Get the lock defined by the values of the <b>mode</b> and <b>
     *        object</b> structure fields, for the specified <b>locker</b> .
     *        Upon return from DbEnv.lockVector, if the <b>lock</b> field is
     *        non-null, a reference to the acquired lock is stored there. (This
     *        reference is invalidated by any call to DbEnv.lockVector or {@link
     *        com.sleepycat.db.DbEnv#lockPut DbEnv.lockPut} that releases the
     *        lock.) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_GET_TIMEOUT
     *        Db.DB_LOCK_GET_TIMEOUT}<p>
     *
     *        Identical to <code>Db.DB_LOCK_GET</code> except that the value in
     *        the <b>timeout</b> structure field overrides any previously
     *        specified timeout value for this lock. A value of 0 turns off any
     *        previously specified timeout. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_PUT Db.DB_LOCK_PUT}<p>
     *
     *        The lock to which the <b>lock</b> structure field refers is
     *        released. The <b>locker</b> parameter, and <b>mode</b> and <b>
     *        object</b> fields are ignored. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_PUT_ALL
     *        Db.DB_LOCK_PUT_ALL}<p>
     *
     *        All locks held by the specified <b>locker</b> are released. The
     *        <b>lock</b> , <b>mode</b> , and <b>object</b> structure fields are
     *        ignored. Locks acquired in operations performed by the current
     *        call to DbEnv.lockVector which appear before the <code>Db.DB_LOCK_PUT_ALL</code>
     *        operation are released; those acquired in operations appearing
     *        after the <code>Db.DB_LOCK_PUT_ALL</code> operation are not
     *        released. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_PUT_OBJ
     *        Db.DB_LOCK_PUT_OBJ}<p>
     *
     *        All locks held on <b>object</b> are released. The <b>locker</b>
     *        parameter and the <b>lock</b> and <b>mode</b> structure fields are
     *        ignored. Locks acquired in operations performed by the current
     *        call to DbEnv.lockVector that appear before the <code>Db.DB_LOCK_PUT_OBJ</code>
     *        operation are released; those acquired in operations appearing
     *        after the <code>Db.DB_LOCK_PUT_OBJ</code> operation are not
     *        released. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_TIMEOUT
     *        Db.DB_LOCK_TIMEOUT}<p>
     *
     *        Cause the specified <b>locker</b> to timeout immediately. If the
     *        database environment has not configured automatic deadlock
     *        detection, the transaction will timeout the next time deadlock
     *        detection is performed. As transactions acquire locks on behalf of
     *        a single locker ID, timing out the locker ID associated with a
     *        transaction will time out the transaction itself. </li>
     *      </ul>
     *      A lock reference. <p>
     *
     *      The lock mode, used as an index into the environment's lock conflict
     *      matrix. When using the default lock conflict matrix, <b>mode</b>
     *      must be set to one of the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_READ Db.DB_LOCK_READ}<p>
     *
     *        read (shared) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_WRITE Db.DB_LOCK_WRITE}<p>
     *
     *        write (exclusive) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_IWRITE Db.DB_LOCK_IWRITE}
     *        <p>
     *
     *        intention to write (shared) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_IREAD Db.DB_LOCK_IREAD}<p>
     *
     *        intention to read (shared) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_IWR Db.DB_LOCK_IWR}<p>
     *
     *        intention to read and write (shared) </li>
     *      </ul>
     *      See {@link com.sleepycat.db.DbEnv#setLockConflicts
     *      DbEnv.setLockConflicts} and <a
     *      href="{@docRoot}/../ref/lock/stdmode.html">Standard Lock Modes</a>
     *      for more information on the lock conflict matrix.</p> <p>
     *
     *      An untyped byte string that specifies the object to be locked or
     *      released. Applications using the locking subsystem directly while
     *      also doing locking via the Berkeley DB access methods must take care
     *      not to inadvertently lock objects that happen to be equal to the
     *      unique file IDs used to lock files. See <a
     *      href="{@docRoot}/../ref/lock/am_conv.html">Access method locking
     *      conventions</a> for more information. <p>
     *
     *      The lock timeout value.
     *@throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock, the
     *      DbEnv.lockVector method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException} exception.
     *@throws  DbLockNotGrantedException  If a Berkeley DB Concurrent Data Store
     *      database environment configured for lock timeouts was unable to
     *      grant a lock in the allowed time, the DbEnv.lockVector method will
     *      fail and throw a {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  DbLockNotGrantedException  If the {@link
     *      com.sleepycat.db.Db#DB_LOCK_NOWAIT Db.DB_LOCK_NOWAIT} flag or lock
     *      timers were configured and the lock could not be granted before the
     *      wait-time expired, the DbEnv.lockVector method will fail and throw a
     *      {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  IllegalArgumentException   The DbEnv.lockVector method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     *@throws  DbMemoryException          If the maximum number of locks has
     *      been reached, the DbEnv.lockVector method will fail and throw a
     *      {@link com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     */
    public void lockVector(int locker, int flags, DbLockRequest[] list, int offset, int count) throws DbException {

        db_javaJNI.DbEnv_lock_vec(swigCPtr, locker, flags, list,
                offset, count);
    }


    /**
     *  The DbEnv.open method opens a Berkeley DB environment. It provides a
     *  structure for creating a consistent environment for processes using one
     *  or more of the features of Berkeley DB.</p>
     *
     *@param  db_home                            the database environment's home
     *      directory. For more information on <b>db_home</b> , and filename
     *      resolution in general, see <a
     *      href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming</a>
     *      . The environment variable <b>DB_HOME</b> may be used as the path of
     *      the database home, as described in <a
     *      href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming</a>
     *      .
     *@param  flags                              specifies the subsystems that
     *      are initialized and how the application's environment affects
     *      Berkeley DB file naming, among other things. The <b>flags</b>
     *      parameter must be set to 0 or by bitwise inclusively <b>OR</b> 'ing
     *      together one or more of the following values: <p>
     *
     *      Because there are a large number of flags that can be specified,
     *      they have been grouped together by functionality. The first group of
     *      flags indicates which of the Berkeley DB subsystems should be
     *      initialized:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_JOINENV Db.DB_JOINENV}<p>
     *
     *        Join an existing environment. This option allows applications to
     *        join an existing environment without knowing which Berkeley DB
     *        subsystems the environment supports. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_CDB Db.DB_INIT_CDB}<p>
     *
     *        Initialize locking for the <a
     *        href="{@docRoot}/../ref/cam/intro.html">Berkeley DB Concurrent
     *        Data Store</a> product. In this mode, Berkeley DB provides
     *        multiple reader/single writer access. The only other subsystem
     *        that should be specified with the <code>Db.DB_INIT_CDB</code> flag
     *        is <code>Db.DB_INIT_MPOOL</code>. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_LOCK Db.DB_INIT_LOCK}<p>
     *
     *        Initialize the locking subsystem. This subsystem should be used
     *        when multiple processes or threads are going to be reading and
     *        writing a Berkeley DB database, so that they do not interfere with
     *        each other. If all threads are accessing the database(s)
     *        read-only, locking is unnecessary. When the <code>Db.DB_INIT_LOCK</code>
     *        flag is specified, it is usually necessary to run a deadlock
     *        detector, as well. See <a href="{@docRoot}/../utility/db_deadlock.html">
     *        db_deadlock</a> and {@link com.sleepycat.db.DbEnv#lockDetect
     *        DbEnv.lockDetect} for more information. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_LOG Db.DB_INIT_LOG}<p>
     *
     *        Initialize the logging subsystem. This subsystem should be used
     *        when recovery from application or system failure is necessary. If
     *        the log region is being created and log files are already present,
     *        the log files are reviewed; subsequent log writes are appended to
     *        the end of the log, rather than overwriting current log entries.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_MPOOL Db.DB_INIT_MPOOL}<p>
     *
     *        Initialize the shared memory buffer pool subsystem. This subsystem
     *        should be used whenever an application is using any Berkeley DB
     *        access method. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_REP Db.DB_INIT_REP}<p>
     *
     *        Initialize the replication subsystem. This subsystem should be
     *        used whenever an application plans on using replication. The
     *        <code>Db.DB_INIT_REP</code> flag requires the <code>Db.DB_INIT_TXN</code>
     *        and <code>Db.DB_INIT_LOCK</code> flags also be configured. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_INIT_TXN Db.DB_INIT_TXN}<p>
     *
     *        Initialize the transaction subsystem. This subsystem should be
     *        used when recovery and atomicity of multiple operations are
     *        important. The <code>Db.DB_INIT_TXN</code> flag implies the <code>Db.DB_INIT_LOG</code>
     *        flag. </li>
     *      </ul>
     *      The second group of flags govern what recovery, if any, is performed
     *      when the environment is initialized:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RECOVER Db.DB_RECOVER}<p>
     *
     *        Run normal recovery on this environment before opening it for
     *        normal use. If this flag is set, the <code>Db.DB_CREATE</code>
     *        flag must also be set because the regions will be removed and
     *        re-created. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RECOVER_FATAL
     *        Db.DB_RECOVER_FATAL}<p>
     *
     *        Run catastrophic recovery on this environment before opening it
     *        for normal use. If this flag is set, the <code>Db.DB_CREATE</code>
     *        flag must also be set because the regions will be removed and
     *        re-created. </li>
     *      </ul>
     *      A standard part of the recovery process is to remove the existing
     *      Berkeley DB environment and create a new one in which to perform
     *      recovery. If the thread of control performing recovery does not
     *      specify the correct region initialization information (for example,
     *      the correct memory pool cache size), the result can be an
     *      application running in an environment with incorrect cache and other
     *      subsystem sizes. For this reason, the thread of control performing
     *      recovery should specify correct configuration information before
     *      calling the DbEnv.open method; or it should remove the environment
     *      after recovery is completed, leaving creation of the correctly sized
     *      environment to a subsequent call to DbEnv.open.</p> <p>
     *
     *      All Berkeley DB recovery processing must be single-threaded; that
     *      is, only a single thread of control may perform recovery or access a
     *      Berkeley DB environment while recovery is being performed. Because
     *      it is not an error to specify Db.DB_RECOVER for an environment for
     *      which no recovery is required, it is reasonable programming practice
     *      for the thread of control responsible for performing recovery and
     *      creating the environment to always specify the Db.DB_CREATE and
     *      Db.DB_RECOVER flags during startup.</p> <p>
     *
     *      The DbEnv.open function returns successfully if Db.DB_RECOVER or
     *      Db.DB_RECOVER_FATAL is specified and no log files exist, so it is
     *      necessary to ensure that all necessary log files are present before
     *      running recovery. For further information, consult <a
     *      href="{@docRoot}/../utility/db_archive.html">db_archive</a> and <a
     *      href="{@docRoot}/../utility/db_recover.html">db_recover</a> .</p>
     *      <p>
     *
     *      The third group of flags govern file-naming extensions in the
     *      environment:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_USE_ENVIRON Db.DB_USE_ENVIRON}
     *        <p>
     *
     *        The Berkeley DB process' environment may be permitted to specify
     *        information to be used when naming files; see <a
     *        href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming
     *        </a>. Because permitting users to specify which files are used can
     *        create security problems, environment information will be used in
     *        file naming for all users only if the <code>Db.DB_USE_ENVIRON</code>
     *        flag is set. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_USE_ENVIRON_ROOT
     *        Db.DB_USE_ENVIRON_ROOT}<p>
     *
     *        The Berkeley DB process' environment may be permitted to specify
     *        information to be used when naming files; see <a
     *        href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming
     *        </a>. Because permitting users to specify which files are used can
     *        create security problems, if the <code>Db.DB_USE_ENVIRON_ROOT</code>
     *        flag is set, environment information will be used for file naming
     *        only for users with appropriate permissions (for example, users
     *        with a user-ID of 0 on UNIX systems). </li>
     *      </ul>
     *      Finally, there are a few additional unrelated flags:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CREATE Db.DB_CREATE}<p>
     *
     *        Cause Berkeley DB subsystems to create any underlying files, as
     *        necessary. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCKDOWN Db.DB_LOCKDOWN}<p>
     *
     *        Lock shared Berkeley DB environment files and memory-mapped
     *        databases into memory. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PRIVATE Db.DB_PRIVATE}<p>
     *
     *        Specify that the environment will only be accessed by a single
     *        process (although that process may be multithreaded). This flag
     *        has two effects on the Berkeley DB environment. First, all
     *        underlying data structures are allocated from per-process memory
     *        instead of from shared memory that is potentially accessible to
     *        more than a single process. Second, mutexes are only configured to
     *        work between threads. <p>
     *
     *        This flag should not be specified if more than a single process is
     *        accessing the environment because it is likely to cause database
     *        corruption and unpredictable behavior. For example, if both a
     *        server application and the Berkeley DB utility <a
     *        href="{@docRoot}/../utility/db_stat.html">db_stat</a> are expected
     *        to access the environment, the <code>Db.DB_PRIVATE</code> flag
     *        should not be specified.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SYSTEM_MEM Db.DB_SYSTEM_MEM}<p>
     *
     *        Allocate memory from system shared memory instead of from memory
     *        backed by the filesystem. See <a
     *        href="{@docRoot}/../ref/env/region.html">Shared Memory Regions</a>
     *        for more information. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD}<p>
     *
     *        Cause the {@link com.sleepycat.db.DbEnv DbEnv} handle returned by
     *        DbEnv.open to be <i>free-threaded</i> ; that is, usable by
     *        multiple threads within a single address space. <p>
     *
     *        Threading is always assumed in the Java API, so no special flags
     *        are required and Berkeley DB functions will always behave as if
     *        the <code>Db.DB_THREAD</code> flag was specified.</p> </li>
     *      </ul>
     *
     *@param  mode                               On UNIX systems or in IEEE/ANSI
     *      Std 1003.1 (POSIX) environments, all files created by Berkeley DB
     *      are created with mode <b>mode</b> (as described in <b>chmod</b> (2))
     *      and modified by the process' umask value at the time of creation
     *      (see <b>umask</b> (2)). If <b>mode</b> is 0, Berkeley DB will use a
     *      default mode of readable and writable by both owner and group. On
     *      Windows systems, the mode parameter is ignored. The group ownership
     *      of created files is based on the system and directory defaults, and
     *      is not further specified by Berkeley DB.
     *@throws  DbException                       The DbEnv.open method may fail
     *      and throw {@link com.sleepycat.db.DbException DbException},
     *      encapsulating a non-zero error, for the following conditions:
     *      <li> The shared memory region was locked and (repeatedly)
     *      unavailable.
     *      <li> HP-UX only: a previously created Berkeley DB environment for
     *      this process still exists.
     *@throws  IllegalArgumentException          The DbEnv.open method will fail
     *      and throw a IllegalArgumentException exception if the Db.DB_THREAD
     *      flag was specified and fast mutexes are not available for this
     *      architecture; The DB_HOME or TMPDIR environment variables were set,
     *      but empty; An incorrectly formatted <b>NAME VALUE</b> entry or line
     *      was found; or if an invalid flag value or parameter was specified.
     *@throws  FileNotFoundException             If the file or directory does
     *      not exist, the DbEnv.open method will fail and throw a
     *      FileNotFoundException exception.
     */
    public void open(String db_home, int flags, int mode) throws DbException, java.io.FileNotFoundException {

        /*
         *  Java is always threaded
         */
        flags |= Db.DB_THREAD;
        open0(db_home, flags, mode);
    }


    /**
     *  The DbEnv.remove method destroys a Berkeley DB environment if it is not
     *  currently in use. The environment regions, including any backing files,
     *  are removed. Any log or database files and the environment directory are
     *  not removed.</p> <p>
     *
     *  If there are processes that have called {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} without calling {@link
     *  com.sleepycat.db.DbEnv#close DbEnv.close} (that is, there are processes
     *  currently using the environment), DbEnv.remove will fail without further
     *  action unless the {@link com.sleepycat.db.Db#DB_FORCE Db.DB_FORCE} flag
     *  is set, in which case DbEnv.remove will attempt to remove the
     *  environment, regardless of any processes still using it.</p> <p>
     *
     *  The result of attempting to forcibly destroy the environment when it is
     *  in use is unspecified. Processes using an environment often maintain
     *  open file descriptors for shared regions within it. On UNIX systems, the
     *  environment removal will usually succeed, and processes that have
     *  already joined the region will continue to run in that region without
     *  change. However, processes attempting to join the environment will
     *  either fail or create new regions. On other systems in which the <b>
     *  unlink</b> (2) system call will fail if any process has an open file
     *  descriptor for the file (for example Windows/NT), the region removal
     *  will fail.</p> <p>
     *
     *  Calling DbEnv.remove should not be necessary for most applications
     *  because the Berkeley DB environment is cleaned up as part of normal
     *  database recovery procedures. However, applications may want to call
     *  DbEnv.remove as part of application shut down to free up system
     *  resources. For example, if the {@link com.sleepycat.db.Db#DB_SYSTEM_MEM
     *  Db.DB_SYSTEM_MEM} flag was specified to {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open}, it may be useful to call
     *  DbEnv.remove in order to release system shared memory segments that have
     *  been allocated. Or, on architectures in which mutexes require allocation
     *  of underlying system resources, it may be useful to call DbEnv.remove in
     *  order to release those resources. Alternatively, if recovery is not
     *  required because no database state is maintained across failures, and no
     *  system resources need to be released, it is possible to clean up an
     *  environment by simply removing all the Berkeley DB files in the database
     *  environment's directories.</p> <p>
     *
     *  In multithreaded applications, only a single thread may call
     *  DbEnv.remove.</p> <p>
     *
     *  A {@link com.sleepycat.db.DbEnv DbEnv} handle that has already been used
     *  to open an environment should not be used to call the DbEnv.remove
     *  method; a new {@link com.sleepycat.db.DbEnv DbEnv} handle should be
     *  created for that purpose.</p> <p>
     *
     *  After DbEnv.remove has been called, regardless of its return, the
     *  Berkeley DB environment handle may not be accessed again.</p>
     *
     *@param  db_home                            The <b>db_home</b> parameter
     *      names the database environment to be removed.
     *@param  flags                              must be set to 0 or by bitwise
     *      inclusively <b>OR</b> 'ing together one or more of the following
     *      values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FORCE Db.DB_FORCE}<p>
     *
     *        If the {@link com.sleepycat.db.Db#DB_FORCE <code>Db.DB_FORCE</code>
     *        } flag is set, the environment is removed, regardless of any
     *        processes that may still using it, and no locks are acquired
     *        during this process. (Generally, the {@link
     *        com.sleepycat.db.Db#DB_FORCE <code>Db.DB_FORCE</code>} flag is
     *        specified only when applications were unable to shut down cleanly,
     *        and there is a risk that an application may have died holding a
     *        Berkeley DB lock.) </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_USE_ENVIRON Db.DB_USE_ENVIRON}
     *        <p>
     *
     *        The Berkeley DB process' environment may be permitted to specify
     *        information to be used when naming files; see <a
     *        href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming
     *        </a>. Because permitting users to specify which files are used can
     *        create security problems, environment information will be used in
     *        file naming for all users only if the <code>Db.DB_USE_ENVIRON</code>
     *        flag is set. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_USE_ENVIRON_ROOT
     *        Db.DB_USE_ENVIRON_ROOT}<p>
     *
     *        The Berkeley DB process' environment may be permitted to specify
     *        information to be used when naming files; see <a
     *        href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming
     *        </a>. Because permitting users to specify which files are used can
     *        create security problems, if the <code>Db.DB_USE_ENVIRON_ROOT</code>
     *        flag is set, environment information will be used for file naming
     *        only for users with appropriate permissions (for example, users
     *        with a user-ID of 0 on UNIX systems). </li>
     *      </ul>
     *
     *@throws  DbException                       The DbEnv.remove method may
     *      fail and throw {@link com.sleepycat.db.DbException DbException},
     *      encapsulating a non-zero error, for the following conditions:
     *      <li> The shared memory region was in use and the force flag was not
     *      set.
     *@throws  FileNotFoundException             If the file or directory does
     *      not exist, the DbEnv.remove method will fail and throw a
     *      FileNotFoundException exception.
     */
    public synchronized void remove(String db_home, int flags) throws DbException, java.io.FileNotFoundException {

        try {
            remove0(db_home, flags);
        } finally {
            cleanup();
        }
    }


    /**
     *@deprecated              Replaced in Berkeley DB 4.2 by {@link
     *      #setCacheSize(long,int)}
     */
    public void set_cachesize(int gbytes, int bytes, int ncache) throws DbException {

        set_cachesize((long) gbytes * Db.GIGABYTE + bytes, ncache);
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getErrorPrefix()}
     */
    public String get_errpfx() {
        return getErrorPrefix();
    }


    /**
     *  The DbEnv.getErrorPrefix method returns the error prefix.</p> <p>
     *
     *  The DbEnv.getErrorPrefix method may be called at any time during the
     *  life of the application.</p>
     *
     *@return    The DbEnv.getErrorPrefix method returns the error prefix.</p>
     */
    public String getErrorPrefix() {
        return this.errpfx;
    }


    /**
     *@deprecated              Replaced in Berkeley DB 4.2 by {@link
     *      #setErrorHandler(DbErrorHandler)}
     */
    public void set_errcall(DbErrcall db_errcall_fcn) throws DbException {
        final DbErrcall ferrcall = db_errcall_fcn;
        try {
            setErrorHandler(
                new DbErrorHandler() {
                    public void error(String prefix, String buffer) {
                        ferrcall.errcall(prefix, buffer);
                    }
                });
        } catch (DbException dbe) {
            // setErrorHandler throws an exception,
            // but set_error_stream does not.
            // If it does happen, report it.
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }
    }


    /**
     *@deprecated     As of Berkeley DB 4.2, replaced by {@link
     *      #setErrorStream(java.io.OutputStream)}
     */
    public void set_error_stream(java.io.OutputStream stream) {
        setErrorStream(stream);
    }


    /**
     *  When an error occurs in the Berkeley DB library, an exception is thrown.
     *  In some cases, however, the error information known to the Java layer
     *  may be insufficient to completely describe the cause of the error,
     *  especially during initial application debugging.</p> <p>
     *
     *  The DbEnv.setErrorStream and {@link com.sleepycat.db.Db#setErrorStream
     *  Db.setErrorStream} methods are used to enhance the mechanism for
     *  reporting error messages to the application by setting a OutputStream to
     *  be used for displaying additional Berkeley DB error messages. In some
     *  cases, when an error occurs, Berkeley DB will output an additional error
     *  message to the specified stream.</p> <p>
     *
     *  The error message will consist of the prefix string and a colon ("<b>:
     *  </b>") (if a prefix string was previously specified using {@link
     *  com.sleepycat.db.DbEnv#setErrorPrefix DbEnv.setErrorPrefix}), an error
     *  string, and a trailing &lt;newline&gt; character.</p> <p>
     *
     *  Alternatively, you can use the {@link
     *  com.sleepycat.db.DbEnv#setErrorHandler DbEnv.setErrorHandler} method to
     *  capture the additional error information in a way that does not use
     *  output streams. You should not mix these approaches. </p> <p>
     *
     *  This error-logging enhancement does not slow performance or
     *  significantly increase application size, and may be run during normal
     *  operation as well as during application debugging.</p>
     *
     *@param  stream  the application-specified output stream to be used for
     *      additional error information.
     */
    public void setErrorStream(java.io.OutputStream stream) {
        final java.io.PrintWriter pw = new java.io.PrintWriter(stream);
        try {
            setErrorHandler(
                new DbErrorHandler() {
                    public void error(String prefix, String buf) {
                        if (prefix != null) {
                            pw.print(prefix + ": ");
                        }
                        pw.println(buf);
                        pw.flush();
                    }
                });
        } catch (DbException dbe) {
            // setErrorHandler throws an exception,
            // but set_error_stream does not.
            // If it does happen, report it.
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }
    }


    /**
     *@deprecated     As of Berkeley DB 4.2, replaced by {@link
     *      #setErrorPrefix(String)}
     */
    public void set_errpfx(String errpfx) {
        setErrorPrefix(errpfx);
    }


    /**
     *  Set the prefix string that appears before error messages issued by
     *  Berkeley DB.</p> <p>
     *
     *  The DbEnv.setErrorPrefix method may be called at any time during the
     *  life of the application.</p>
     *
     *@param  errpfx  the application-specified error prefix for additional
     *      error messages.
     */
    public void setErrorPrefix(String errpfx) {
        this.errpfx = errpfx;
    }


    /**
     *@deprecated              Replaced in Berkeley DB 4.2 by {@link
     *      #setFeedbackHandler(DbEnvFeedbackHandler)}
     */
    public void set_feedback(DbEnvFeedback feedback) throws DbException {
        final DbEnvFeedback ffeedback = feedback;
        setFeedbackHandler(
            new DbEnvFeedbackHandler() {
                public void feedback(DbEnv env, int opcode, int percent) {
                    ffeedback.feedback(env, opcode, percent);
                }
            });
    }


    /**
     *@deprecated              Replaced in Berkeley DB 4.2 by {@link
     *      #setReplicationLimit(long)}
     */
    public void set_rep_limit(int gbytes, int bytes) throws DbException {

        set_rep_limit((long) gbytes * Db.GIGABYTE + bytes);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setTxnTimestamp(java.util.Date)}
     */
    public void set_tx_timestamp(java.util.Date timestamp) throws DbException {
        setTxnTimestamp(timestamp);
    }


    /**
     *  Recover to the time specified by <b>timestamp</b> rather than to the
     *  most current possible date.</p> <p>
     *
     *  Once a database environment has been upgraded to a new version of
     *  Berkeley DB involving a log format change (see <a
     *  href="{@docRoot}/../ref/upgrade/process.html">Upgrading Berkeley DB
     *  installations</a> ), it is no longer possible to recover to a specific
     *  time before that upgrade.</p> <p>
     *
     *  The DbEnv.setTxnTimestamp method configures operations performed using
     *  the specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setTxnTimestamp method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. </p>
     *
     *@param  timestamp                  references the memory location where
     *      the recovery timestamp is located. <p>
     *
     *      Note that only the seconds (not the milliseconds) of the <b>
     *      timestamp</b> are used</p>
     *@throws  IllegalArgumentException  The DbEnv.setTxnTimestamp method will
     *      fail and throw a IllegalArgumentException exception if it is not
     *      possible to recover to the specified time using the log files
     *      currently present in the environment; or if an invalid flag value or
     *      parameter was specified.
     */
    public void setTxnTimestamp(java.util.Date timestamp) throws DbException {
        set_tx_timestamp0(timestamp.getTime() / 1000);
    }


    /**
     *  The constructor creates the DbEnv object. The constructor allocates
     *  memory internally; calling the {@link com.sleepycat.db.DbEnv#close
     *  DbEnv.close} or {@link com.sleepycat.db.DbEnv#remove DbEnv.remove}
     *  methods will free that memory.</p>
     *
     *@param  flags            The following <b>flags</b> value may be
     *      specified:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RPCCLIENT Db.DB_RPCCLIENT}<p>
     *
     *        Create a client environment to connect to a server. <p>
     *
     *        The <code>Db.DB_RPCCLIENT</code> flag indicates to the system that
     *        this environment is remote on a server. The use of this flag
     *        causes the environment methods to use functions that call a server
     *        instead of local functions. Prior to making any environment or
     *        database method calls, the application must call the {@link
     *        com.sleepycat.db.DbEnv#setRpcServer DbEnv.setRpcServer} function
     *        to establish the connection to the server.</p> </li>
     *      </ul>
     *
     *@throws  DbException     Signals that an exception of some sort has
     *      occurred.
     */
    public DbEnv(int flags) throws DbException {
        this(db_javaJNI.new_DbEnv(flags), true);
        initialize();
    }


    /**
     *
     */
    void close0(int flags) {
        db_javaJNI.DbEnv_close0(swigCPtr, flags);
    }


    /**
     *@deprecated                                As of Berkeley DB 4.2, replaced
     *      by {@link #dbRemove(DbTxn,String,String,int)}
     */
    public void dbremove(DbTxn txnid, String file, String database, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, java.io.FileNotFoundException {
        dbRemove(txnid, file, database, flags);
    }


    /**
     *  The DbEnv.dbRemove method removes the database specified by the <b>file
     *  </b> and <b>database</b> parameters. If no <b>database</b> is specified,
     *  the underlying file represented by <b>file</b> is removed, incidentally
     *  removing all of the databases it contained.</p> <p>
     *
     *  Applications should never remove databases with open {@link
     *  com.sleepycat.db.Db Db} handles, or in the case of removing a file, when
     *  any database in the file has an open handle. For example, some
     *  architectures do not permit the removal of files with open system
     *  handles. On these architectures, attempts to remove databases currently
     *  in use by any thread of control in the system will fail.</p> <h3>
     *  Environment Variables</h3> <p>
     *
     *  The environment variable <b>DB_HOME</b> may be used as the path of the
     *  database environment home.</p> <p>
     *
     *  DbEnv.dbRemove is affected by any database directory specified using the
     *  {@link com.sleepycat.db.DbEnv#setDataDir DbEnv.setDataDir} method, or by
     *  setting the "set_data_dir" string in the environment's <b>DB_CONFIG</b>
     *  file.</p>
     *
     *@param  database                           the database to be removed.
     *@param  file                               the physical file which
     *      contains the database(s) to be removed.
     *@param  flags                              must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT Db.DB_AUTO_COMMIT}
     *        <p>
     *
     *        Enclose the DbEnv.dbRemove call within a transaction. If the call
     *        succeeds, changes made by the operation will be recoverable. If
     *        the call fails, the operation will have made no changes. </li>
     *
     *      </ul>
     *
     *@param  txnid                              If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a transaction
     *      handle returned from {@link com.sleepycat.db.DbEnv#txnBegin
     *      DbEnv.txnBegin}; otherwise, null.
     *@throws  DbException                       The DbEnv.dbRemove method may
     *      fail and throw {@link com.sleepycat.db.DbException DbException},
     *      encapsulating a non-zero error, for the following conditions:
     *      <li> An attempt was made to remove the underlying file and a
     *      database in the file was currently open.
     *@throws  DbDeadlockException               If a transactional database
     *      environment operation was selected to resolve a deadlock, the
     *      DbEnv.dbRemove method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException} exception.
     *@throws  DbLockNotGrantedException         If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock timeouts was
     *      unable to grant a lock in the allowed time, the DbEnv.dbRemove
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  IllegalArgumentException          The DbEnv.dbRemove method will
     *      fail and throw a IllegalArgumentException exception if
     *      DbEnv.dbRemove called before {@link com.sleepycat.db.DbEnv#open
     *      DbEnv.open} was called; or if an invalid flag value or parameter was
     *      specified.
     *@throws  FileNotFoundException             If the file or directory does
     *      not exist, the DbEnv.dbRemove method will fail and throw a
     *      FileNotFoundException exception.
     */
    public void dbRemove(DbTxn txnid, String file, String database, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, java.io.FileNotFoundException {
        db_javaJNI.DbEnv_dbremove(swigCPtr, DbTxn.getCPtr(txnid), file, database, flags);
    }


    /**
     *@deprecated                                As of Berkeley DB 4.2, replaced
     *      by {@link #dbRename(DbTxn,String,String,String,int)}
     */
    public void dbrename(DbTxn txnid, String file, String database, String newname, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, java.io.FileNotFoundException {
        dbRename(txnid, file, database, newname, flags);
    }


    /**
     *  The DbEnv.dbRename method renames the database specified by the <b>file
     *  </b> and <b>database</b> parameters to <b>newname</b> . If no <b>
     *  database</b> is specified, the underlying file represented by <b>file
     *  </b> is renamed, incidentally renaming all of the databases it
     *  contained.</p> <p>
     *
     *  Applications should not rename databases that are currently in use. If
     *  an underlying file is being renamed and logging is currently enabled in
     *  the database environment, no database in the file may be open when the
     *  DbEnv.dbRename method is called. In particular, some architectures do
     *  not permit renaming files with open handles. On these architectures,
     *  attempts to rename databases that are currently in use by any thread of
     *  control in the system will fail.</p> <h3>Environment Variables</h3> <p>
     *
     *  The environment variable <b>DB_HOME</b> may be used as the path of the
     *  database environment home.</p> <p>
     *
     *  DbEnv.dbRename is affected by any database directory specified using the
     *  {@link com.sleepycat.db.DbEnv#setDataDir DbEnv.setDataDir} method, or by
     *  setting the "set_data_dir" string in the environment's <b>DB_CONFIG</b>
     *  file.</p>
     *
     *@param  database                           the database to be removed.
     *@param  file                               the physical file which
     *      contains the database(s) to be removed.
     *@param  flags                              must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT Db.DB_AUTO_COMMIT}
     *        <p>
     *
     *        Enclose the DbEnv.dbRename call within a transaction. If the call
     *        succeeds, changes made by the operation will be recoverable. If
     *        the call fails, the operation will have made no changes. </li>
     *
     *      </ul>
     *
     *@param  newname                            the new name of the database or
     *      file.
     *@param  txnid                              If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a transaction
     *      handle returned from {@link com.sleepycat.db.DbEnv#txnBegin
     *      DbEnv.txnBegin}; otherwise, null.
     *@throws  DbException                       The DbEnv.dbRename method may
     *      fail and throw {@link com.sleepycat.db.DbException DbException},
     *      encapsulating a non-zero error, for the following conditions:
     *      <li> An attempt was made to rename the underlying file and a
     *      database in the file was currently open.
     *@throws  DbDeadlockException               If a transactional database
     *      environment operation was selected to resolve a deadlock, the
     *      DbEnv.dbRename method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException} exception.
     *@throws  DbLockNotGrantedException         If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock timeouts was
     *      unable to grant a lock in the allowed time, the DbEnv.dbRename
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  IllegalArgumentException          The DbEnv.dbRename method will
     *      fail and throw a IllegalArgumentException exception if
     *      DbEnv.dbRename called before {@link com.sleepycat.db.DbEnv#open
     *      DbEnv.open} was called; or if an invalid flag value or parameter was
     *      specified.
     *@throws  FileNotFoundException             If the file or directory does
     *      not exist, the DbEnv.dbRename method will fail and throw a
     *      FileNotFoundException exception.
     */
    public void dbRename(DbTxn txnid, String file, String database, String newname, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, java.io.FileNotFoundException {
        db_javaJNI.DbEnv_dbrename(swigCPtr, DbTxn.getCPtr(txnid), file, database, newname, flags);
    }


    /**
     *  The DbEnv.err, DbEnv.errx, {@link com.sleepycat.db.Db#err Db.err} and
     *  {@link com.sleepycat.db.Db#errx Db.errx} methods provide error-messaging
     *  functionality for applications written using the Berkeley DB library.
     *  </p> <p>
     *
     *  The DbEnv.err method constructs an error message consisting of the
     *  following elements:</p> <blockquote> <p>
     *
     *  If no error callback function has been set using the {@link
     *  com.sleepycat.db.DbEnv#setErrorHandler DbEnv.setErrorHandler} method,
     *  any prefix string specified using the {@link
     *  com.sleepycat.db.DbEnv#setErrorPrefix DbEnv.setErrorPrefix} method,
     *  followed by two separating characters: a colon and a &lt;space&gt;
     *  character. <p>
     *
     *  <p>
     *
     *  Two separating characters: a colon and a &lt;space&gt; character. <p>
     *
     *  The standard system or Berkeley DB library error string associated with
     *  the <b>error</b> value, as returned by the {@link
     *  com.sleepycat.db.DbEnv#strerror DbEnv.strerror} method. </blockquote>
     *  <p>
     *
     *  This constructed error message is then handled as follows:</p>
     *  <blockquote><p>
     *
     *  If an error callback function has been set (see {@link
     *  com.sleepycat.db.Db#setErrorHandler Db.setErrorHandler} and {@link
     *  com.sleepycat.db.DbEnv#setErrorHandler DbEnv.setErrorHandler}), that
     *  function is called with two parameters: any prefix string specified (see
     *  {@link com.sleepycat.db.Db#setErrorPrefix Db.setErrorPrefix} and {@link
     *  com.sleepycat.db.DbEnv#setErrorPrefix DbEnv.setErrorPrefix}) and the
     *  error message.</p> <p>
     *
     *  If an OutputStream has been set (see {@link
     *  com.sleepycat.db.DbEnv#setErrorStream DbEnv.setErrorStream} and {@link
     *  com.sleepycat.db.Db#setErrorStream Db.setErrorStream}), the error
     *  message is written to that stream.</p> <p>
     *
     *  If none of these output options has been configured, the error message
     *  is written to System.err, the standard error output stream.</p>
     *  </blockquote>
     *
     *@param  error    the error value for which the DbEnv.err and {@link
     *      com.sleepycat.db.Db#err Db.err} methods will display a explanatory
     *      string.
     *@param  message  an error message to display.
     */
    public void err(int error, String message) {
        db_javaJNI.DbEnv_err(swigCPtr, error, message);
    }


    /**
     *  The DbEnv.errx and {@link com.sleepycat.db.Db#errx Db.errx} methods
     *  perform identically to the DbEnv.err and {@link com.sleepycat.db.Db#err
     *  Db.err} methods, except that they do not append the final separator
     *  characters and standard error string to the error message.</p>
     *
     *@param  message  an error message to display.
     */
    public void errx(String message) {
        db_javaJNI.DbEnv_errx(swigCPtr, message);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getDataDirs()}
     */
    public String[] get_data_dirs() throws DbException {
        return getDataDirs();
    }


    /**
     *  The DbEnv.getDataDirs method returns the array of directories.</p> <p>
     *
     *  The DbEnv.getDataDirs method may be called at any time during the life
     *  of the application.</p>
     *
     *@return               The DbEnv.getDataDirs method returns the array of
     *      directories.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public String[] getDataDirs() throws DbException {
        return db_javaJNI.DbEnv_get_data_dirs(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getEncryptFlags()}
     */
    public int get_encrypt_flags() throws DbException {
        return getEncryptFlags();
    }


    /**
     *  The DbEnv.getEncryptFlags method returns the encryption flags.</p> <p>
     *
     *  The DbEnv.getEncryptFlags method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getEncryptFlags method returns the
     *      encryption flags.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getEncryptFlags() throws DbException {
        return db_javaJNI.DbEnv_get_encrypt_flags(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getFlags()}
     */
    public int get_flags() throws DbException {
        return getFlags();
    }


    /**
     *  The DbEnv.getFlags method returns the configuration flags.</p> <p>
     *
     *  The DbEnv.getFlags method may be called at any time during the life of
     *  the application.</p>
     *
     *@return               The DbEnv.getFlags method returns the configuration
     *      flags.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getFlags() throws DbException {
        return db_javaJNI.DbEnv_get_flags(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getDbEnvHome()}
     */
    public String get_home() throws DbException {
        return getDbEnvHome();
    }


    /**
     *  The DbEnv.getDbEnvHome method returns the database environment home
     *  directory.</p> <p>
     *
     *  The DbEnv.getDbEnvHome method may be called at any time during the life
     *  of the application.</p>
     *
     *@return               The DbEnv.getDbEnvHome method returns the database
     *      environment home directory.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public String getDbEnvHome() throws DbException {
        return db_javaJNI.DbEnv_get_home(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getOpenFlags()}
     */
    public int get_open_flags() throws DbException {
        return getOpenFlags();
    }


    /**
     *  The DbEnv.getOpenFlags method returns the open method flags.</p> <p>
     *
     *  The DbEnv.getOpenFlags method may not be called before the DbEnv.open
     *  method has been called.</p>
     *
     *@return               The DbEnv.getOpenFlags method returns the open
     *      method flags.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getOpenFlags() throws DbException {
        return db_javaJNI.DbEnv_get_open_flags(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getSegmentId()}
     */
    public long get_shm_key() throws DbException {
        return getSegmentId();
    }


    /**
     *  The DbEnv.getSegmentId method returns the base segment ID.</p> <p>
     *
     *  The DbEnv.getSegmentId method may be called at any time during the life
     *  of the application.</p>
     *
     *@return               The DbEnv.getSegmentId method returns the base
     *      segment ID.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getSegmentId() throws DbException {
        return db_javaJNI.DbEnv_get_shm_key(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getTestAndSetSpins()}
     */
    public int get_tas_spins() throws DbException {
        return getTestAndSetSpins();
    }


    /**
     *  The DbEnv.getTestAndSetSpins method returns the test-and-set spin count.
     *  </p> <p>
     *
     *  The DbEnv.getTestAndSetSpins method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getTestAndSetSpins method returns the
     *      test-and-set spin count.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getTestAndSetSpins() throws DbException {
        return db_javaJNI.DbEnv_get_tas_spins(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getTmpDir()}
     */
    public String get_tmp_dir() throws DbException {
        return getTmpDir();
    }


    /**
     *  The DbEnv.getTmpDir method returns the database environment temporary
     *  file directory.</p> <p>
     *
     *  The DbEnv.getTmpDir method may be called at any time during the life of
     *  the application.</p>
     *
     *@return               The DbEnv.getTmpDir method returns the database
     *      environment temporary file directory.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public String getTmpDir() throws DbException {
        return db_javaJNI.DbEnv_get_tmp_dir(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getVerbose(int)}
     */
    public boolean get_verbose(int which) throws DbException {
        return getVerbose(which);
    }


    /**
     *  The DbEnv.getVerbose method returns whether the specified <b>which</b>
     *  parameter is currently set or not.</p> <p>
     *
     *  The DbEnv.getVerbose method may be called at any time during the life of
     *  the application.</p>
     *
     *@param  which         the message value for which configuration is being
     *      checked.
     *@return               The DbEnv.getVerbose method returns whether the
     *      specified <b>which</b> parameter is currently set or not.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public boolean getVerbose(int which) throws DbException {
        return db_javaJNI.DbEnv_get_verbose(swigCPtr, which);
    }


    /**
     *
     */
    void open0(String db_home, int flags, int mode) {
        db_javaJNI.DbEnv_open0(swigCPtr, db_home, flags, mode);
    }


    /**
     *
     */
    void remove0(String db_home, int flags) {
        db_javaJNI.DbEnv_remove0(swigCPtr, db_home, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setCacheSize(long,int)}
     */
    public void set_cachesize(long bytes, int ncache) throws DbException {
        setCacheSize(bytes, ncache);
    }


    /**
     *  Set the size of the shared memory buffer pool -- that is, the cache. The
     *  cache should be the size of the normal working data set of the
     *  application, with some small amount of additional memory for unusual
     *  situations. (Note: the working set is not the same as the number of
     *  pages accessed simultaneously, and is usually much larger.)</p> <p>
     *
     *  The default cache size is 256KB, and may not be specified as less than
     *  20KB. Any cache size less than 500MB is automatically increased by 25%
     *  to account for buffer pool overhead; cache sizes larger than 500MB are
     *  used as specified. The current maximum size of a single cache is 4GB.
     *  (All sizes are in powers-of-two, that is, 256KB is 2^32 not 256,000.)
     *  For information on tuning the Berkeley DB cache size, see <a
     *  href="{@docRoot}/../ref/am_conf/cachesize.html">Selecting a cache size
     *  </a>.</p> <p>
     *
     *  It is possible to specify caches to Berkeley DB larger than 4GB and/or
     *  large enough they cannot be allocated contiguously on some
     *  architectures. For example, some releases of Solaris limit the amount of
     *  memory that may be allocated contiguously by a process. If <b>ncache</b>
     *  is 0 or 1, the cache will be allocated contiguously in memory. If it is
     *  greater than 1, the cache will be broken up into <b>ncache</b> equally
     *  sized, separate pieces of memory.</p> <p>
     *
     *  The database environment's cache size may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_cachesize", one or more
     *  whitespace characters, and the cache size specified in three parts: the
     *  gigabytes of cache, the additional bytes of cache, and the number of
     *  caches, also separated by whitespace characters. For example,
     *  "set_cachesize 2 524288000 3" would create a 2.5GB logical cache, split
     *  between three physical caches. Because the <b>DB_CONFIG</b> file is read
     *  when the database environment is opened, it will silently overrule
     *  configuration done before that time.</p> <p>
     *
     *  The DbEnv.setCacheSize method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setCacheSize method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setCacheSize will be ignored. </p>
     *
     *@param  bytes                      The size of the cache in bytes.
     *@param  ncache                     the number of caches to create.
     *@throws  IllegalArgumentException  The DbEnv.setCacheSize method will fail
     *      and throw a IllegalArgumentException exception if the specified
     *      cache size was impossibly small; the method was called after {@link
     *      com.sleepycat.db.DbEnv#open DbEnv.open} was called; or if an invalid
     *      flag value or parameter was specified.
     */
    public void setCacheSize(long bytes, int ncache) throws DbException {
        db_javaJNI.DbEnv_set_cachesize(swigCPtr, bytes, ncache);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setDataDir(String)}
     */
    public void set_data_dir(String dir) throws DbException {
        setDataDir(dir);
    }


    /**
     *  Set the path of a directory to be used as the location of the access
     *  method database files. Paths specified to the {@link
     *  com.sleepycat.db.Db#open Db.open} function will be searched relative to
     *  this path. Paths set using this method are additive, and specifying more
     *  than one will result in each specified directory being searched for
     *  database files. If any directories are specified, created database files
     *  will always be created in the first path specified.</p> <p>
     *
     *  If no database directories are specified, database files can exist only
     *  in the environment home directory. See <a
     *  href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming</a> for
     *  more information.</p> <p>
     *
     *  For the greatest degree of recoverability from system or application
     *  failure, database files and log files should be located on separate
     *  physical devices.</p> <p>
     *
     *  The database environment's data directories may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_data_dir", one or more
     *  whitespace characters, and the directory name. </p> <p>
     *
     *  The DbEnv.setDataDir method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setDataDir method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setDataDir must be consistent with the existing
     *  environment or corruption can occur.</p>
     *
     *@param  dir                        a directory to be used as a location
     *      for database files.
     *@throws  IllegalArgumentException  The DbEnv.setDataDir method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setDataDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_data_dir(swigCPtr, dir);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setEncrypted(String,int)}
     */
    public void set_encrypt(String passwd, int flags) throws DbException {
        setEncrypted(passwd, flags);
    }


    /**
     *  Set the password used by the Berkeley DB library to perform encryption
     *  and decryption.</p> <p>
     *
     *  The DbEnv.setEncrypted method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setEncrypted method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setEncrypted must be consistent with the existing
     *  environment or an error will be returned. </p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ENCRYPT_AES Db.DB_ENCRYPT_AES}
     *        <p>
     *
     *        Use the Rijndael/AES (also known as the Advanced Encryption
     *        Standard and Federal Information Processing Standard (FIPS) 197)
     *        algorithm for encryption or decryption. </li>
     *      </ul>
     *
     *@param  passwd                     the password used to perform encryption
     *      and decryption.
     *@throws  DbException               The DbEnv.setEncrypted method may fail
     *      and throw {@link com.sleepycat.db.DbException DbException},
     *      encapsulating a non-zero error, for the following conditions:
     *      <li> Cryptography is not available in this Berkeley DB release.
     *@throws  IllegalArgumentException  The DbEnv.setEncrypted method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setEncrypted(String passwd, int flags) throws DbException {
        db_javaJNI.DbEnv_set_encrypt(swigCPtr, passwd, flags);
    }


    /**
     *  When an error occurs in the Berkeley DB library, an exception is thrown.
     *  In some cases, however, the <b>errno</b> value may be insufficient to
     *  completely describe the cause of the error, especially during initial
     *  application debugging. <p>
     *
     *  The DbEnv.setOnError and {@link com.sleepycat.db.Db#setErrorHandler
     *  Db.setErrorHandler} methods are used to enhance the mechanism for
     *  reporting error messages to the application. The DbEnv.setOnError and
     *  {@link com.sleepycat.db.Db#setErrorHandler Db.setErrorHandler} methods
     *  must be called with a single object parameter. The object's class must
     *  implement the DbErrorHandler interface.</p> <p>
     *
     *  In some cases, when an error occurs, Berkeley DB will invoke the
     *  object's errcall() method with two parameters; the first is the prefix
     *  string (as previously set by {@link com.sleepycat.db.Db#setErrorPrefix
     *  Db.setErrorPrefix} or {@link com.sleepycat.db.DbEnv#setErrorPrefix
     *  DbEnv.setErrorPrefix}), the second will be an error message string. It
     *  is up to this method to display the message in an appropriate manner.
     *  </p> <p>
     *
     *  Alternatively, you can use the {@link
     *  com.sleepycat.db.DbEnv#setErrorStream DbEnv.setErrorStream} and {@link
     *  com.sleepycat.db.Db#setErrorStream Db.setErrorStream} methods to display
     *  the additional information via an output stream. You should not mix
     *  these approaches.</p> <p>
     *
     *  This error-logging enhancement does not slow performance or
     *  significantly increase application size, and may be run during normal
     *  operation as well as during application debugging.</p> <p>
     *
     *  The DbEnv.setOnError method may be called at any time during the life of
     *  the application.</p>
     *
     *@param  db_errcall_fcn  the application-specified error reporting
     *      function. The function takes two parameters: <p>
     *
     *      The <b>errpfx</b> parameter is the prefix string (as previously set
     *      by {@link com.sleepycat.db.Db#setErrorPrefix Db.setErrorPrefix} or
     *      {@link com.sleepycat.db.DbEnv#setErrorPrefix DbEnv.setErrorPrefix}).
     *      <p>
     *
     *      The <b>msg</b> parameter is the error message string.
     *@throws  DbException    Signals that an exception of some sort has
     *      occurred.
     */
    public void setErrorHandler(DbErrorHandler db_errcall_fcn) throws DbException {
        db_javaJNI.DbEnv_setErrorHandler(swigCPtr, (error_handler = db_errcall_fcn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setFlags(int,boolean)}
     */
    public void set_flags(int flags, boolean onoff) throws DbException {
        setFlags(flags, onoff);
    }


    /**
     *  Configure a database environment.</p> <p>
     *
     *  The database environment's flag values may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_flags", one or more
     *  whitespace characters, and the method flag parameter as a string; for
     *  example, "set_flags DB_TXN_NOSYNC". Because the <b>DB_CONFIG</b> file is
     *  read when the database environment is opened, it will silently overrule
     *  configuration done before that time.</p>
     *
     *@param  flags                      must be set by bitwise inclusively <b>
     *      OR</b> 'ing together one or more of the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT Db.DB_AUTO_COMMIT}
     *        <p>
     *
     *        If set, operations for which no explicit transaction handle was
     *        specified, and which modify databases in the database environment,
     *        will be automatically enclosed within a transaction. If the call
     *        succeeds, changes made by the operation will be recoverable. If
     *        the call fails, the operation will have made no changes. <p>
     *
     *        Calling DbEnv.setFlags with the {@link
     *        com.sleepycat.db.Db#DB_AUTO_COMMIT <code>Db.DB_AUTO_COMMIT</code>}
     *        flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the {@link
     *        com.sleepycat.db.Db#DB_AUTO_COMMIT <code>Db.DB_AUTO_COMMIT</code>}
     *        flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The {@link com.sleepycat.db.Db#DB_AUTO_COMMIT <code>Db.DB_AUTO_COMMIT</code>
     *        } flag may be used to configure Berkeley DB at any time during the
     *        life of the application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CDB_ALLDB Db.DB_CDB_ALLDB}<p>
     *
     *        If set, Berkeley DB Concurrent Data Store applications will
     *        perform locking on an environment-wide basis rather than on a
     *        per-database basis. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_CDB_ALLDB</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_CDB_ALLDB</code> flag
     *        or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_CDB_ALLDB</code> flag may be used to configure
     *        Berkeley DB only before the {@link com.sleepycat.db.DbEnv#open
     *        DbEnv.open} method is called.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRECT_DB Db.DB_DIRECT_DB}<p>
     *
     *        Turn off system buffering of Berkeley DB database files to avoid
     *        double caching. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_DIRECT_DB</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_DIRECT_DB</code> flag
     *        or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_DIRECT_DB</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRECT_LOG Db.DB_DIRECT_LOG}<p>
     *
     *        Turn off system buffering of Berkeley DB log files to avoid double
     *        caching. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_DIRECT_LOG</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_DIRECT_LOG</code> flag
     *        or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_DIRECT_LOG</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOG_AUTOREMOVE
     *        Db.DB_LOG_AUTOREMOVE}<p>
     *
     *        If set, Berkeley DB will automatically remove log files that are
     *        no longer needed. Automatic log file removal is likely to make
     *        catastrophic recovery impossible. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_LOG_AUTOREMOVE</code>
     *        flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the <code>Db.DB_LOG_AUTOREMOVE</code>
     *        flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_LOG_AUTOREMOVE</code> flag may be used to
     *        configure Berkeley DB at any time during the life of the
     *        application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOLOCKING Db.DB_NOLOCKING}<p>
     *
     *        If set, Berkeley DB will grant all requested mutual exclusion
     *        mutexes and database locks without regard for their actual
     *        availability. This functionality should never be used for purposes
     *        other than debugging. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_NOLOCKING</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). </p> <p>
     *
     *        The <code>Db.DB_NOLOCKING</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOMMAP Db.DB_NOMMAP}<p>
     *
     *        If set, Berkeley DB will copy read-only database files into the
     *        local cache instead of potentially mapping them into process
     *        memory (see the description of the {@link
     *        com.sleepycat.db.DbEnv#setMemoryPoolMapSize
     *        DbEnv.setMemoryPoolMapSize} method for further information). <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_NOMMAP</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_NOMMAP</code> flag or
     *        the flag should be specified in the <b>DB_CONFIG</b> configuration
     *        file.</p> <p>
     *
     *        The <code>Db.DB_NOMMAP</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOPANIC Db.DB_NOPANIC}<p>
     *
     *        If set, Berkeley DB will ignore any panic state in the database
     *        environment. (Database environments in a panic state normally
     *        refuse all attempts to call Berkeley DB functions, returning <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_RUNRECOVERY">
     *        <code>Db.DB_RUNRECOVERY</code></a> .) This functionality should
     *        never be used for purposes other than debugging. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_NOPANIC</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). </p> <p>
     *
     *        The <code>Db.DB_NOPANIC</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_OVERWRITE Db.DB_OVERWRITE}<p>
     *
     *        Overwrite files stored in encrypted formats before deleting them.
     *        Berkeley DB overwrites files using alternating 0xff, 0x00 and 0xff
     *        byte patterns. For file overwriting to be effective, the
     *        underlying file must be stored on a fixed-block filesystem.
     *        Systems with journaling or logging filesystems will require
     *        operating system support and probably modification of the Berkeley
     *        DB sources. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_OVERWRITE</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). </p> <p>
     *
     *        The <code>Db.DB_OVERWRITE</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PANIC_ENVIRONMENT
     *        Db.DB_PANIC_ENVIRONMENT}<p>
     *
     *        If set, Berkeley DB will set the panic state for the database
     *        environment. (Database environments in a panic state normally
     *        refuse all attempts to call Berkeley DB functions, returning <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_RUNRECOVERY">
     *        <code>Db.DB_RUNRECOVERY</code></a> .) This flag may not be
     *        specified using the environment's <b>DB_CONFIG</b> file. This flag
     *        may be used to configure Berkeley DB only after the {@link
     *        com.sleepycat.db.DbEnv#open DbEnv.open} method is called. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_PANIC_ENVIRONMENT</code>
     *        flag affects the database environment, including all threads of
     *        control accessing the database environment.</p> <p>
     *
     *        The <code>Db.DB_PANIC_ENVIRONMENT</code> flag may be used to
     *        configure Berkeley DB at any time during the life of the
     *        application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REGION_INIT Db.DB_REGION_INIT}
     *        <p>
     *
     *        In some applications, the expense of page-faulting the underlying
     *        shared memory regions can affect performance. (For example, if the
     *        page-fault occurs while holding a lock, other lock requests can
     *        convoy, and overall throughput may decrease.) If set, Berkeley DB
     *        will page-fault shared regions into memory when initially creating
     *        or joining a Berkeley DB environment. In addition, Berkeley DB
     *        will write the shared regions when creating an environment,
     *        forcing the underlying virtual memory and filesystems to
     *        instantiate both the necessary memory and the necessary disk
     *        space. This can also avoid out-of-disk space failures later on.
     *        <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_REGION_INIT</code>
     *        flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the <code>Db.DB_REGION_INIT</code>
     *        flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_REGION_INIT</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TIME_NOTGRANTED
     *        Db.DB_TIME_NOTGRANTED}<p>
     *
     *        If set, database calls timing out based on lock or transaction
     *        timeout values will throw a {@link
     *        com.sleepycat.db.DbLockNotGrantedException
     *        DbLockNotGrantedException} exception instead of {@link
     *        com.sleepycat.db.DbDeadlockException DbDeadlockException}. This
     *        allows applications to distinguish between operations which have
     *        deadlocked and operations which have exceeded their time limits.
     *        <p>
     *
     *        Calling DbEnv.setFlags with the {@link
     *        com.sleepycat.db.Db#DB_TIME_NOTGRANTED <code>Db.DB_TIME_NOTGRANTED</code>
     *        } flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the {@link
     *        com.sleepycat.db.Db#DB_TIME_NOTGRANTED <code>Db.DB_TIME_NOTGRANTED</code>
     *        } flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The {@link com.sleepycat.db.Db#DB_TIME_NOTGRANTED <code>Db.DB_TIME_NOTGRANTED</code>
     *        } flag may be used to configure Berkeley DB at any time during the
     *        life of the application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_NOSYNC Db.DB_TXN_NOSYNC}<p>
     *
     *        If set, Berkeley DB will not write or synchronously flush the log
     *        on transaction commit. This means that transactions exhibit the
     *        ACI (atomicity, consistency, and isolation) properties, but not D
     *        (durability); that is, database integrity will be maintained, but
     *        if the application or system fails, it is possible some number of
     *        the most recently committed transactions may be undone during
     *        recovery. The number of transactions at risk is governed by how
     *        many log updates can fit into the log buffer, how often the
     *        operating system flushes dirty buffers to disk, and how often the
     *        log is checkpointed. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_TXN_NOSYNC</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_TXN_NOSYNC</code> flag
     *        or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_TXN_NOSYNC</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_NOT_DURABLE
     *        Db.DB_TXN_NOT_DURABLE}<p>
     *
     *        If set, Berkeley DB will not write log records. This means that
     *        transactions exhibit the ACI (atomicity, consistency, and
     *        isolation) properties, but not D (durability); that is, database
     *        integrity will be maintained, but if the application or system
     *        fails, integrity will not persist. All database files must be
     *        verified and/or restored from backup after a failure. In order to
     *        ensure integrity after application shut down, all database handles
     *        must be closed without specifying {@link
     *        com.sleepycat.db.Db#DB_NOSYNC <code>Db.DB_NOSYNC</code>}, or all
     *        database changes must be flushed from the database environment
     *        cache using the {@link com.sleepycat.db.DbEnv#txnCheckpoint
     *        DbEnv.txnCheckpoint} method. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_TXN_NOT_DURABLE</code>
     *        flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the <code>Db.DB_TXN_NOT_DURABLE</code>
     *        flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_TXN_NOT_DURABLE</code> flag may be used to
     *        configure Berkeley DB at any time during the life of the
     *        application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_WRITE_NOSYNC
     *        Db.DB_TXN_WRITE_NOSYNC}<p>
     *
     *        If set, Berkeley DB will write, but will not synchronously flush,
     *        the log on transaction commit. This means that transactions
     *        exhibit the ACI (atomicity, consistency, and isolation)
     *        properties, but not D (durability); that is, database integrity
     *        will be maintained, but if the system fails, it is possible some
     *        number of the most recently committed transactions may be undone
     *        during recovery. The number of transactions at risk is governed by
     *        how often the system flushes dirty buffers to disk and how often
     *        the log is checkpointed. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_TXN_WRITE_NOSYNC</code>
     *        flag only affects the specified {@link com.sleepycat.db.DbEnv
     *        DbEnv} handle (and any other Berkeley DB handles opened within the
     *        scope of that handle). For consistent behavior across the
     *        environment, all {@link com.sleepycat.db.DbEnv DbEnv} handles
     *        opened in the environment must either set the <code>Db.DB_TXN_WRITE_NOSYNC</code>
     *        flag or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_TXN_WRITE_NOSYNC</code> flag may be used to
     *        configure Berkeley DB at any time during the life of the
     *        application.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_YIELDCPU Db.DB_YIELDCPU}<p>
     *
     *        If set, Berkeley DB will yield the processor immediately after
     *        each page or mutex acquisition. This functionality should never be
     *        used for purposes other than stress testing. <p>
     *
     *        Calling DbEnv.setFlags with the <code>Db.DB_YIELDCPU</code> flag
     *        only affects the specified {@link com.sleepycat.db.DbEnv DbEnv}
     *        handle (and any other Berkeley DB handles opened within the scope
     *        of that handle). For consistent behavior across the environment,
     *        all {@link com.sleepycat.db.DbEnv DbEnv} handles opened in the
     *        environment must either set the <code>Db.DB_YIELDCPU</code> flag
     *        or the flag should be specified in the <b>DB_CONFIG</b>
     *        configuration file.</p> <p>
     *
     *        The <code>Db.DB_YIELDCPU</code> flag may be used to configure
     *        Berkeley DB at any time during the life of the application.</p>
     *        </li>
     *      </ul>
     *
     *@param  onoff                      If the <b>onoff</b> parameter is false,
     *      the specified flags are cleared; otherwise they are set.
     *@throws  IllegalArgumentException  The DbEnv.setFlags method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public void setFlags(int flags, boolean onoff) throws DbException {
        db_javaJNI.DbEnv_set_flags(swigCPtr, flags, onoff);
    }


    /**
     *  Sets the feedbackHandler attribute of the DbEnv object
     *
     *@param  db_feedback_fcn  The new feedbackHandler value
     */
    public void setFeedbackHandler(DbEnvFeedbackHandler db_feedback_fcn) throws DbException {
        db_javaJNI.DbEnv_setFeedbackHandler(swigCPtr, (env_feedback_handler = db_feedback_fcn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setMemoryPoolMapSize(long)}
     */
    public void set_mp_mmapsize(long mp_mmapsize) throws DbException {
        setMemoryPoolMapSize(mp_mmapsize);
    }


    /**
     *  Files that are opened read-only in the pool (and that satisfy a few
     *  other criteria) are, by default, mapped into the process address space
     *  instead of being copied into the local cache. This can result in
     *  better-than-usual performance because available virtual memory is
     *  normally much larger than the local cache, and page faults are faster
     *  than page copying on many systems. However, it can cause resource
     *  starvation in the presence of limited virtual memory, and it can result
     *  in immense process sizes in the presence of large databases.</p> <p>
     *
     *  The DbEnv.getMemoryPoolMapSize method sets the maximum file size, in
     *  bytes, for a file to be mapped into the process address space. If no
     *  value is specified, it defaults to 10MB.</p> <p>
     *
     *  The database environment's maximum mapped file size may also be set
     *  using the environment's <b>DB_CONFIG</b> file. The syntax of the entry
     *  in that file is a single line with the string "set_mp_mmapsize", one or
     *  more whitespace characters, and the size in bytes. Because the <b>
     *  DB_CONFIG</b> file is read when the database environment is opened, it
     *  will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setMemoryPoolMapSize method configures operations performed
     *  using the specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setMemoryPoolMapSize method may be called at any time during
     *  the life of the application.</p>
     *
     *@param  mp_mmapsize                the maximum file size, in bytes, for a
     *      file to be mapped into the process address space.
     *@throws  IllegalArgumentException  The DbEnv.setMemoryPoolMapSize method
     *      will fail and throw a IllegalArgumentException exception if the
     *      method was called after {@link com.sleepycat.db.DbEnv#open
     *      DbEnv.open} was called; or if an invalid flag value or parameter was
     *      specified.
     */
    public void setMemoryPoolMapSize(long mp_mmapsize) throws DbException {
        db_javaJNI.DbEnv_set_mp_mmapsize(swigCPtr, mp_mmapsize);
    }


    /**
     *  Sets the panicHandler attribute of the DbEnv object
     *
     *@param  db_panic_fcn     The new panicHandler value
     */
    public void setPanicHandler(DbPanicHandler db_panic_fcn) throws DbException {
        db_javaJNI.DbEnv_setPanicHandler(swigCPtr, (panic_handler = db_panic_fcn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setRpcServer(DbClient,String,long,long,int)}
     */
    public void set_rpc_server(DbClient client, String host, long cl_timeout, long sv_timeout, int flags) throws DbException {
        setRpcServer(client, host, cl_timeout, sv_timeout, flags);
    }


    /**
     *  Establishes a connection for this <b>dbenv</b> to a RPC server.</p> The
     *  DbEnv.setRpcServer method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setRpcServer method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. </p>
     *
     *@param  cl_timeout                 specifies the number of seconds the
     *      client should wait for results to come back from the server. Once
     *      the timeout has expired on any communication with the server,
     *      Db.DB_NOSERVER will be returned. If this value is zero, a default
     *      timeout is used.
     *@param  client                     reserved for future use. If it is not
     *      NULL, an exception is thrown.
     *@param  host                       the host to which the Berkeley DB
     *      server will connect and create a channel for communication.
     *@param  flags                      currently unused, and must be set to 0.
     *@param  sv_timeout                 specifies the number of seconds the
     *      server should allow a client connection to remain idle before
     *      assuming that the client is gone. Once that timeout has been
     *      reached, the server releases all resources associated with that
     *      client connection. Subsequent attempts by that client to communicate
     *      with the server result in Db.DB_NOSERVER_ID, indicating that an
     *      invalid identifier has been given to the server. This value can be
     *      considered a hint to the server. The server may alter this value
     *      based on its own policies or allowed values. If this value is zero,
     *      a default timeout is used.
     *@throws  IllegalArgumentException  The DbEnv.setRpcServer method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public void setRpcServer(DbClient client, String host, long cl_timeout, long sv_timeout, int flags) throws DbException {
        db_javaJNI.DbEnv_set_rpc_server(swigCPtr, client, host, cl_timeout, sv_timeout, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setSegmentId(long)}
     */
    public void set_shm_key(long shm_key) throws DbException {
        setSegmentId(shm_key);
    }


    /**
     *  Specify a base segment ID for Berkeley DB environment shared memory
     *  regions created in system memory on VxWorks or systems supporting
     *  X/Open-style shared memory interfaces; for example, UNIX systems
     *  supporting <b>shmget</b> (2) and related System V IPC interfaces.</p>
     *  <p>
     *
     *  This base segment ID will be used when Berkeley DB shared memory regions
     *  are first created. It will be incremented a small integer value each
     *  time a new shared memory region is created; that is, if the base ID is
     *  35, the first shared memory region created will have a segment ID of 35,
     *  and the next one will have a segment ID between 36 and 40 or so. A
     *  Berkeley DB environment always creates a master shared memory region; an
     *  additional shared memory region for each of the subsystems supported by
     *  the environment (Locking, Logging, Memory Pool and Transaction); plus an
     *  additional shared memory region for each additional memory pool cache
     *  that is supported. Already existing regions with the same segment IDs
     *  will be removed. See <a href="{@docRoot}/../ref/env/region.html">Shared
     *  Memory Regions</a> for more information.</p> <p>
     *
     *  The intent behind this method is two-fold: without it, applications have
     *  no way to ensure that two Berkeley DB applications don't attempt to use
     *  the same segment IDs when creating different Berkeley DB environments.
     *  In addition, by using the same segment IDs each time the environment is
     *  created, previously created segments will be removed, and the set of
     *  segments on the system will not grow without bound.</p> <p>
     *
     *  The database environment's base segment ID may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_shm_key", one or more
     *  whitespace characters, and the ID. Because the <b>DB_CONFIG</b> file is
     *  read when the database environment is opened, it will silently overrule
     *  configuration done before that time.</p> <p>
     *
     *  The DbEnv.setSegmentId method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setSegmentId method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setSegmentId must be consistent with the existing
     *  environment or corruption can occur.</p>
     *
     *@param  shm_key                    the base segment ID for the database
     *      environment.
     *@throws  IllegalArgumentException  The DbEnv.setSegmentId method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setSegmentId(long shm_key) throws DbException {
        db_javaJNI.DbEnv_set_shm_key(swigCPtr, shm_key);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setTestAndSetSpins(int)}
     */
    public void set_tas_spins(int tas_spins) throws DbException {
        setTestAndSetSpins(tas_spins);
    }


    /**
     *  Specify that test-and-set mutexes should spin <b>tas_spins</b> times
     *  without blocking. The value defaults to 1 on uniprocessor systems and to
     *  50 times the number of processors on multiprocessor systems.</p> <p>
     *
     *  The database environment's test-and-set spin count may also be set using
     *  the environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_tas_spins", one or more
     *  whitespace characters, and the number of spins. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setTestAndSetSpins method configures operations performed
     *  using the specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setTestAndSetSpins method may be called at any time during the
     *  life of the application.</p>
     *
     *@param  tas_spins                  the number of spins test-and-set
     *      mutexes should execute before blocking.
     *@throws  IllegalArgumentException  The DbEnv.setTestAndSetSpins method
     *      will fail and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     */
    public void setTestAndSetSpins(int tas_spins) throws DbException {
        db_javaJNI.DbEnv_set_tas_spins(swigCPtr, tas_spins);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setTimeout(long,int)}
     */
    public void set_timeout(long timeout, int flags) throws DbException {
        setTimeout(timeout, flags);
    }


    /**
     *  The DbEnv.setTimeout method sets timeout values for locks or
     *  transactions in the database environment.</p> <p>
     *
     *  Timeouts are checked whenever a thread of control blocks on a lock or
     *  when deadlock detection is performed. (In the case of
     *  Db.DB_SET_LOCK_TIMEOUT, the lock is one requested explicitly through the
     *  Lock subsystem interfaces. In the case of Db.DB_SET_TXN_TIMEOUT, the
     *  lock is one requested on behalf of a transaction. In either case, it may
     *  be a lock requested by the database access methods underlying the
     *  application.) As timeouts are only checked when the lock request first
     *  blocks or when deadlock detection is performed, the accuracy of the
     *  timeout depends on how often deadlock detection is performed.</p> <p>
     *
     *  Timeout values specified for the database environment may be overridden
     *  on a per-lock or per-transaction basis. See {@link
     *  com.sleepycat.db.DbEnv#lockVector DbEnv.lockVector} and {@link
     *  com.sleepycat.db.DbTxn#setTimeout DbTxn.setTimeout} for more
     *  information.</p> <p>
     *
     *  The DbEnv.setTimeout method configures a database environment, not only
     *  operations performed using the specified {@link com.sleepycat.db.DbEnv
     *  DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setTimeout method may be called at any time during the life of
     *  the application.</p>
     *
     *@param  flags                      must be set to one of the following
     *      values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_LOCK_TIMEOUT
     *        Db.DB_SET_LOCK_TIMEOUT}<p>
     *
     *        Set the timeout value for locks in this database environment. <p>
     *
     *        The database environment's lock timeout value may also be set
     *        using the environment's <b>DB_CONFIG</b> file. The syntax of the
     *        entry in that file is a single line with the string
     *        "set_lock_timeout", one or more whitespace characters, and the
     *        lock timeout value. Because the <b>DB_CONFIG</b> file is read when
     *        the database environment is opened, it will silently overrule
     *        configuration done before that time.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_TXN_TIMEOUT
     *        Db.DB_SET_TXN_TIMEOUT}<p>
     *
     *        Set the timeout value for transactions in this database
     *        environment. <p>
     *
     *        The database environment's transaction timeout value may also be
     *        set using the environment's <b>DB_CONFIG</b> file. The syntax of
     *        the entry in that file is a single line with the string
     *        "set_txn_timeout", one or more whitespace characters, and the
     *        transaction timeout value. Because the <b>DB_CONFIG</b> file is
     *        read when the database environment is opened, it will silently
     *        overrule configuration done before that time.</p> </li>
     *      </ul>
     *
     *@param  timeout                    the timeout value. It must be specified
     *      as an unsigned 32-bit number of microseconds, limiting the maximum
     *      timeout to roughly 71 minutes.
     *@throws  IllegalArgumentException  The DbEnv.setTimeout method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public void setTimeout(long timeout, int flags) throws DbException {
        db_javaJNI.DbEnv_set_timeout(swigCPtr, timeout, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setTmpDir(String)}
     */
    public void set_tmp_dir(String dir) throws DbException {
        setTmpDir(dir);
    }


    /**
     *  Specify the path of a directory to be used as the location of temporary
     *  files. The files created to back in-memory access method databases will
     *  be created relative to this path. These temporary files can be quite
     *  large, depending on the size of the database.</p> <p>
     *
     *  If no directories are specified, the following alternatives are checked
     *  in the specified order. The first existing directory path is used for
     *  all temporary files.</p>
     *  <ol><p>
     *
     *
     *    <li> The value of the environment variable <b>TMPDIR</b> .
     *    <li> The value of the environment variable <b>TEMP</b> .
     *    <li> The value of the environment variable <b>TMP</b> .
     *    <li> The value of the environment variable <b>TempFolder</b> .
     *    <li> The value returned by the GetTempPath interface.
     *    <li> The directory <b>/var/tmp</b> .
     *    <li> The directory <b>/usr/tmp</b> .
     *    <li> The directory <b>/temp</b> .
     *    <li> The directory <b>/tmp</b> .
     *    <li> The directory <b>C:/temp</b> .
     *    <li> The directory <b>C:/tmp</b> .
     *  </ol>
     *  <p>
     *
     *  Note: environment variables are only checked if one of the {@link
     *  com.sleepycat.db.Db#DB_USE_ENVIRON Db.DB_USE_ENVIRON} or {@link
     *  com.sleepycat.db.Db#DB_USE_ENVIRON_ROOT Db.DB_USE_ENVIRON_ROOT} flags
     *  were specified.</p> <p>
     *
     *  Note: the GetTempPath interface is only checked on Win/32 platforms.</p>
     *  <p>
     *
     *  The database environment's temporary file directory may also be set
     *  using the environment's <b>DB_CONFIG</b> file. The syntax of the entry
     *  in that file is a single line with the string "set_tmp_dir", one or more
     *  whitespace characters, and the directory name. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setTmpDir method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setTmpDir method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setTmpDir must be consistent with the existing
     *  environment or corruption can occur.</p>
     *
     *@param  dir                        the directory to be used to store
     *      temporary files.
     *@throws  IllegalArgumentException  The DbEnv.setTmpDir method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setTmpDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_tmp_dir(swigCPtr, dir);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setTxnMax(int)}
     */
    public void set_tx_max(int max) throws DbException {
        setTxnMax(max);
    }


    /**
     *  Configure the Berkeley DB database environment to support at least <b>
     *  max</b> active transactions. This value bounds the size of the memory
     *  allocated for transactions. Child transactions are counted as active
     *  until they either commit or abort.</p> <p>
     *
     *  When all of the memory available in the database environment for
     *  transactions is in use, calls to {@link com.sleepycat.db.DbEnv#txnBegin
     *  DbEnv.txnBegin} will fail (until some active transactions complete). If
     *  this interface is never called, the database environment is configured
     *  to support at least 20 active transactions.</p> <p>
     *
     *  The database environment's number of active transactions may also be set
     *  using the environment's <b>DB_CONFIG</b> file. The syntax of the entry
     *  in that file is a single line with the string "set_tx_max", one or more
     *  whitespace characters, and the number of transactions. Because the <b>
     *  DB_CONFIG</b> file is read when the database environment is opened, it
     *  will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setTxnMax method configures a database environment, not only
     *  operations performed using the specified {@link com.sleepycat.db.DbEnv
     *  DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setTxnMax method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setTxnMax will be ignored. </p>
     *
     *@param  max                        The <b>max</b> parameter configures the
     *      minimum number of simultaneously active transactions supported by
     *      Berkeley DB database environment.
     *@throws  IllegalArgumentException  The DbEnv.setTxnMax method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setTxnMax(int max) throws DbException {
        db_javaJNI.DbEnv_set_tx_max(swigCPtr, max);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setAppDispatch(DbAppDispatch)}
     */
    public void set_app_dispatch(DbAppDispatch tx_recover) throws DbException {
        setAppDispatch(tx_recover);
    }


    /**
     *  Sets the appDispatch attribute of the DbEnv object
     *
     *@param  tx_recover       The new appDispatch value
     */
    public void setAppDispatch(DbAppDispatch tx_recover) throws DbException {
        db_javaJNI.DbEnv_set_app_dispatch(swigCPtr, (app_dispatch_handler = tx_recover));
    }


    /**
     *
     */
    void set_tx_timestamp0(long timestamp) {
        db_javaJNI.DbEnv_set_tx_timestamp0(swigCPtr, timestamp);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setVerbose(int,boolean)}
     */
    public void set_verbose(int which, boolean onoff) throws DbException {
        setVerbose(which, onoff);
    }


    /**
     *  The DbEnv.setVerbose method turns specific additional informational and
     *  debugging messages in the Berkeley DB message output on and off. To see
     *  the additional messages, verbose messages must also be configured for
     *  the application. For more information on verbose messages, see the
     *  {@link com.sleepycat.db.Db#setErrorStream Db.setErrorStream} method.</p>
     *  <p>
     *
     *  The database environment's messages may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_verbose", one or more
     *  whitespace characters, and the method <b>which</b> parameter as a
     *  string; for example, "set_verbose DB_VERB_CHKPOINT". Because the <b>
     *  DB_CONFIG</b> file is read when the database environment is opened, it
     *  will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setVerbose method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setVerbose method may be called at any time during the life of
     *  the application.</p>
     *
     *@param  onoff                      If the <b>onoff</b> parameter is set to
     *      true, the additional messages are output.
     *@param  which                      must be set to one of the following
     *      values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_VERB_CHKPOINT
     *        Db.DB_VERB_CHKPOINT}<p>
     *
     *        Display checkpoint location information when searching the log for
     *        checkpoints. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_VERB_DEADLOCK
     *        Db.DB_VERB_DEADLOCK}<p>
     *
     *        Display additional information when doing deadlock detection.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_VERB_RECOVERY
     *        Db.DB_VERB_RECOVERY}<p>
     *
     *        Display additional information when performing recovery. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_VERB_REPLICATION
     *        Db.DB_VERB_REPLICATION}<p>
     *
     *        Display additional information when processing replication
     *        messages. <p>
     *
     *        Note, to get complete replication logging when debugging
     *        replication applications, you must also configure and build the
     *        Berkeley DB library with the <a
     *        href="{@docRoot}/../ref/build_unix/conf.html">--enable-diagnostic
     *        </a> configuration option as well as call the DbEnv.setVerbose
     *        method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_VERB_WAITSFOR
     *        Db.DB_VERB_WAITSFOR}<p>
     *
     *        Display the waits-for table when doing deadlock detection. </li>
     *
     *      </ul>
     *
     *@throws  IllegalArgumentException  The DbEnv.setVerbose method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public void setVerbose(int which, boolean onoff) throws DbException {
        db_javaJNI.DbEnv_set_verbose(swigCPtr, which, onoff);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLockConflicts()}
     */
    public byte[][] get_lk_conflicts() throws DbException {
        return getLockConflicts();
    }


    /**
     *  The DbEnv.getLockConflicts method returns the conflicts array.</p> <p>
     *
     *  The DbEnv.getLockConflicts method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getLockConflicts method returns the
     *      conflicts array.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public byte[][] getLockConflicts() throws DbException {
        return db_javaJNI.DbEnv_get_lk_conflicts(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLockDetect()}
     */
    public int get_lk_detect() throws DbException {
        return getLockDetect();
    }


    /**
     *  The DbEnv.getLockDetect method returns the deadlock detector
     *  configuration.</p> <p>
     *
     *  The DbEnv.getLockDetect method may be called at any time during the life
     *  of the application.</p>
     *
     *@return               The DbEnv.getLockDetect method returns the deadlock
     *      detector configuration.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLockDetect() throws DbException {
        return db_javaJNI.DbEnv_get_lk_detect(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLockMaxLocks()}
     */
    public int get_lk_max_locks() throws DbException {
        return getLockMaxLocks();
    }


    /**
     *  The DbEnv.setLockMaxLocks method returns the maximum number of locks.
     *  </p> <p>
     *
     *  The DbEnv.setLockMaxLocks method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.setLockMaxLocks method returns the maximum
     *      number of locks.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLockMaxLocks() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_locks(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLockMaxLockers()}
     */
    public int get_lk_max_lockers() throws DbException {
        return getLockMaxLockers();
    }


    /**
     *  The DbEnv.getLockMaxLockers method returns the maximum number of
     *  lockers.</p> <p>
     *
     *  The DbEnv.getLockMaxLockers method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getLockMaxLockers method returns the
     *      maximum number of lockers.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLockMaxLockers() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_lockers(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLockMaxObjects()}
     */
    public int get_lk_max_objects() throws DbException {
        return getLockMaxObjects();
    }


    /**
     *  The DbEnv.getLockMaxObjects method returns the maximum number of locked
     *  objects.</p> <p>
     *
     *  The DbEnv.getLockMaxObjects method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getLockMaxObjects method returns the
     *      maximum number of locked objects.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLockMaxObjects() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_objects(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockDetect(int,int)}
     */
    public int lock_detect(int flags, int atype) throws DbException {
        return lockDetect(flags, atype);
    }


    /**
     *  The DbEnv.lockDetect method runs one iteration of the deadlock detector.
     *  The deadlock detector traverses the lock table and marks one of the
     *  participating lock requesters for rejection in each deadlock it finds.
     *  </p>
     *
     *@param  atype                      specifies which lock request(s) to
     *      reject. It must be set to one of the following list:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_DEFAULT
     *        Db.DB_LOCK_DEFAULT}<p>
     *
     *        Use whatever lock policy was specified when the database
     *        environment was created. If no lock policy has yet been specified,
     *        set the lock policy to <code>Db.DB_LOCK_RANDOM</code>. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_EXPIRE Db.DB_LOCK_EXPIRE}
     *        <p>
     *
     *        Reject lock requests which have timed out. No other deadlock
     *        detection is performed. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MAXLOCKS
     *        Db.DB_LOCK_MAXLOCKS}<p>
     *
     *        Reject the lock request for the locker ID with the greatest number
     *        of locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MINLOCKS
     *        Db.DB_LOCK_MINLOCKS}<p>
     *
     *        Reject the lock request for the locker ID with the fewest number
     *        of locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MINWRITE
     *        Db.DB_LOCK_MINWRITE}<p>
     *
     *        Reject the lock request for the locker ID with the fewest number
     *        of write locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_OLDEST Db.DB_LOCK_OLDEST}
     *        <p>
     *
     *        Reject the lock request for the oldest locker ID. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_RANDOM Db.DB_LOCK_RANDOM}
     *        <p>
     *
     *        Reject the lock request for a random locker ID. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_YOUNGEST
     *        Db.DB_LOCK_YOUNGEST}<p>
     *
     *        Reject the lock request for the youngest locker ID. </li>
     *      </ul>
     *
     *@param  flags                      currently unused, and must be set to 0.
     *@return                            The DbEnv.lockDetect method returns the
     *      number of lock requests that were rejected.</p>
     *@throws  IllegalArgumentException  The DbEnv.lockDetect method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public int lockDetect(int flags, int atype) throws DbException {
        return db_javaJNI.DbEnv_lock_detect(swigCPtr, flags, atype);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockGet(int,int,Dbt,int)}
     */
    public DbLock lock_get(int locker, int flags, Dbt object, int lock_mode) throws DbException {
        return lockGet(locker, flags, object, lock_mode);
    }


    /**
     *  The DbEnv.lockGet method acquires a lock from the lock table, returning
     *  information about it in a DbLock object.</p>
     *
     *@param  flags                       must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_NOWAIT Db.DB_LOCK_NOWAIT}
     *        <p>
     *
     *        If a lock cannot be granted because the requested lock conflicts
     *        with an existing lock, throw a {@link
     *        com.sleepycat.db.DbLockNotGrantedException
     *        DbLockNotGrantedException} immediately instead of waiting for the
     *        lock to become available. </li>
     *      </ul>
     *
     *@param  lock_mode                   used as an index into the
     *      environment's lock conflict matrix. When using the default lock
     *      conflict matrix, <b>lock_mode</b> must be set to one of the
     *      following values: read (shared) write (exclusive) intention to write
     *      (shared) intention to read (shared) intention to read and write
     *      (shared) <p>
     *
     *      See {@link com.sleepycat.db.DbEnv#setLockConflicts
     *      DbEnv.setLockConflicts} and <a
     *      href="{@docRoot}/../ref/lock/stdmode.html">Standard Lock Modes</a>
     *      for more information on the lock conflict matrix.</p>
     *@param  locker                      an unsigned 32-bit integer quantity.
     *      It represents the entity requesting the lock.
     *@param  object                      an untyped byte string that specifies
     *      the object to be locked. Applications using the locking subsystem
     *      directly while also doing locking via the Berkeley DB access methods
     *      must take care not to inadvertently lock objects that happen to be
     *      equal to the unique file IDs used to lock files. See <a
     *      href="{@docRoot}/../ref/lock/am_conv.html">Access method locking
     *      conventions</a> for more information.
     *@return                             The DbEnv.lockGet method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock, the
     *      DbEnv.lockGet method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException} exception.
     *@throws  DbLockNotGrantedException  If a Berkeley DB Concurrent Data Store
     *      database environment configured for lock timeouts was unable to
     *      grant a lock in the allowed time, the DbEnv.lockGet method will fail
     *      and throw a {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  DbLockNotGrantedException  If the {@link
     *      com.sleepycat.db.Db#DB_LOCK_NOWAIT Db.DB_LOCK_NOWAIT} flag or lock
     *      timers were configured and the lock could not be granted before the
     *      wait-time expired, the DbEnv.lockGet method will fail and throw a
     *      {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     *@throws  IllegalArgumentException   The DbEnv.lockGet method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     *@throws  DbMemoryException          If the maximum number of locks has
     *      been reached, the DbEnv.lockGet method will fail and throw a {@link
     *      com.sleepycat.db.DbMemoryException DbMemoryException} exception.
     */
    public DbLock lockGet(int locker, int flags, Dbt object, int lock_mode) throws DbException {
        long cPtr = db_javaJNI.DbEnv_lock_get(swigCPtr, locker, flags, object, lock_mode);
        return (cPtr == 0) ? null : new DbLock(cPtr, true);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockId()}
     */
    public int lock_id() throws DbException {
        return lockId();
    }


    /**
     *  The DbEnv.lockId method returns a locker ID, which is guaranteed to be
     *  unique in the specified lock table.</p> <p>
     *
     *  The {@link com.sleepycat.db.DbEnv#lockIdFree DbEnv.lockIdFree} method
     *  should be called to return the locker ID to the Berkeley DB library when
     *  it is no longer needed.</p>
     *
     *@return               The DbEnv.lockId method returns a locker ID which is
     *      guaranteed to be unique in the specified lock table.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int lockId() throws DbException {
        return db_javaJNI.DbEnv_lock_id(swigCPtr);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockIdFree(int)}
     */
    public void lock_id_free(int id) throws DbException {
        lockIdFree(id);
    }


    /**
     *  The DbEnv.lockIdFree method frees a locker ID allocated by the {@link
     *  com.sleepycat.db.DbEnv#lockId DbEnv.lockId} method.</p>
     *
     *@param  id                         the locker id to be freed.
     *@throws  IllegalArgumentException  The DbEnv.lockIdFree method will fail
     *      and throw a IllegalArgumentException exception if the locker ID is
     *      invalid or locks are still held by this locker ID; or if an invalid
     *      flag value or parameter was specified.
     */
    public void lockIdFree(int id) throws DbException {
        db_javaJNI.DbEnv_lock_id_free(swigCPtr, id);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockPut(DbLock)}
     */
    public void lock_put(DbLock lock) throws DbException {
        lockPut(lock);
    }


    /**
     *  The DbEnv.lockPut method releases <b>lock</b> .</p>
     *
     *@param  lock                       the lock to be released.
     *@throws  IllegalArgumentException  The DbEnv.lockPut method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public void lockPut(DbLock lock) throws DbException {
        db_javaJNI.DbEnv_lock_put(swigCPtr, DbLock.getCPtr(lock));
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #lockStat(int)}
     */
    public DbLockStat lock_stat(int flags) throws DbException {
        return lockStat(flags);
    }


    /**
     *  The DbEnv.lockStat method returns the locking subsystem statistics.</p>
     *  <p>
     *
     *  The DbEnv.lockStat method creates a DbLockStat object encapsulating the
     *  locking subsystem statistics. The following data fields are available
     *  from the DbLockStat object:</p> For convenience, the DbLockStat class
     *  has a toString method that lists all the data fields.</p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return                            The DbEnv.lockStat method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.lockStat method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public DbLockStat lockStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_lock_stat(swigCPtr, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLockConflicts(byte[][])}
     */
    public void set_lk_conflicts(byte[][] conflicts) throws DbException {
        setLockConflicts(conflicts);
    }


    /**
     *  Set the locking conflicts matrix.</p> <p>
     *
     *  If DbEnv.setLockConflicts is never called, a standard conflicts array is
     *  used; see <a href="{@docRoot}/../ref/lock/stdmode.html">Standard Lock
     *  Modes</a> for more information.</p> <p>
     *
     *  The DbEnv.setLockConflicts method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLockConflicts method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLockConflicts will be ignored. </p>
     *
     *@param  conflicts                  the new locking conflicts matrix. A
     *      non-0 value for the array element indicates that requested_mode and
     *      held_mode conflict: <blockquote><pre>conflicts[requested_mode][held_mode]</pre>
     *      </blockquote> <p>
     *
     *      The <i>not-granted</i> mode must be represented by 0.</p>
     *@throws  IllegalArgumentException  The DbEnv.setLockConflicts method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     *@throws  DbMemoryException         If the conflicts array could not be
     *      copied, the DbEnv.setLockConflicts method will fail and throw a
     *      {@link com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     */
    public void setLockConflicts(byte[][] conflicts) throws DbException {
        db_javaJNI.DbEnv_set_lk_conflicts(swigCPtr, conflicts);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLockDetect(int)}
     */
    public void set_lk_detect(int detect) throws DbException {
        setLockDetect(detect);
    }


    /**
     *  Set if the deadlock detector is to be run whenever a lock conflict
     *  occurs, and specify what lock request(s) should be rejected. As
     *  transactions acquire locks on behalf of a single locker ID, rejecting a
     *  lock request associated with a transaction normally requires the
     *  transaction be aborted.</p> <p>
     *
     *  The database environment's deadlock detector configuration may also be
     *  set using the environment's <b>DB_CONFIG</b> file. The syntax of the
     *  entry in that file is a single line with the string "set_lk_detect", one
     *  or more whitespace characters, and the method <b>detect</b> parameter as
     *  a string; for example, "set_lk_detect DB_LOCK_OLDEST". Because the <b>
     *  DB_CONFIG</b> file is read when the database environment is opened, it
     *  will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLockDetect method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLockDetect method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLockDetect must be consistent with the existing
     *  environment or an error will be returned. </p>
     *
     *@param  detect                     The <b>detect</b> parameter configures
     *      the deadlock detector. The specified value must be one of the
     *      following list:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_DEFAULT
     *        Db.DB_LOCK_DEFAULT}<p>
     *
     *        Use whatever lock policy was specified when the database
     *        environment was created. If no lock policy has yet been specified,
     *        set the lock policy to <code>Db.DB_LOCK_RANDOM</code>. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_EXPIRE Db.DB_LOCK_EXPIRE}
     *        <p>
     *
     *        Reject lock requests which have timed out. No other deadlock
     *        detection is performed. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MAXLOCKS
     *        Db.DB_LOCK_MAXLOCKS}<p>
     *
     *        Reject the lock request for the locker ID with the greatest number
     *        of locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MINLOCKS
     *        Db.DB_LOCK_MINLOCKS}<p>
     *
     *        Reject the lock request for the locker ID with the fewest number
     *        of locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_MINWRITE
     *        Db.DB_LOCK_MINWRITE}<p>
     *
     *        Reject the lock request for the locker ID with the fewest number
     *        of write locks. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_OLDEST Db.DB_LOCK_OLDEST}
     *        <p>
     *
     *        Reject the lock request for the oldest locker ID. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_RANDOM Db.DB_LOCK_RANDOM}
     *        <p>
     *
     *        Reject the lock request for a random locker ID. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LOCK_YOUNGEST
     *        Db.DB_LOCK_YOUNGEST}<p>
     *
     *        Reject the lock request for the youngest locker ID. </li>
     *      </ul>
     *
     *@throws  IllegalArgumentException  The DbEnv.setLockDetect method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLockDetect(int detect) throws DbException {
        db_javaJNI.DbEnv_set_lk_detect(swigCPtr, detect);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLockMaxLockers(int)}
     */
    public void set_lk_max_lockers(int max) throws DbException {
        setLockMaxLockers(max);
    }


    /**
     *  Set the maximum number of locking entities supported by the Berkeley DB
     *  environment. This value is used by {@link com.sleepycat.db.DbEnv#open
     *  DbEnv.open} to estimate how much space to allocate for various
     *  lock-table data structures. The default value is 1000 lockers. For
     *  specific information on configuring the size of the lock subsystem, see
     *  <a href="{@docRoot}/../ref/lock/max.html">Configuring locking: sizing
     *  the system</a> .</p> <p>
     *
     *  The database environment's maximum number of lockers may also be set
     *  using the environment's <b>DB_CONFIG</b> file. The syntax of the entry
     *  in that file is a single line with the string "set_lk_max_lockers", one
     *  or more whitespace characters, and the number of lockers. Because the
     *  <b>DB_CONFIG</b> file is read when the database environment is opened,
     *  it will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLockMaxLockers method configures a database environment,
     *  not only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLockMaxLockers method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLockMaxLockers will be ignored. </p>
     *
     *@param  max                        the maximum number simultaneous locking
     *      entities supported by the Berkeley DB environment.
     *@throws  IllegalArgumentException  The DbEnv.setLockMaxLockers method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLockMaxLockers(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_lockers(swigCPtr, max);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLockMaxLocks(int)}
     */
    public void set_lk_max_locks(int max) throws DbException {
        setLockMaxLocks(max);
    }


    /**
     *  Set the maximum number of locks supported by the Berkeley DB
     *  environment. This value is used by {@link com.sleepycat.db.DbEnv#open
     *  DbEnv.open} to estimate how much space to allocate for various
     *  lock-table data structures. The default value is 1000 locks. For
     *  specific information on configuring the size of the lock subsystem, see
     *  <a href="{@docRoot}/../ref/lock/max.html">Configuring locking: sizing
     *  the system</a> .</p> <p>
     *
     *  The database environment's maximum number of locks may also be set using
     *  the environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_lk_max_locks", one or more
     *  whitespace characters, and the number of locks. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLockMaxLocks method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLockMaxLocks method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLockMaxLocks will be ignored. </p>
     *
     *@param  max                        the maximum number of locks supported
     *      by the Berkeley DB environment.
     *@throws  IllegalArgumentException  The DbEnv.setLockMaxLocks method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLockMaxLocks(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_locks(swigCPtr, max);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLockMaxObjects(int)}
     */
    public void set_lk_max_objects(int max) throws DbException {
        setLockMaxObjects(max);
    }


    /**
     *  Set the maximum number of locked objects supported by the Berkeley DB
     *  environment. This value is used by {@link com.sleepycat.db.DbEnv#open
     *  DbEnv.open} to estimate how much space to allocate for various
     *  lock-table data structures. The default value is 1000 objects. For
     *  specific information on configuring the size of the lock subsystem, see
     *  <a href="{@docRoot}/../ref/lock/max.html">Configuring locking: sizing
     *  the system</a> .</p> <p>
     *
     *  The database environment's maximum number of objects may also be set
     *  using the environment's <b>DB_CONFIG</b> file. The syntax of the entry
     *  in that file is a single line with the string "set_lk_max_objects", one
     *  or more whitespace characters, and the number of objects. Because the
     *  <b>DB_CONFIG</b> file is read when the database environment is opened,
     *  it will silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLockMaxObjects method configures a database environment,
     *  not only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLockMaxObjects method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLockMaxObjects will be ignored. </p>
     *
     *@param  max                        the maximum number of locked objects
     *      supported by the Berkeley DB environment.
     *@throws  IllegalArgumentException  The DbEnv.setLockMaxObjects method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLockMaxObjects(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_objects(swigCPtr, max);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLogBufferSize()}
     */
    public int get_lg_bsize() throws DbException {
        return getLogBufferSize();
    }


    /**
     *  The DbEnv.getLogBufferSize method returns the size of the log buffer, in
     *  bytes.</p> <p>
     *
     *  The DbEnv.getLogBufferSize method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getLogBufferSize method returns the size
     *      of the log buffer, in bytes.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLogBufferSize() throws DbException {
        return db_javaJNI.DbEnv_get_lg_bsize(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLogDir()}
     */
    public String get_lg_dir() throws DbException {
        return getLogDir();
    }


    /**
     *  The DbEnv.getLogDir method returns the log directory.</p> <p>
     *
     *  The DbEnv.getLogDir method may be called at any time during the life of
     *  the application.</p>
     *
     *@return               The DbEnv.getLogDir method returns the log
     *      directory.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public String getLogDir() throws DbException {
        return db_javaJNI.DbEnv_get_lg_dir(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLogMax()}
     */
    public int get_lg_max() throws DbException {
        return getLogMax();
    }


    /**
     *  The DbEnv.getLogMax method returns the maximum log file size.</p> <p>
     *
     *  The DbEnv.getLogMax method may be called at any time during the life of
     *  the application.</p>
     *
     *@return               The DbEnv.getLogMax method returns the maximum log
     *      file size.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLogMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_max(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getLogRegionMax()}
     */
    public int get_lg_regionmax() throws DbException {
        return getLogRegionMax();
    }


    /**
     *  The DbEnv.getLogRegionMax method returns the size of the underlying
     *  logging subsystem region.</p> <p>
     *
     *  The DbEnv.getLogRegionMax method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getLogRegionMax method returns the size of
     *      the underlying logging subsystem region.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getLogRegionMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_regionmax(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logArchive(int)}
     */
    public String[] log_archive(int flags) throws DbException {
        return logArchive(flags);
    }


    /**
     *  The DbEnv.logArchive method returns an array of log or database
     *  filenames.</p> <p>
     *
     *  By default, DbEnv.logArchive returns the names of all of the log files
     *  that are no longer in use (for example, that are no longer involved in
     *  active transactions), and that may safely be archived for catastrophic
     *  recovery and then removed from the system. If there are no filenames to
     *  return, DbEnv.logArchive returns null.</p> <p>
     *
     *  Log cursor handles (returned by the {@link
     *  com.sleepycat.db.DbEnv#logCursor DbEnv.logCursor} method) may have open
     *  file descriptors for log files in the database environment. Also, the
     *  Berkeley DB interfaces to the database environment logging subsystem
     *  (for example, {@link com.sleepycat.db.DbEnv#logPut DbEnv.logPut} and
     *  {@link com.sleepycat.db.DbTxn#abort DbTxn.abort}) may allocate log
     *  cursors and have open file descriptors for log files as well. On
     *  operating systems where filesystem related system calls (for example,
     *  rename and unlink on Windows/NT) can fail if a process has an open file
     *  descriptor for the affected file, attempting to move or remove the log
     *  files listed by DbEnv.logArchive may fail. All Berkeley DB internal use
     *  of log cursors operates on active log files only and furthermore, is
     *  short-lived in nature. So, an application seeing such a failure should
     *  be restructured to close any open log cursors it may have, and otherwise
     *  to retry the operation until it succeeds. (Although the latter is not
     *  likely to be necessary; it is hard to imagine a reason to move or rename
     *  a log file in which transactions are being logged or aborted.)</p> <p>
     *
     *  See <a href="{@docRoot}/../utility/db_archive.html">db_archive</a> for
     *  more information on database archival procedures.</p>
     *
     *@param  flags                      must be set to 0 or by bitwise
     *      inclusively <b>OR</b> 'ing together one or more of the following
     *      values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ARCH_ABS Db.DB_ARCH_ABS}<p>
     *
     *        All pathnames are returned as absolute pathnames, instead of
     *        relative to the database home directory. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ARCH_DATA Db.DB_ARCH_DATA}<p>
     *
     *        Return the database files that need to be archived in order to
     *        recover the database from catastrophic failure. If any of the
     *        database files have not been accessed during the lifetime of the
     *        current log files, DbEnv.logArchive will not include them in this
     *        list. It is also possible that some of the files referred to by
     *        the log have since been deleted from the system. <p>
     *
     *        The <code>Db.DB_ARCH_DATA</code> and <code>Db.DB_ARCH_LOG</code>
     *        flags are mutually exclusive.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ARCH_LOG Db.DB_ARCH_LOG}<p>
     *
     *        Return all the log filenames, regardless of whether or not they
     *        are in use. <p>
     *
     *        The <code>Db.DB_ARCH_DATA</code> and <code>Db.DB_ARCH_LOG</code>
     *        flags are mutually exclusive.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ARCH_REMOVE Db.DB_ARCH_REMOVE}
     *        <p>
     *
     *        Remove log files that are no longer needed; no filenames are
     *        returned. Automatic log file removal is likely to make
     *        catastrophic recovery impossible. <p>
     *
     *        The <code>Db.DB_ARCH_REMOVE</code> flag may not be specified with
     *        any other flag.</p> </li>
     *      </ul>
     *
     *@return                            The DbEnv.logArchive method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.logArchive method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public String[] logArchive(int flags) throws DbException {
        return db_javaJNI.DbEnv_log_archive(swigCPtr, flags);
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #logCompare(DbLsn,DbLsn)}
     */
    public static int log_compare(DbLsn lsn0, DbLsn lsn1) {
        return logCompare(lsn0, lsn1);
    }


    /**
     *  The DbEnv.logCompare method allows the caller to compare two {@link
     *  com.sleepycat.db.DbLsn DbLsn} objects, returning 0 if they are equal, 1
     *  if <b>lsn0</b> is greater than <b>lsn1</b> , and -1 if <b>lsn0</b> is
     *  less than <b>lsn1</b> .</p>
     *
     *@param  lsn0  one of the {@link com.sleepycat.db.DbLsn DbLsn} objects to
     *      be compared.
     *@param  lsn1  one of the {@link com.sleepycat.db.DbLsn DbLsn} objects to
     *      be compared.
     *@return       The DbEnv.logCompare method returns 0 if the {@link
     *      com.sleepycat.db.DbLsn DbLsn} object parameters are equal, 1 if <b>
     *      lsn0</b> is greater than <b>lsn1</b> , and -1 if <b>lsn0</b> is less
     *      than <b>lsn1</b> .</p>
     */
    public static int logCompare(DbLsn lsn0, DbLsn lsn1) {
        return db_javaJNI.DbEnv_log_compare(DbLsn.getCPtr(lsn0), DbLsn.getCPtr(lsn1));
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logCursor(int)}
     */
    public DbLogc log_cursor(int flags) throws DbException {
        return logCursor(flags);
    }


    /**
     *  The DbEnv.logCursor method returns a created log cursor.</p>
     *
     *@param  flags                      currently unused, and must be set to 0.
     *@return                            The DbEnv.logCursor method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.logCursor method will fail
     *      and throw a IllegalArgumentException exception if an invalid flag
     *      value or parameter was specified.
     */
    public DbLogc logCursor(int flags) throws DbException {
        long cPtr = db_javaJNI.DbEnv_log_cursor(swigCPtr, flags);
        return (cPtr == 0) ? null : new DbLogc(cPtr, true);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logFile(DbLsn)}
     */
    public String log_file(DbLsn lsn) throws DbException {
        return logFile(lsn);
    }


    /**
     *  The DbEnv.logFile method maps {@link com.sleepycat.db.DbLsn DbLsn}
     *  objects to filenames, returning the name of the file containing the
     *  record named by <b>lsn</b> .</p> <p>
     *
     *  This mapping of {@link com.sleepycat.db.DbLsn DbLsn} objects to files is
     *  needed for database administration. For example, a transaction manager
     *  typically records the earliest {@link com.sleepycat.db.DbLsn DbLsn}
     *  needed for restart, and the database administrator may want to archive
     *  log files to tape when they contain only {@link com.sleepycat.db.DbLsn
     *  DbLsn} entries before the earliest one needed for restart.</p>
     *
     *@param  lsn                 the {@link com.sleepycat.db.DbLsn DbLsn}
     *      object for which a filename is wanted.
     *@return                     The DbEnv.logFile method throws an exception
     *      that encapsulates a non-zero error value on failure. </p>
     *@throws  DbMemoryException  If the supplied buffer was too small to hold
     *      the log filename, the DbEnv.logFile method will fail and throw a
     *      {@link com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     */
    public String logFile(DbLsn lsn) throws DbException {
        return db_javaJNI.DbEnv_log_file(swigCPtr, DbLsn.getCPtr(lsn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logFlush(DbLsn)}
     */
    public void log_flush(DbLsn lsn) throws DbException {
        logFlush(lsn);
    }


    /**
     *  The DbEnv.logFlush method writes log records to disk.</p>
     *
     *@param  lsn                        All log records with {@link
     *      com.sleepycat.db.DbLsn DbLsn} values less than or equal to the <b>
     *      lsn</b> parameter are written to disk. If <b>lsn</b> is null, all
     *      records in the log are flushed.
     *@throws  IllegalArgumentException  The DbEnv.logFlush method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public void logFlush(DbLsn lsn) throws DbException {
        db_javaJNI.DbEnv_log_flush(swigCPtr, DbLsn.getCPtr(lsn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logPut(DbLsn,Dbt,int)}
     */
    public void log_put(DbLsn lsn, Dbt data, int flags) throws DbException {
        logPut(lsn, data, flags);
    }


    /**
     *  The DbEnv.logPut method appends records to the log. The {@link
     *  com.sleepycat.db.DbLsn DbLsn} of the put record is returned in the <b>
     *  lsn</b> parameter.</p>
     *
     *@param  data                       the record to write to the log. <p>
     *
     *      The caller is responsible for providing any necessary structure to
     *      <b>data</b> . (For example, in a write-ahead logging protocol, the
     *      application must understand what part of <b>data</b> is an operation
     *      code, what part is redo information, and what part is undo
     *      information. In addition, most transaction managers will store in
     *      <b>data</b> the {@link com.sleepycat.db.DbLsn DbLsn} of the previous
     *      log record for the same transaction, to support chaining back
     *      through the transaction's log records during undo.)</p>
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FLUSH Db.DB_FLUSH}<p>
     *
     *        The log is forced to disk after this record is written,
     *        guaranteeing that all records with {@link com.sleepycat.db.DbLsn
     *        DbLsn} values less than or equal to the one being "put" are on
     *        disk before DbEnv.logPut returns. </li>
     *      </ul>
     *
     *@param  lsn                        references memory into which the {@link
     *      com.sleepycat.db.DbLsn DbLsn} of the put record is copied.
     *@throws  IllegalArgumentException  The {@link
     *      com.sleepycat.db.DbEnv#logFlush DbEnv.logFlush} method will fail and
     *      throw a IllegalArgumentException exception if the record to be
     *      logged is larger than the maximum log record; or if an invalid flag
     *      value or parameter was specified.
     */
    public void logPut(DbLsn lsn, Dbt data, int flags) throws DbException {
        db_javaJNI.DbEnv_log_put(swigCPtr, DbLsn.getCPtr(lsn), data, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #logStat(int)}
     */
    public DbLogStat log_stat(int flags) throws DbException {
        return logStat(flags);
    }


    /**
     *  The DbEnv.logStat method returns the logging subsystem statistics.</p>
     *  <p>
     *
     *  The DbEnv.logStat method creates a DbLogStat object encapsulating the
     *  logging subsystem statistics. The following data fields are available
     *  from the DbLogStat object:</p> For convenience, the DbLogStat class has
     *  a toString method that lists all the data fields.</p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return                            The DbEnv.logStat method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.logStat method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public DbLogStat logStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_log_stat(swigCPtr, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLogBufferSize(int)}
     */
    public void set_lg_bsize(int lg_bsize) throws DbException {
        setLogBufferSize(lg_bsize);
    }


    /**
     *  Set the size of the in-memory log buffer, in bytes. By default, or if
     *  the value is set to 0, a size of 32K is used. The size of the log file
     *  (see {@link com.sleepycat.db.DbEnv#setLogMax DbEnv.setLogMax}) must be
     *  at least four times the size of the in-memory log buffer.</p> <p>
     *
     *  Log information is stored in-memory until the storage space fills up or
     *  transaction commit forces the information to be flushed to stable
     *  storage. In the presence of long-running transactions or transactions
     *  producing large amounts of data, larger buffer sizes can increase
     *  throughput.</p> <p>
     *
     *  The database environment's log buffer size may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_lg_bsize", one or more
     *  whitespace characters, and the size in bytes. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLogBufferSize method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLogBufferSize method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLogBufferSize will be ignored. </p>
     *
     *@param  lg_bsize                   the size of the in-memory log buffer,
     *      in bytes.
     *@throws  IllegalArgumentException  The DbEnv.setLogBufferSize method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; The size of the log file is less than four times the size of
     *      the in-memory log buffer; or if an invalid flag value or parameter
     *      was specified.
     */
    public void setLogBufferSize(int lg_bsize) throws DbException {
        db_javaJNI.DbEnv_set_lg_bsize(swigCPtr, lg_bsize);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLogDir(String)}
     */
    public void set_lg_dir(String dir) throws DbException {
        setLogDir(dir);
    }


    /**
     *  The path of a directory to be used as the location of logging files. Log
     *  files created by the Log Manager subsystem will be created in this
     *  directory.</p> <p>
     *
     *  If no logging directory is specified, log files are created in the
     *  environment home directory. See <a
     *  href="{@docRoot}/../ref/env/naming.html">Berkeley DB File Naming</a> for
     *  more information.</p> <p>
     *
     *  For the greatest degree of recoverability from system or application
     *  failure, database files and log files should be located on separate
     *  physical devices.</p> <p>
     *
     *  The database environment's logging directory may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_lg_dir", one or more
     *  whitespace characters, and the directory name. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLogDir method configures operations performed using the
     *  specified {@link com.sleepycat.db.DbEnv DbEnv} handle, not all
     *  operations performed on the underlying database environment.</p> <p>
     *
     *  The DbEnv.setLogDir method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLogDir must be consistent with the existing
     *  environment or corruption can occur.</p>
     *
     *@param  dir                        the directory used to store the logging
     *      files.
     *@throws  IllegalArgumentException  The DbEnv.setLogDir method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLogDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_lg_dir(swigCPtr, dir);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLogMax(int)}
     */
    public void set_lg_max(int lg_max) throws DbException {
        setLogMax(lg_max);
    }


    /**
     *  Set the maximum size of a single file in the log, in bytes. By default,
     *  or if the <b>lg_max</b> parameter is set to 0, a size of 10MB is used.
     *  Because {@link com.sleepycat.db.DbLsn DbLsn} file offsets are unsigned
     *  four-byte values, the set value may not be larger than the maximum
     *  unsigned four-byte value. The size of the log file must be at least four
     *  times the size of the in-memory log buffer (see {@link
     *  com.sleepycat.db.DbEnv#setLogBufferSize DbEnv.setLogBufferSize}).</p>
     *  <p>
     *
     *  See <a href="{@docRoot}/../ref/log/limits.html">Log File Limits</a> for
     *  more information.</p> <p>
     *
     *  The database environment's log file size may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_lg_max", one or more
     *  whitespace characters, and the size in bytes. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLogMax method configures a database environment, not only
     *  operations performed using the specified {@link com.sleepycat.db.DbEnv
     *  DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLogMax method may be called at any time during the life of
     *  the application.</p> If no size is specified by the application, the
     *  size last specified for the database region will be used, or if no
     *  database region previously existed, the default will be used.
     *
     *@param  lg_max                     the size of a single log file, in
     *      bytes.
     *@throws  IllegalArgumentException  The DbEnv.setLogMax method will fail
     *      and throw a IllegalArgumentException exception if the method was
     *      called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; the size of the log file is less than four times the size of
     *      the in-memory log buffer; The specified log file size was too large;
     *      or if an invalid flag value or parameter was specified.
     */
    public void setLogMax(int lg_max) throws DbException {
        db_javaJNI.DbEnv_set_lg_max(swigCPtr, lg_max);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setLogRegionMax(int)}
     */
    public void set_lg_regionmax(int lg_regionmax) throws DbException {
        setLogRegionMax(lg_regionmax);
    }


    /**
     *  Set the size of the underlying logging area of the Berkeley DB
     *  environment, in bytes. By default, or if the value is set to 0, the
     *  default size is 60KB. The log region is used to store filenames, and so
     *  may need to be increased in size if a large number of files will be
     *  opened and registered with the specified Berkeley DB environment's log
     *  manager.</p> <p>
     *
     *  The database environment's log region size may also be set using the
     *  environment's <b>DB_CONFIG</b> file. The syntax of the entry in that
     *  file is a single line with the string "set_lg_regionmax", one or more
     *  whitespace characters, and the size in bytes. Because the <b>DB_CONFIG
     *  </b> file is read when the database environment is opened, it will
     *  silently overrule configuration done before that time.</p> <p>
     *
     *  The DbEnv.setLogRegionMax method configures a database environment, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setLogRegionMax method may not be called after the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method is called. If the
     *  database environment already exists when {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} is called, the information
     *  specified to DbEnv.setLogRegionMax will be ignored. </p>
     *
     *@param  lg_regionmax               the size of the logging area in the
     *      Berkeley DB environment, in bytes.
     *@throws  IllegalArgumentException  The DbEnv.setLogRegionMax method will
     *      fail and throw a IllegalArgumentException exception if the method
     *      was called after {@link com.sleepycat.db.DbEnv#open DbEnv.open} was
     *      called; or if an invalid flag value or parameter was specified.
     */
    public void setLogRegionMax(int lg_regionmax) throws DbException {
        db_javaJNI.DbEnv_set_lg_regionmax(swigCPtr, lg_regionmax);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getCacheSize()}
     */
    public long get_cachesize() throws DbException {
        return getCacheSize();
    }


    /**
     *  The DbEnv.getCacheSize method returns the size of the cache.</p> <p>
     *
     *  The DbEnv.getCacheSize method may be called at any time during the life
     *  of the application.</p>
     *
     *@return               The DbEnv.getCacheSize method returns the size of
     *      the cache.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getCacheSize() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getCacheSizeNcache()}
     */
    public int get_cachesize_ncache() throws DbException {
        return getCacheSizeNcache();
    }


    /**
     *  The DbEnv.getCacheSizeNcache method returns the number of caches.</p>
     *  <p>
     *
     *  The DbEnv.getCacheSizeNcache method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getCacheSizeNcache method returns the
     *      number of caches.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize_ncache(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getMemoryPoolMapSize()}
     */
    public long get_mp_mmapsize() throws DbException {
        return getMemoryPoolMapSize();
    }


    /**
     *  The DbEnv.getMemoryPoolMapSize method returns the maximum file map size.
     *  </p> <p>
     *
     *  The DbEnv.getMemoryPoolMapSize method may be called at any time during
     *  the life of the application.</p>
     *
     *@return               The DbEnv.getMemoryPoolMapSize method returns the
     *      maximum file map size.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getMemoryPoolMapSize() throws DbException {
        return db_javaJNI.DbEnv_get_mp_mmapsize(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #memoryPoolStat(int)}
     */
    public DbMpoolStat memp_stat(int flags) throws DbException {
        return memoryPoolStat(flags);
    }


    /**
     *  The DbEnv.memoryPoolStat method returns the memory pool (that is, the
     *  buffer cache) subsystem statistics.</p> <p>
     *
     *  The DbEnv.memoryPoolStat method creates a DbMpoolStat object
     *  encapsulating memory pool (that is, the buffer cache) statistics. The
     *  following data fields are available from the DbMpoolStat object:</p> For
     *  convenience, the DbMpoolStat class has a toString method that lists all
     *  the data fields.</p>
     *
     *@param  flags         must be set to 0 or the following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return               The DbEnv.memoryPoolStat method throws an exception
     *      that encapsulates a non-zero error value on failure. </p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public DbMpoolStat memoryPoolStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_memp_stat(swigCPtr, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #memoryPoolFileStat(int)}
     */
    public DbMpoolFStat[] memp_fstat(int flags) throws DbException {
        return memoryPoolFileStat(flags);
    }


    /**
     *  The DbEnv.memoryPoolFileStat method creates an array of DbMpoolFStat
     *  objects containing statistics for individual files in the cache. Each
     *  DbMpoolFStat object contains statistics for an individual DbMpoolFile.
     *  The following data fields are available for each DbMpoolFStat object:
     *  </p> For convenience, the DbMpoolFStat class has a toString method that
     *  lists all the data fields.</p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return                            The DbEnv.memoryPoolFileStat method
     *      throws an exception that encapsulates a non-zero error value on
     *      failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.memoryPoolStat method will
     *      fail and throw a IllegalArgumentException exception if an invalid
     *      flag value or parameter was specified.
     */
    public DbMpoolFStat[] memoryPoolFileStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_memp_fstat(swigCPtr, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #memoryPoolTrickle(int)}
     */
    public int memp_trickle(int percent) throws DbException {
        return memoryPoolTrickle(percent);
    }


    /**
     *  The DbEnv.memoryPoolTrickle method ensures that a specified percent of
     *  the pages in the shared memory pool are clean, by writing dirty pages to
     *  their backing files.</p> <p>
     *
     *  The purpose of the DbEnv.memoryPoolTrickle function is to enable a
     *  memory pool manager to ensure that a page is always available for
     *  reading in new information without having to wait for a write.</p>
     *
     *@param  percent                    the percent of the pages in the cache
     *      that should be clean.
     *@return                            The DbEnv.memoryPoolTrickle method
     *      returns the number of pages that were written to reach the specified
     *      percentage.
     *@throws  IllegalArgumentException  The DbEnv.memoryPoolTrickle method will
     *      fail and throw a IllegalArgumentException exception if an invalid
     *      flag value or parameter was specified.
     */
    public int memoryPoolTrickle(int percent) throws DbException {
        return db_javaJNI.DbEnv_memp_trickle(swigCPtr, percent);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getTxnMax()}
     */
    public int get_tx_max() throws DbException {
        return getTxnMax();
    }


    /**
     *  The DbEnv.getTxnMax method returns the number of active transactions.
     *  </p> <p>
     *
     *  The DbEnv.getTxnMax method may be called at any time during the life of
     *  the application.</p>
     *
     *@return               The DbEnv.getTxnMax method returns the number of
     *      active transactions.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int getTxnMax() throws DbException {
        return db_javaJNI.DbEnv_get_tx_max(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getTxnTimestamp()}
     */
    public long get_tx_timestamp() throws DbException {
        return getTxnTimestamp();
    }


    /**
     *  The DbEnv.getTxnTimestamp method returns the recovery timestamp.</p> <p>
     *
     *  The DbEnv.getTxnTimestamp method may be called at any time during the
     *  life of the application.</p>
     *
     *@return               The DbEnv.getTxnTimestamp method returns the
     *      recovery timestamp.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getTxnTimestamp() throws DbException {
        return db_javaJNI.DbEnv_get_tx_timestamp(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getTimeout(int)}
     */
    public long get_timeout(int flag) throws DbException {
        return getTimeout(flag);
    }


    /**
     *  The DbEnv.getTimeout method returns a timeout value, in microseconds.
     *  </p> <p>
     *
     *  The DbEnv.getTimeout method may be called at any time during the life of
     *  the application.</p>
     *
     *@param  flag          must be set to one of the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_LOCK_TIMEOUT
     *        Db.DB_SET_LOCK_TIMEOUT}<p>
     *
     *        Return the timeout value for locks in this database environment.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_TXN_TIMEOUT
     *        Db.DB_SET_TXN_TIMEOUT}<p>
     *
     *        Return the timeout value for transactions in this database
     *        environment. </li>
     *      </ul>
     *
     *@return               The DbEnv.getTimeout method returns a timeout value,
     *      in microseconds.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getTimeout(int flag) throws DbException {
        return db_javaJNI.DbEnv_get_timeout(swigCPtr, flag);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #txnBegin(DbTxn,int)}
     */
    public DbTxn txn_begin(DbTxn parent, int flags) throws DbException {
        return txnBegin(parent, flags);
    }


    /**
     *  The DbEnv.txnBegin method creates a new transaction in the environment
     *  and returns a {@link com.sleepycat.db.DbTxn DbTxn} that uniquely
     *  identifies it. Calling the {@link com.sleepycat.db.DbTxn#abort
     *  DbTxn.abort}, {@link com.sleepycat.db.DbTxn#commit DbTxn.commit} or
     *  {@link com.sleepycat.db.DbTxn#discard DbTxn.discard} methods will
     *  discard the returned handle.</p> <p>
     *
     *  <b>Note: Transactions may only span threads if they do so serially; that
     *  is, each transaction must be active in only a single thread of control
     *  at a time. This restriction holds for parents of nested transactions as
     *  well; not two children may be concurrently active in more than one
     *  thread of control at any one time.</b> </p> <p>
     *
     *  <b>Note: Cursors may not span transactions; that is, each cursor must be
     *  opened and closed within a single transaction.</b> </p> <p>
     *
     *  <b>Note: A parent transaction may not issue any Berkeley DB operations
     *  -- except for DbEnv.txnBegin, {@link com.sleepycat.db.DbTxn#abort
     *  DbTxn.abort} and {@link com.sleepycat.db.DbTxn#commit DbTxn.commit} --
     *  while it has active child transactions (child transactions that have not
     *  yet been committed or aborted).</b> </p>
     *
     *@param  flags               must be set to 0 or by bitwise inclusively <b>
     *      OR</b> 'ing together one or more of the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ Db.DB_DIRTY_READ}<p>
     *
     *        All read operations performed by the transaction may read modified
     *        but not yet committed data. Silently ignored if the {@link
     *        com.sleepycat.db.Db#DB_DIRTY_READ <code>Db.DB_DIRTY_READ</code>}
     *        flag was not specified when the underlying database was opened.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_NOSYNC Db.DB_TXN_NOSYNC}<p>
     *
     *        Do not synchronously flush the log when this transaction commits
     *        or prepares. This means the transaction will exhibit the ACI
     *        (atomicity, consistency, and isolation) properties, but not D
     *        (durability); that is, database integrity will be maintained but
     *        it is possible that this transaction may be undone during
     *        recovery. <p>
     *
     *        This behavior may be set for a Berkeley DB environment using the
     *        {@link com.sleepycat.db.DbEnv#setFlags DbEnv.setFlags} method. Any
     *        value specified to this method overrides that setting.</p> </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_NOWAIT Db.DB_TXN_NOWAIT}<p>
     *
     *        If a lock is unavailable for any Berkeley DB operation performed
     *        in the context of this transaction, cause the operation to throw a
     *        {@link com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *        immediately instead of blocking on the lock. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_SYNC Db.DB_TXN_SYNC}<p>
     *
     *        Synchronously flush the log when this transaction commits or
     *        prepares. This means the transaction will exhibit all of the ACID
     *        (atomicity, consistency, isolation, and durability) properties.
     *        <p>
     *
     *        This behavior is the default for Berkeley DB environments unless
     *        the {@link com.sleepycat.db.Db#DB_TXN_NOSYNC <code>Db.DB_TXN_NOSYNC</code>
     *        } flag was specified to the {@link com.sleepycat.db.DbEnv#setFlags
     *        DbEnv.setFlags} method. Any value specified to this method
     *        overrides that setting.</p> </li>
     *      </ul>
     *
     *@param  parent              If the <b>parent</b> parameter is non-null,
     *      the new transaction will be a nested transaction, with the
     *      transaction indicated by <b>parent</b> as its parent. Transactions
     *      may be nested to any level. In the presence of distributed
     *      transactions and two-phase commit, only the parental transaction,
     *      that is a transaction without a <b>parent</b> specified, should be
     *      passed as an parameter to {@link com.sleepycat.db.DbTxn#prepare
     *      DbTxn.prepare}.
     *@return                     The DbEnv.txnBegin method throws an exception
     *      that encapsulates a non-zero error value on failure. </p>
     *@throws  DbMemoryException  If the maximum number of concurrent
     *      transactions has been reached, the DbEnv.txnBegin method will fail
     *      and throw a {@link com.sleepycat.db.DbMemoryException
     *      DbMemoryException} exception.
     */
    public DbTxn txnBegin(DbTxn parent, int flags) throws DbException {
        long cPtr = db_javaJNI.DbEnv_txn_begin(swigCPtr, DbTxn.getCPtr(parent), flags);
        return (cPtr == 0) ? null : new DbTxn(cPtr, false);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #txnCheckpoint(int,int,int)}
     */
    public void txn_checkpoint(int kbyte, int min, int flags) throws DbException {
        txnCheckpoint(kbyte, min, flags);
    }


    /**
     *  The DbEnv.txnCheckpoint method flushes the underlying memory pool,
     *  writes a checkpoint record to the log, and then flushes the log.</p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FORCE Db.DB_FORCE}<p>
     *
     *        Force a checkpoint record, even if there has been no activity
     *        since the last checkpoint. </li>
     *      </ul>
     *
     *@param  kbyte                      If the <b>kbyte</b> parameter is
     *      non-zero, a checkpoint will be done if more than <b>kbyte</b>
     *      kilobytes of log data have been written since the last checkpoint.
     *@param  min                        If the <b>min</b> parameter is
     *      non-zero, a checkpoint will be done if more than <b>min</b> minutes
     *      have passed since the last checkpoint.
     *@throws  IllegalArgumentException  The DbEnv.txnCheckpoint method will
     *      fail and throw a IllegalArgumentException exception if an invalid
     *      flag value or parameter was specified.
     */
    public void txnCheckpoint(int kbyte, int min, int flags) throws DbException {
        db_javaJNI.DbEnv_txn_checkpoint(swigCPtr, kbyte, min, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #txnRecover(int,int)}
     */
    public DbPreplist[] txn_recover(int count, int flags) throws DbException {
        return txnRecover(count, flags);
    }


    /**
     *  The DbEnv.txnRecover method returns a list of prepared but not yet
     *  resolved transactions. The DbEnv.txnRecover method should only be called
     *  after the environment has been recovered. Because database environment
     *  state must be preserved between recovery and the application calling
     *  DbEnv.txnRecover, applications must either call DbEnv.txnRecover using
     *  the same environment handle used when recovery is done, or the database
     *  environment must not be configured using the {@link
     *  com.sleepycat.db.Db#DB_PRIVATE Db.DB_PRIVATE} flag.</p> <p>
     *
     *  The DbEnv.txnRecover method returns a list of transactions that must be
     *  resolved by the application (committed, aborted or discarded). The
     *  return value is an array of objects of type DbPreplist; the following
     *  DbPreplist fields will be filled in:</p> The application must call
     *  {@link com.sleepycat.db.DbTxn#abort DbTxn.abort}, {@link
     *  com.sleepycat.db.DbTxn#commit DbTxn.commit} or {@link
     *  com.sleepycat.db.DbTxn#discard DbTxn.discard} on each returned {@link
     *  com.sleepycat.db.DbTxn DbTxn} handle before starting any new operations.
     *  </p>
     *
     *@param  count         specifies the number of maximum size of the array
     *      that should be returned.
     *@param  flags         must be set to one of the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FIRST Db.DB_FIRST}<p>
     *
     *        Begin returning a list of prepared, but not yet resolved
     *        transactions. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT Db.DB_NEXT}<p>
     *
     *        Continue returning a list of prepared, but not yet resolved
     *        transactions, starting where the last call to DbEnv.txnRecover
     *        left off. </li>
     *      </ul>
     *
     *@return               The DbEnv.txnRecover method throws an exception that
     *      encapsulates a non-zero error value on failure. </p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public DbPreplist[] txnRecover(int count, int flags) throws DbException {
        return db_javaJNI.DbEnv_txn_recover(swigCPtr, count, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #txnStat(int)}
     */
    public DbTxnStat txn_stat(int flags) throws DbException {
        return txnStat(flags);
    }


    /**
     *  The DbEnv.txnStat method returns the transaction subsystem statistics.
     *  </p> <p>
     *
     *  The DbEnv.txnStat method creates a DbTxnStat object encapsulating the
     *  transaction subsystem statistics. The following data fields are
     *  available from the DbTxnStat object:</p> For convenience, the DbTxnStat
     *  class has a toString method that lists all the data fields.</p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return                            The DbEnv.txnStat method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  IllegalArgumentException  The DbEnv.txnStat method will fail and
     *      throw a IllegalArgumentException exception if an invalid flag value
     *      or parameter was specified.
     */
    public DbTxnStat txnStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_txn_stat(swigCPtr, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #getReplicationLimit()}
     */
    public long get_rep_limit() throws DbException {
        return getReplicationLimit();
    }


    /**
     *  The DbEnv.getReplicationLimit method returns the transmit limit in
     *  bytes.</p> <p>
     *
     *  The DbEnv.getReplicationLimit method may be called at any time during
     *  the life of the application.</p>
     *
     *@return               The DbEnv.getReplicationLimit method returns the
     *      transmit limit in bytes.</p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public long getReplicationLimit() throws DbException {
        return db_javaJNI.DbEnv_get_rep_limit(swigCPtr);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #replicationElect(int,int,int)}
     */
    public int rep_elect(int nsites, int priority, int timeout) throws DbException {
        return replicationElect(nsites, priority, timeout);
    }


    /**
     *  The DbEnv.replicationElect method holds an election for the master of a
     *  replication group.</p> <p>
     *
     *  If the election is successful, the new master's ID may be the ID of the
     *  previous master, or the ID of the current environment. The application
     *  is responsible for adjusting its usage of the other environments in the
     *  replication group, including directing all database updates to the newly
     *  selected master, in accordance with the results of this election.</p>
     *  <p>
     *
     *  The thread of control that calls the DbEnv.replicationElect method must
     *  not be the thread of control that processes incoming messages;
     *  processing the incoming messages is necessary to successfully complete
     *  an election.</p>
     *
     *@param  nsites        The <b>nsites</b> parameter indicates the number of
     *      environments that the application believes are in the replication
     *      group. This number is used by Berkeley DB to avoid having two
     *      masters active simultaneously, even in the case of a network
     *      partition. During an election, a new master cannot be elected unless
     *      more than half of <b>nsites</b> agree on the new master. Thus, in
     *      the face of a network partition, the side of the partition with more
     *      than half the environments will elect a new master and continue,
     *      while the environments communicating with fewer than half the other
     *      environments will fail to find a new master.
     *@param  priority      the priority of this environment. It must be a
     *      positive integer, or 0 if this environment is not permitted to
     *      become a master (see <a href="{@docRoot}/../ref/rep/pri.html">
     *      Replication environment priorities</a> for more information).
     *@param  timeout       specifies a timeout period for an election. If the
     *      election has not completed after <b>timeout</b> microseconds, the
     *      election will fail.
     *@return               The DbEnv.replicationElect method returns the newly
     *      elected master's ID.
     *@throws  DbException  The DbEnv.replicationElect method may fail and throw
     *      {@link com.sleepycat.db.DbException DbException}, encapsulating a
     *      non-zero error, for the following conditions:
     *      <li> The replication group was unable to elect a master, or was
     *      unable to complete the election in the specified <b>timeout</b>
     *      period.
     */
    public int replicationElect(int nsites, int priority, int timeout) throws DbException {
        return db_javaJNI.DbEnv_rep_elect(swigCPtr, nsites, priority, timeout);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     */
    public int rep_process_message(Dbt control, Dbt rec, DbEnv.RepProcessMessage envid, DbLsn ret_lsn) throws DbException {
        return replicationProcessMessage(control, rec, envid, ret_lsn);
    }


    /**
     *  The DbEnv.replicationProcessMessage method processes an incoming
     *  replication message sent by a member of the replication group to the
     *  local database environment.</p> <p>
     *
     *  For implementation reasons, all incoming replication messages must be
     *  processed using the same {@link com.sleepycat.db.DbEnv DbEnv} handle. It
     *  is not required that a single thread of control process all messages,
     *  only that all threads of control processing messages use the same
     *  handle.</p> <p>
     *
     *  The DbEnv.replicationProcessMessage method has additional return values:
     *  </p>
     *
     *@param  control       The <b>control</b> parameter should reference a copy
     *      of the <b>control</b> parameter specified by Berkeley DB on the
     *      sending environment.
     *@param  envid         The <b>envid</b> parameter should contain the local
     *      identifier that corresponds to the environment that sent the message
     *      to be processed (see <a href="{@docRoot}/../ref/rep/id.html">
     *      Replication environment IDs</a> for more information).
     *@param  rec           The <b>rec</b> parameter should reference a copy of
     *      the <b>rec</b> parameter specified by Berkeley DB on the sending
     *      environment.
     *@param  ret_lsn       If DbEnv.replicationProcessMessage method returns
     *      Db.DB_REP_NOTPERM then the <b>ret_lsn</b> parameter will contain the
     *      log sequence number of this permanent log message that could not be
     *      written to disk. If DbEnv.replicationProcessMessage method returns
     *      Db.DB_REP_ISPERM then the <b>ret_lsn</b> parameter will contain
     *      largest log sequence number of the permanent records that are now
     *      written to disk as a result of processing this message. In all other
     *      cases the value of <b>ret_lsn</b> is undefined.
     *@return
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_DUPMASTER DB_REP_DUPMASTER}
     *        <p>
     *
     *        The DbEnv.replicationProcessMessage method will throw an exception
     *        that encapsulates <code>Db.DB_REP_DUPMASTER</code> if the
     *        replication group has more than one master. </li>
     *      </ul>
     *      The application should reconfigure itself as a client by calling the
     *      {@link com.sleepycat.db.DbEnv#replicationStart
     *      DbEnv.replicationStart} method, and then call for an election by
     *      calling {@link com.sleepycat.db.DbEnv#replicationElect
     *      DbEnv.replicationElect}. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_HOLDELECTION
     *        DB_REP_HOLDELECTION}<p>
     *
     *        The DbEnv.replicationProcessMessage method will throw an exception
     *        that encapsulates <code>Db.DB_REP_HOLDELECTION</code> if an
     *        election is needed. </li>
     *      </ul>
     *      The application should call for an election by calling {@link
     *      com.sleepycat.db.DbEnv#replicationElect DbEnv.replicationElect}.
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_ISPERM DB_REP_ISPERM}<p>
     *
     *        The DbEnv.replicationProcessMessage method will return <code>Db.DB_REP_ISPERM</code>
     *        if processing this message results in the processing of records
     *        that are permanent. </li>
     *      </ul>
     *      The maximum LSN of the permanent records stored is returned. </p>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_NEWMASTER DB_REP_NEWMASTER}
     *        <p>
     *
     *        The DbEnv.replicationProcessMessage method will return <code>Db.DB_REP_NEWMASTER</code>
     *        if a new master has been elected. </li>
     *      </ul>
     *      The <b>envid</b> parameter contains the environment ID of the new
     *      master. If the recipient of this error return has been made master,
     *      it is the application's responsibility to begin acting as the master
     *      environment. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_NEWSITE DB_REP_NEWSITE}<p>
     *
     *        The DbEnv.replicationProcessMessage method will return <code>Db.DB_REP_NEWSITE</code>
     *        if the system received contact information from a new environment.
     *        </li>
     *      </ul>
     *      The <b>rec</b> parameter contains the opaque data specified in the
     *      <b>cdata</b> parameter to the {@link
     *      com.sleepycat.db.DbEnv#replicationStart DbEnv.replicationStart}. The
     *      application should take whatever action is needed to establish a
     *      communication channel with this new environment. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_NOTPERM DB_REP_NOTPERM}<p>
     *
     *        The DbEnv.replicationProcessMessage method will return <code>Db.DB_REP_NOTPERM</code>
     *        if a message carrying a {@link
     *        com.sleepycat.db.Db#DB_REP_PERMANENT <code>Db.DB_REP_PERMANENT</code>
     *        } flag was processed successfully, but was not written to disk.
     *        </li>
     *      </ul>
     *      The LSN of this record is returned. The application should take
     *      whatever action is deemed necessary to retain its recoverability
     *      characteristics. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_OUTDATED DB_REP_OUTDATED}
     *        <p>
     *
     *        The DbEnv.replicationProcessMessage method will throw an exception
     *        that encapsulates <code>Db.DB_REP_OUTDATED</code> if the current
     *        environment's logs are too far out of date with respect to the
     *        master to be automatically synchronized. </li>
     *      </ul>
     *      The application should copy over a hot backup of the environment,
     *      run recovery, and restart the client. </p> Unless otherwise
     *      specified, the DbEnv.replicationProcessMessage method throws an
     *      exception that encapsulates a non-zero error value on failure. </p>
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public int replicationProcessMessage(Dbt control, Dbt rec, DbEnv.RepProcessMessage envid, DbLsn ret_lsn) throws DbException {
        return db_javaJNI.DbEnv_rep_process_message(swigCPtr, control, rec, envid, DbLsn.getCPtr(ret_lsn));
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #replicationStart(Dbt,int)}
     */
    public void rep_start(Dbt cdata, int flags) throws DbException {
        replicationStart(cdata, flags);
    }


    /**
     *  The DbEnv.replicationStart method configures the database environment as
     *  a client or master in a group of replicated database environments.
     *  Replication master environments are the only database environments where
     *  replicated databases may be modified. Replication client environments
     *  are read-only as long as they are clients. Replication client
     *  environments may be upgraded to be replication master environments in
     *  the case that the current master fails or there is no master present.
     *  </p> <p>
     *
     *  The enclosing database environment must already have been opened by
     *  calling the {@link com.sleepycat.db.DbEnv#open DbEnv.open} method and
     *  must already have been configured to send replication messages by
     *  calling the {@link com.sleepycat.db.DbEnv#setReplicationTransport
     *  DbEnv.setReplicationTransport} method.</p>
     *
     *@param  cdata                      an opaque data item that is sent over
     *      the communication infrastructure when the client or master comes
     *      online (see <a href="{@docRoot}/../ref/rep/newsite.html">Connecting
     *      to a new site</a> for more information). If no such information is
     *      useful, <b>cdata</b> should be null.
     *@param  flags                      must be set to one of the following
     *      values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_CLIENT Db.DB_REP_CLIENT}<p>
     *
     *        Configure the environment as a replication client. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_LOGSONLY
     *        Db.DB_REP_LOGSONLY}<p>
     *
     *        Configure the environment as a log files-only client. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REP_MASTER Db.DB_REP_MASTER}<p>
     *
     *        Configure the environment as a replication master. </li>
     *      </ul>
     *
     *@throws  IllegalArgumentException  The DbEnv.replicationStart method will
     *      fail and throw a IllegalArgumentException exception if the database
     *      environment was not already configured to communicate with a
     *      replication group by a call to {@link
     *      com.sleepycat.db.DbEnv#setReplicationTransport
     *      DbEnv.setReplicationTransport}; the database environment was not
     *      already opened; or if an invalid flag value or parameter was
     *      specified.
     */
    public void replicationStart(Dbt cdata, int flags) throws DbException {
        db_javaJNI.DbEnv_rep_start(swigCPtr, cdata, flags);
    }


    /**
     *@return                  Description of the Return Value
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #replicationStat(int)}
     */
    public DbRepStat rep_stat(int flags) throws DbException {
        return replicationStat(flags);
    }


    /**
     *  The DbEnv.replicationStat method returns the replication subsystem
     *  statistics.</p> <p>
     *
     *  The DbEnv.replicationStat method creates a DbRepStat object
     *  encapsulating the replication subsystem statistics. The following data
     *  fields are available from the DbRepStat object:</p> For convenience, the
     *  DbRepStat class has a toString method that lists all the data fields.
     *  </p>
     *
     *@param  flags                      must be set to 0 or the following
     *      value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_STAT_CLEAR Db.DB_STAT_CLEAR}<p>
     *
     *        Reset statistics after returning their values. </li>
     *      </ul>
     *
     *@return                            The DbEnv.replicationStat method throws
     *      an exception that encapsulates a non-zero error value on failure.
     *      </p>
     *@throws  IllegalArgumentException  The DbEnv.replicationStat method will
     *      fail and throw a IllegalArgumentException exception if an invalid
     *      flag value or parameter was specified.
     */
    public DbRepStat replicationStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_rep_stat(swigCPtr, flags);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setReplicationLimit(long)}
     */
    public void set_rep_limit(long bytes) throws DbException {
        setReplicationLimit(bytes);
    }


    /**
     *  The DbEnv.setReplicationLimit method imposes a byte-count limit on the
     *  amount of data that will be transmitted from a site in a single call to
     *  {@link com.sleepycat.db.DbEnv#replicationProcessMessage
     *  DbEnv.replicationProcessMessage} method.</p> <p>
     *
     *  The DbEnv.setReplicationLimit method configures a database environment,
     *  not only operations performed using the specified {@link
     *  com.sleepycat.db.DbEnv DbEnv} handle.</p> <p>
     *
     *  The DbEnv.setReplicationLimit method may not be called before the {@link
     *  com.sleepycat.db.DbEnv#open DbEnv.open} method has been called.</p>
     *
     *@param  bytes         specifies the maximum number of bytes that will be
     *      sent in a single call to {@link
     *      com.sleepycat.db.DbEnv#replicationProcessMessage
     *      DbEnv.replicationProcessMessage} method.
     *@throws  DbException  Signals that an exception of some sort has occurred.
     */
    public void setReplicationLimit(long bytes) throws DbException {
        db_javaJNI.DbEnv_set_rep_limit(swigCPtr, bytes);
    }


    /**
     *@deprecated              As of Berkeley DB 4.2, replaced by {@link
     *      #setReplicationTransport(int,DbRepTransport)}
     */
    public void set_rep_transport(int envid, DbRepTransport send) throws DbException {
        setReplicationTransport(envid, send);
    }


    /**
     *  Sets the replicationTransport attribute of the DbEnv object
     *
     *@param  envid            The new replicationTransport value
     *@param  send             The new replicationTransport value
     */
    public void setReplicationTransport(int envid, DbRepTransport send) throws DbException {
        db_javaJNI.DbEnv_set_rep_transport(swigCPtr, envid, (rep_transport_handler = send));
    }


    /**
     *  The DbEnv.strerror method returns an error message string corresponding
     *  to the error number <b>error</b> parameter.</p> <p>
     *
     *  This function is a superset of the ANSI C X3.159-1989 (ANSI C) <b>
     *  strerror</b> (3) function. If the error number <b>error</b> is greater
     *  than or equal to 0, then the string returned by the system function <b>
     *  strerror</b> (3) is returned. If the error number is less than 0, an
     *  error string appropriate to the corresponding Berkeley DB library error
     *  is returned. See <a href="{@docRoot}/../ref/program/errorret.html">Error
     *  returns to applications</a> for more information.</p>
     *
     *@param  error  the error number for which an error message string is
     *      wanted.
     *@return        The DbEnv.strerror method returns an error message string
     *      corresponding to the error number <b>error</b> parameter.</p>
     */
    public static String strerror(int error) {
        return db_javaJNI.DbEnv_strerror(error);
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getVersionMajor()}
     */
    public static int get_version_major() {
        return getVersionMajor();
    }


    /**
     *  The DbEnv.getVersionMajor method returns the release major number.</p>
     *  <p>
     *
     *  The DbEnv.getVersionMajor method may be called at any time during the
     *  life of the application.</p>
     *
     *@return    The DbEnv.getVersionMajor method returns the release major
     *      number.</p>
     */
    public static int getVersionMajor() {
        return db_javaJNI.DbEnv_get_version_major();
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getVersionMinor()}
     */
    public static int get_version_minor() {
        return getVersionMinor();
    }


    /**
     *  The DbEnv.getVersionMinor method returns the release minor number.</p>
     *  <p>
     *
     *  The DbEnv.getVersionMinor method may be called at any time during the
     *  life of the application.</p>
     *
     *@return    The DbEnv.getVersionMinor method returns the release minor
     *      number.</p>
     */
    public static int getVersionMinor() {
        return db_javaJNI.DbEnv_get_version_minor();
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getVersionPatch()}
     */
    public static int get_version_patch() {
        return getVersionPatch();
    }


    /**
     *  The DbEnv.getVersionPatch method returns the release patch number.</p>
     *  <p>
     *
     *  The DbEnv.getVersionPatch method may be called at any time during the
     *  life of the application.</p>
     *
     *@return    The DbEnv.getVersionPatch method returns the release patch
     *      number.</p>
     */
    public static int getVersionPatch() {
        return db_javaJNI.DbEnv_get_version_patch();
    }


    /**
     *@return        Description of the Return Value
     *@deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getVersionString()}
     */
    public static String get_version_string() {
        return getVersionString();
    }


    /**
     *  The DbEnv.getVersionString method returns the release verbose version
     *  information, suitable for display.</p> <p>
     *
     *  The DbEnv.getVersionString method may be called at any time during the
     *  life of the application.</p>
     *
     *@return    The DbEnv.getVersionString method returns the release verbose
     *      version information, suitable for display.</p>
     */
    public static String getVersionString() {
        return db_javaJNI.DbEnv_get_version_string();
    }

}
