(* 
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *	Office of Technology Transfer
 *	Carnegie Mellon University
 *	5000 Forbes Avenue
 *	Pittsburgh, PA  15213-3890
 *	(412) 268-4387, fax: (412) 268-7395
 *	tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

(* contexts always assume entry names are full paths *)

signature CONTEXT =
sig
  exception Modified of AcapTime.acaptime
  exception NotNotifyContext

  datatype outMsg = 
    CNEW of {dset : string, name : string, entry : Entry.entry} * int
  | CCHANGE of {dset : string, name : string, entry : Entry.entry}
 	* (int * int)
  | CDELETE of {dset : string, name : string} * int
  | CTIME of AcapTime.acaptime

  type context

  val create : (Entry.entry -> bool)
    -> ({dset : string, name : string, entry : Entry.entry} * 
	{dset : string, name : string, entry : Entry.entry} -> order) option * 
	(outMsg -> unit) option * bool -> context

  (* no notifications; doesn't resort until "doneInitial" is called *)
  val fastInsert : context 
	-> {dset : string, name : string, entry : Entry.entry} -> unit

  (* has side-effect of starting a thread to listen for changes *)
  val doneInitial : context -> unit

  (* ask the context to send a CTIME message *)
  val updatecontext : context -> unit
    
  (* search the current context *)
  val search : context 
	-> ((int * Entry.entry) -> bool) * 
	   {dset : string, name : string, entry : Entry.entry}
	              Throttle.throttle * AcapTime.acaptime 
	-> unit

  (* add a new dataset to listen to *)
  val addDSet : context -> Entry.updatemsg RMulticast.port -> unit

  (* event enabled on context destruction *)
  val destroyEvent : context -> unit CML.event

  (* done with the context *)
  val destroy : context -> unit
end
