(* 
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *	Office of Technology Transfer
 *	Carnegie Mellon University
 *	5000 Forbes Avenue
 *	Pittsburgh, PA  15213-3890
 *	(412) 268-4387, fax: (412) 268-7395
 *	tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

structure AcapServer =
struct
  val implementation = 
    "(Implementation \"smlacapd 0.4, Carnegie Mellon Project Cyrus\")"

  val contextlimit = "(ContextLimit \"100\")"

  fun cmd (_, []) = doit ()
    | cmd _ = usage ()

  and usage () = (print "Usage: sml @SMLload=<heap_name>\n";
		  OS.Process.failure)

  and doit () = (RunCML.doit (fn () => (main();
					RunCML.shutdown(OS.Process.success)),
			      NONE))

  and main () =
    let val pleaseDie = SyncVar.iVar () : unit SyncVar.ivar
    in
    let
      val _ = Config.init ()
      val port = !Config.FNAME_socket
      val _ = Signals.setHandler 
	            (valOf (Signals.fromString "PIPE"), Signals.IGNORE);
      val _ = AcapTime.init ()
      val _ = Sasl.init ()
      val _ = Dataset.init ()
	
      (* val socket = SocketStreams.inet_port_socket (port)*)
      val socket = SocketStreams.unix_socket port
      val sockch = SocketStreams.acceptLoop (socket, pleaseDie)

      fun acc () =
	let 
	  (* new connection ! *) 
	  val (nsocket, _) = CML.recv sockch
	  val DieConn = SyncVar.iVar ()

	  (* we touch DieConn when we die *)
	  val (inch, outch) = SocketStreams.create (nsocket, DieConn)
	    
	  val saslconn = Sasl.newconn ()

	  val banner = "* ACAP " ^ contextlimit ^ " " ^ implementation
	                         ^ " " ^ (Sasl.listmechs saslconn) ^ "\r\n"

	  (* ok, start up the writer *)
	  val response = Response.create (outch, DieConn, banner)

	  val conn = Execute.start response saslconn

	  (* and the reader thread_id *)
	  val reader = Parse.create (inch, conn)
	in 
	  CML.spawn(fn () => (CML.sync(CML.joinEvt(reader));
			      print "reader came back\n";
			      SyncVar.iPut(DieConn, ())));
	  acc ()
	end handle exn => (print ("exception! " ^ (exnMessage exn) ^ "\n"))

      val tid = CML.spawn acc

    in
      print "starting...\n";
      CML.sync(CML.joinEvt(tid));
      print "ending...\n";
      SyncVar.iPut(pleaseDie, ()) handle _ => ();
      Sasl.done ()
    end
  handle e => (print "oops, caught an exception...\n";
	       print ((exnMessage e) ^ "\n");
	       SyncVar.iPut(pleaseDie, ()) handle _ => ()) end

end
