#!/bin/sh

# DISPLAY THE HELP INFO
help() {
	more Readme.txt | more
}

# --- COMMAND LINE PARAMETERS ---
if [ "$1" != "" ]
then
	help
	exit
fi



# --- SET THE ENVIRONMENT ---

# *Platform-specific variables*
export DOX_PROJECT_NAME="gCvs Source"
export DOX_PROJECT_VERSION="1.0"
export DOX_OUTPUT_DIRECTORY=GCvsSrcDoc
export DOX_PREDEFINED="qUnix"
export DOX_INCLUDE_PATH="../common ../rf ../rf/support/gtk ../gcvs ../gcvs/src"

# *Input*
export DOX_INPUT="../common ../rf ../rf/support/gtk ../gcvs ../gcvs/src"
export DOX_FILE_PATTERNS="*.c *.cc *.cpp *.cxx *.inl *.y *.h *.hpp *.odl"
export DOX_EXCLUDE_PATTERNS="*/CVS/*"

# *Variable to strip from files path (STRIP_FROM_PATH)*
PWD_ORG=`pwd`
$DOX_INPUT
export DOX_STRIP_FROM_PATH=`pwd`
cd $PWD_ORG

# *Output types*
export DOX_CASE_SENSE_NAMES=NO
export DOX_SHORT_NAMES=YES
export DOX_MAN_EXT=4
export DOX_OUTPUT_LANG=English

# *Output types*
export DOX_GENERATE_HTML=YES
export DOX_DOT_IMAGE_FORMAT=gif
export DOX_GENERATE_HTMLHELP=YES
export DOX_GENERATE_TREEVIEW=NO
export DOX_GENERATE_LATEX=NO
export DOX_GENERATE_RTF=NO
export DOX_GENERATE_MAN=NO
export DOX_GENERATE_XML=NO
export DOX_GENERATE_AUTOGEN_DEF=NO
export DOX_SEARCHENGINE=NO


# --- SET THE FILES ---

#@rem Execution log file
DOX_LOG=DoDoxygen.log

#@rem HHC project file
#export DOX_HHP=$DOX_OUTPUT_DIRECTORY\html\index.hhp


# --- EXECUTE ---

echo Generating the documentation
echo Start: `date +"%d.%m.%y %H:%M:%S"`> $DOX_LOG
doxygen >> $DOX_LOG 2>&1 

#echo Creating the compressed html file
#if EXIST %DOX_HHP% hhc.exe %DOX_HHP% >> %DOX_LOG%

echo Finished: `date +"%d.%m.%y %H:%M:%S"` >> $DOX_LOG
