/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * dll_loader.cpp --- code to load dynamic code
 */

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#if !defined(WIN32) && !defined(macintosh)
#	include "dynl.h"
#endif /* !WIN32 && !macintosh */

#ifdef WIN32
#	include <windows.h>
#endif /* WIN32 */

#include <string.h>

#include "dll_loader.h"

#if defined(macintosh) && !TARGET_API_MAC_CARBON
	RoutineDescriptor sCompatProcRD;
	UniversalProcPtr sCompatProc;
#else /* !macintosh || TARGET_API_MAC_CARBON */
	void *sCompatProc;
#endif /* !macintosh || TARGET_API_MAC_CARBON */

#ifdef macintosh
#	include <TextUtils.h>
	static ProcPtr getSymFunction(CompatConnectID connID, const Str255 name)
	{
		long symCount;
		Ptr symAddr;
		int i;
		OSErr err = CountSymbols(connID, &symCount);
		if(err != noErr)
			return 0L;
		
		for(i = 0; i < symCount; i++)
		{
			CFragSymbolClass symClass;
			Str255 symName;
			err = GetIndSymbol(connID, i, symName, &symAddr, &symClass);
			if(err != noErr)
				return 0L;
			if(memcmp(symName, name, name[0]) == 0)
				break;
		}
		if(i == symCount)
			return 0L;
		return (ProcPtr)symAddr;
	}
#endif /* macintosh */

int
CompatLoadLibrary(CompatConnectID * connID, const char *name_dll)
{
	if(connID == 0L)
		return 0;

#ifdef macintosh
	{
	OSErr err;
	Ptr mainAddr;
	Str255 errMessage;
	Str255 pname;

	c2pstrcpy(pname, name_dll);
	err = GetSharedLibrary(pname, kPowerPCCFragArch, kPrivateCFragCopy, connID, &mainAddr, errMessage);
	return err == noErr;
	}
#elif defined(WIN32)
	*connID = LoadLibrary(name_dll);

	return (*connID) != 0L;
#else /* !WIN32 && !macintosh */
	*connID = dynl_link(name_dll);
	return (*connID) != 0L;
#endif /* !WIN32 && !macintosh */
}

int
CompatCloseLibrary(CompatConnectID * connID)
{
	if(connID == 0L)
		return 0;

#ifdef macintosh
	CloseConnection(connID);
	return 1;
#elif defined(WIN32)
	FreeLibrary(*connID);
	connID = 0L;
	return 1;
#else /* !WIN32 && !macintosh */
	dynl_unlink(*connID);
	connID = 0L;
	return 1;
#endif /* !WIN32 && !macintosh */
}

#if defined(macintosh) && !TARGET_API_MAC_CARBON
UniversalProcPtr
_CompatCallLibrary(CompatConnectID connID, long id_func, const char *name_func)
#else /* !macintosh || TARGET_API_MAC_CARBON */
void *
_CompatCallLibrary(CompatConnectID connID, const char *name_func)
#endif /* !macintosh || TARGET_API_MAC_CARBON */
{
#ifdef macintosh
	ProcPtr symAddr;
	UniversalProcPtr proc;
	Str255 pname;

	c2pstrcpy(pname, name_func);

	symAddr = getSymFunction(connID, pname);
#	if TARGET_API_MAC_CARBON
	return symAddr;
#	else
	if(symAddr == 0L)
		return 0L;
	
	proc = NewRoutineDescriptor(symAddr, id_func, kPowerPCISA);
	return proc;
#	endif
#elif defined(WIN32)
	return GetProcAddress(connID, name_func);
#else /* !WIN32 && !macintosh */
	return dynl_func(name_func, connID);
#endif /* !WIN32 && !macintosh */
}
