/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- August 2001
 */

/*
 * PythonGlue.h --- glue to the Python language
 */

#ifndef PYTHONGLUE_H
#define PYTHONGLUE_H

class UCmdUI;
class EntnodeData;
typedef struct _ts PyThreadState;

class CPython_Interp
{
public:
	CPython_Interp(bool mainInterp = true);
	~CPython_Interp();

	static bool IsAvail(void);
		// tells if Python is available
	
	int DoScriptVar(const char *format, ...);
	int DoScript(const char *script);
	int DoFile(const char *file);
		// execute a Python script, returns false on error
	
	static void InitPythonSupport(void);
	static void ClosePythonSupport(void);

	inline operator PyThreadState *(void) {return fInterp;}

protected:
	PyThreadState *fInterp;

	static PyThreadState *m_mainInterpreter;
};

void PyMacrosReloadAll(void);
	// reload the available macros

void PyDoCmdUI(UCmdUI *ucmdui);
	// update a menu state (call python)

void PyDoPython(int cmd);
	// call python because a command has been trigerred (by the menu or an icon)

bool PyIsUICacheValid();
void PyValidUICache();
void PyInvalUICache();
void PyAppendCache(EntnodeData *data);
	// call for Python to invalidate selection cache (the current selection
	// in the file and folder browser)

#endif /* PYTHONGLUE_H */
