/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * PromptFiles.h --- class to pick set of files and folder
 */

#ifndef PROMPTFILES_H
#define PROMPTFILES_H

class MultiFiles;
class CWnd;

#ifdef WIN32
const char *BrowserGetDirectory(const char *prompt, CWnd* pParentWnd = 0L);
	// return a directory, the prompt is a caption for the dialog

bool BrowserGetDirectory(const char* prompt, char* fileName, int size, CWnd* pParentWnd = 0L);
// prompts the user for directory selection
// Parameters
//      prompt - dialog caption
//      fileName   - IN  : initial directory
//                   OUT : selected directory if selection done
//      size       - size of the fileName buffer
//      pParentWnd - parent for the dialog, important if you call it from within the dialog
// Return
//  true if selection done, false otherwise
// Notes
//  single-argument version should probably be deprecated after implementing this one
//  on all platforms

bool BrowserGetMultiFiles(const char *prompt, MultiFiles & mf, const char* lpszFilter = NULL);
	// return a set of files, sorted by directory (class MultiFiles).
#else
const char *BrowserGetDirectory(const char *prompt);
	// return a directory, the prompt is a caption for the dialog

bool BrowserGetMultiFiles(const char *prompt, MultiFiles & mf);
	// return a set of files, sorted by directory (class MultiFiles).
#endif /* WIN32 */

#endif /* PROMPTFILES_H */
