/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * CvsArgs.h --- class to handle cvs arguments
 */

#ifndef CVSARGS_H
#define CVSARGS_H

#ifdef macintosh
#	include <Files.h>
#else /* !macintosh */
	typedef int FSSpec;
#endif /* !macintosh */

class CvsArgs
{
public :
	CvsArgs(bool defargs = true);
		// append "cvs" and misc options
		// defined by preferences ("-z9" for example)
	CvsArgs(char * const *fromargv, int fromargc);
	virtual ~CvsArgs();

	// add arguments
	virtual void add(const char *arg);
	virtual void addfile(const char *arg, const char *dir = 0L,
		const FSSpec *spec = 0L);

	void reset(bool defargs = true);
		// see the constructor

	void print(const char *indirectory = 0L);
		// print the command line to the console

	char * const *Argv(void) const {return argv;}
	int Argc(void) const {return argc;}
protected:
	char **argv;
	int argc;
};

#endif /* CVSPREFS_H */
