/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- April 1998
 */

// AskYesNo.cpp : ask yes or no !

#include "stdafx.h"

#ifdef WIN32
#	include "resource.h"
#endif /* WIN32 */

#ifdef qUnix
#	include "CvsAlert.h"
#	include "memory"
#endif /* qUnix */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>

#	include "MacCvsApp.h"
#	include "MacCvsConstant.h"
#endif /* qMacCvsPP */

#include "AskYesNo.h"
#include "uwidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CAskYesNo dialog


CAskYesNo::CAskYesNo(CWnd* pParent /*=NULL*/)
	: CDialog(CAskYesNo::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAskYesNo)
	//}}AFX_DATA_INIT
}


void CAskYesNo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAskYesNo)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAskYesNo, CDialog)
	//{{AFX_MSG_MAP(CAskYesNo)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAskYesNo message handlers
#endif /* WIN32 */

const char *AskYesNo(void)
{
#ifdef WIN32
	CAskYesNo gp;
	return gp.DoModal() == IDOK ? "yes" : "no";
#endif /* WIN32 */
#ifdef qMacCvsPP
	if(!CMacCvsApp::app->IsFrontProcess() && CMacCvsApp::app->NotifyUser(0L))
	{
		while(!CMacCvsApp::app->IsFrontProcess())
		{
			CMacCvsApp::app->SpendSomeTime();
		}
	}

	StDialogHandler	theHandler(dlg_YesNo, LCommander::GetTopCommander());
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	
	return hitMessage == msg_OK ? "yes" : "no";
#endif /* qMacCvsPP */
#ifdef qUnix
	return CvsAlert("cvs is requiring you to answer yes or no (see the console for details)", "No", "Yes") ?
		"no" : "yes";
#endif /* qUnix */
}

class UPromptMessage : public UWidget
{
	UDECLARE_DYNAMIC(UPromptMessage)
public:
	UPromptMessage(const char *msg, const char *title, const char *def,
		const char *cncl) : UWidget(UEventGetWidID()), m_msg(msg), m_title(title),
		m_ok(def), m_cncl(cncl)
	{
	}

	virtual ~UPromptMessage() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kMsg					// 2
	};

	virtual void DoDataExchange(bool fill)
	{
		if(fill)
		{
			UEventSendMessage(GetWidID(), EV_SETTEXT, kOK, (void *)m_ok.c_str());
			UEventSendMessage(GetWidID(), EV_SETTEXT, kUMainWidget, (void *)m_title.c_str());
			UEventSendMessage(GetWidID(), EV_SETTEXT, kCancel, (void *)m_cncl.c_str());
			UEventSendMessage(GetWidID(), EV_SETTEXT, kMsg, (void *)m_msg.c_str());
		}
		else
		{
		}
	}

protected:
	UStr m_msg, m_title, m_ok, m_cncl;

	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UPromptMessage, UWidget)

UBEGIN_MESSAGE_MAP(UPromptMessage, UWidget)
	ON_UCOMMAND(kOK, UPromptMessage::OnOK)
	ON_UCOMMAND(kCancel, UPromptMessage::OnCancel)
UEND_MESSAGE_MAP()

int UPromptMessage::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UPromptMessage::OnCancel(void)
{
	EndModal(false);
	return 0;
}

bool PromptMessage(const char *msg, const char *title, const char *def, const char *cncl)
{
	std::auto_ptr<UPromptMessage> dlg(new UPromptMessage(msg, title, def, cncl));
	bool res = false;

#ifdef WIN32
	res = dlg->DoModal(IDD_PROMPTMESSAGE);
#endif
#ifdef qMacCvsPP
	res = dlg->DoModal(dlg_PromptCommand);
#endif

	return res;
}

class UEditMessage : public UPromptMessage
{
	UDECLARE_DYNAMIC(UEditMessage)
public:
	UEditMessage(const char *msg, const char *edit, const char *title, const char *def,
		const char *cncl) : m_edit(edit), UPromptMessage(msg, title, def, cncl)
	{
	}

	virtual ~UEditMessage() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kMsg,					// 2
		kEdit					// 3
	};

	virtual void DoDataExchange(bool fill)
	{
		UPromptMessage::DoDataExchange(fill);

		if(fill)
		{
			UEventSendMessage(GetWidID(), EV_SETTEXT, kEdit, (void *)m_edit.c_str());
		}
		else
		{
			UEventSendMessage(GetWidID(), EV_GETTEXT, kEdit, &m_edit);
		}
	}

	UStr m_edit;

protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UEditMessage, UPromptMessage)

UBEGIN_MESSAGE_MAP(UEditMessage, UPromptMessage)
UEND_MESSAGE_MAP()

bool PromptEditMessage(const char *msg, UStr & edit, const char *title, const char *def, const char *cncl)
{
	std::auto_ptr<UEditMessage> dlg(new UEditMessage(msg, edit, title, def, cncl));
	bool res = false;

#ifdef WIN32
	res = dlg->DoModal(IDD_EDITMESSAGE);
#endif
#ifdef qMacCvsPP
	res = dlg->DoModal(dlg_PromptEditCommand);
#endif

	if(res)
		edit = dlg->m_edit;

	return res;
}
